<?php
	
/*
-----------------------------------------
---------   All about this file   -------
-----------------------------------------

Your plans/general settings are customized using the settings area, Wizard Panel:

https://www.zomex.com/docs/whmcs-templates/wizard-panel/

This file contains all of the text of the template that isn't edited via Wizard Panel such as the company page text. The reason why text is edited in this file is it allows multi-language support and also ensures that all of the text is located in one place instead of being hardcoded in template files.

Each language has this same file allowing you to set different translations for each language. If you want to support 1 language only then you can ignore the other language files and edit only your default language set in WHMCS.

BEFORE YOU EDIT THIS FILE please read our guide below for full details:

https://www.zomex.com/docs/whmcs-templates/how-to-edit-text-in-the-template/

For more information about editing your template please refer to our full documentation below:

https://www.zomex.com/docs/whmcs-templates/

Feel free to contact Zomex if you run into any issues or have any questions.

------ Tips ------

- While it looks a bit intimidating initially, you do not need any prior coding experience to edit this file. After a bit of practise it's easy to edit. If you run into any problems you can contact Zomex support at anytime.

- Keep a backup of this file at all times, if you make a edit and it causes errors with your website replace this file with your backup to restore everything. As long as you have a backup you cannot go wrong. Making a backup of this file after every few edits is recommended.

- This file uses a PHP structure, ensure that the markup remains valid (no missing " ' ;) to avoid errors. If you experience an error you can use the following tool (paste the full contents of this file), it will highlight the line/section where the error is:

http://phpcodechecker.com/

- You can search this file for the page name to easily find the language text associated with it. E.g for the Company page search this file for "company.php" or "Company page".

- If you are only using 1 language you do not need to edit below the line: Multi-language support: on - Any text below that line is editable in Wizard Panel when multi-language set to off.

-----------------------------------------

*/






/*
-----------------------------------------
---------   Settings - Commonly used text. You can leave settings empty (= "";) such as the email to remove it throughout the template    ---------
-----------------------------------------
*/

$_LANG['prosper_setting_companyname'] = "Your Company";
$_LANG['prosper_setting_domain'] = "yourcompany.com"; // Without https://www.
$_LANG['prosper_setting_email'] = "sales@";
$_LANG['prosper_setting_phone_number'] = "+01 23 45 47 25";
$_LANG['prosper_setting_address'] = "29 Your Street, Chatham, Kent, England";
$_LANG['prosper_setting_company_number'] = "7832763";
$_LANG['prosper_setting_tax_number'] = "FR197763863";











/*
-----------------------------------------
---------   Pages - The page name and description text are used in various places of the template such as the menu & footer & subbanner. The menu highlight adds the badge to the main menu and footer, it supports hot, new. The content of each page is further down this file.     ---------
-----------------------------------------
*/

// Register Domain

$_LANG['prosper_registerdomain_name'] = "Register Domain";         
$_LANG['prosper_registerdomain_text'] = "Your very own website address";
$_LANG['prosper_registerdomain_icon'] = "domains.png";
$_LANG['prosper_registerdomain_highlight'] = "hot";

// Transfer Domain

$_LANG['prosper_transferdomain_name'] = "Transfer Domain";         
$_LANG['prosper_transferdomain_text'] = "Move your domain to " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_transferdomain_icon'] = "transfer.png";
$_LANG['prosper_transferdomain_highlight'] = "";

//  Wizard Panel service pages (With quick setup turned off) - You can re-name any of the 10 default pages by following this guide: https://www.zomex.com/docs/whmcs-templates/how-to-change-hosting-page-type/

// Page 1 - Shared Hosting by default

$_LANG['prosper_custom1_name'] = "Shared Hosting";         
$_LANG['prosper_custom1_text'] = "Premium cPanel web hosting";
$_LANG['prosper_custom1_icon'] = "webhosting.png";
$_LANG['prosper_custom1_highlight'] = "hot";

// Page 2 - Reseller Hosting by default

$_LANG['prosper_custom2_name'] = "Reseller Hosting";
$_LANG['prosper_custom2_text'] = "Start your own hosting business";
$_LANG['prosper_custom2_icon'] = "resellerhosting.png";
$_LANG['prosper_custom2_highlight'] = "";

// Page 3 - VPS Hosting by default

$_LANG['prosper_custom3_name'] = "VPS Hosting";
$_LANG['prosper_custom3_text'] = "Take full control of your hosting";
$_LANG['prosper_custom3_icon'] = "vpshosting.png";
$_LANG['prosper_custom3_highlight'] = "";

// Page 4 - Dedicated Servers by default

$_LANG['prosper_custom4_name'] = "Dedicated Servers";
$_LANG['prosper_custom4_text'] = "Your powerful hosting environment";
$_LANG['prosper_custom4_icon'] = "dedicatedservers.png";
$_LANG['prosper_custom4_highlight'] = "new";

// Page 5 - Cloud Hosting by default

$_LANG['prosper_custom5_name'] = "Cloud Hosting";
$_LANG['prosper_custom5_text'] = "Take your website to the cloud";
$_LANG['prosper_custom5_icon'] = "cloudhosting.svg";
$_LANG['prosper_custom5_highlight'] = "";

// Page 6 - Game Servers by default

$_LANG['prosper_custom6_name'] = "Game Servers";
$_LANG['prosper_custom6_text'] = "Create your own game server";
$_LANG['prosper_custom6_icon'] = "gameservers.svg";
$_LANG['prosper_custom6_highlight'] = "";

// Page 7 - Virtual Private Network by default

$_LANG['prosper_custom7_name'] = "Virtual Private Network";
$_LANG['prosper_custom7_text'] = "Setup your Virtual Private Network";
$_LANG['prosper_custom7_icon'] = "vpn.png";
$_LANG['prosper_custom7_highlight'] = "";

// Page 8 - IPTV by default

$_LANG['prosper_custom8_name'] = "IPTV";
$_LANG['prosper_custom8_text'] = "Stream your favorite TV shows &amp; movies";
$_LANG['prosper_custom8_icon'] = "iptv.png";
$_LANG['prosper_custom8_highlight'] = "hot";

// Page 9 - Hosting Addons by default

$_LANG['prosper_custom9_name'] = "Hosting Addons";
$_LANG['prosper_custom9_text'] = "View our selection of Hosting Addons";
$_LANG['prosper_custom9_icon'] = "hostingaddons.png";
$_LANG['prosper_custom9_highlight'] = "";

// Page 10 - Web Design by default

$_LANG['prosper_custom10_name'] = "Web Design";
$_LANG['prosper_custom10_text'] = "Hire " . $_LANG['prosper_setting_companyname'] . " to build your website";
$_LANG['prosper_custom10_icon'] = "webdesign.png";
$_LANG['prosper_custom10_highlight'] = "";

// MarketConnect pages - These pages are displayed if enabled within WHMCS: https://marketplace.whmcs.com/connect

// SSL Certificates

$_LANG['prosper_sslcertificates_name'] = "SSL Certificates";
$_LANG['prosper_sslcertificates_text'] = "Encrypt your website using https";
$_LANG['prosper_sslcertificates_icon'] = "sslcertificate.svg";
$_LANG['prosper_sslcertificates_highlight'] = "";

// VPN

$_LANG['prosper_vpn_name'] = "VPN";
$_LANG['prosper_vpn_text'] = "Protect your online identity and IP address";
$_LANG['prosper_vpn_icon'] = "vpn.png";
$_LANG['prosper_vpn_highlight'] = "hot";

// Website Builder

$_LANG['prosper_websitebuilder_name'] = "Website Builder";
$_LANG['prosper_websitebuilder_text'] = "An easy to create website builder tool";
$_LANG['prosper_websitebuilder_icon'] = "websitebuilder.png";
$_LANG['prosper_websitebuilder_highlight'] = "";

// Website Backup

$_LANG['prosper_websitebackup_name'] = "Website Backup";
$_LANG['prosper_websitebackup_text'] = "Protect your website with frequent backups";
$_LANG['prosper_websitebackup_icon'] = "websitebackup.png";
$_LANG['prosper_websitebackup_highlight'] = "";

// Website Security

$_LANG['prosper_websitesecurity_name'] = "Website Security";
$_LANG['prosper_websitesecurity_text'] = "Keep your website safe &amp; secure";
$_LANG['prosper_websitesecurity_icon'] = "websitesecurity.png";
$_LANG['prosper_websitesecurity_highlight'] = "";

// Email Security

$_LANG['prosper_emailsecurity_name'] = "Email Security";
$_LANG['prosper_emailsecurity_text'] = "Secure your incoming and outgoing email";
$_LANG['prosper_emailsecurity_icon'] = "emailsecurity.svg";
$_LANG['prosper_emailsecurity_highlight'] = "";

// SEO Tools

$_LANG['prosper_seotools_name'] = "SEO Tools";
$_LANG['prosper_seotools_text'] = "SEO report with optimization steps";
$_LANG['prosper_seotools_icon'] = "seotools.png";
$_LANG['prosper_seotools_highlight'] = "";

// Professional Email

$_LANG['prosper_professionalemail_name'] = "Professional Email";
$_LANG['prosper_professionalemail_text'] = "Powerful email and productivity";
$_LANG['prosper_professionalemail_icon'] = "professionalemail.png";
$_LANG['prosper_professionalemail_highlight'] = "";

// Site Builder

$_LANG['prosper_sitebuilder_name'] = "Site Builder";
$_LANG['prosper_sitebuilder_text'] = "Drag and drop DIY site builder";
$_LANG['prosper_sitebuilder_icon'] = "sitebuilder.png";
$_LANG['prosper_sitebuilder_highlight'] = "new";

// cPanel SEO

$_LANG['prosper_cpanelseo_name'] = "cPanel SEO";
$_LANG['prosper_cpanelseo_text'] = "SEO from cPanel";
$_LANG['prosper_cpanelseo_icon'] = "cpanelseo.png";
$_LANG['prosper_cpanelseo_highlight'] = "";

// Company

$_LANG['prosper_company_name'] = "Company";         
$_LANG['prosper_company_text'] = "Learn more about " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_company_icon'] = "company.png";
$_LANG['prosper_company_highlight'] = "";

// Why Choose Us

$_LANG['prosper_whychooseus_name'] = "Why Choose Us";         
$_LANG['prosper_whychooseus_text'] = "The reasons why to choose us";
$_LANG['prosper_whychooseus_icon'] = "whychooseus.png";
$_LANG['prosper_whychooseus_highlight'] = "";

// Testimonials

$_LANG['prosper_testimonials_name'] = "Testimonials";         
$_LANG['prosper_testimonials_text'] = "Lots of feedback from our customer&#39;s";
$_LANG['prosper_testimonials_icon'] = "testimonials.png";
$_LANG['prosper_testimonials_highlight'] = "";

// Affiliate Program

$_LANG['prosper_affiliateprogram_name'] = "Affiliate Program";         
$_LANG['prosper_affiliateprogram_text'] = "Make money with " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_affiliateprogram_icon'] = "affiliateprogram.png";
$_LANG['prosper_affiliateprogram_highlight'] = "new";

// Announcements

$_LANG['prosper_announcements_name'] = "Announcements";         
$_LANG['prosper_announcements_text'] = "Get up to date with the latest news";
$_LANG['prosper_announcements_icon'] = "announcements.png";
$_LANG['prosper_announcements_highlight'] = "";

// Downloads

$_LANG['prosper_downloads_name'] = "Downloads";         
$_LANG['prosper_downloads_text'] = "View our collection of downloads";
$_LANG['prosper_downloads_icon'] = "downloads.png";
$_LANG['prosper_downloads_highlight'] = "";

// Addon pages - Displayed if you have the addons setting enabled under Wizard Panel > Pages

// Addons

$_LANG['prosper_addons_name'] = "Addons";

// WHMCS Templates

$_LANG['prosper_whmcstemplates_name'] = "WHMCS Templates";         
$_LANG['prosper_whmcstemplates_text'] = "The best web hosting templates";
$_LANG['prosper_whmcstemplates_icon'] = "whmcslogo.png";
$_LANG['prosper_whmcstemplates_highlight'] = "hot";

// WordPress Themes

$_LANG['prosper_wordpressthemes_name'] = "WordPress Themes";         
$_LANG['prosper_wordpressthemes_text'] = "Feature-rich WordPress themes";
$_LANG['prosper_wordpressthemes_icon'] = "wordpresslogo.png";
$_LANG['prosper_wordpressthemes_highlight'] = "";

// HTML Templates

$_LANG['prosper_htmltemplates_name'] = "HTML Templates";         
$_LANG['prosper_htmltemplates_text'] = "Responsive HTML5 Templates";
$_LANG['prosper_htmltemplates_icon'] = "htmllogo.png";
$_LANG['prosper_htmltemplates_highlight'] = "";

// Blesta Templates

$_LANG['prosper_blestatemplates_name'] = "Blesta Templates";         
$_LANG['prosper_blestatemplates_text'] = "Blesta web hosting templates";
$_LANG['prosper_blestatemplates_icon'] = "blestalogo.png";
$_LANG['prosper_blestatemplates_highlight'] = "";

// Clientexec Templates

$_LANG['prosper_clientexectemplates_name'] = "Clientexec Templates";         
$_LANG['prosper_clientexectemplates_text'] = "Powerful templates for Clientexec";
$_LANG['prosper_clientexectemplates_icon'] = "clientexeclogo.png";
$_LANG['prosper_clientexectemplates_highlight'] = "";

// WISECP Templates

$_LANG['prosper_wisecptemplates_name'] = "WISECP Templates";         
$_LANG['prosper_wisecptemplates_text'] = "Powerful templates for WISECP";
$_LANG['prosper_wisecptemplates_icon'] = "wisecplogo.png";
$_LANG['prosper_wisecptemplates_highlight'] = "new";

// HostBill Templates

$_LANG['prosper_hostbilltemplates_name'] = "HostBill Templates";         
$_LANG['prosper_hostbilltemplates_text'] = "Powerful templates for HostBill";
$_LANG['prosper_hostbilltemplates_icon'] = "hostbilllogo.png";
$_LANG['prosper_hostbilltemplates_highlight'] = "new";

// WHMCS Modules

$_LANG['prosper_whmcsmodules_name'] = "WHMCS Modules";         
$_LANG['prosper_whmcsmodules_text'] = "Enhance your WHMCS system";
$_LANG['prosper_whmcsmodules_icon'] = "whmcslogo.png";
$_LANG['prosper_whmcsmodules_highlight'] = "hot";

// Scripts

$_LANG['prosper_scripts_name'] = "Scripts";         
$_LANG['prosper_scripts_text'] = "Menus, feature boxes &amp; tables";
$_LANG['prosper_scripts_icon'] = "scripts.png";
$_LANG['prosper_scripts_highlight'] = "";

// Logo Design

$_LANG['prosper_logodesign_name'] = "Logo Design";         
$_LANG['prosper_logodesign_text'] = "Custom vector logo design service";
$_LANG['prosper_logodesign_icon'] = "logodesign.png";
$_LANG['prosper_logodesign_highlight'] = "new";

// Banner Design

$_LANG['prosper_bannerdesign_name'] = "Banner Design";         
$_LANG['prosper_bannerdesign_text'] = "Custom animated banner design";
$_LANG['prosper_bannerdesign_icon'] = "bannerdesign.png";
$_LANG['prosper_bannerdesign_highlight'] = "";

// WHMCS Services

$_LANG['prosper_whmcsservices_name'] = "WHMCS Services";         
$_LANG['prosper_whmcsservices_text'] = "Setup, configuration &amp; custom services";
$_LANG['prosper_whmcsservices_icon'] = "whmcslogo.png";
$_LANG['prosper_whmcsservices_highlight'] = "";

// WordPress Services

$_LANG['prosper_wordpressservices_name'] = "WordPress Services";         
$_LANG['prosper_wordpressservices_text'] = "Installation, integration &amp; more";
$_LANG['prosper_wordpressservices_icon'] = "wordpresslogo.png";
$_LANG['prosper_wordpressservices_highlight'] = "";

// Blesta Services

$_LANG['prosper_blestaservices_name'] = "Blesta Services";         
$_LANG['prosper_blestaservices_text'] = "Installation, integration &amp; more";
$_LANG['prosper_blestaservices_icon'] = "blestalogo.png";
$_LANG['prosper_blestaservices_highlight'] = "";

// Clientexec Services

$_LANG['prosper_clientexecservices_name'] = "Clientexec Services";         
$_LANG['prosper_clientexecservices_text'] = "Installation, integration &amp; more";
$_LANG['prosper_clientexecservices_icon'] = "clientexeclogo.png";
$_LANG['prosper_clientexecservices_highlight'] = "";

// Portal

$_LANG['prosper_portal_name'] = "Support";

// Contact

$_LANG['prosper_contact_name'] = "Contact Form";         
$_LANG['prosper_contact_text'] = "Contact our pre-sales department";
$_LANG['prosper_contact_icon'] = "contact.png";
$_LANG['prosper_contact_highlight'] = "";

// Submit Ticket

$_LANG['prosper_submitticket_name'] = "Submit Ticket";         
$_LANG['prosper_submitticket_text'] = "Contact our support via ticket";
$_LANG['prosper_submitticket_icon'] = "submitticket.png";
$_LANG['prosper_submitticket_highlight'] = "";

// Knowledgebase

$_LANG['prosper_knowledgebase_name'] = "Knowledgebase";         
$_LANG['prosper_knowledgebase_text'] = "View our vast documentation";
$_LANG['prosper_knowledgebase_icon'] = "knowledgebase.png";
$_LANG['prosper_knowledgebase_highlight'] = "new";

// Terms Of Service

$_LANG['prosper_termsofservice_name'] = "Terms Of Service";

// Acceptable Usage Policy

$_LANG['prosper_acceptableusagepolicy_name'] = "Acceptable Usage Policy";

// Privacy Policy

$_LANG['prosper_privacypolicy_name'] = "Privacy Policy";





/*
-----------------------------------------
---------   Toolbar (File: includes/toolbar.tpl)   ---------
-----------------------------------------
*/

$_LANG['prosper_toolbar_text'] = "We provide <strong>premium cPanel hosting!</strong>";
$_LANG['prosper_toolbar_text_cart'] = "Thank you for shopping with <strong>" . $_LANG['prosper_setting_companyname'] . "</strong>";

// Logged-out menu

$_LANG['prosper_toolbar_menu_contact'] = "Contact";
$_LANG['prosper_toolbar_menu_contact_icon'] = "fas fa-envelope";

$_LANG['prosper_toolbar_menu_cart'] = "View Cart";
$_LANG['prosper_toolbar_menu_cart_icon'] = "fas fa-shopping-cart";

$_LANG['prosper_toolbar_menu_clientarea'] = "Client Area";
$_LANG['prosper_toolbar_menu_clientarea_icon'] = "fas fa-lock";

// Logged-in menu

$_LANG['prosper_toolbar_menu_welcome'] = "Welcome back ";

$_LANG['prosper_toolbar_menu_account'] = "My Account";
$_LANG['prosper_toolbar_menu_account_icon'] = "fas fa-address-card";

$_LANG['prosper_toolbar_menu_home'] = "Portal Home";
$_LANG['prosper_toolbar_menu_details'] = "Account Details";
$_LANG['prosper_toolbar_menu_usermanagement'] = "User Management";
$_LANG['prosper_toolbar_menu_contacts'] = "Contacts";
$_LANG['prosper_toolbar_menu_emails'] = "Email History";
$_LANG['prosper_toolbar_menu_profile'] = "Profile";
$_LANG['prosper_toolbar_menu_password'] = "Change Password";
$_LANG['prosper_toolbar_menu_commissions'] = "Refer A Friend";
$_LANG['prosper_toolbar_menu_invoices'] = "My Invoices";
$_LANG['prosper_toolbar_menu_orders'] = "My Orders";
$_LANG['prosper_toolbar_menu_domains'] = "My Domains";
$_LANG['prosper_toolbar_menu_quotes'] = "My Quotes";
$_LANG['prosper_toolbar_menu_tickets'] = "My Tickets";

$_LANG['prosper_toolbar_menu_logout'] = "Logout";
$_LANG['prosper_toolbar_menu_logout_icon'] = "far fa-sign-out";






/*
-----------------------------------------
---------   Main menu (File: includes/menu.tpl). The links within the menu can be found in the Pages section of this file.   ---------
-----------------------------------------
*/

// Domains

$_LANG['prosper_menu_domains'] = "Domains";

$_LANG['prosper_menu_domains_text'] = "<p>Hundreds of customer's around the world trust " . $_LANG['prosper_setting_companyname'] . " to manage their domain. We provide freedom and control including full access & the ability to move/sell your domains.</p>";

// Web Hosting

$_LANG['prosper_menu_services'] = "Web Hosting";

$_LANG['prosper_menu_services_text'] = "<p>We provide a wide range of services for your business including Web Hosting, Dedicated Servers, VPNs &amp; more.</p>";

// Extras

$_LANG['prosper_menu_extras'] = "Extras";

$_LANG['prosper_menu_extras_text'] = "<p>Enhance your website with these extras including our website backup &amp; security services.</p>";

// Company

$_LANG['prosper_menu_company'] = "Company";

$_LANG['prosper_menu_company_text'] = "<p>Learn more about what makes " . $_LANG['prosper_setting_companyname'] . " the best choice for web hosting services.</p>";

// Addons

$_LANG['prosper_menu_addons'] = "Addons";

$_LANG['prosper_menu_addons_text'] = "<p>Launch your business with our range of website templates and related services.</p>";

// Support

$_LANG['prosper_menu_support'] = "Support";

$_LANG['prosper_menu_support_text'] = "<p>If you have a pre-sale question or issue with your website we are here to help.</p>";

// Order

$_LANG['prosper_menu_order'] = "Order";






/*
-----------------------------------------
---------   Cart menu (File: includes/menu.tpl) - Displayed on the cart.php pages    ---------
-----------------------------------------
*/

$_LANG['prosper_cart_steps_1_name'] = "Step 1";
$_LANG['prosper_cart_steps_1_text'] = "Choose";

$_LANG['prosper_cart_steps_2_name'] = "Step 2";
$_LANG['prosper_cart_steps_2_text'] = "Configure";

$_LANG['prosper_cart_steps_3_name'] = "Step 3";
$_LANG['prosper_cart_steps_3_text'] = "Checkout";






/*
-----------------------------------------
---------   Header (File: header.tpl)   ---------
-----------------------------------------
*/

// Your logo is set within the WHMCS General settings

$_LANG['prosper_header_logo_alt'] = $_LANG['prosper_setting_companyname'] . " logo";

$_LANG['prosper_header_buttons'] = true;

$_LANG['prosper_header_buttons_1'] = true;
$_LANG['prosper_header_buttons_1_text'] = "Our Clients";
$_LANG['prosper_header_buttons_1_icon'] = "fas fa-star";
$_LANG['prosper_header_buttons_1_url'] = "testimonials.php";
$_LANG['prosper_header_buttons_1_url_newwindow'] = false;

$_LANG['prosper_header_buttons_2'] = true;
$_LANG['prosper_header_buttons_2_text'] = "Knowledgebase";
$_LANG['prosper_header_buttons_2_icon'] = "fad fa-book";
$_LANG['prosper_header_buttons_2_url'] = "default";
$_LANG['prosper_header_buttons_2_url_newwindow'] = false;






/*
-----------------------------------------
---------   CTA (File: includes/cta.tpl)   ---------
-----------------------------------------
*/

$_LANG['prosper_cta'] = true;

$_LANG['prosper_cta_text'] = "700+ people trust " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_cta_button'] = "Join Them Today";
$_LANG['prosper_cta_button_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_cta_button_url'] = "cart.php";
$_LANG['prosper_cta_button_url_newwindow'] = false;






/*
-----------------------------------------
---------   Partners (File: includes/partners.tpl)   ---------
-----------------------------------------
*/

$_LANG['prosper_partners'] = true;

$_LANG['prosper_partners_image'] = "partners.png";
$_LANG['prosper_partners_image_alt'] = $_LANG['prosper_setting_companyname'] . " partners";
$_LANG['prosper_partners_image_url'] = "";
$_LANG['prosper_partners_image_url_newwindow'] = false;






/*
-----------------------------------------
---------   Footer (File: includes/footer.tpl) - The link text for each link (e.g Register Domain of the register domain link) are set under the Pages section within this file    ---------
-----------------------------------------
*/

$_LANG['prosper_footer_services'] = "Services";

$_LANG['prosper_footer_extras'] = "Extras";

$_LANG['prosper_footer_addons'] = "Addons";

$_LANG['prosper_footer_domains'] = "Domains";

$_LANG['prosper_footer_support'] = "Support";

$_LANG['prosper_footer_company'] = "Company";

$_LANG['prosper_footer_about'] = "About " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_footer_about_text'] = $_LANG['prosper_setting_companyname'] . " provide premium web hosting, domain registration &amp; security services to businesses around the world.";
$_LANG['prosper_footer_about_button'] = true;
$_LANG['prosper_footer_about_button_text'] = "more";
$_LANG['prosper_footer_about_button_icon'] = "fas fa-info-circle";
$_LANG['prosper_footer_about_button_url'] = "default"; // By default the button will link to your company.php page
$_LANG['prosper_footer_about_button_url_newwindow'] = false;
$_LANG['prosper_footer_about_address'] = $_LANG['prosper_setting_address'];
$_LANG['prosper_footer_about_address_icon'] = "fas fa-globe";
$_LANG['prosper_footer_about_email'] = $_LANG['prosper_setting_email'] . $_LANG['prosper_setting_domain'];
$_LANG['prosper_footer_about_email_icon'] = "fas fa-envelope";
$_LANG['prosper_footer_about_phone_number'] = $_LANG['prosper_setting_phone_number'];
$_LANG['prosper_footer_about_phone_number_icon'] = "fas fa-phone-square-alt";
$_LANG['prosper_footer_about_company_number'] = "Company Number: " . $_LANG['prosper_setting_company_number'];
$_LANG['prosper_footer_about_company_number_icon'] = "fas fa-building";
$_LANG['prosper_footer_about_tax_number'] = "VAT Number: " . $_LANG['prosper_setting_tax_number'];
$_LANG['prosper_footer_about_tax_number_icon'] = "fas fa-book";

$_LANG['prosper_footer_social'] = "Follow " . $_LANG['prosper_setting_companyname'];






/*
-----------------------------------------
---------   Copyright (File: includes/footer.tpl)   ---------
-----------------------------------------
*/

$_LANG['prosper_copyright_text'] = " | All rights reserved";

$_LANG['prosper_legal_link_terms'] = "Terms Of Service";
$_LANG['prosper_legal_link_usage'] = "Acceptable Usage Policy";
$_LANG['prosper_legal_link_privacy'] = "Privacy Policy";

$_LANG['prosper_copyright_logos'] = true;

$_LANG['prosper_copyright_logos1'] = true;
$_LANG['prosper_copyright_logos1_image'] = "paypal.jpg";
$_LANG['prosper_copyright_logos1_image_alt'] = $_LANG['prosper_setting_companyname'] . " PayPal";
$_LANG['prosper_copyright_logos1_image_url'] = "";
$_LANG['prosper_copyright_logos1_image_url_newwindow'] = false;

$_LANG['prosper_copyright_logos2'] = true;
$_LANG['prosper_copyright_logos2_image'] = "credit-card.jpg";
$_LANG['prosper_copyright_logos2_image_alt'] = $_LANG['prosper_setting_companyname'] . " Credit Card";
$_LANG['prosper_copyright_logos2_image_url'] = "";
$_LANG['prosper_copyright_logos2_image_url_newwindow'] = false;

$_LANG['prosper_copyright_logos3'] = true;
$_LANG['prosper_copyright_logos3_image'] = "rapidssl.png";
$_LANG['prosper_copyright_logos3_image_alt'] = $_LANG['prosper_setting_companyname'] . " RapidSSL";
$_LANG['prosper_copyright_logos3_image_url'] = "";
$_LANG['prosper_copyright_logos3_image_url_newwindow'] = false;






/*
-----------------------------------------
---------   Slideshow (File: includes/slideshow.tpl). Supports up to 10 banners following: https://www.zomex.com/docs/whmcs-templates/how-to-edit-text-in-the-template/#4   ---------
-----------------------------------------
*/

// Banner 1

$_LANG['prosper_banner_1_display'] = true;
$_LANG['prosper_banner_1_heading'] = "Shared Hosting";
$_LANG['prosper_banner_1_text'] = "Reliable cPanel Hosting Plans";
$_LANG['prosper_banner_1_feat1'] = "Unlimited domains, email & space";
$_LANG['prosper_banner_1_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_banner_1_feat3'] = "Money back guarantee with all plans";
$_LANG['prosper_banner_1_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_banner_1_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_banner_1_feat6'] = "Perfect for personal websites and businesses";
$_LANG['prosper_banner_1_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_banner_1_background'] = "background.jpg";
$_LANG['prosper_banner_1_background_opacity'] = 0.6;
$_LANG['prosper_banner_1_price_before'] = "Starting From";
$_LANG['prosper_banner_1_price'] = "9.99";
$_LANG['prosper_banner_1_price_term'] = "/month";
$_LANG['prosper_banner_1_image'] = "cpanel.png";
$_LANG['prosper_banner_1_image_small'] = "cpanel-small.png";
$_LANG['prosper_banner_1_image_alt'] = "Web Hosting";
$_LANG['prosper_banner_1_image_url'] = "web-hosting.php";
$_LANG['prosper_banner_1_image_url_newwindow'] = false;
$_LANG['prosper_banner_1_image_screenshot'] = true;
$_LANG['prosper_banner_1_image_video'] = false;
$_LANG['prosper_banner_1_image_video_badge'] = "Watch Video";
$_LANG['prosper_banner_1_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_banner_1_button1_text'] = "Features";
$_LANG['prosper_banner_1_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_1_button1_url'] = "web-hosting.php#features";
$_LANG['prosper_banner_1_button1_url_newwindow'] = false;
$_LANG['prosper_banner_1_button2_text'] = "Get Started Now!";
$_LANG['prosper_banner_1_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_banner_1_button2_url'] = "web-hosting.php#plans";
$_LANG['prosper_banner_1_button2_url_newwindow'] = false;

// Banner 2

$_LANG['prosper_banner_2_display'] = true;
$_LANG['prosper_banner_2_heading'] = "Reseller Hosting";
$_LANG['prosper_banner_2_text'] = "Provide web hosting as a business!";
$_LANG['prosper_banner_2_feat1'] = "Provide your clients with cPanel hosting";
$_LANG['prosper_banner_2_feat2'] = "Manage your reseller business with WHM";
$_LANG['prosper_banner_2_feat3'] = "Create unlimited cPanel accounts";
$_LANG['prosper_banner_2_feat4'] = "WHMCS license provided at a discount";
$_LANG['prosper_banner_2_feat5'] = "Unlimited access to our knowledgeable support";
$_LANG['prosper_banner_2_feat6'] = "We only use the highest quality LiteSpeed servers";
$_LANG['prosper_banner_2_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_banner_2_background'] = "background.jpg";
$_LANG['prosper_banner_2_background_opacity'] = 0.6;
$_LANG['prosper_banner_2_price_before'] = "Starting From";
$_LANG['prosper_banner_2_price'] = "19.99";
$_LANG['prosper_banner_2_price_term'] = "/month";
$_LANG['prosper_banner_2_image'] = "whm.png";
$_LANG['prosper_banner_2_image_small'] = "whm-small.png";
$_LANG['prosper_banner_2_image_alt'] = "Reseller Hosting";
$_LANG['prosper_banner_2_image_url'] = "https://www.youtube.com/watch?v=NAlCCCLg0rM";
$_LANG['prosper_banner_2_image_url_newwindow'] = false;
$_LANG['prosper_banner_2_image_screenshot'] = true;
$_LANG['prosper_banner_2_image_video'] = true;
$_LANG['prosper_banner_2_image_video_badge'] = "Watch Video";
$_LANG['prosper_banner_2_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_banner_2_button1_text'] = "Features";
$_LANG['prosper_banner_2_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_2_button1_url'] = "reseller-hosting.php#features";
$_LANG['prosper_banner_2_button1_url_newwindow'] = false;
$_LANG['prosper_banner_2_button2_text'] = "Get Started Now!";
$_LANG['prosper_banner_2_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_banner_2_button2_url'] = "reseller-hosting.php#plans";
$_LANG['prosper_banner_2_button2_url_newwindow'] = false;

// Banner 3

$_LANG['prosper_banner_3_display'] = true;
$_LANG['prosper_banner_3_heading'] = "About " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_banner_3_text'] = $_LANG['prosper_setting_companyname'] . " provide premium web hosting, domain registration & security services to businesses around the world. Our most popular service is our shared hosting which comes packed with many features and reliable support.";
$_LANG['prosper_banner_3_feat1'] = "";
$_LANG['prosper_banner_3_feat2'] = "";
$_LANG['prosper_banner_3_feat3'] = "";
$_LANG['prosper_banner_3_feat4'] = "";
$_LANG['prosper_banner_3_feat5'] = "";
$_LANG['prosper_banner_3_feat6'] = "";
$_LANG['prosper_banner_3_feat_icon'] = "";
$_LANG['prosper_banner_3_background'] = "background6.jpg";
$_LANG['prosper_banner_3_background_opacity'] = 0.6;
$_LANG['prosper_banner_3_price_before'] = "";
$_LANG['prosper_banner_3_price'] = "";
$_LANG['prosper_banner_3_price_term'] = "";
$_LANG['prosper_banner_3_image'] = "";
$_LANG['prosper_banner_3_image_small'] = "";
$_LANG['prosper_banner_3_image_alt'] = "";
$_LANG['prosper_banner_3_image_url'] = "";
$_LANG['prosper_banner_3_image_url_newwindow'] = false;
$_LANG['prosper_banner_3_image_screenshot'] = false;
$_LANG['prosper_banner_3_image_video'] = false;
$_LANG['prosper_banner_3_image_video_badge'] = "";
$_LANG['prosper_banner_3_image_video_badge_icon'] = "";
$_LANG['prosper_banner_3_button1_text'] = "Why Choose " . $_LANG['prosper_setting_companyname'] . "?";
$_LANG['prosper_banner_3_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_3_button1_url'] = "why-choose-us.php";
$_LANG['prosper_banner_3_button1_url_newwindow'] = false;
$_LANG['prosper_banner_3_button2_text'] = "Learn More About Us";
$_LANG['prosper_banner_3_button2_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_3_button2_url'] = "company.php";
$_LANG['prosper_banner_3_button2_url_newwindow'] = false;

// Banner 4

$_LANG['prosper_banner_4_display'] = false;
$_LANG['prosper_banner_4_heading'] = "Shared Hosting";
$_LANG['prosper_banner_4_text'] = "Reliable cPanel Hosting Plans";
$_LANG['prosper_banner_4_feat1'] = "Unlimited domains, email & space";
$_LANG['prosper_banner_4_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_banner_4_feat3'] = "Money back guarantee with all plans";
$_LANG['prosper_banner_4_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_banner_4_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_banner_4_feat6'] = "Perfect for personal websites and businesses";
$_LANG['prosper_banner_4_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_banner_4_background'] = "background.jpg";
$_LANG['prosper_banner_4_background_opacity'] = 0.6;
$_LANG['prosper_banner_4_price_before'] = "Starting From";
$_LANG['prosper_banner_4_price'] = "9.99";
$_LANG['prosper_banner_4_price_term'] = "/month";
$_LANG['prosper_banner_4_image'] = "cpanel.png";
$_LANG['prosper_banner_4_image_small'] = "cpanel-small.png";
$_LANG['prosper_banner_4_image_alt'] = "Web Hosting";
$_LANG['prosper_banner_4_image_url'] = "web-hosting.php";
$_LANG['prosper_banner_4_image_url_newwindow'] = false;
$_LANG['prosper_banner_4_image_screenshot'] = true;
$_LANG['prosper_banner_4_image_video'] = false;
$_LANG['prosper_banner_4_image_video_badge'] = "Watch Video";
$_LANG['prosper_banner_4_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_banner_4_button1_text'] = "Features";
$_LANG['prosper_banner_4_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_4_button1_url'] = "web-hosting.php#features";
$_LANG['prosper_banner_4_button1_url_newwindow'] = false;
$_LANG['prosper_banner_4_button2_text'] = "Get Started Now!";
$_LANG['prosper_banner_4_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_banner_4_button2_url'] = "web-hosting.php#plans";
$_LANG['prosper_banner_4_button2_url_newwindow'] = false;

// Banner 5

$_LANG['prosper_banner_5_display'] = false;
$_LANG['prosper_banner_5_heading'] = "Shared Hosting";
$_LANG['prosper_banner_5_text'] = "Reliable cPanel Hosting Plans";
$_LANG['prosper_banner_5_feat1'] = "Unlimited domains, email & space";
$_LANG['prosper_banner_5_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_banner_5_feat3'] = "Money back guarantee with all plans";
$_LANG['prosper_banner_5_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_banner_5_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_banner_5_feat6'] = "Perfect for personal websites and businesses";
$_LANG['prosper_banner_5_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_banner_5_background'] = "background.jpg";
$_LANG['prosper_banner_5_background_opacity'] = 0.6;
$_LANG['prosper_banner_5_price_before'] = "Starting From";
$_LANG['prosper_banner_5_price'] = "9.99";
$_LANG['prosper_banner_5_price_term'] = "/month";
$_LANG['prosper_banner_5_image'] = "cpanel.png";
$_LANG['prosper_banner_5_image_small'] = "cpanel-small.png";
$_LANG['prosper_banner_5_image_alt'] = "Web Hosting";
$_LANG['prosper_banner_5_image_url'] = "web-hosting.php";
$_LANG['prosper_banner_5_image_url_newwindow'] = false;
$_LANG['prosper_banner_5_image_screenshot'] = true;
$_LANG['prosper_banner_5_image_video'] = false;
$_LANG['prosper_banner_5_image_video_badge'] = "Watch Video";
$_LANG['prosper_banner_5_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_banner_5_button1_text'] = "Features";
$_LANG['prosper_banner_5_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_5_button1_url'] = "web-hosting.php#features";
$_LANG['prosper_banner_5_button1_url_newwindow'] = false;
$_LANG['prosper_banner_5_button2_text'] = "Get Started Now!";
$_LANG['prosper_banner_5_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_banner_5_button2_url'] = "web-hosting.php#plans";
$_LANG['prosper_banner_5_button2_url_newwindow'] = false;

// Banner static - Displayed when the slideshow setting in Wizard Panel is set to static.

$_LANG['prosper_banner_static_heading'] = "Shared Hosting";
$_LANG['prosper_banner_static_text'] = "Reliable cPanel Hosting Plans";
$_LANG['prosper_banner_static_feat1'] = "Unlimited domains, email & space";
$_LANG['prosper_banner_static_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_banner_static_feat3'] = "Money back guarantee with all plans";
$_LANG['prosper_banner_static_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_banner_static_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_banner_static_feat6'] = "Perfect for personal websites and businesses";
$_LANG['prosper_banner_static_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_banner_static_background'] = "background.jpg";
$_LANG['prosper_banner_static_background_opacity'] = 0.6;
$_LANG['prosper_banner_static_price_before'] = "Starting From";
$_LANG['prosper_banner_static_price'] = "9.99";
$_LANG['prosper_banner_static_price_term'] = "/month";
$_LANG['prosper_banner_static_image'] = "cpanel.png";
$_LANG['prosper_banner_static_image_small'] = "cpanel-small.png";
$_LANG['prosper_banner_static_image_alt'] = "Web Hosting";
$_LANG['prosper_banner_static_image_url'] = "web-hosting.php";
$_LANG['prosper_banner_static_image_url_newwindow'] = false;
$_LANG['prosper_banner_static_image_screenshot'] = true;
$_LANG['prosper_banner_static_image_video'] = false;
$_LANG['prosper_banner_static_image_video_badge'] = "Watch Video";
$_LANG['prosper_banner_static_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_banner_static_button1_text'] = "Features";
$_LANG['prosper_banner_static_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_banner_static_button1_url'] = "web-hosting.php#features";
$_LANG['prosper_banner_static_button1_url_newwindow'] = false;
$_LANG['prosper_banner_static_button2_text'] = "Get Started Now!";
$_LANG['prosper_banner_static_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_banner_static_button2_url'] = "web-hosting.php#plans";
$_LANG['prosper_banner_static_button2_url_newwindow'] = false;






/*
-----------------------------------------
---------   Cart banner (File: includes/itemsincart.tpl)   ---------
-----------------------------------------
*/

$_LANG['prosper_itemsincart_display'] = true;
$_LANG['prosper_itemsincart_heading'] = "Your Order Is Almost Completed";
$_LANG['prosper_itemsincart_text1'] = "We notice that you have items in your cart totalling ";
$_LANG['prosper_itemsincart_text2'] = ". We have saved it for you so you don't miss out on the high quality products &amp; support that you can expect from " . $_LANG['prosper_setting_companyname'] . ".";
$_LANG['prosper_itemsincart_carttotal_display'] = true;
$_LANG['prosper_itemsincart_promo_display'] = true;
$_LANG['prosper_itemsincart_promo_text'] = "Complete your order today and <strong>save 5%</strong>* using coupon: ";
$_LANG['prosper_itemsincart_promo_code'] = "WelcomeBack"; // Leave blank for no promo. This promo should be created in WHMCS: https://docs.whmcs.com/Promotions
$_LANG['prosper_itemsincart_button1_text'] = "Have A Question?";
$_LANG['prosper_itemsincart_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_itemsincart_button1_url'] = "default";
$_LANG['prosper_itemsincart_button1_url_newwindow'] = false;
$_LANG['prosper_itemsincart_button2_text'] = "Apply Discount!";
$_LANG['prosper_itemsincart_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_itemsincart_button2_url'] = "default";
$_LANG['prosper_itemsincart_button2_url_newwindow'] = false;






/*
-----------------------------------------
---------   Badges - Used for various areas such as the menu, footer links, feature boxes   ---------
-----------------------------------------
*/

$_LANG['prosper_badge_hot'] = "hot";
$_LANG['prosper_badge_new'] = "new";
$_LANG['prosper_badge_popular'] = "popular";
$_LANG['prosper_badge_free'] = "free";






/*
-----------------------------------------
---------   Home page (File: homepage.tpl, index.php)   ---------
-----------------------------------------
*/

// Domain checker

$_LANG['prosper_domainchecker_display'] = true;

$_LANG['prosper_domainchecker_heading'] = "A Great Domain Means Instant Credibility";
$_LANG['prosper_domainchecker_subheading'] = "Register your perfect domain name from just ";
$_LANG['prosper_domainchecker_input'] = "yourcompanywebsite.com";
$_LANG['prosper_domainchecker_button'] = "Search";
$_LANG['prosper_domainchecker_image'] = "domaintlds.png";
$_LANG['prosper_domainchecker_image_alt'] = "Search TLDS";


// Submenu

$_LANG['prosper_homepage_submenu_display'] = false;

$_LANG['prosper_homepage_submenu_1_display'] = true;
$_LANG['prosper_homepage_submenu_1_text'] = "Overview";
$_LANG['prosper_homepage_submenu_1_url'] = "#overview";
$_LANG['prosper_homepage_submenu_1_url_newwindow'] = false;

$_LANG['prosper_homepage_submenu_2_display'] = true;
$_LANG['prosper_homepage_submenu_2_text'] = "Services";
$_LANG['prosper_homepage_submenu_2_url'] = "#services";
$_LANG['prosper_homepage_submenu_2_url_newwindow'] = false;

$_LANG['prosper_homepage_submenu_3_display'] = true;
$_LANG['prosper_homepage_submenu_3_text'] = "Features";
$_LANG['prosper_homepage_submenu_3_url'] = "#features";
$_LANG['prosper_homepage_submenu_3_url_newwindow'] = false;

$_LANG['prosper_homepage_submenu_4_display'] = true;
$_LANG['prosper_homepage_submenu_4_text'] = "Testimonials";
$_LANG['prosper_homepage_submenu_4_url'] = "#testimonials";
$_LANG['prosper_homepage_submenu_4_url_newwindow'] = false;

$_LANG['prosper_homepage_submenu_5_display'] = true;
$_LANG['prosper_homepage_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_homepage_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_homepage_submenu_5_url_newwindow'] = false;

$_LANG['prosper_homepage_submenu_6_display'] = true;
$_LANG['prosper_homepage_submenu_6_text'] = "FAQS";
$_LANG['prosper_homepage_submenu_6_url'] = "#faqs";
$_LANG['prosper_homepage_submenu_6_url_newwindow'] = false;

// Overview

$_LANG['prosper_homepage_overview_display'] = true;

$_LANG['prosper_homepage_overview_heading'] = $_LANG['prosper_setting_companyname'] . " brings you quality web hosting";

$_LANG['prosper_homepage_overview_text'] = "

<p>We provide Shared Hosting, Reseller Hosting, Business Hosting, Virtual Private Servers, Dedicated Servers and many more solutions for individuals, families, organisations and businesses. As we are a pronounced web hosting company we include a free domain name registration/transfer with all of our web hosting plans. The domain name included with your hosting plan is yours to carry on forever.</p>
	
<p>Our experts are available 24 hours a day, 7 days a week by customer desk, live chat & by phone for those times when you need help. Whether you need help with server assistance, registration of domains, transferring domain and websites, hosting related issues, control panel guidance we are here to assist you!</p>

";

// Plans title

$_LANG['prosper_homepage_plans_heading'] = "Choose Your Service To Get Started";

// Feature boxes

/* By default your plans are editable via Wizard Panel (With quick setup set to off). If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Features

$_LANG['prosper_homepage_features_display'] = true;

$_LANG['prosper_homepage_features_heading'] = "Our Hosting Features";

// Feature 1

$_LANG['prosper_homepage_features_1_display'] = true;
$_LANG['prosper_homepage_features_1_displayorder'] = 0;
$_LANG['prosper_homepage_features_1_heading'] = "Control Panel";
$_LANG['prosper_homepage_features_1_content_image'] = "homepage-features-1.png";
$_LANG['prosper_homepage_features_1_content_image_alt'] = "cpanel";
$_LANG['prosper_homepage_features_1_content_image_url'] = "";
$_LANG['prosper_homepage_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_homepage_features_1_content_image_bold'] = true;
$_LANG['prosper_homepage_features_1_content_heading'] = "cPanel Control Panel";
$_LANG['prosper_homepage_features_1_content_heading2'] = "The most powerful control panel";
$_LANG['prosper_homepage_features_1_content_text'] = "

<p>With cPanel you can easily manage every aspect of your web hosting account. From creating custom email addresses all the way to editing your website files.</p>

<p>The best thing about cPanel is that it can be accessed easily from any computer with an Internet connection.</p>

<p>With cPanel you can manage your website files with its browser based file manager (e.g upload, delete, edit files), Create/delete email accounts of your choice (@yourdomain.com) and access webmail via your browser, Install/remove software on your account with the help of Softaculous (Wordpress, Joomla etc) &amp; much more!</p>

<div class=\"gridboxes7-buttons\">
	<a href=\"https://demo.cpanel.net:2083/login/?user=democom&pass=DemoCoA5620&locale=en\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>cPanel Demo</a>
</div>

";

// Feature 2

$_LANG['prosper_homepage_features_2_display'] = true;
$_LANG['prosper_homepage_features_2_displayorder'] = 0;
$_LANG['prosper_homepage_features_2_heading'] = "Script Installer";
$_LANG['prosper_homepage_features_2_content_image'] = "homepage-features-2.png";
$_LANG['prosper_homepage_features_2_content_image_alt'] = "softaculous";
$_LANG['prosper_homepage_features_2_content_image_url'] = "";
$_LANG['prosper_homepage_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_homepage_features_2_content_image_bold'] = false;
$_LANG['prosper_homepage_features_2_content_heading'] = "Softaculous Script Installer";
$_LANG['prosper_homepage_features_2_content_heading2'] = "Easy to use";
$_LANG['prosper_homepage_features_2_content_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, phpBB, Magento, Prestashop and many more.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>WordPress</li>
		<li>Magento</li>
		<li>Joomla</li>
		<li>Prestashop</li>
		<li>phpBB</li>
		<li>Drupal</li>
	</ul>
</div><!-- .list -->

<p>No matter which type of website you're looking to build we provide access to software that'll make it easier to create and manage your website/blog/forum/online store! Don't get court with hosting services that make it hard to install these scripts. Join " . $_LANG['prosper_setting_companyname'] . " today and gain instant access to this feature!</p>

";

// Feature 3

$_LANG['prosper_homepage_features_3_display'] = true;
$_LANG['prosper_homepage_features_3_displayorder'] = 0;
$_LANG['prosper_homepage_features_3_heading'] = "Server";
$_LANG['prosper_homepage_features_3_content_image'] = "homepage-features-3.png";
$_LANG['prosper_homepage_features_3_content_image_alt'] = "litespeed";
$_LANG['prosper_homepage_features_3_content_image_url'] = "";
$_LANG['prosper_homepage_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_homepage_features_3_content_image_bold'] = true;
$_LANG['prosper_homepage_features_3_content_heading'] = "LiteSpeed web servers";
$_LANG['prosper_homepage_features_3_content_heading2'] = "Powerful, lightning fast servers";
$_LANG['prosper_homepage_features_3_content_text'] = "

<p>All of our web hosting packages come with LiteSpeed. LiteSpeed is up to 9 times faster than Apache (standard web server setup). LiteSpeed fully supports everything that Apache uses such as .htaccess and mod_rewrite so if your website loads quickly on an Apache server it will be even faster on our servers!</p>

<p>You should choose LiteSpeed if you want to processes PHP 50% faster, wow! - (Wordpress which is the most popular software uses PHP) &amp; benefit from 3 times faster than SSL Apache hosting!</p>

";

// Feature 4

$_LANG['prosper_homepage_features_4_display'] = true;
$_LANG['prosper_homepage_features_4_displayorder'] = 0;
$_LANG['prosper_homepage_features_4_heading'] = "Backups";
$_LANG['prosper_homepage_features_4_content_image'] = "homepage-features-4.png";
$_LANG['prosper_homepage_features_4_content_image_alt'] = "r1soft";
$_LANG['prosper_homepage_features_4_content_image_url'] = "";
$_LANG['prosper_homepage_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_homepage_features_4_content_image_bold'] = true;
$_LANG['prosper_homepage_features_4_content_heading'] = "R1Soft backups";
$_LANG['prosper_homepage_features_4_content_heading2'] = "Protecting your website";
$_LANG['prosper_homepage_features_4_content_text'] = "

<p>All of our web hosting accounts come with automated and completely free backups. This is made possible by the leading R1Soft Backup software.</p>

<p>R1Soft is used by providers worldwide and currently protects over 250,000 servers!</p>

<p>R1Soft can be accessed directly in cPanel giving you instant and easy access to backups of your website files &amp; database!</p>

";

// Feature 5

$_LANG['prosper_homepage_features_5_display'] = true;
$_LANG['prosper_homepage_features_5_displayorder'] = 0;
$_LANG['prosper_homepage_features_5_heading'] = "Datacenter";
$_LANG['prosper_homepage_features_5_content_image'] = "homepage-features-5.png";
$_LANG['prosper_homepage_features_5_content_image_alt'] = "datacenter";
$_LANG['prosper_homepage_features_5_content_image_url'] = "";
$_LANG['prosper_homepage_features_5_content_image_url_newwindow'] = false;
$_LANG['prosper_homepage_features_5_content_image_bold'] = true;
$_LANG['prosper_homepage_features_5_content_heading'] = "Our datacenter";
$_LANG['prosper_homepage_features_5_content_heading2'] = "24/7 monitoring";
$_LANG['prosper_homepage_features_5_content_text'] = "

<p>All of our servers are located in a large, well-known datacenter in Dallas Texas, USA. Our facility is monitored 24/7 to ensure that all servers are up.</p>

<p>Many companies out there take shortcuts when it comes to their servers. At " . $_LANG['prosper_setting_companyname'] . " we use the most up to date and premium quality servers available to ensure that your website loads lightning fast each and every time.</p>

";

// Feature 6

$_LANG['prosper_homepage_features_6_display'] = true;
$_LANG['prosper_homepage_features_6_displayorder'] = 0;
$_LANG['prosper_homepage_features_6_heading'] = "Awards";
$_LANG['prosper_homepage_features_6_content_image'] = "";
$_LANG['prosper_homepage_features_6_content_image_alt'] = "";
$_LANG['prosper_homepage_features_6_content_image_url'] = "";
$_LANG['prosper_homepage_features_6_content_image_url_newwindow'] = false;
$_LANG['prosper_homepage_features_6_content_image_bold'] = false;
$_LANG['prosper_homepage_features_6_content_heading'] = "Awards";
$_LANG['prosper_homepage_features_6_content_heading2'] = "Award winning provider";
$_LANG['prosper_homepage_features_6_content_text'] = "

<p>We've won a selection of prestigious awards as a reliable web hosting provider. Made possible with a quality service offer and high level of included support.</p>

<p>Signup today with " . $_LANG['prosper_setting_companyname'] . " and find out how we've been able to acquire these awards through the quality of our servers and the free support we provide.</p>

<p>We are so confident that you will like our service that we provide a no questions asked 30 day money back guarantee!</p>

";

// Testimonials

$_LANG['prosper_homepage_testimonials_display'] = true;

$_LANG['prosper_homepage_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_homepage_testimonials_1_display'] = true;
$_LANG['prosper_homepage_testimonials_1_displayorder'] = 0;
$_LANG['prosper_homepage_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_homepage_testimonials_1_author'] = "Nathan";
$_LANG['prosper_homepage_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_homepage_testimonials_1_image'] = "homepage-testimonials-1.png";
$_LANG['prosper_homepage_testimonials_1_alt'] = "client 1";
$_LANG['prosper_homepage_testimonials_1_image_url'] = "";
$_LANG['prosper_homepage_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_homepage_testimonials_2_display'] = true;
$_LANG['prosper_homepage_testimonials_2_displayorder'] = 0;
$_LANG['prosper_homepage_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_homepage_testimonials_2_author'] = "Joanna";
$_LANG['prosper_homepage_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_homepage_testimonials_2_image'] = "homepage-testimonials-2.png";
$_LANG['prosper_homepage_testimonials_2_alt'] = "client 2";
$_LANG['prosper_homepage_testimonials_2_image_url'] = "";
$_LANG['prosper_homepage_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_homepage_testimonials_3_display'] = true;
$_LANG['prosper_homepage_testimonials_3_displayorder'] = 0;
$_LANG['prosper_homepage_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_homepage_testimonials_3_author'] = "George";
$_LANG['prosper_homepage_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_homepage_testimonials_3_image'] = "homepage-testimonials-3.png";
$_LANG['prosper_homepage_testimonials_3_alt'] = "client 3";
$_LANG['prosper_homepage_testimonials_3_image_url'] = "";
$_LANG['prosper_homepage_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_homepage_whychooseus_display'] = true;

$_LANG['prosper_homepage_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_homepage_whychooseus_1_display'] = true;
$_LANG['prosper_homepage_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_homepage_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_homepage_whychooseus_1_image'] = "homepage-whychooseus-1.png";
$_LANG['prosper_homepage_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_homepage_whychooseus_1_image_url'] = "";
$_LANG['prosper_homepage_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_homepage_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_homepage_whychooseus_1_button1_text'] = "";
$_LANG['prosper_homepage_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_homepage_whychooseus_1_button1_url'] = "";
$_LANG['prosper_homepage_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_homepage_whychooseus_1_button2_text'] = "";
$_LANG['prosper_homepage_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_homepage_whychooseus_1_button2_url'] = "";
$_LANG['prosper_homepage_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_homepage_whychooseus_2_display'] = true;
$_LANG['prosper_homepage_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_homepage_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_homepage_whychooseus_2_image'] = "homepage-whychooseus-2.png";
$_LANG['prosper_homepage_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_homepage_whychooseus_2_image_url'] = "";
$_LANG['prosper_homepage_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_homepage_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_homepage_whychooseus_2_button1_text'] = "";
$_LANG['prosper_homepage_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_homepage_whychooseus_2_button1_url'] = "";
$_LANG['prosper_homepage_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_homepage_whychooseus_2_button2_text'] = "";
$_LANG['prosper_homepage_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_homepage_whychooseus_2_button2_url'] = "";
$_LANG['prosper_homepage_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_homepage_whychooseus_3_display'] = true;
$_LANG['prosper_homepage_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_homepage_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_homepage_whychooseus_3_image'] = "homepage-whychooseus-3.png";
$_LANG['prosper_homepage_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_homepage_whychooseus_3_image_url'] = "";
$_LANG['prosper_homepage_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_homepage_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_homepage_whychooseus_3_button1_text'] = "";
$_LANG['prosper_homepage_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_homepage_whychooseus_3_button1_url'] = "";
$_LANG['prosper_homepage_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_homepage_whychooseus_3_button2_text'] = "";
$_LANG['prosper_homepage_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_homepage_whychooseus_3_button2_url'] = "";
$_LANG['prosper_homepage_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_homepage_faqs_display'] = true;

$_LANG['prosper_homepage_faqs_heading'] = "FAQs";

$_LANG['prosper_homepage_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_homepage_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_homepage_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_homepage_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_homepage_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_homepage_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_homepage_faqs_question_button2_text'] = "";
$_LANG['prosper_homepage_faqs_question_button2_icon'] = "";
$_LANG['prosper_homepage_faqs_question_button2_url'] = "";
$_LANG['prosper_homepage_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_homepage_faqs_1_display'] = true;
$_LANG['prosper_homepage_faqs_1_displayorder'] = 0;
$_LANG['prosper_homepage_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_homepage_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_homepage_faqs_2_display'] = true;
$_LANG['prosper_homepage_faqs_2_displayorder'] = 0;
$_LANG['prosper_homepage_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_homepage_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_homepage_faqs_3_display'] = true;
$_LANG['prosper_homepage_faqs_3_displayorder'] = 0;
$_LANG['prosper_homepage_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_homepage_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Register domain page (File: registerdomain.tpl, registerdomain.php)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_registerdomain_banner_display'] = true;
$_LANG['prosper_registerdomain_banner_heading'] = "Register Domain";
$_LANG['prosper_registerdomain_banner_text'] = "Find the perfect domain for your business";
$_LANG['prosper_registerdomain_banner_background'] = "background5.jpg";
$_LANG['prosper_registerdomain_banner_background_opacity'] = 0.5;
$_LANG['prosper_registerdomain_banner_domainsearch_display'] = true;
$_LANG['prosper_registerdomain_banner_domainsearch_prefix'] = "www.";
$_LANG['prosper_registerdomain_banner_domainsearch_placeholder'] = "yourbusinessname.com";
$_LANG['prosper_registerdomain_banner_domainsearch_button'] = "Search";

// Submenu

$_LANG['prosper_registerdomain_submenu_display'] = true;

$_LANG['prosper_registerdomain_submenu_1_display'] = true;
$_LANG['prosper_registerdomain_submenu_1_text'] = "Featured TLDs";
$_LANG['prosper_registerdomain_submenu_1_url'] = "#featured";
$_LANG['prosper_registerdomain_submenu_1_url_newwindow'] = false;

$_LANG['prosper_registerdomain_submenu_2_display'] = true;
$_LANG['prosper_registerdomain_submenu_2_text'] = "Domain Pricing";
$_LANG['prosper_registerdomain_submenu_2_url'] = "#pricing";
$_LANG['prosper_registerdomain_submenu_2_url_newwindow'] = false;

$_LANG['prosper_registerdomain_submenu_3_display'] = true;
$_LANG['prosper_registerdomain_submenu_3_text'] = "Domain Features";
$_LANG['prosper_registerdomain_submenu_3_url'] = "#features";
$_LANG['prosper_registerdomain_submenu_3_url_newwindow'] = false;

// Featured TLDs

$_LANG['prosper_registerdomain_featuredtld_display'] = true;
$_LANG['prosper_registerdomain_featuredtld_heading'] = "Featured TLDs";

// Domain Pricing Table

$_LANG['prosper_registerdomain_domainpricing_display'] = true;
$_LANG['prosper_registerdomain_domainpricing_heading'] = "Domain Pricing";
$_LANG['prosper_registerdomain_domainpricing_text'] = "<p>At " . $_LANG['prosper_setting_companyname'] . " we provide many domain registration options including .com, .net & .org. The table below lists all of the TLDs we provide.</p>";

// Features

$_LANG['prosper_registerdomain_features_display'] = true;

$_LANG['prosper_registerdomain_features_heading'] = "Domain Features";

// Feature 1

$_LANG['prosper_registerdomain_features_1_display'] = true;
$_LANG['prosper_registerdomain_features_1_displayorder'] = 0;
$_LANG['prosper_registerdomain_features_1_heading'] = "DNS Management";
$_LANG['prosper_registerdomain_features_1_image'] = "registerdomain-features-1.png";
$_LANG['prosper_registerdomain_features_1_image_alt'] = "dns management";
$_LANG['prosper_registerdomain_features_1_image_url'] = "";
$_LANG['prosper_registerdomain_features_1_image_url_newwindow'] = false;
$_LANG['prosper_registerdomain_features_1_text'] = "<p>Full control of your domain's DNS without any restrictions. DNS management includes nameservers, A records, MX, CNAME, URL redirects & email forwarding.</p>";
$_LANG['prosper_registerdomain_features_1_button1_text'] = "";
$_LANG['prosper_registerdomain_features_1_button1_icon'] = "";
$_LANG['prosper_registerdomain_features_1_button1_url'] = "";
$_LANG['prosper_registerdomain_features_1_button1_url_newwindow'] = false;
$_LANG['prosper_registerdomain_features_1_button2_text'] = "";
$_LANG['prosper_registerdomain_features_1_button2_icon'] = "";
$_LANG['prosper_registerdomain_features_1_button2_url'] = "";
$_LANG['prosper_registerdomain_features_1_button2_url_newwindow'] = false;

// Feature 2

$_LANG['prosper_registerdomain_features_2_display'] = true;
$_LANG['prosper_registerdomain_features_2_displayorder'] = 0;
$_LANG['prosper_registerdomain_features_2_heading'] = "Control Panel";
$_LANG['prosper_registerdomain_features_2_image'] = "registerdomain-features-2.png";
$_LANG['prosper_registerdomain_features_2_image_alt'] = "domain control panel";
$_LANG['prosper_registerdomain_features_2_image_url'] = "";
$_LANG['prosper_registerdomain_features_2_image_url_newwindow'] = false;
$_LANG['prosper_registerdomain_features_2_text'] = "<p>Manage every aspect of your domain easily from inside your " . $_LANG['prosper_setting_companyname'] . " domain control panel. Mange your DNS, nameservers, email, forwarding, lock, EPP code & WHOIS.</p>";
$_LANG['prosper_registerdomain_features_2_button1_text'] = "";
$_LANG['prosper_registerdomain_features_2_button1_icon'] = "";
$_LANG['prosper_registerdomain_features_2_button1_url'] = "";
$_LANG['prosper_registerdomain_features_2_button1_url_newwindow'] = false;
$_LANG['prosper_registerdomain_features_2_button2_text'] = "";
$_LANG['prosper_registerdomain_features_2_button2_icon'] = "";
$_LANG['prosper_registerdomain_features_2_button2_url'] = "";
$_LANG['prosper_registerdomain_features_2_button2_url_newwindow'] = false;

// Feature 3

$_LANG['prosper_registerdomain_features_3_display'] = true;
$_LANG['prosper_registerdomain_features_3_displayorder'] = 0;
$_LANG['prosper_registerdomain_features_3_heading'] = "Email Forwarding";
$_LANG['prosper_registerdomain_features_3_image'] = "registerdomain-features-3.png";
$_LANG['prosper_registerdomain_features_3_image_alt'] = "email forwarding";
$_LANG['prosper_registerdomain_features_3_image_url'] = "";
$_LANG['prosper_registerdomain_features_3_image_url_newwindow'] = false;
$_LANG['prosper_registerdomain_features_3_text'] = "<p>Email forwarding is included completely free with all domains. This allows you to forward unlimited @yourcompany.com email addresses without a hosting or email service.</p>";
$_LANG['prosper_registerdomain_features_3_button1_text'] = "";
$_LANG['prosper_registerdomain_features_3_button1_icon'] = "";
$_LANG['prosper_registerdomain_features_3_button1_url'] = "";
$_LANG['prosper_registerdomain_features_3_button1_url_newwindow'] = false;
$_LANG['prosper_registerdomain_features_3_button2_text'] = "";
$_LANG['prosper_registerdomain_features_3_button2_icon'] = "";
$_LANG['prosper_registerdomain_features_3_button2_url'] = "";
$_LANG['prosper_registerdomain_features_3_button2_url_newwindow'] = false;






/*
-----------------------------------------
---------   Wizard Panel sales pages   ---------
-----------------------------------------
*/






/*
	
	You can re-name any of the 10 Wizard Panel sales pages following this guide: https://www.zomex.com/docs/whmcs-templates/how-to-change-hosting-page-type/
	
*/






/*
-----------------------------------------
---------   Shared Hosting page by default (File: web-hosting.tpl, web-hosting.php, includes/custom1.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom1_banner_display'] = true;
$_LANG['prosper_custom1_banner_heading'] = $_LANG['prosper_custom1_name'];
$_LANG['prosper_custom1_banner_text'] = "Reliable cPanel Hosting Plans";
$_LANG['prosper_custom1_banner_feat1'] = "Unlimited domains, email & space";
$_LANG['prosper_custom1_banner_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_custom1_banner_feat3'] = "Money back guarantee with all plans";
$_LANG['prosper_custom1_banner_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_custom1_banner_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_custom1_banner_feat6'] = "Perfect for personal websites and businesses";
$_LANG['prosper_custom1_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom1_banner_background'] = "background.jpg";
$_LANG['prosper_custom1_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom1_banner_price_before'] = "Starting From";
$_LANG['prosper_custom1_banner_price'] = "9.99";
$_LANG['prosper_custom1_banner_price_term'] = "/month";
$_LANG['prosper_custom1_banner_image'] = "cpanel.png";
$_LANG['prosper_custom1_banner_image_small'] = "cpanel-small.png";
$_LANG['prosper_custom1_banner_image_alt'] = $_LANG['prosper_custom1_name'];
$_LANG['prosper_custom1_banner_image_url'] = "#features";
$_LANG['prosper_custom1_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom1_banner_image_screenshot'] = true;
$_LANG['prosper_custom1_banner_image_video'] = false;
$_LANG['prosper_custom1_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom1_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom1_banner_button1_text'] = "Features";
$_LANG['prosper_custom1_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom1_banner_button1_url'] = "#features";
$_LANG['prosper_custom1_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom1_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom1_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom1_banner_button2_url'] = "#plans";
$_LANG['prosper_custom1_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom1_submenu_display'] = true;

$_LANG['prosper_custom1_submenu_1_display'] = true;
$_LANG['prosper_custom1_submenu_1_text'] = "Overview";
$_LANG['prosper_custom1_submenu_1_url'] = "#overview";
$_LANG['prosper_custom1_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom1_submenu_2_display'] = true;
$_LANG['prosper_custom1_submenu_2_text'] = "Plans";
$_LANG['prosper_custom1_submenu_2_url'] = "#plans";
$_LANG['prosper_custom1_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom1_submenu_3_display'] = true;
$_LANG['prosper_custom1_submenu_3_text'] = "Features";
$_LANG['prosper_custom1_submenu_3_url'] = "#features";
$_LANG['prosper_custom1_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom1_submenu_4_display'] = true;
$_LANG['prosper_custom1_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom1_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom1_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom1_submenu_5_display'] = true;
$_LANG['prosper_custom1_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom1_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom1_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom1_submenu_6_display'] = true;
$_LANG['prosper_custom1_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom1_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom1_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom1_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom1_name'] . " plan";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom1_overview_display'] = true;

$_LANG['prosper_custom1_overview_text'] = "

<p>View our premium quality web hosting plans below. All of our web hosting plans come with cPanel, the leading hosting control panel allowing easy editing and full control of your website.</p>
	
<p>Preinstalled scripts included with our web hosting plans make life much easier by allowing you to install any popular application/software without any prior web hosting knowledge. Whether you want to start a website, blog, forum or online store our 1 click script installer has you covered.</p>

";

// Features

$_LANG['prosper_custom1_features_display'] = true;

$_LANG['prosper_custom1_features_heading'] = $_LANG['prosper_custom1_name'] . " Features";

// Feature 1

$_LANG['prosper_custom1_features_1_display'] = true;
$_LANG['prosper_custom1_features_1_displayorder'] = 0;
$_LANG['prosper_custom1_features_1_heading'] = "Control Panel";
$_LANG['prosper_custom1_features_1_content_image'] = "custom1-features-1.png";
$_LANG['prosper_custom1_features_1_content_image_alt'] = "cpanel";
$_LANG['prosper_custom1_features_1_content_image_url'] = "";
$_LANG['prosper_custom1_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom1_features_1_content_image_bold'] = true;
$_LANG['prosper_custom1_features_1_content_heading'] = "cPanel Control Panel";
$_LANG['prosper_custom1_features_1_content_heading2'] = "The most powerful control panel";
$_LANG['prosper_custom1_features_1_content_text'] = "

<p>With cPanel you can easily manage every aspect of your web hosting account. From creating custom email addresses all the way to editing your website files.</p>

<p>The best thing about cPanel is that it can be accessed easily from any computer with an Internet connection.</p>

<p>With cPanel you can manage your website files with its browser based file manager (e.g upload, delete, edit files), Create/delete email accounts of your choice (@yourdomain.com) and access webmail via your browser, Install/remove software on your account with the help of Softaculous (Wordpress, Joomla etc) &amp; much more!</p>

<div class=\"gridboxes2-buttons\">
	<a href=\"https://demo.cpanel.net:2083/login/?user=democom&pass=DemoCoA5620&locale=en\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>cPanel Demo</a>
</div>

";

// Feature 2

$_LANG['prosper_custom1_features_2_display'] = true;
$_LANG['prosper_custom1_features_2_displayorder'] = 0;
$_LANG['prosper_custom1_features_2_heading'] = "Script Installer";
$_LANG['prosper_custom1_features_2_content_image'] = "custom1-features-2.png";
$_LANG['prosper_custom1_features_2_content_image_alt'] = "softaculous";
$_LANG['prosper_custom1_features_2_content_image_url'] = "";
$_LANG['prosper_custom1_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom1_features_2_content_image_bold'] = false;
$_LANG['prosper_custom1_features_2_content_heading'] = "Softaculous Script Installer";
$_LANG['prosper_custom1_features_2_content_heading2'] = "Easy to use";
$_LANG['prosper_custom1_features_2_content_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, phpBB, Magento, Prestashop and many more.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>WordPress</li>
		<li>Magento</li>
		<li>Joomla</li>
		<li>Prestashop</li>
		<li>phpBB</li>
		<li>Drupal</li>
	</ul>
</div><!-- .list -->

<p>No matter which type of website you're looking to build we provide access to software that'll make it easier to create and manage your website/blog/forum/online store! Don't get court with hosting services that make it hard to install these scripts. Join " . $_LANG['prosper_setting_companyname'] . " today and gain instant access to this feature!</p>

";

// Feature 3

$_LANG['prosper_custom1_features_3_display'] = true;
$_LANG['prosper_custom1_features_3_displayorder'] = 0;
$_LANG['prosper_custom1_features_3_heading'] = "Server";
$_LANG['prosper_custom1_features_3_content_image'] = "custom1-features-3.png";
$_LANG['prosper_custom1_features_3_content_image_alt'] = "litespeed";
$_LANG['prosper_custom1_features_3_content_image_url'] = "";
$_LANG['prosper_custom1_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom1_features_3_content_image_bold'] = true;
$_LANG['prosper_custom1_features_3_content_heading'] = "LiteSpeed web servers";
$_LANG['prosper_custom1_features_3_content_heading2'] = "Powerful, lightning fast servers";
$_LANG['prosper_custom1_features_3_content_text'] = "

<p>All of our web hosting packages come with LiteSpeed. LiteSpeed is up to 9 times faster than Apache (standard web server setup). LiteSpeed fully supports everything that Apache uses such as .htaccess and mod_rewrite so if your website loads quickly on an Apache server it will be even faster on our servers!</p>

<p>You should choose LiteSpeed if you want to processes PHP 50% faster, wow! - (Wordpress which is the most popular software uses PHP) &amp; benefit from 3 times faster than SSL Apache hosting!</p>

";

// Feature 4

$_LANG['prosper_custom1_features_4_display'] = true;
$_LANG['prosper_custom1_features_4_displayorder'] = 0;
$_LANG['prosper_custom1_features_4_heading'] = "Backups";
$_LANG['prosper_custom1_features_4_content_image'] = "custom1-features-4.png";
$_LANG['prosper_custom1_features_4_content_image_alt'] = "r1soft";
$_LANG['prosper_custom1_features_4_content_image_url'] = "";
$_LANG['prosper_custom1_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_custom1_features_4_content_image_bold'] = true;
$_LANG['prosper_custom1_features_4_content_heading'] = "R1Soft backups";
$_LANG['prosper_custom1_features_4_content_heading2'] = "Protecting your website";
$_LANG['prosper_custom1_features_4_content_text'] = "

<p>All of our web hosting accounts come with automated and completely free backups. This is made possible by the leading R1Soft Backup software.</p>

<p>R1Soft is used by providers worldwide and currently protects over 250,000 servers!</p>

<p>R1Soft can be accessed directly in cPanel giving you instant and easy access to backups of your website files &amp; database!</p>

";

// Feature 5

$_LANG['prosper_custom1_features_5_display'] = true;
$_LANG['prosper_custom1_features_5_displayorder'] = 0;
$_LANG['prosper_custom1_features_5_heading'] = "Datacenter";
$_LANG['prosper_custom1_features_5_content_image'] = "custom1-features-5.png";
$_LANG['prosper_custom1_features_5_content_image_alt'] = "datacenter";
$_LANG['prosper_custom1_features_5_content_image_url'] = "";
$_LANG['prosper_custom1_features_5_content_image_url_newwindow'] = false;
$_LANG['prosper_custom1_features_5_content_image_bold'] = true;
$_LANG['prosper_custom1_features_5_content_heading'] = "Our datacenter";
$_LANG['prosper_custom1_features_5_content_heading2'] = "24/7 monitoring";
$_LANG['prosper_custom1_features_5_content_text'] = "

<p>All of our servers are located in a large, well-known datacenter in Dallas Texas, USA. Our facility is monitored 24/7 to ensure that all servers are up.</p>

<p>Many companies out there take shortcuts when it comes to their servers. At " . $_LANG['prosper_setting_companyname'] . " we use the most up to date and premium quality servers available to ensure that your website loads lightning fast each and every time.</p>

";

// Feature 6

$_LANG['prosper_custom1_features_6_display'] = true;
$_LANG['prosper_custom1_features_6_displayorder'] = 0;
$_LANG['prosper_custom1_features_6_heading'] = "Awards";
$_LANG['prosper_custom1_features_6_content_image'] = "";
$_LANG['prosper_custom1_features_6_content_image_alt'] = "";
$_LANG['prosper_custom1_features_6_content_image_url'] = "";
$_LANG['prosper_custom1_features_6_content_image_url_newwindow'] = false;
$_LANG['prosper_custom1_features_6_content_image_bold'] = false;
$_LANG['prosper_custom1_features_6_content_heading'] = "Awards";
$_LANG['prosper_custom1_features_6_content_heading2'] = "Award winning provider";
$_LANG['prosper_custom1_features_6_content_text'] = "

<p>We've won a selection of prestigious awards as a reliable web hosting provider. Made possible with a quality service offer and high level of included support.</p>

<p>Signup today with " . $_LANG['prosper_setting_companyname'] . " and find out how we've been able to acquire these awards through the quality of our servers and the free support we provide.</p>

<p>We are so confident that you will like our service that we provide a no questions asked 30 day money back guarantee!</p>

";

// Testimonials

$_LANG['prosper_custom1_testimonials_display'] = true;

$_LANG['prosper_custom1_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom1_testimonials_1_display'] = true;
$_LANG['prosper_custom1_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom1_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom1_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom1_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom1_testimonials_1_image'] = "custom1-testimonials-1.png";
$_LANG['prosper_custom1_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom1_testimonials_1_image_url'] = "";
$_LANG['prosper_custom1_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom1_testimonials_2_display'] = true;
$_LANG['prosper_custom1_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom1_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom1_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom1_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom1_testimonials_2_image'] = "custom1-testimonials-2.png";
$_LANG['prosper_custom1_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom1_testimonials_2_image_url'] = "";
$_LANG['prosper_custom1_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom1_testimonials_3_display'] = true;
$_LANG['prosper_custom1_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom1_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom1_testimonials_3_author'] = "George";
$_LANG['prosper_custom1_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom1_testimonials_3_image'] = "custom1-testimonials-3.png";
$_LANG['prosper_custom1_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom1_testimonials_3_image_url'] = "";
$_LANG['prosper_custom1_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom1_whychooseus_display'] = true;

$_LANG['prosper_custom1_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom1_whychooseus_1_display'] = true;
$_LANG['prosper_custom1_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom1_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom1_whychooseus_1_image'] = "custom1-whychooseus-1.png";
$_LANG['prosper_custom1_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom1_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom1_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom1_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom1_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom1_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom1_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom1_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom1_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom1_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom1_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom1_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom1_whychooseus_2_display'] = true;
$_LANG['prosper_custom1_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom1_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom1_whychooseus_2_image'] = "custom1-whychooseus-2.png";
$_LANG['prosper_custom1_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom1_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom1_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom1_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom1_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom1_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom1_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom1_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom1_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom1_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom1_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom1_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom1_whychooseus_3_display'] = true;
$_LANG['prosper_custom1_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom1_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom1_whychooseus_3_image'] = "custom1-whychooseus-3.png";
$_LANG['prosper_custom1_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom1_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom1_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom1_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom1_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom1_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom1_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom1_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom1_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom1_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom1_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom1_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom1_faqs_display'] = true;

$_LANG['prosper_custom1_faqs_heading'] = "FAQs";

$_LANG['prosper_custom1_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom1_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom1_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom1_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom1_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom1_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom1_faqs_question_button2_text'] = "";
$_LANG['prosper_custom1_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom1_faqs_question_button2_url'] = "";
$_LANG['prosper_custom1_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom1_faqs_1_display'] = true;
$_LANG['prosper_custom1_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom1_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom1_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom1_faqs_2_display'] = true;
$_LANG['prosper_custom1_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom1_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom1_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom1_faqs_3_display'] = true;
$_LANG['prosper_custom1_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom1_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom1_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Reseller Hosting page by default (File: reseller-hosting.tpl, reseller-hosting.php, includes/custom2.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom2_banner_display'] = true;
$_LANG['prosper_custom2_banner_heading'] = $_LANG['prosper_custom2_name'];
$_LANG['prosper_custom2_banner_text'] = "Provide web hosting as a business!";
$_LANG['prosper_custom2_banner_feat1'] = "Provide your clients with cPanel hosting";
$_LANG['prosper_custom2_banner_feat2'] = "Manage your reseller business with WHM";
$_LANG['prosper_custom2_banner_feat3'] = "Create unlimited cPanel accounts";
$_LANG['prosper_custom2_banner_feat4'] = "WHMCS license provided at a discount";
$_LANG['prosper_custom2_banner_feat5'] = "Unlimited access to our knowledgeable support";
$_LANG['prosper_custom2_banner_feat6'] = "We only use the highest quality LiteSpeed servers";
$_LANG['prosper_custom2_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom2_banner_background'] = "background.jpg";
$_LANG['prosper_custom2_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom2_banner_price_before'] = "Starting From";
$_LANG['prosper_custom2_banner_price'] = "19.99";
$_LANG['prosper_custom2_banner_price_term'] = "/month";
$_LANG['prosper_custom2_banner_image'] = "whm.png";
$_LANG['prosper_custom2_banner_image_small'] = "whm-small.png";
$_LANG['prosper_custom2_banner_image_alt'] = $_LANG['prosper_custom2_name'];
$_LANG['prosper_custom2_banner_image_url'] = "https://www.youtube.com/watch?v=NAlCCCLg0rM";
$_LANG['prosper_custom2_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom2_banner_image_screenshot'] = true;
$_LANG['prosper_custom2_banner_image_video'] = true;
$_LANG['prosper_custom2_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom2_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom2_banner_button1_text'] = "Features";
$_LANG['prosper_custom2_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom2_banner_button1_url'] = "#features";
$_LANG['prosper_custom2_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom2_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom2_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom2_banner_button2_url'] = "#plans";
$_LANG['prosper_custom2_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom2_submenu_display'] = true;

$_LANG['prosper_custom2_submenu_1_display'] = true;
$_LANG['prosper_custom2_submenu_1_text'] = "Overview";
$_LANG['prosper_custom2_submenu_1_url'] = "#overview";
$_LANG['prosper_custom2_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom2_submenu_2_display'] = true;
$_LANG['prosper_custom2_submenu_2_text'] = "Plans";
$_LANG['prosper_custom2_submenu_2_url'] = "#plans";
$_LANG['prosper_custom2_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom2_submenu_3_display'] = true;
$_LANG['prosper_custom2_submenu_3_text'] = "Features";
$_LANG['prosper_custom2_submenu_3_url'] = "#features";
$_LANG['prosper_custom2_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom2_submenu_4_display'] = true;
$_LANG['prosper_custom2_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom2_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom2_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom2_submenu_5_display'] = true;
$_LANG['prosper_custom2_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom2_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom2_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom2_submenu_6_display'] = true;
$_LANG['prosper_custom2_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom2_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom2_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom2_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom2_name'] . " plan";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom2_overview_display'] = true;

$_LANG['prosper_custom2_overview_text'] = "

<p>Our reseller hosting plans come with everything you need to start a web hosting business. All plans come with cPanel/WHM which is the leading control panel in the web hosting industry. With WHM you can create and manage cPanel web hosting accounts for your clients.</p>
	
<p>As a " . $_LANG['prosper_setting_companyname'] . " reseller you can also promote many great features to your clients including Softaculous Script Installer, LiteSpeed Web Servers and R1Soft Daily Account Backups.</p>

";

// Features

$_LANG['prosper_custom2_features_display'] = true;

$_LANG['prosper_custom2_features_heading'] = $_LANG['prosper_custom2_name'] . " Features";

// Feature 1

$_LANG['prosper_custom2_features_1_display'] = true;
$_LANG['prosper_custom2_features_1_displayorder'] = 0;
$_LANG['prosper_custom2_features_1_heading'] = "Control Panel";
$_LANG['prosper_custom2_features_1_content_image'] = "custom2-features-1.png";
$_LANG['prosper_custom2_features_1_content_image_alt'] = "cpanel";
$_LANG['prosper_custom2_features_1_content_image_url'] = "";
$_LANG['prosper_custom2_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom2_features_1_content_image_bold'] = true;
$_LANG['prosper_custom2_features_1_content_heading'] = "cPanel/WHM";
$_LANG['prosper_custom2_features_1_content_heading2'] = "Take control of your web hosting business";
$_LANG['prosper_custom2_features_1_content_text'] = "

<p>WHM allows you to create and manage cPanel web hosting accounts for your clients. You can also automate this process using software such as WHMCS.</p>

<p>With cPanel your clients can easily manage every aspect of their web hosting account. From creating custom email addresses all the way to editing your website files.</p>

<p>The best thing about cPanel is that it can be accessed easily from any computer with an Internet connection.</p>

<p>With cPanel your clients can manage their website files with its browser based file manager (e.g upload, delete, edit files), Create/delete email accounts of their choice (@yourdomain.com) and access webmail via their browser, Install/remove software on their account with the help of Softaculous (Wordpress, Joomla etc) &amp; much more!</p>

<div class=\"gridboxes2-buttons\">
	<a href=\"https://trycpanel.net/\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>WHM Demo</a>
	<a href=\"https://demo.cpanel.net:2083/login/?user=democom&pass=DemoCoA5620&locale=en\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>cPanel Demo</a>
	<a href=\"https://www.youtube.com/watch?v=NAlCCCLg0rM\" rel=\"nofollow\" class=\"button1 color2 popup-youtube\"><i class=\"fab fa-youtube\"></i>Video Demo</a>
</div>

";

// Feature 2

$_LANG['prosper_custom2_features_2_display'] = true;
$_LANG['prosper_custom2_features_2_displayorder'] = 0;
$_LANG['prosper_custom2_features_2_heading'] = "Script Installer";
$_LANG['prosper_custom2_features_2_content_image'] = "custom2-features-2.png";
$_LANG['prosper_custom2_features_2_content_image_alt'] = "softaculous";
$_LANG['prosper_custom2_features_2_content_image_url'] = "";
$_LANG['prosper_custom2_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom2_features_2_content_image_bold'] = false;
$_LANG['prosper_custom2_features_2_content_heading'] = "Softaculous Script Installer";
$_LANG['prosper_custom2_features_2_content_heading2'] = "Easy to use";
$_LANG['prosper_custom2_features_2_content_text'] = "

<p>Softaculous is an application built into cPanel that will allow your clients to easily install from over 150 free scripts/software. The software they can install includes: WordPress, Joomla, phpBB, Magento, Prestashop and many more.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>WordPress</li>
		<li>Magento</li>
		<li>Joomla</li>
		<li>Prestashop</li>
		<li>phpBB</li>
		<li>Drupal</li>
	</ul>
</div><!-- .list -->

<p>No matter which type of website they're looking to build we provide access to software that'll make it easier to create and manage their website/blog/forum/online store! Purchase your " . $_LANG['prosper_setting_companyname'] . " reseller hosting account today and start providing Softaculous to your clients!</p>

";

// Feature 3

$_LANG['prosper_custom2_features_3_display'] = true;
$_LANG['prosper_custom2_features_3_displayorder'] = 0;
$_LANG['prosper_custom2_features_3_heading'] = "Server";
$_LANG['prosper_custom2_features_3_content_image'] = "custom2-features-3.png";
$_LANG['prosper_custom2_features_3_content_image_alt'] = "litespeed";
$_LANG['prosper_custom2_features_3_content_image_url'] = "";
$_LANG['prosper_custom2_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom2_features_3_content_image_bold'] = true;
$_LANG['prosper_custom2_features_3_content_heading'] = "LiteSpeed web servers";
$_LANG['prosper_custom2_features_3_content_heading2'] = "Powerful, lightning fast servers";
$_LANG['prosper_custom2_features_3_content_text'] = "

<p>All of our reseller hosting packages come with LiteSpeed. LiteSpeed is up to 9 times faster than Apache (standard web server setup). LiteSpeed fully supports everything that Apache uses such as .htaccess and mod_rewrite.</p>

<p>You should choose LiteSpeed if you want to processes PHP 50% faster, wow! - (Wordpress which is the most popular software uses PHP) &amp; benefit from 3 times faster than SSL Apache hosting!</p>

";

// Feature 4

$_LANG['prosper_custom2_features_4_display'] = true;
$_LANG['prosper_custom2_features_4_displayorder'] = 0;
$_LANG['prosper_custom2_features_4_heading'] = "Backups";
$_LANG['prosper_custom2_features_4_content_image'] = "custom2-features-4.png";
$_LANG['prosper_custom2_features_4_content_image_alt'] = "r1soft";
$_LANG['prosper_custom2_features_4_content_image_url'] = "";
$_LANG['prosper_custom2_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_custom2_features_4_content_image_bold'] = true;
$_LANG['prosper_custom2_features_4_content_heading'] = "R1Soft backups";
$_LANG['prosper_custom2_features_4_content_heading2'] = "Protecting your website";
$_LANG['prosper_custom2_features_4_content_text'] = "

<p>All of our reseller hosting accounts come with automated and completely free backups. This is made possible by the leading R1Soft Backup software. The backups are for both you and your clients accounts.</p>

<p>R1Soft is used by providers worldwide and currently protects over 250,000 servers!</p>

<p>R1Soft can be accessed directly in cPanel by both you and your clients giving easy access to website backups.</p>

";

// Feature 5

$_LANG['prosper_custom2_features_5_display'] = true;
$_LANG['prosper_custom2_features_5_displayorder'] = 0;
$_LANG['prosper_custom2_features_5_heading'] = "Datacenter";
$_LANG['prosper_custom2_features_5_content_image'] = "custom2-features-5.png";
$_LANG['prosper_custom2_features_5_content_image_alt'] = "datacenter";
$_LANG['prosper_custom2_features_5_content_image_url'] = "";
$_LANG['prosper_custom2_features_5_content_image_url_newwindow'] = false;
$_LANG['prosper_custom2_features_5_content_image_bold'] = true;
$_LANG['prosper_custom2_features_5_content_heading'] = "Our datacenter";
$_LANG['prosper_custom2_features_5_content_heading2'] = "24/7 monitoring";
$_LANG['prosper_custom2_features_5_content_text'] = "

<p>All of our servers are located in a large, well-known datacenter in Dallas Texas, USA. Our facility is monitored 24/7 to ensure that all servers are up.</p>

<p>Many companies out there take shortcuts when it comes to their servers. At " . $_LANG['prosper_setting_companyname'] . " we use the most up to date and premium quality servers available to ensure that both you and your clients website's loads lightning fast each and every time.</p>

";

// Feature 6

$_LANG['prosper_custom2_features_6_display'] = true;
$_LANG['prosper_custom2_features_6_displayorder'] = 0;
$_LANG['prosper_custom2_features_6_heading'] = "Awards";
$_LANG['prosper_custom2_features_6_content_image'] = "";
$_LANG['prosper_custom2_features_6_content_image_alt'] = "";
$_LANG['prosper_custom2_features_6_content_image_url'] = "";
$_LANG['prosper_custom2_features_6_content_image_url_newwindow'] = false;
$_LANG['prosper_custom2_features_6_content_image_bold'] = false;
$_LANG['prosper_custom2_features_6_content_heading'] = "Awards";
$_LANG['prosper_custom2_features_6_content_heading2'] = "Award winning provider";
$_LANG['prosper_custom2_features_6_content_text'] = "

<p>We've won a selection of prestigious awards as a reliable reseller web hosting provider. Made possible with a quality service offer and high level of included support.</p>

<p>Signup today with " . $_LANG['prosper_setting_companyname'] . " and find out how we've been able to acquire these awards through the quality of our servers and the free support we provide.</p>

<p>We are so confident that you will like our service that we provide a no questions asked 30 day money back guarantee!</p>

";

// Testimonials

$_LANG['prosper_custom2_testimonials_display'] = true;

$_LANG['prosper_custom2_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom2_testimonials_1_display'] = true;
$_LANG['prosper_custom2_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom2_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom2_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom2_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom2_testimonials_1_image'] = "custom2-testimonials-1.png";
$_LANG['prosper_custom2_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom2_testimonials_1_image_url'] = "";
$_LANG['prosper_custom2_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom2_testimonials_2_display'] = true;
$_LANG['prosper_custom2_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom2_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom2_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom2_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom2_testimonials_2_image'] = "custom2-testimonials-2.png";
$_LANG['prosper_custom2_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom2_testimonials_2_image_url'] = "";
$_LANG['prosper_custom2_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom2_testimonials_3_display'] = true;
$_LANG['prosper_custom2_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom2_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom2_testimonials_3_author'] = "George";
$_LANG['prosper_custom2_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom2_testimonials_3_image'] = "custom2-testimonials-3.png";
$_LANG['prosper_custom2_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom2_testimonials_3_image_url'] = "";
$_LANG['prosper_custom2_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom2_whychooseus_display'] = true;

$_LANG['prosper_custom2_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom2_whychooseus_1_display'] = true;
$_LANG['prosper_custom2_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom2_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom2_whychooseus_1_image'] = "custom2-whychooseus-1.png";
$_LANG['prosper_custom2_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom2_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom2_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom2_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom2_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom2_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom2_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom2_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom2_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom2_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom2_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom2_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom2_whychooseus_2_display'] = true;
$_LANG['prosper_custom2_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom2_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom2_whychooseus_2_image'] = "custom2-whychooseus-2.png";
$_LANG['prosper_custom2_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom2_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom2_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom2_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom2_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom2_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom2_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom2_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom2_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom2_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom2_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom2_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom2_whychooseus_3_display'] = true;
$_LANG['prosper_custom2_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom2_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom2_whychooseus_3_image'] = "custom2-whychooseus-3.png";
$_LANG['prosper_custom2_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom2_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom2_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom2_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom2_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom2_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom2_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom2_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom2_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom2_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom2_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom2_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom2_faqs_display'] = true;

$_LANG['prosper_custom2_faqs_heading'] = "FAQs";

$_LANG['prosper_custom2_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom2_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom2_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom2_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom2_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom2_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom2_faqs_question_button2_text'] = "";
$_LANG['prosper_custom2_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom2_faqs_question_button2_url'] = "";
$_LANG['prosper_custom2_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom2_faqs_1_display'] = true;
$_LANG['prosper_custom2_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom2_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom2_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom2_faqs_2_display'] = true;
$_LANG['prosper_custom2_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom2_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom2_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom2_faqs_3_display'] = true;
$_LANG['prosper_custom2_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom2_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom2_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   VPS Hosting page by default (File: vps-hosting.tpl, vps-hosting.php, includes/custom3.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom3_banner_display'] = true;
$_LANG['prosper_custom3_banner_heading'] = $_LANG['prosper_custom3_name'];
$_LANG['prosper_custom3_banner_text'] = "Take control of your hosting";
$_LANG['prosper_custom3_banner_feat1'] = "FREE SolusVM control panel";
$_LANG['prosper_custom3_banner_feat2'] = "FREE cPanel license with selected plans";
$_LANG['prosper_custom3_banner_feat3'] = "VPS Templates included allowing easy setup";
$_LANG['prosper_custom3_banner_feat4'] = "Option to use LiteSpeed or Apache";
$_LANG['prosper_custom3_banner_feat5'] = "Money Back Guarantee on all plans";
$_LANG['prosper_custom3_banner_feat6'] = "Hundreds of video tutorials";
$_LANG['prosper_custom3_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom3_banner_background'] = "background.jpg";
$_LANG['prosper_custom3_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom3_banner_price_before'] = "Starting From";
$_LANG['prosper_custom3_banner_price'] = "24.99";
$_LANG['prosper_custom3_banner_price_term'] = "/month";
$_LANG['prosper_custom3_banner_image'] = "solusvm.png";
$_LANG['prosper_custom3_banner_image_small'] = "solusvm-small.png";
$_LANG['prosper_custom3_banner_image_alt'] = $_LANG['prosper_custom3_name'];
$_LANG['prosper_custom3_banner_image_url'] = "#features";
$_LANG['prosper_custom3_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom3_banner_image_screenshot'] = true;
$_LANG['prosper_custom3_banner_image_video'] = false;
$_LANG['prosper_custom3_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom3_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom3_banner_button1_text'] = "Features";
$_LANG['prosper_custom3_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom3_banner_button1_url'] = "#features";
$_LANG['prosper_custom3_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom3_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom3_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom3_banner_button2_url'] = "#plans";
$_LANG['prosper_custom3_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom3_submenu_display'] = true;

$_LANG['prosper_custom3_submenu_1_display'] = true;
$_LANG['prosper_custom3_submenu_1_text'] = "Overview";
$_LANG['prosper_custom3_submenu_1_url'] = "#overview";
$_LANG['prosper_custom3_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom3_submenu_2_display'] = true;
$_LANG['prosper_custom3_submenu_2_text'] = "Plans";
$_LANG['prosper_custom3_submenu_2_url'] = "#plans";
$_LANG['prosper_custom3_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom3_submenu_3_display'] = true;
$_LANG['prosper_custom3_submenu_3_text'] = "Features";
$_LANG['prosper_custom3_submenu_3_url'] = "#features";
$_LANG['prosper_custom3_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom3_submenu_4_display'] = true;
$_LANG['prosper_custom3_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom3_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom3_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom3_submenu_5_display'] = true;
$_LANG['prosper_custom3_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom3_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom3_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom3_submenu_6_display'] = true;
$_LANG['prosper_custom3_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom3_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom3_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom3_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom3_name'] . " plan";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom3_overview_display'] = true;

$_LANG['prosper_custom3_overview_text'] = "

<p>Purchase a VPS today to add a large amount of power to your website(s). A virtual server is a dedicated section of a server that is significantly more powerful than conventional shared hosting. A VPS will also give you freedom to install the software and extensions with the direct root access.</p>

";

// Features

$_LANG['prosper_custom3_features_display'] = true;

$_LANG['prosper_custom3_features_heading'] = $_LANG['prosper_custom3_name'] . " Features";

// Feature 1

$_LANG['prosper_custom3_features_1_display'] = true;
$_LANG['prosper_custom3_features_1_displayorder'] = 0;
$_LANG['prosper_custom3_features_1_heading'] = "Control Panel";
$_LANG['prosper_custom3_features_1_content_image'] = "custom3-features-1.png";
$_LANG['prosper_custom3_features_1_content_image_alt'] = "solusvm";
$_LANG['prosper_custom3_features_1_content_image_url'] = "";
$_LANG['prosper_custom3_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom3_features_1_content_image_bold'] = true;
$_LANG['prosper_custom3_features_1_content_heading'] = "SolusVM";
$_LANG['prosper_custom3_features_1_content_heading2'] = "Take full control of your VPS";
$_LANG['prosper_custom3_features_1_content_text'] = "

<p>With SolusVM you can easily manage every aspect of your VPS. Features include power, usage stats, rebooting, settings &amp; statistics.</p>

<p>The best thing about SolusVM is that it can be accessed easily from any computer with an Internet connection.</p>

<p>SolusVM is the most popular VPS management software on the market which is why we offer it with all of our packages.</p>

";

// Feature 2

$_LANG['prosper_custom3_features_2_display'] = true;
$_LANG['prosper_custom3_features_2_displayorder'] = 0;
$_LANG['prosper_custom3_features_2_heading'] = "Script Installer";
$_LANG['prosper_custom3_features_2_content_image'] = "custom3-features-2.png";
$_LANG['prosper_custom3_features_2_content_image_alt'] = "softaculous";
$_LANG['prosper_custom3_features_2_content_image_url'] = "";
$_LANG['prosper_custom3_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom3_features_2_content_image_bold'] = false;
$_LANG['prosper_custom3_features_2_content_heading'] = "Softaculous Script Installer";
$_LANG['prosper_custom3_features_2_content_heading2'] = "Easy to use";
$_LANG['prosper_custom3_features_2_content_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, phpBB, Magento, Prestashop and many more.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>WordPress</li>
		<li>Magento</li>
		<li>Joomla</li>
		<li>Prestashop</li>
		<li>phpBB</li>
		<li>Drupal</li>
	</ul>
</div><!-- .list -->

<p>No matter which type of website you're looking to build we provide access to software that'll make it easier to create and manage your website/blog/forum/online store! Don't get court with hosting services that make it hard to install these scripts. Join " . $_LANG['prosper_setting_companyname'] . " today and gain instant access to this feature!</p>

";

// Feature 3

$_LANG['prosper_custom3_features_3_display'] = true;
$_LANG['prosper_custom3_features_3_displayorder'] = 0;
$_LANG['prosper_custom3_features_3_heading'] = "OS";
$_LANG['prosper_custom3_features_3_content_image'] = "custom3-features-3.png";
$_LANG['prosper_custom3_features_3_content_image_alt'] = "litespeed";
$_LANG['prosper_custom3_features_3_content_image_url'] = "";
$_LANG['prosper_custom3_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom3_features_3_content_image_bold'] = true;
$_LANG['prosper_custom3_features_3_content_heading'] = "LiteSpeed or Apache";
$_LANG['prosper_custom3_features_3_content_heading2'] = "Choose the OS of your VPS";
$_LANG['prosper_custom3_features_3_content_text'] = "

<p>All of our VPS come with root access allowing you to choose the OS. Apache is free and popular OS that is the default option with all of our VPS. During checkout you can also select LiteSpeed. LiteSpeed is up to 9 times faster than Apache (standard web server setup). LiteSpeed fully supports everything that Apache uses such as .htaccess and mod_rewrite.</p>

<p>You should choose LiteSpeed if you want to processes PHP 50% faster, wow! - (WordPress which is the most popular software uses PHP) &amp; benefit from 3 times faster than SSL Apache hosting!</p>

";

// Feature 4

$_LANG['prosper_custom3_features_4_display'] = true;
$_LANG['prosper_custom3_features_4_displayorder'] = 0;
$_LANG['prosper_custom3_features_4_heading'] = "Backups";
$_LANG['prosper_custom3_features_4_content_image'] = "custom3-features-4.png";
$_LANG['prosper_custom3_features_4_content_image_alt'] = "r1soft";
$_LANG['prosper_custom3_features_4_content_image_url'] = "";
$_LANG['prosper_custom3_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_custom3_features_4_content_image_bold'] = true;
$_LANG['prosper_custom3_features_4_content_heading'] = "R1Soft backups";
$_LANG['prosper_custom3_features_4_content_heading2'] = "Protecting your website";
$_LANG['prosper_custom3_features_4_content_text'] = "

<p>Add R1Soft to your VPS order to completely automate backups.</p>

<p>R1Soft is used by providers worldwide and currently protects over 250,000 servers!</p>

<p>R1Soft can be accessed directly in cPanel giving you instant and easy access to backups of your website files &amp; database!</p>

";

// Feature 5

$_LANG['prosper_custom3_features_5_display'] = true;
$_LANG['prosper_custom3_features_5_displayorder'] = 0;
$_LANG['prosper_custom3_features_5_heading'] = "Datacenter";
$_LANG['prosper_custom3_features_5_content_image'] = "custom3-features-5.png";
$_LANG['prosper_custom3_features_5_content_image_alt'] = "datacenter";
$_LANG['prosper_custom3_features_5_content_image_url'] = "";
$_LANG['prosper_custom3_features_5_content_image_url_newwindow'] = false;
$_LANG['prosper_custom3_features_5_content_image_bold'] = true;
$_LANG['prosper_custom3_features_5_content_heading'] = "Our datacenter";
$_LANG['prosper_custom3_features_5_content_heading2'] = "24/7 monitoring";
$_LANG['prosper_custom3_features_5_content_text'] = "

<p>All of VPS servers are located in a large, well-known datacenter in Dallas Texas, USA. Our facility is monitored 24/7 to ensure that all servers are up.</p>

<p>Many companies out there take shortcuts when it comes to their servers. At " . $_LANG['prosper_setting_companyname'] . " we use the most up to date and premium quality servers available to ensure that your website loads lightning fast each and every time.</p>

";

// Feature 6

$_LANG['prosper_custom3_features_6_display'] = true;
$_LANG['prosper_custom3_features_6_displayorder'] = 0;
$_LANG['prosper_custom3_features_6_heading'] = "Awards";
$_LANG['prosper_custom3_features_6_content_image'] = "";
$_LANG['prosper_custom3_features_6_content_image_alt'] = "";
$_LANG['prosper_custom3_features_6_content_image_url'] = "";
$_LANG['prosper_custom3_features_6_content_image_url_newwindow'] = false;
$_LANG['prosper_custom3_features_6_content_image_bold'] = false;
$_LANG['prosper_custom3_features_6_content_heading'] = "Awards";
$_LANG['prosper_custom3_features_6_content_heading2'] = "Award winning provider";
$_LANG['prosper_custom3_features_6_content_text'] = "

<p>We've won a selection of prestigious awards as a reliable VPS hosting provider. Made possible with a quality service offer and high level of included support.</p>

<p>Signup today with " . $_LANG['prosper_setting_companyname'] . " and find out how we've been able to acquire these awards through the quality of our servers and the free support we provide.</p>

<p>We are so confident that you will like our service that we provide a no questions asked 30 day money back guarantee!</p>

";

// Testimonials

$_LANG['prosper_custom3_testimonials_display'] = true;

$_LANG['prosper_custom3_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom3_testimonials_1_display'] = true;
$_LANG['prosper_custom3_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom3_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom3_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom3_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom3_testimonials_1_image'] = "custom3-testimonials-1.png";
$_LANG['prosper_custom3_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom3_testimonials_1_image_url'] = "";
$_LANG['prosper_custom3_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom3_testimonials_2_display'] = true;
$_LANG['prosper_custom3_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom3_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom3_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom3_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom3_testimonials_2_image'] = "custom3-testimonials-2.png";
$_LANG['prosper_custom3_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom3_testimonials_2_image_url'] = "";
$_LANG['prosper_custom3_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom3_testimonials_3_display'] = true;
$_LANG['prosper_custom3_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom3_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom3_testimonials_3_author'] = "George";
$_LANG['prosper_custom3_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom3_testimonials_3_image'] = "custom3-testimonials-3.png";
$_LANG['prosper_custom3_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom3_testimonials_3_image_url'] = "";
$_LANG['prosper_custom3_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom3_whychooseus_display'] = true;

$_LANG['prosper_custom3_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom3_whychooseus_1_display'] = true;
$_LANG['prosper_custom3_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom3_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom3_whychooseus_1_image'] = "custom3-whychooseus-1.png";
$_LANG['prosper_custom3_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom3_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom3_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom3_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom3_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom3_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom3_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom3_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom3_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom3_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom3_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom3_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom3_whychooseus_2_display'] = true;
$_LANG['prosper_custom3_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom3_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom3_whychooseus_2_image'] = "custom3-whychooseus-2.png";
$_LANG['prosper_custom3_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom3_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom3_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom3_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom3_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom3_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom3_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom3_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom3_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom3_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom3_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom3_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom3_whychooseus_3_display'] = true;
$_LANG['prosper_custom3_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom3_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom3_whychooseus_3_image'] = "custom3-whychooseus-3.png";
$_LANG['prosper_custom3_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom3_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom3_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom3_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom3_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom3_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom3_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom3_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom3_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom3_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom3_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom3_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom3_faqs_display'] = true;

$_LANG['prosper_custom3_faqs_heading'] = "FAQs";

$_LANG['prosper_custom3_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom3_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom3_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom3_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom3_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom3_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom3_faqs_question_button2_text'] = "";
$_LANG['prosper_custom3_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom3_faqs_question_button2_url'] = "";
$_LANG['prosper_custom3_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom3_faqs_1_display'] = true;
$_LANG['prosper_custom3_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom3_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom3_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom3_faqs_2_display'] = true;
$_LANG['prosper_custom3_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom3_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom3_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom3_faqs_3_display'] = true;
$_LANG['prosper_custom3_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom3_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom3_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Dedicated Servers page by default (File: dedicated-servers.tpl, dedicated-servers.php, includes/custom4.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom4_banner_display'] = true;
$_LANG['prosper_custom4_banner_heading'] = $_LANG['prosper_custom4_name'];
$_LANG['prosper_custom4_banner_text'] = "The most powerful hosting";
$_LANG['prosper_custom4_banner_feat1'] = "Full root access to your own server";
$_LANG['prosper_custom4_banner_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_custom4_banner_feat3'] = "Money back guarantee with all servers";
$_LANG['prosper_custom4_banner_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_custom4_banner_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_custom4_banner_feat6'] = "Perfect solution for large businesses";
$_LANG['prosper_custom4_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom4_banner_background'] = "background.jpg";
$_LANG['prosper_custom4_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom4_banner_price_before'] = "Starting From";
$_LANG['prosper_custom4_banner_price'] = "84.99";
$_LANG['prosper_custom4_banner_price_term'] = "/month";
$_LANG['prosper_custom4_banner_image'] = "dedicatedserver.png";
$_LANG['prosper_custom4_banner_image_small'] = "dedicatedserver.png";
$_LANG['prosper_custom4_banner_image_alt'] = $_LANG['prosper_custom4_name'];
$_LANG['prosper_custom4_banner_image_url'] = "#features";
$_LANG['prosper_custom4_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom4_banner_image_screenshot'] = false;
$_LANG['prosper_custom4_banner_image_video'] = false;
$_LANG['prosper_custom4_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom4_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom4_banner_button1_text'] = "Features";
$_LANG['prosper_custom4_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom4_banner_button1_url'] = "#features";
$_LANG['prosper_custom4_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom4_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom4_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom4_banner_button2_url'] = "#plans";
$_LANG['prosper_custom4_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom4_submenu_display'] = true;

$_LANG['prosper_custom4_submenu_1_display'] = true;
$_LANG['prosper_custom4_submenu_1_text'] = "Overview";
$_LANG['prosper_custom4_submenu_1_url'] = "#overview";
$_LANG['prosper_custom4_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom4_submenu_2_display'] = true;
$_LANG['prosper_custom4_submenu_2_text'] = "Plans";
$_LANG['prosper_custom4_submenu_2_url'] = "#plans";
$_LANG['prosper_custom4_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom4_submenu_3_display'] = true;
$_LANG['prosper_custom4_submenu_3_text'] = "Features";
$_LANG['prosper_custom4_submenu_3_url'] = "#features";
$_LANG['prosper_custom4_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom4_submenu_4_display'] = true;
$_LANG['prosper_custom4_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom4_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom4_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom4_submenu_5_display'] = true;
$_LANG['prosper_custom4_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom4_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom4_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom4_submenu_6_display'] = true;
$_LANG['prosper_custom4_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom4_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom4_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom4_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom4_name'];

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom4_overview_display'] = true;

$_LANG['prosper_custom4_overview_text'] = "

<p>Are you looking for the most powerful hosting option? Then look no further than our dedicated servers. A dedicated server is a single full access server that is used by only you. This allows you to use all of the available server resources and is widely considered to be the best option for large scale businesses. All of our dedicated servers come with free setup.</p>

";

// Features

$_LANG['prosper_custom4_features_display'] = true;

$_LANG['prosper_custom4_features_heading'] = $_LANG['prosper_custom4_name'] . " Features";

// Feature 1

$_LANG['prosper_custom4_features_1_display'] = true;
$_LANG['prosper_custom4_features_1_displayorder'] = 0;
$_LANG['prosper_custom4_features_1_heading'] = "Datacenter";
$_LANG['prosper_custom4_features_1_content_image'] = "custom4-features-1.png";
$_LANG['prosper_custom4_features_1_content_image_alt'] = "cpanel";
$_LANG['prosper_custom4_features_1_content_image_url'] = "";
$_LANG['prosper_custom4_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom4_features_1_content_image_bold'] = true;
$_LANG['prosper_custom4_features_1_content_heading'] = "Our datacenter";
$_LANG['prosper_custom4_features_1_content_heading2'] = "24/7 monitoring";
$_LANG['prosper_custom4_features_1_content_text'] = "

<p>All of our dedicated servers are located in a large, well-known datacenter in Dallas Texas, USA. Our facility is monitored 24/7 to ensure that all servers are up.</p>

<p>Many companies out there take shortcuts when it comes to their servers. At " . $_LANG['prosper_setting_companyname'] . " we use the most up to date and premium quality servers available to ensure that your website loads lightning fast each and every time.</p>

";

// Feature 2

$_LANG['prosper_custom4_features_2_display'] = true;
$_LANG['prosper_custom4_features_2_displayorder'] = 0;
$_LANG['prosper_custom4_features_2_heading'] = "OS";
$_LANG['prosper_custom4_features_2_content_image'] = "custom4-features-2.png";
$_LANG['prosper_custom4_features_2_content_image_alt'] = "os";
$_LANG['prosper_custom4_features_2_content_image_url'] = "";
$_LANG['prosper_custom4_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom4_features_2_content_image_bold'] = true;
$_LANG['prosper_custom4_features_2_content_heading'] = "LiteSpeed or Apache OS";
$_LANG['prosper_custom4_features_2_content_heading2'] = "Powerful, lightning fast servers";
$_LANG['prosper_custom4_features_2_content_text'] = "

<p>Your server comes with the option to use LiteSpeed instead of Apache. LiteSpeed is up to 9 times faster than Apache (standard web server setup). LiteSpeed fully supports everything that Apache uses such as .htaccess and mod_rewrite so if your website loads quickly on an Apache server it will be even faster on our servers!</p>

<p>You should choose LiteSpeed if you want to processes PHP 50% faster, wow! - (Wordpress which is the most popular software uses PHP) &amp; benefit from 3 times faster than SSL Apache hosting!</p>

";

// Feature 3

$_LANG['prosper_custom4_features_3_display'] = true;
$_LANG['prosper_custom4_features_3_displayorder'] = 0;
$_LANG['prosper_custom4_features_3_heading'] = "cPanel";
$_LANG['prosper_custom4_features_3_content_image'] = "custom4-features-3.png";
$_LANG['prosper_custom4_features_3_content_image_alt'] = "cpanel";
$_LANG['prosper_custom4_features_3_content_image_url'] = "";
$_LANG['prosper_custom4_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom4_features_3_content_image_bold'] = true;
$_LANG['prosper_custom4_features_3_content_heading'] = "cPanel License";
$_LANG['prosper_custom4_features_3_content_heading2'] = "The most powerful control panel";
$_LANG['prosper_custom4_features_3_content_text'] = "

<p>If you're looking to ease into your dedicated server without using SSH you have the option to use cPanel. Using cPanel you can easily manage every aspect of your web hosting environment without using root access. From creating custom email addresses all the way to editing your website files.</p>

<p>The best thing about cPanel is that it can be accessed easily from any computer with an Internet connection.</p>

<p>With cPanel you can manage your website files with its browser based file manager (e.g upload, delete, edit files), Create/delete email accounts of your choice (@yourdomain.com) and access webmail via your browser, Install/remove software on your account with the help of Softaculous (Wordpress, Joomla etc) &amp; much more!</p>

<div class=\"gridboxes2-buttons\">
	<a href=\"https://demo.cpanel.net:2083/login/?user=democom&pass=DemoCoA5620&locale=en\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>cPanel Demo</a>
</div>

";

// Feature 4

$_LANG['prosper_custom4_features_4_display'] = true;
$_LANG['prosper_custom4_features_4_displayorder'] = 0;
$_LANG['prosper_custom4_features_4_heading'] = "Softaculous";
$_LANG['prosper_custom4_features_4_content_image'] = "custom4-features-4.png";
$_LANG['prosper_custom4_features_4_content_image_alt'] = "softaculous";
$_LANG['prosper_custom4_features_4_content_image_url'] = "";
$_LANG['prosper_custom4_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_custom4_features_4_content_image_bold'] = false;
$_LANG['prosper_custom4_features_4_content_heading'] = "Softaculous script installer";
$_LANG['prosper_custom4_features_4_content_heading2'] = "Protecting your website";
$_LANG['prosper_custom4_features_4_content_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, phpBB, Magento, Prestashop and many more.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>WordPress</li>
		<li>Magento</li>
		<li>Joomla</li>
		<li>Prestashop</li>
		<li>phpBB</li>
		<li>Drupal</li>
	</ul>
</div><!-- .list -->

<p>No matter which type of website you're looking to build we provide access to software that'll make it easier to create and manage your website/blog/forum/online store! Don't get court with hosting services that make it hard to install these scripts. Join " . $_LANG['prosper_setting_companyname'] . " today and gain instant access to this feature!</p>

";

// Feature 5

$_LANG['prosper_custom4_features_5_display'] = true;
$_LANG['prosper_custom4_features_5_displayorder'] = 0;
$_LANG['prosper_custom4_features_5_heading'] = "Backups";
$_LANG['prosper_custom4_features_5_content_image'] = "custom4-features-5.png";
$_LANG['prosper_custom4_features_5_content_image_alt'] = "datacenter";
$_LANG['prosper_custom4_features_5_content_image_url'] = "";
$_LANG['prosper_custom4_features_5_content_image_url_newwindow'] = false;
$_LANG['prosper_custom4_features_5_content_image_bold'] = true;
$_LANG['prosper_custom4_features_5_content_heading'] = "R1Soft";
$_LANG['prosper_custom4_features_5_content_heading2'] = "Protecting your website";
$_LANG['prosper_custom4_features_5_content_text'] = "

<p>All of dedicated servers come with automated and completely free backups. This is made possible by the leading R1Soft Backup software.</p>

<p>R1Soft is used by providers worldwide and currently protects over 250,000 servers!</p>

<p>R1Soft can be accessed directly in cPanel giving you instant and easy access to backups of your website files &amp; database!</p>

";

// Testimonials

$_LANG['prosper_custom4_testimonials_display'] = true;

$_LANG['prosper_custom4_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom4_testimonials_1_display'] = true;
$_LANG['prosper_custom4_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom4_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom4_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom4_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom4_testimonials_1_image'] = "custom4-testimonials-1.png";
$_LANG['prosper_custom4_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom4_testimonials_1_image_url'] = "";
$_LANG['prosper_custom4_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom4_testimonials_2_display'] = true;
$_LANG['prosper_custom4_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom4_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom4_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom4_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom4_testimonials_2_image'] = "custom4-testimonials-2.png";
$_LANG['prosper_custom4_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom4_testimonials_2_image_url'] = "";
$_LANG['prosper_custom4_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom4_testimonials_3_display'] = true;
$_LANG['prosper_custom4_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom4_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom4_testimonials_3_author'] = "George";
$_LANG['prosper_custom4_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom4_testimonials_3_image'] = "custom4-testimonials-3.png";
$_LANG['prosper_custom4_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom4_testimonials_3_image_url'] = "";
$_LANG['prosper_custom4_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom4_whychooseus_display'] = true;

$_LANG['prosper_custom4_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom4_whychooseus_1_display'] = true;
$_LANG['prosper_custom4_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom4_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom4_whychooseus_1_image'] = "custom4-whychooseus-1.png";
$_LANG['prosper_custom4_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom4_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom4_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom4_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom4_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom4_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom4_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom4_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom4_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom4_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom4_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom4_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom4_whychooseus_2_display'] = true;
$_LANG['prosper_custom4_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom4_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom4_whychooseus_2_image'] = "custom4-whychooseus-2.png";
$_LANG['prosper_custom4_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom4_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom4_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom4_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom4_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom4_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom4_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom4_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom4_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom4_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom4_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom4_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom4_whychooseus_3_display'] = true;
$_LANG['prosper_custom4_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom4_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom4_whychooseus_3_image'] = "custom4-whychooseus-3.png";
$_LANG['prosper_custom4_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom4_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom4_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom4_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom4_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom4_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom4_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom4_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom4_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom4_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom4_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom4_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom4_faqs_display'] = true;

$_LANG['prosper_custom4_faqs_heading'] = "FAQs";

$_LANG['prosper_custom4_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom4_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom4_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom4_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom4_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom4_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom4_faqs_question_button2_text'] = "";
$_LANG['prosper_custom4_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom4_faqs_question_button2_url'] = "";
$_LANG['prosper_custom4_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom4_faqs_1_display'] = true;
$_LANG['prosper_custom4_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom4_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom4_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom4_faqs_2_display'] = true;
$_LANG['prosper_custom4_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom4_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom4_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom4_faqs_3_display'] = true;
$_LANG['prosper_custom4_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom4_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom4_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Cloud Hosting page by default (File: cloud-hosting.tpl, cloud-hosting.php, includes/custom5.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom5_banner_display'] = true;
$_LANG['prosper_custom5_banner_heading'] = $_LANG['prosper_custom5_name'];
$_LANG['prosper_custom5_banner_text'] = "Take your website to the cloud";
$_LANG['prosper_custom5_banner_feat1'] = "Our Cloud hosting is highly scaleable";
$_LANG['prosper_custom5_banner_feat2'] = "Award-winning 24/7 technical support";
$_LANG['prosper_custom5_banner_feat3'] = "Money back guarantee with all plans";
$_LANG['prosper_custom5_banner_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['prosper_custom5_banner_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['prosper_custom5_banner_feat6'] = "Perfect for personal websites and businesses";
$_LANG['prosper_custom5_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom5_banner_background'] = "background.jpg";
$_LANG['prosper_custom5_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom5_banner_price_before'] = "Starting From";
$_LANG['prosper_custom5_banner_price'] = "19.99";
$_LANG['prosper_custom5_banner_price_term'] = "/month";
$_LANG['prosper_custom5_banner_image'] = "cloud.png";
$_LANG['prosper_custom5_banner_image_small'] = "cloud.png";
$_LANG['prosper_custom5_banner_image_alt'] = $_LANG['prosper_custom5_name'];
$_LANG['prosper_custom5_banner_image_url'] = "#features";
$_LANG['prosper_custom5_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom5_banner_image_screenshot'] = false;
$_LANG['prosper_custom5_banner_image_video'] = false;
$_LANG['prosper_custom5_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom5_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom5_banner_button1_text'] = "Features";
$_LANG['prosper_custom5_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom5_banner_button1_url'] = "#features";
$_LANG['prosper_custom5_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom5_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom5_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom5_banner_button2_url'] = "#plans";
$_LANG['prosper_custom5_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom5_submenu_display'] = true;

$_LANG['prosper_custom5_submenu_1_display'] = true;
$_LANG['prosper_custom5_submenu_1_text'] = "Overview";
$_LANG['prosper_custom5_submenu_1_url'] = "#overview";
$_LANG['prosper_custom5_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom5_submenu_2_display'] = true;
$_LANG['prosper_custom5_submenu_2_text'] = "Plans";
$_LANG['prosper_custom5_submenu_2_url'] = "#plans";
$_LANG['prosper_custom5_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom5_submenu_3_display'] = true;
$_LANG['prosper_custom5_submenu_3_text'] = "Features";
$_LANG['prosper_custom5_submenu_3_url'] = "#features";
$_LANG['prosper_custom5_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom5_submenu_4_display'] = true;
$_LANG['prosper_custom5_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom5_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom5_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom5_submenu_5_display'] = true;
$_LANG['prosper_custom5_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom5_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom5_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom5_submenu_6_display'] = true;
$_LANG['prosper_custom5_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom5_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom5_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom5_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom5_name'] . " plan";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom5_overview_display'] = true;

$_LANG['prosper_custom5_overview_text'] = "

<p>Take your website to the cloud with our wide variety of cloud hosting packages. Cloud Hosting is highly scaleable allowing you to adjust your hosting environment instantly. We use cPanel, the leading hosting control panel for all of our plans. With cPanel you can easily manage every aspect of your web hosting account.</p>

";

// Features

$_LANG['prosper_custom5_features_display'] = true;

$_LANG['prosper_custom5_features_heading'] = $_LANG['prosper_custom5_name'] . " Features";

// Feature 1

$_LANG['prosper_custom5_features_1_display'] = true;
$_LANG['prosper_custom5_features_1_displayorder'] = 0;
$_LANG['prosper_custom5_features_1_heading'] = "Control Panel";
$_LANG['prosper_custom5_features_1_content_image'] = "custom5-features-1.png";
$_LANG['prosper_custom5_features_1_content_image_alt'] = "cpanel";
$_LANG['prosper_custom5_features_1_content_image_url'] = "";
$_LANG['prosper_custom5_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom5_features_1_content_image_bold'] = true;
$_LANG['prosper_custom5_features_1_content_heading'] = "cPanel Control Panel";
$_LANG['prosper_custom5_features_1_content_heading2'] = "The most powerful control panel";
$_LANG['prosper_custom5_features_1_content_text'] = "

<p>With cPanel you can easily manage every aspect of your cloud hosting account. From creating custom email addresses all the way to editing your website files.</p>

<p>The best thing about cPanel is that it can be accessed easily from any computer with an Internet connection.</p>

<p>With cPanel you can manage your website files with its browser based file manager (e.g upload, delete, edit files), Create/delete email accounts of your choice (@yourdomain.com) and access webmail via your browser, Install/remove software on your account with the help of Softaculous (Wordpress, Joomla etc) &amp; much more!</p>

<div class=\"gridboxes2-buttons\">
	<a href=\"https://demo.cpanel.net:2083/login/?user=democom&pass=DemoCoA5620&locale=en\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>cPanel Demo</a>
</div>

";

// Feature 2

$_LANG['prosper_custom5_features_2_display'] = true;
$_LANG['prosper_custom5_features_2_displayorder'] = 0;
$_LANG['prosper_custom5_features_2_heading'] = "Script Installer";
$_LANG['prosper_custom5_features_2_content_image'] = "custom5-features-2.png";
$_LANG['prosper_custom5_features_2_content_image_alt'] = "softaculous";
$_LANG['prosper_custom5_features_2_content_image_url'] = "";
$_LANG['prosper_custom5_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom5_features_2_content_image_bold'] = false;
$_LANG['prosper_custom5_features_2_content_heading'] = "Softaculous Script Installer";
$_LANG['prosper_custom5_features_2_content_heading2'] = "Easy to use";
$_LANG['prosper_custom5_features_2_content_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, phpBB, Magento, Prestashop and many more.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>WordPress</li>
		<li>Magento</li>
		<li>Joomla</li>
		<li>Prestashop</li>
		<li>phpBB</li>
		<li>Drupal</li>
	</ul>
</div><!-- .list -->

<p>No matter which type of website you're looking to build we provide access to software that'll make it easier to create and manage your website/blog/forum/online store! Don't get court with hosting services that make it hard to install these scripts. Join " . $_LANG['prosper_setting_companyname'] . " today and gain instant access to this feature!</p>

";

// Feature 3

$_LANG['prosper_custom5_features_3_display'] = true;
$_LANG['prosper_custom5_features_3_displayorder'] = 0;
$_LANG['prosper_custom5_features_3_heading'] = "Server";
$_LANG['prosper_custom5_features_3_content_image'] = "custom5-features-3.png";
$_LANG['prosper_custom5_features_3_content_image_alt'] = "litespeed";
$_LANG['prosper_custom5_features_3_content_image_url'] = "";
$_LANG['prosper_custom5_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom5_features_3_content_image_bold'] = true;
$_LANG['prosper_custom5_features_3_content_heading'] = "LiteSpeed web servers";
$_LANG['prosper_custom5_features_3_content_heading2'] = "Powerful, lightning fast servers";
$_LANG['prosper_custom5_features_3_content_text'] = "

<p>All of our cloud hosting packages also come packed with LiteSpeed. LiteSpeed is up to 9 times faster than Apache (standard web server setup). LiteSpeed fully supports everything that Apache uses such as .htaccess and mod_rewrite so if your website loads quickly on an Apache server it will be even faster on our servers!</p>

<p>You should choose LiteSpeed if you want to processes PHP 50% faster, wow! - (Wordpress which is the most popular software uses PHP) &amp; benefit from 3 times faster than SSL Apache hosting!</p>

";

// Feature 4

$_LANG['prosper_custom5_features_4_display'] = true;
$_LANG['prosper_custom5_features_4_displayorder'] = 0;
$_LANG['prosper_custom5_features_4_heading'] = "Backups";
$_LANG['prosper_custom5_features_4_content_image'] = "custom5-features-4.png";
$_LANG['prosper_custom5_features_4_content_image_alt'] = "r1soft";
$_LANG['prosper_custom5_features_4_content_image_url'] = "";
$_LANG['prosper_custom5_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_custom5_features_4_content_image_bold'] = true;
$_LANG['prosper_custom5_features_4_content_heading'] = "R1Soft backups";
$_LANG['prosper_custom5_features_4_content_heading2'] = "Protecting your website";
$_LANG['prosper_custom5_features_4_content_text'] = "

<p>All of our cloud hosting accounts come with automated and completely free backups. This is made possible by the leading R1Soft Backup software.</p>

<p>R1Soft is used by providers worldwide and currently protects over 250,000 servers!</p>

<p>R1Soft can be accessed directly in cPanel giving you instant and easy access to backups of your website files &amp; database!</p>

";

// Feature 5

$_LANG['prosper_custom5_features_5_display'] = true;
$_LANG['prosper_custom5_features_5_displayorder'] = 0;
$_LANG['prosper_custom5_features_5_heading'] = "Datacenter";
$_LANG['prosper_custom5_features_5_content_image'] = "custom5-features-5.png";
$_LANG['prosper_custom5_features_5_content_image_alt'] = "datacenter";
$_LANG['prosper_custom5_features_5_content_image_url'] = "";
$_LANG['prosper_custom5_features_5_content_image_url_newwindow'] = false;
$_LANG['prosper_custom5_features_5_content_image_bold'] = true;
$_LANG['prosper_custom5_features_5_content_heading'] = "Our datacenter";
$_LANG['prosper_custom5_features_5_content_heading2'] = "24/7 monitoring";
$_LANG['prosper_custom5_features_5_content_text'] = "

<p>All of our cloud servers are located in a large, well-known datacenter in Dallas Texas, USA. Our facility is monitored 24/7 to ensure that all servers are up.</p>

<p>Many companies out there take shortcuts when it comes to their servers. At " . $_LANG['prosper_setting_companyname'] . " we use the most up to date and premium quality servers available to ensure that your website loads lightning fast each and every time.</p>

";

// Feature 6

$_LANG['prosper_custom5_features_6_display'] = true;
$_LANG['prosper_custom5_features_6_displayorder'] = 0;
$_LANG['prosper_custom5_features_6_heading'] = "Awards";
$_LANG['prosper_custom5_features_6_content_image'] = "";
$_LANG['prosper_custom5_features_6_content_image_alt'] = "";
$_LANG['prosper_custom5_features_6_content_image_url'] = "";
$_LANG['prosper_custom5_features_6_content_image_url_newwindow'] = false;
$_LANG['prosper_custom5_features_6_content_image_bold'] = false;
$_LANG['prosper_custom5_features_6_content_heading'] = "Awards";
$_LANG['prosper_custom5_features_6_content_heading2'] = "Award winning provider";
$_LANG['prosper_custom5_features_6_content_text'] = "

<p>We've won a selection of prestigious awards as a reliable cloud hosting provider. Made possible with a quality service offer and high level of included support.</p>

<p>Signup today with " . $_LANG['prosper_setting_companyname'] . " and find out how we've been able to acquire these awards through the quality of our servers and the free support we provide.</p>

<p>We are so confident that you will like our service that we provide a no questions asked 30 day money back guarantee!</p>

";

// Testimonials

$_LANG['prosper_custom5_testimonials_display'] = true;

$_LANG['prosper_custom5_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom5_testimonials_1_display'] = true;
$_LANG['prosper_custom5_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom5_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom5_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom5_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom5_testimonials_1_image'] = "custom5-testimonials-1.png";
$_LANG['prosper_custom5_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom5_testimonials_1_image_url'] = "";
$_LANG['prosper_custom5_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom5_testimonials_2_display'] = true;
$_LANG['prosper_custom5_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom5_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom5_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom5_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom5_testimonials_2_image'] = "custom5-testimonials-2.png";
$_LANG['prosper_custom5_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom5_testimonials_2_image_url'] = "";
$_LANG['prosper_custom5_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom5_testimonials_3_display'] = true;
$_LANG['prosper_custom5_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom5_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom5_testimonials_3_author'] = "George";
$_LANG['prosper_custom5_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom5_testimonials_3_image'] = "custom5-testimonials-3.png";
$_LANG['prosper_custom5_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom5_testimonials_3_image_url'] = "";
$_LANG['prosper_custom5_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom5_whychooseus_display'] = true;

$_LANG['prosper_custom5_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom5_whychooseus_1_display'] = true;
$_LANG['prosper_custom5_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom5_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom5_whychooseus_1_image'] = "custom5-whychooseus-1.png";
$_LANG['prosper_custom5_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom5_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom5_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom5_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom5_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom5_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom5_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom5_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom5_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom5_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom5_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom5_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom5_whychooseus_2_display'] = true;
$_LANG['prosper_custom5_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom5_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom5_whychooseus_2_image'] = "custom5-whychooseus-2.png";
$_LANG['prosper_custom5_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom5_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom5_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom5_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom5_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom5_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom5_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom5_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom5_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom5_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom5_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom5_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom5_whychooseus_3_display'] = true;
$_LANG['prosper_custom5_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom5_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom5_whychooseus_3_image'] = "custom5-whychooseus-3.png";
$_LANG['prosper_custom5_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom5_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom5_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom5_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom5_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom5_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom5_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom5_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom5_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom5_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom5_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom5_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom5_faqs_display'] = true;

$_LANG['prosper_custom5_faqs_heading'] = "FAQs";

$_LANG['prosper_custom5_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom5_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom5_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom5_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom5_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom5_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom5_faqs_question_button2_text'] = "";
$_LANG['prosper_custom5_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom5_faqs_question_button2_url'] = "";
$_LANG['prosper_custom5_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom5_faqs_1_display'] = true;
$_LANG['prosper_custom5_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom5_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom5_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom5_faqs_2_display'] = true;
$_LANG['prosper_custom5_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom5_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom5_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom5_faqs_3_display'] = true;
$_LANG['prosper_custom5_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom5_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom5_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Game Servers page by default (File: game-servers.tpl, game-servers.php, includes/custom6.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom6_banner_display'] = true;
$_LANG['prosper_custom6_banner_heading'] = $_LANG['prosper_custom6_name'];
$_LANG['prosper_custom6_banner_text'] = "Take your gaming to the next level";
$_LANG['prosper_custom6_banner_feat1'] = "Minecraft, Battlefield, Call Of Duty &amp; more";
$_LANG['prosper_custom6_banner_feat2'] = "Instant account activation";
$_LANG['prosper_custom6_banner_feat3'] = "100GB+ backup storage included";
$_LANG['prosper_custom6_banner_feat4'] = "Choice of server location";
$_LANG['prosper_custom6_banner_feat5'] = "Easy to use game server panel";
$_LANG['prosper_custom6_banner_feat6'] = "24/7 support as standard";
$_LANG['prosper_custom6_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom6_banner_background'] = "background.jpg";
$_LANG['prosper_custom6_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom6_banner_price_before'] = "Starting From";
$_LANG['prosper_custom6_banner_price'] = "0.45";
$_LANG['prosper_custom6_banner_price_term'] = "/slot";
$_LANG['prosper_custom6_banner_image'] = "gameservers.png";
$_LANG['prosper_custom6_banner_image_small'] = "gameservers-small.png";
$_LANG['prosper_custom6_banner_image_alt'] = $_LANG['prosper_custom6_name'];
$_LANG['prosper_custom6_banner_image_url'] = "#features";
$_LANG['prosper_custom6_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom6_banner_image_screenshot'] = false;
$_LANG['prosper_custom6_banner_image_video'] = false;
$_LANG['prosper_custom6_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom6_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom6_banner_button1_text'] = "Features";
$_LANG['prosper_custom6_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom6_banner_button1_url'] = "#features";
$_LANG['prosper_custom6_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom6_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom6_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom6_banner_button2_url'] = "#plans";
$_LANG['prosper_custom6_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom6_submenu_display'] = true;

$_LANG['prosper_custom6_submenu_1_display'] = true;
$_LANG['prosper_custom6_submenu_1_text'] = "Overview";
$_LANG['prosper_custom6_submenu_1_url'] = "#overview";
$_LANG['prosper_custom6_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom6_submenu_2_display'] = true;
$_LANG['prosper_custom6_submenu_2_text'] = "Plans";
$_LANG['prosper_custom6_submenu_2_url'] = "#plans";
$_LANG['prosper_custom6_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom6_submenu_3_display'] = true;
$_LANG['prosper_custom6_submenu_3_text'] = "Features";
$_LANG['prosper_custom6_submenu_3_url'] = "#features";
$_LANG['prosper_custom6_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom6_submenu_4_display'] = true;
$_LANG['prosper_custom6_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom6_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom6_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom6_submenu_5_display'] = true;
$_LANG['prosper_custom6_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom6_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom6_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom6_submenu_6_display'] = true;
$_LANG['prosper_custom6_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom6_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom6_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom6_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom6_name'] . " plan";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom6_overview_display'] = true;

$_LANG['prosper_custom6_overview_text'] = "

<p>We provide game servers for multiple games including Minecraft, Battlefield, Call Of Duty, Counter Strike, ARK &amp; more.</p>

<p>Our servers use the highest quality hardware and software to ensure you experience the greatest dedicated gaming has to offer.</p>

<p>View our plans below to compare what is right for you.</p>

";

// Features

$_LANG['prosper_custom6_features_display'] = true;

$_LANG['prosper_custom6_features_heading'] = $_LANG['prosper_custom6_name'] . " Features";

// Feature 1

$_LANG['prosper_custom6_features_1_display'] = true;
$_LANG['prosper_custom6_features_1_displayorder'] = 0;
$_LANG['prosper_custom6_features_1_heading'] = "Games";
$_LANG['prosper_custom6_features_1_content_image'] = "custom6-features-1.png";
$_LANG['prosper_custom6_features_1_content_image_alt'] = "game";
$_LANG['prosper_custom6_features_1_content_image_url'] = "";
$_LANG['prosper_custom6_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom6_features_1_content_image_bold'] = true;
$_LANG['prosper_custom6_features_1_content_heading'] = "Choose your game";
$_LANG['prosper_custom6_features_1_content_heading2'] = "We provide hosting for the most popular games";
$_LANG['prosper_custom6_features_1_content_text'] = "

<p>Here at " . $_LANG['prosper_setting_companyname'] . " we provide hosting for the most popular games including:</p>

<div class=\"list list-col2\">
	<ul>							
		<li>Battlefield</li>
		<li>Call Of Duty</li>
		<li>Counter Strike</li>
		<li>ARK</li>
		<li>Crysis 2</li>
		<li>Halo</li>
		<li>Quake 3</li>
		<li>Team Fortress 2</li>
		<li>Unreal Tournament</li>
		<li>&amp; Much More</li>
	</ul>
</div><!-- .list -->

";

// Feature 2

$_LANG['prosper_custom6_features_2_display'] = true;
$_LANG['prosper_custom6_features_2_displayorder'] = 0;
$_LANG['prosper_custom6_features_2_heading'] = "DDoS Protection";
$_LANG['prosper_custom6_features_2_content_image'] = "custom6-features-2.png";
$_LANG['prosper_custom6_features_2_content_image_alt'] = "ddos";
$_LANG['prosper_custom6_features_2_content_image_url'] = "";
$_LANG['prosper_custom6_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom6_features_2_content_image_bold'] = true;
$_LANG['prosper_custom6_features_2_content_heading'] = "High ping &amp; DDoS protection";
$_LANG['prosper_custom6_features_2_content_heading2'] = "Reliable gaming at any cost";
$_LANG['prosper_custom6_features_2_content_text'] = "

<p>Our game servers are guaranteed to have high ping thanks to the use of only the highest quality hardware.</p>

<p>We also have built in DDoS protection which will automatically mitigate attacks. This protection means you can game with confidence.</p>

";

// Testimonials

$_LANG['prosper_custom6_testimonials_display'] = true;

$_LANG['prosper_custom6_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom6_testimonials_1_display'] = true;
$_LANG['prosper_custom6_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom6_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom6_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom6_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom6_testimonials_1_image'] = "custom6-testimonials-1.png";
$_LANG['prosper_custom6_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom6_testimonials_1_image_url'] = "";
$_LANG['prosper_custom6_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom6_testimonials_2_display'] = true;
$_LANG['prosper_custom6_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom6_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom6_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom6_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom6_testimonials_2_image'] = "custom6-testimonials-2.png";
$_LANG['prosper_custom6_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom6_testimonials_2_image_url'] = "";
$_LANG['prosper_custom6_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom6_testimonials_3_display'] = true;
$_LANG['prosper_custom6_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom6_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom6_testimonials_3_author'] = "George";
$_LANG['prosper_custom6_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom6_testimonials_3_image'] = "custom6-testimonials-3.png";
$_LANG['prosper_custom6_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom6_testimonials_3_image_url'] = "";
$_LANG['prosper_custom6_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom6_whychooseus_display'] = true;

$_LANG['prosper_custom6_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom6_whychooseus_1_display'] = true;
$_LANG['prosper_custom6_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom6_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom6_whychooseus_1_image'] = "custom6-whychooseus-1.png";
$_LANG['prosper_custom6_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom6_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom6_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom6_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom6_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom6_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom6_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom6_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom6_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom6_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom6_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom6_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom6_whychooseus_2_display'] = true;
$_LANG['prosper_custom6_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom6_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom6_whychooseus_2_image'] = "custom6-whychooseus-2.png";
$_LANG['prosper_custom6_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom6_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom6_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom6_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom6_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom6_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom6_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom6_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom6_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom6_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom6_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom6_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom6_whychooseus_3_display'] = true;
$_LANG['prosper_custom6_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom6_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom6_whychooseus_3_image'] = "custom6-whychooseus-3.png";
$_LANG['prosper_custom6_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom6_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom6_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom6_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom6_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom6_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom6_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom6_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom6_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom6_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom6_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom6_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom6_faqs_display'] = true;

$_LANG['prosper_custom6_faqs_heading'] = "FAQs";

$_LANG['prosper_custom6_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom6_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom6_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom6_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom6_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom6_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom6_faqs_question_button2_text'] = "";
$_LANG['prosper_custom6_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom6_faqs_question_button2_url'] = "";
$_LANG['prosper_custom6_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom6_faqs_1_display'] = true;
$_LANG['prosper_custom6_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom6_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom6_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom6_faqs_2_display'] = true;
$_LANG['prosper_custom6_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom6_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom6_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom6_faqs_3_display'] = true;
$_LANG['prosper_custom6_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom6_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom6_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Virtual Private Network page by default (File: virtual-private-network.tpl, virtual-private-network.php, includes/custom7.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom7_banner_display'] = true;
$_LANG['prosper_custom7_banner_heading'] = $_LANG['prosper_custom7_name'];
$_LANG['prosper_custom7_banner_text'] = "Protect your connection to the Internet";
$_LANG['prosper_custom7_banner_feat1'] = "Protect your identity";
$_LANG['prosper_custom7_banner_feat2'] = "No website tracking";
$_LANG['prosper_custom7_banner_feat3'] = "Secure internet access";
$_LANG['prosper_custom7_banner_feat4'] = "Stream without limitations";
$_LANG['prosper_custom7_banner_feat5'] = "High speed network";
$_LANG['prosper_custom7_banner_feat6'] = "Military-grade encryption";
$_LANG['prosper_custom7_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom7_banner_background'] = "background.jpg";
$_LANG['prosper_custom7_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom7_banner_price_before'] = "Starting From";
$_LANG['prosper_custom7_banner_price'] = "4.99";
$_LANG['prosper_custom7_banner_price_term'] = "/user";
$_LANG['prosper_custom7_banner_image'] = "virtual-private-network.png";
$_LANG['prosper_custom7_banner_image_small'] = "virtual-private-network.png";
$_LANG['prosper_custom7_banner_image_alt'] = $_LANG['prosper_custom7_name'];
$_LANG['prosper_custom7_banner_image_url'] = "#features";
$_LANG['prosper_custom7_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom7_banner_image_screenshot'] = false;
$_LANG['prosper_custom7_banner_image_video'] = false;
$_LANG['prosper_custom7_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom7_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom7_banner_button1_text'] = "Features";
$_LANG['prosper_custom7_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom7_banner_button1_url'] = "#features";
$_LANG['prosper_custom7_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom7_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom7_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom7_banner_button2_url'] = "#plans";
$_LANG['prosper_custom7_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom7_submenu_display'] = true;

$_LANG['prosper_custom7_submenu_1_display'] = true;
$_LANG['prosper_custom7_submenu_1_text'] = "Overview";
$_LANG['prosper_custom7_submenu_1_url'] = "#overview";
$_LANG['prosper_custom7_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom7_submenu_2_display'] = true;
$_LANG['prosper_custom7_submenu_2_text'] = "Plans";
$_LANG['prosper_custom7_submenu_2_url'] = "#plans";
$_LANG['prosper_custom7_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom7_submenu_3_display'] = true;
$_LANG['prosper_custom7_submenu_3_text'] = "Features";
$_LANG['prosper_custom7_submenu_3_url'] = "#features";
$_LANG['prosper_custom7_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom7_submenu_4_display'] = true;
$_LANG['prosper_custom7_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom7_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom7_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom7_submenu_5_display'] = true;
$_LANG['prosper_custom7_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom7_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom7_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom7_submenu_6_display'] = true;
$_LANG['prosper_custom7_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom7_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom7_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom7_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom7_name'] . " plan";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom7_overview_display'] = true;

$_LANG['prosper_custom7_overview_text'] = "

<p>A VPN (virtual private network) allows you to anonymous and encrypted browsing sessions over any network connection. It is effectively a server that you connect to from your computer that acts as an extra layer/mask. This means any website that you visit will see the server as the source and not your device/computer. In a time where we are sending more data online and companies are storing and analysing more a VPN is a great way to protect both your privacy and security.</p>

";

// Features

$_LANG['prosper_custom7_features_display'] = true;

$_LANG['prosper_custom7_features_heading'] = $_LANG['prosper_custom7_name'] . " Features";

// Feature 1

$_LANG['prosper_custom7_features_1_display'] = true;
$_LANG['prosper_custom7_features_1_displayorder'] = 0;
$_LANG['prosper_custom7_features_1_heading'] = "Secure";
$_LANG['prosper_custom7_features_1_content_image'] = "custom7-features-1.png";
$_LANG['prosper_custom7_features_1_content_image_alt'] = "secure";
$_LANG['prosper_custom7_features_1_content_image_url'] = "";
$_LANG['prosper_custom7_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom7_features_1_content_image_bold'] = true;
$_LANG['prosper_custom7_features_1_content_heading'] = "Secure Internet Access";
$_LANG['prosper_custom7_features_1_content_heading2'] = "An extra layer of protection";
$_LANG['prosper_custom7_features_1_content_text'] = "

<p>Connect to the Internet with peace of mind knowing that you are shielded with a " . $_LANG['prosper_setting_companyname'] . " VPN. Our VPN service will mask your IP and secure your connection which is especially useful when accessing public Wi-Fi, traveling, and keeping browsing history to yourself.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>Hide your IP address</li>
		<li>Be safe on public Wi-Fi networks</li>
		<li>Travel &amp; stay connected with piece of mind</li>
		<li>Secure your bank transactions</li>
		<li>Military-grade encryption</li>
	</ul>
</div><!-- .list -->

";

// Feature 2

$_LANG['prosper_custom7_features_2_display'] = true;
$_LANG['prosper_custom7_features_2_displayorder'] = 0;
$_LANG['prosper_custom7_features_2_heading'] = "Protection";
$_LANG['prosper_custom7_features_2_content_image'] = "custom7-features-2.png";
$_LANG['prosper_custom7_features_2_content_image_alt'] = "protection";
$_LANG['prosper_custom7_features_2_content_image_url'] = "";
$_LANG['prosper_custom7_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom7_features_2_content_image_bold'] = true;
$_LANG['prosper_custom7_features_2_content_heading'] = "Protect Your Identity";
$_LANG['prosper_custom7_features_2_content_heading2'] = "Take control of your privacy";
$_LANG['prosper_custom7_features_2_content_text'] = "

<p>In 2021 protecting your identity is vital. The Netflix documentary The Social Dilemma was a big wake up call as to just how much data companies are collecting, analysing to advertise to you and in some cases selling. Make a stand and protect your data using a " . $_LANG['prosper_setting_companyname'] . " VPN.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>Hide your IP address</li>
		<li>No activity logs to track browsing</li>
		<li>Bypass local internet censorship</li>
		<li>Stay private and anonymous</li>
	</ul>
</div><!-- .list -->

";

// Feature 3

$_LANG['prosper_custom7_features_3_display'] = true;
$_LANG['prosper_custom7_features_3_displayorder'] = 0;
$_LANG['prosper_custom7_features_3_heading'] = "Streaming";
$_LANG['prosper_custom7_features_3_content_image'] = "custom7-features-3.png";
$_LANG['prosper_custom7_features_3_content_image_alt'] = "streaming";
$_LANG['prosper_custom7_features_3_content_image_url'] = "";
$_LANG['prosper_custom7_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom7_features_3_content_image_bold'] = true;
$_LANG['prosper_custom7_features_3_content_heading'] = "Stream Without Limitations";
$_LANG['prosper_custom7_features_3_content_heading2'] = "The perfect upgrade to online video";
$_LANG['prosper_custom7_features_3_content_text'] = "

<p>Our VPN works perfectly for video streaming. We offer lightning fast speeds that result in easy browsing and no more buffering or long waits. A " . $_LANG['prosper_setting_companyname'] . " VPN will support the websites and apps you know and love.</p>

<div class=\"list list-col2\">
	<ul>							
		<li>Watch streaming services anywhere</li>
		<li>Bypass local internet censorship</li>
		<li>Play region-locked games</li>
		<li>Access blocked websites</li>
		<li>Get better deals online</li>
	</ul>
</div><!-- .list -->

";

// Testimonials

$_LANG['prosper_custom7_testimonials_display'] = true;

$_LANG['prosper_custom7_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom7_testimonials_1_display'] = true;
$_LANG['prosper_custom7_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom7_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom7_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom7_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom7_testimonials_1_image'] = "custom7-testimonials-1.png";
$_LANG['prosper_custom7_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom7_testimonials_1_image_url'] = "";
$_LANG['prosper_custom7_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom7_testimonials_2_display'] = true;
$_LANG['prosper_custom7_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom7_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom7_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom7_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom7_testimonials_2_image'] = "custom7-testimonials-2.png";
$_LANG['prosper_custom7_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom7_testimonials_2_image_url'] = "";
$_LANG['prosper_custom7_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom7_testimonials_3_display'] = true;
$_LANG['prosper_custom7_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom7_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom7_testimonials_3_author'] = "George";
$_LANG['prosper_custom7_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom7_testimonials_3_image'] = "custom7-testimonials-3.png";
$_LANG['prosper_custom7_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom7_testimonials_3_image_url'] = "";
$_LANG['prosper_custom7_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom7_whychooseus_display'] = true;

$_LANG['prosper_custom7_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom7_whychooseus_1_display'] = true;
$_LANG['prosper_custom7_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom7_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom7_whychooseus_1_image'] = "custom7-whychooseus-1.png";
$_LANG['prosper_custom7_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom7_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom7_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom7_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom7_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom7_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom7_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom7_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom7_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom7_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom7_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom7_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom7_whychooseus_2_display'] = true;
$_LANG['prosper_custom7_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom7_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom7_whychooseus_2_image'] = "custom7-whychooseus-2.png";
$_LANG['prosper_custom7_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom7_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom7_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom7_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom7_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom7_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom7_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom7_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom7_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom7_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom7_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom7_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom7_whychooseus_3_display'] = true;
$_LANG['prosper_custom7_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom7_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom7_whychooseus_3_image'] = "custom7-whychooseus-3.png";
$_LANG['prosper_custom7_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom7_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom7_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom7_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom7_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom7_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom7_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom7_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom7_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom7_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom7_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom7_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom7_faqs_display'] = true;

$_LANG['prosper_custom7_faqs_heading'] = "FAQs";

$_LANG['prosper_custom7_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom7_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom7_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom7_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom7_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom7_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom7_faqs_question_button2_text'] = "";
$_LANG['prosper_custom7_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom7_faqs_question_button2_url'] = "";
$_LANG['prosper_custom7_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom7_faqs_1_display'] = true;
$_LANG['prosper_custom7_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom7_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom7_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom7_faqs_2_display'] = true;
$_LANG['prosper_custom7_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom7_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom7_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom7_faqs_3_display'] = true;
$_LANG['prosper_custom7_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom7_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom7_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   IPTV page by default (File: iptv.tpl, iptv.php, includes/custom8.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom8_banner_display'] = true;
$_LANG['prosper_custom8_banner_heading'] = $_LANG['prosper_custom8_name'];
$_LANG['prosper_custom8_banner_text'] = "Stream Live TV, Movies &amp; Shows";
$_LANG['prosper_custom8_banner_feat1'] = "Access to over 40,000 Movies";
$_LANG['prosper_custom8_banner_feat2'] = "Access to over 30,000 TV Shows";
$_LANG['prosper_custom8_banner_feat3'] = "Stream Live TV";
$_LANG['prosper_custom8_banner_feat4'] = "24/7 Support included";
$_LANG['prosper_custom8_banner_feat5'] = "Connect with up to 18 devices";
$_LANG['prosper_custom8_banner_feat6'] = "Our top plan supports 10 users";
$_LANG['prosper_custom8_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom8_banner_background'] = "background.jpg";
$_LANG['prosper_custom8_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom8_banner_price_before'] = "Starting From";
$_LANG['prosper_custom8_banner_price'] = "5.99";
$_LANG['prosper_custom8_banner_price_term'] = "/month";
$_LANG['prosper_custom8_banner_image'] = "iptv1.png";
$_LANG['prosper_custom8_banner_image_small'] = "iptv1.png";
$_LANG['prosper_custom8_banner_image_alt'] = $_LANG['prosper_custom8_name'];
$_LANG['prosper_custom8_banner_image_url'] = "#features";
$_LANG['prosper_custom8_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom8_banner_image_screenshot'] = false;
$_LANG['prosper_custom8_banner_image_video'] = false;
$_LANG['prosper_custom8_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom8_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom8_banner_button1_text'] = "Features";
$_LANG['prosper_custom8_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom8_banner_button1_url'] = "#features";
$_LANG['prosper_custom8_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom8_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom8_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom8_banner_button2_url'] = "#plans";
$_LANG['prosper_custom8_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom8_submenu_display'] = true;

$_LANG['prosper_custom8_submenu_1_display'] = true;
$_LANG['prosper_custom8_submenu_1_text'] = "Overview";
$_LANG['prosper_custom8_submenu_1_url'] = "#overview";
$_LANG['prosper_custom8_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom8_submenu_2_display'] = true;
$_LANG['prosper_custom8_submenu_2_text'] = "Plans";
$_LANG['prosper_custom8_submenu_2_url'] = "#plans";
$_LANG['prosper_custom8_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom8_submenu_3_display'] = true;
$_LANG['prosper_custom8_submenu_3_text'] = "Features";
$_LANG['prosper_custom8_submenu_3_url'] = "#features";
$_LANG['prosper_custom8_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom8_submenu_4_display'] = true;
$_LANG['prosper_custom8_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom8_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom8_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom8_submenu_5_display'] = true;
$_LANG['prosper_custom8_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom8_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom8_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom8_submenu_6_display'] = true;
$_LANG['prosper_custom8_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom8_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom8_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom8_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom8_name'];

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom8_overview_display'] = true;

$_LANG['prosper_custom8_overview_text'] = "

<p>IPTV stands for Internet Protocol Television which simply means watching TV via the Internet.</p>

<p>All of our IPTV plans provide access to 40,000+ movies &amp; 30,000+ TV shows and allow you to watch live TV using any of your devices.</p>

";

// Features

$_LANG['prosper_custom8_features_display'] = true;

$_LANG['prosper_custom8_features_heading'] = $_LANG['prosper_custom8_name'] . " Features";

// Feature 1

$_LANG['prosper_custom8_features_1_display'] = true;
$_LANG['prosper_custom8_features_1_displayorder'] = 0;
$_LANG['prosper_custom8_features_1_heading'] = "Streaming";
$_LANG['prosper_custom8_features_1_content_image'] = "custom8-features-1.png";
$_LANG['prosper_custom8_features_1_content_image_alt'] = "streaming";
$_LANG['prosper_custom8_features_1_content_image_url'] = "";
$_LANG['prosper_custom8_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom8_features_1_content_image_bold'] = true;
$_LANG['prosper_custom8_features_1_content_heading'] = "Unlimited Streaming";
$_LANG['prosper_custom8_features_1_content_heading2'] = "Access to thousands of Movies &amp; TV Shows";
$_LANG['prosper_custom8_features_1_content_text'] = "

<p>All of our IPTV plans give you access to 40,000+ movies and 30,000+ TV shows.</p>

<p>It is important to us to provide you with full access regardless of which plan you choose. Our IPTV plans only differ based on the amount of users and devices that are connecting.</p>

<p>Create your order with " . $_LANG['prosper_setting_companyname'] . " today to gain access to this amazing array of content.</p>

";

// Feature 2

$_LANG['prosper_custom8_features_2_display'] = true;
$_LANG['prosper_custom8_features_2_displayorder'] = 0;
$_LANG['prosper_custom8_features_2_heading'] = "Limitless";
$_LANG['prosper_custom8_features_2_content_image'] = "custom8-features-2.png";
$_LANG['prosper_custom8_features_2_content_image_alt'] = "content";
$_LANG['prosper_custom8_features_2_content_image_url'] = "";
$_LANG['prosper_custom8_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom8_features_2_content_image_bold'] = true;
$_LANG['prosper_custom8_features_2_content_heading'] = "Limitless content";
$_LANG['prosper_custom8_features_2_content_heading2'] = "Thousands of hours of content using any device";
$_LANG['prosper_custom8_features_2_content_text'] = "

<p>Our IPTV plans give you access to thousands of hours of content. Some of the channels you will gain access to are:</p>

<div class=\"list list-col2\">
	<ul>
		<li>YouTube</li>
		<li>BBC iPlayer</li>
		<li>ITV Hub</li>
		<li>Channel 4</li>
		<li>Free View</li>
		<li>Sky Sports</li>
		<li>Adult Channels</li>
	</ul>
</div><!-- .list -->

";

// Feature 3

$_LANG['prosper_custom8_features_3_display'] = true;
$_LANG['prosper_custom8_features_3_displayorder'] = 0;
$_LANG['prosper_custom8_features_3_heading'] = "Live TV";
$_LANG['prosper_custom8_features_3_content_image'] = "custom8-features-3.png";
$_LANG['prosper_custom8_features_3_content_image_alt'] = "live";
$_LANG['prosper_custom8_features_3_content_image_url'] = "";
$_LANG['prosper_custom8_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom8_features_3_content_image_bold'] = true;
$_LANG['prosper_custom8_features_3_content_heading'] = "Live TV";
$_LANG['prosper_custom8_features_3_content_heading2'] = "Access live TV from any device";
$_LANG['prosper_custom8_features_3_content_text'] = "

<p>Unlike most IPTV solutions on the market we provide you with access to live TV channels.</p>

<p>While pre-made content is good, nothing beats the thrill of watching live sporting events. Very few providers support live TV but we like to make our services as competitive as possible.</p>

";

// Testimonials

$_LANG['prosper_custom8_testimonials_display'] = true;

$_LANG['prosper_custom8_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom8_testimonials_1_display'] = true;
$_LANG['prosper_custom8_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom8_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom8_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom8_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom8_testimonials_1_image'] = "custom8-testimonials-1.png";
$_LANG['prosper_custom8_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom8_testimonials_1_image_url'] = "";
$_LANG['prosper_custom8_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom8_testimonials_2_display'] = true;
$_LANG['prosper_custom8_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom8_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom8_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom8_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom8_testimonials_2_image'] = "custom8-testimonials-2.png";
$_LANG['prosper_custom8_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom8_testimonials_2_image_url'] = "";
$_LANG['prosper_custom8_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom8_testimonials_3_display'] = true;
$_LANG['prosper_custom8_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom8_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom8_testimonials_3_author'] = "George";
$_LANG['prosper_custom8_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom8_testimonials_3_image'] = "custom8-testimonials-3.png";
$_LANG['prosper_custom8_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom8_testimonials_3_image_url'] = "";
$_LANG['prosper_custom8_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom8_whychooseus_display'] = true;

$_LANG['prosper_custom8_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom8_whychooseus_1_display'] = true;
$_LANG['prosper_custom8_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom8_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom8_whychooseus_1_image'] = "custom8-whychooseus-1.png";
$_LANG['prosper_custom8_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom8_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom8_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom8_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom8_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom8_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom8_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom8_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom8_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom8_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom8_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom8_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom8_whychooseus_2_display'] = true;
$_LANG['prosper_custom8_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom8_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom8_whychooseus_2_image'] = "custom8-whychooseus-2.png";
$_LANG['prosper_custom8_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom8_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom8_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom8_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom8_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom8_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom8_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom8_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom8_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom8_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom8_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom8_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom8_whychooseus_3_display'] = true;
$_LANG['prosper_custom8_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom8_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom8_whychooseus_3_image'] = "custom8-whychooseus-3.png";
$_LANG['prosper_custom8_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom8_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom8_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom8_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom8_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom8_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom8_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom8_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom8_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom8_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom8_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom8_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom8_faqs_display'] = true;

$_LANG['prosper_custom8_faqs_heading'] = "FAQs";

$_LANG['prosper_custom8_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom8_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom8_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom8_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom8_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom8_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom8_faqs_question_button2_text'] = "";
$_LANG['prosper_custom8_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom8_faqs_question_button2_url'] = "";
$_LANG['prosper_custom8_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom8_faqs_1_display'] = true;
$_LANG['prosper_custom8_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom8_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom8_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom8_faqs_2_display'] = true;
$_LANG['prosper_custom8_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom8_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom8_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom8_faqs_3_display'] = true;
$_LANG['prosper_custom8_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom8_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom8_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Hosting Addons by default (File: hosting-addons.tpl, hosting-addons.php, includes/custom9.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom9_banner_display'] = true;
$_LANG['prosper_custom9_banner_heading'] = $_LANG['prosper_custom9_name'];
$_LANG['prosper_custom9_banner_text'] = "Enhance your web hosting account";
$_LANG['prosper_custom9_banner_feat1'] = "Multiple addons to choose from";
$_LANG['prosper_custom9_banner_feat2'] = "Instant addon activation";
$_LANG['prosper_custom9_banner_feat3'] = "Money back guarantee with all addons";
$_LANG['prosper_custom9_banner_feat4'] = "Manage your addon from your account";
$_LANG['prosper_custom9_banner_feat5'] = "24/7 support as standard";
$_LANG['prosper_custom9_banner_feat6'] = "Instant access to video tutorials";
$_LANG['prosper_custom9_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom9_banner_background'] = "background.jpg";
$_LANG['prosper_custom9_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom9_banner_price_before'] = "Starting From";
$_LANG['prosper_custom9_banner_price'] = "3.00";
$_LANG['prosper_custom9_banner_price_term'] = "/one time";
$_LANG['prosper_custom9_banner_image'] = "hostingaddons.png";
$_LANG['prosper_custom9_banner_image_small'] = "hostingaddons.png";
$_LANG['prosper_custom9_banner_image_alt'] = $_LANG['prosper_custom9_name'];
$_LANG['prosper_custom9_banner_image_url'] = "#features";
$_LANG['prosper_custom9_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom9_banner_image_screenshot'] = false;
$_LANG['prosper_custom9_banner_image_video'] = false;
$_LANG['prosper_custom9_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom9_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom9_banner_button1_text'] = "Features";
$_LANG['prosper_custom9_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom9_banner_button1_url'] = "#features";
$_LANG['prosper_custom9_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom9_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom9_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom9_banner_button2_url'] = "#plans";
$_LANG['prosper_custom9_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom9_submenu_display'] = true;

$_LANG['prosper_custom9_submenu_1_display'] = true;
$_LANG['prosper_custom9_submenu_1_text'] = "Overview";
$_LANG['prosper_custom9_submenu_1_url'] = "#overview";
$_LANG['prosper_custom9_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom9_submenu_2_display'] = true;
$_LANG['prosper_custom9_submenu_2_text'] = "Plans";
$_LANG['prosper_custom9_submenu_2_url'] = "#plans";
$_LANG['prosper_custom9_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom9_submenu_3_display'] = true;
$_LANG['prosper_custom9_submenu_3_text'] = "Features";
$_LANG['prosper_custom9_submenu_3_url'] = "#features";
$_LANG['prosper_custom9_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom9_submenu_4_display'] = true;
$_LANG['prosper_custom9_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom9_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom9_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom9_submenu_5_display'] = true;
$_LANG['prosper_custom9_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom9_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom9_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom9_submenu_6_display'] = true;
$_LANG['prosper_custom9_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom9_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom9_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom9_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom9_name'];

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom9_overview_display'] = true;

$_LANG['prosper_custom9_overview_text'] = "

<p>Enhance your web hosting with our choice of hosting addons, all of which are activated automatically.</p>

";

// Features

$_LANG['prosper_custom9_features_display'] = true;

$_LANG['prosper_custom9_features_heading'] = $_LANG['prosper_custom9_name'] . " Features";

// Feature 1

$_LANG['prosper_custom9_features_1_display'] = true;
$_LANG['prosper_custom9_features_1_displayorder'] = 0;
$_LANG['prosper_custom9_features_1_heading'] = "Control Panel";
$_LANG['prosper_custom9_features_1_content_image'] = "custom9-features-1.png";
$_LANG['prosper_custom9_features_1_content_image_alt'] = "cpanel";
$_LANG['prosper_custom9_features_1_content_image_url'] = "";
$_LANG['prosper_custom9_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom9_features_1_content_image_bold'] = true;
$_LANG['prosper_custom9_features_1_content_heading'] = "cPanel Access";
$_LANG['prosper_custom9_features_1_content_heading2'] = "Manage your addons with cPanel";
$_LANG['prosper_custom9_features_1_content_text'] = "

<p>With cPanel you can easily manage every aspect of your web hosting account and purchased addons. From creating custom email addresses all the way to editing your website files.</p>

<p>The best thing about cPanel is that it can be accessed easily from any computer with an Internet connection.</p>

<p>With cPanel you can manage your website files with its browser based file manager (e.g upload, delete, edit files), Create/delete email accounts of your choice (@yourdomain.com) and access webmail via your browser, Install/remove software on your account with the help of Softaculous (Wordpress, Joomla etc) &amp; much more!</p>

<div class=\"gridboxes2-buttons\">
	<a href=\"https://demo.cpanel.net:2083/login/?user=democom&pass=DemoCoA5620&locale=en\" rel=\"nofollow\" target=\"_blank\" class=\"button1 color2\"><i class=\"fas fa-search\"></i>cPanel Demo</a>
</div>

";

// Testimonials

$_LANG['prosper_custom9_testimonials_display'] = true;

$_LANG['prosper_custom9_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom9_testimonials_1_display'] = true;
$_LANG['prosper_custom9_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom9_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom9_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom9_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom9_testimonials_1_image'] = "custom9-testimonials-1.png";
$_LANG['prosper_custom9_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom9_testimonials_1_image_url'] = "";
$_LANG['prosper_custom9_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom9_testimonials_2_display'] = true;
$_LANG['prosper_custom9_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom9_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom9_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom9_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom9_testimonials_2_image'] = "custom9-testimonials-2.png";
$_LANG['prosper_custom9_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom9_testimonials_2_image_url'] = "";
$_LANG['prosper_custom9_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom9_testimonials_3_display'] = true;
$_LANG['prosper_custom9_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom9_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom9_testimonials_3_author'] = "George";
$_LANG['prosper_custom9_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom9_testimonials_3_image'] = "custom9-testimonials-3.png";
$_LANG['prosper_custom9_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom9_testimonials_3_image_url'] = "";
$_LANG['prosper_custom9_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom9_whychooseus_display'] = true;

$_LANG['prosper_custom9_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom9_whychooseus_1_display'] = true;
$_LANG['prosper_custom9_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom9_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom9_whychooseus_1_image'] = "custom9-whychooseus-1.png";
$_LANG['prosper_custom9_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom9_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom9_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom9_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom9_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom9_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom9_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom9_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom9_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom9_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom9_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom9_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom9_whychooseus_2_display'] = true;
$_LANG['prosper_custom9_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom9_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom9_whychooseus_2_image'] = "custom9-whychooseus-2.png";
$_LANG['prosper_custom9_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom9_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom9_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom9_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom9_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom9_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom9_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom9_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom9_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom9_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom9_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom9_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom9_whychooseus_3_display'] = true;
$_LANG['prosper_custom9_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom9_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom9_whychooseus_3_image'] = "custom9-whychooseus-3.png";
$_LANG['prosper_custom9_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom9_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom9_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom9_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom9_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom9_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom9_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom9_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom9_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom9_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom9_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom9_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom9_faqs_display'] = true;

$_LANG['prosper_custom9_faqs_heading'] = "FAQs";

$_LANG['prosper_custom9_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom9_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom9_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom9_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom9_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom9_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom9_faqs_question_button2_text'] = "";
$_LANG['prosper_custom9_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom9_faqs_question_button2_url'] = "";
$_LANG['prosper_custom9_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom9_faqs_1_display'] = true;
$_LANG['prosper_custom9_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom9_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom9_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom9_faqs_2_display'] = true;
$_LANG['prosper_custom9_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom9_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom9_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom9_faqs_3_display'] = true;
$_LANG['prosper_custom9_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom9_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom9_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Web Design by default (File: web-design.tpl, web-design.php, includes/custom10.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_custom10_banner_display'] = true;
$_LANG['prosper_custom10_banner_heading'] = $_LANG['prosper_custom10_name'];
$_LANG['prosper_custom10_banner_text'] = "We design &amp; develop custom websites";
$_LANG['prosper_custom10_banner_feat1'] = "WordPress or HTML";
$_LANG['prosper_custom10_banner_feat2'] = "Bespoke Design";
$_LANG['prosper_custom10_banner_feat3'] = "Custom Logo Design*";
$_LANG['prosper_custom10_banner_feat4'] = "FREE Web Hosting";
$_LANG['prosper_custom10_banner_feat5'] = "FREE Domain Registration*";
$_LANG['prosper_custom10_banner_feat6'] = "FREE Search Engine Optimization";
$_LANG['prosper_custom10_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_custom10_banner_background'] = "background.jpg";
$_LANG['prosper_custom10_banner_background_opacity'] = 0.6;
$_LANG['prosper_custom10_banner_price_before'] = "Starting From";
$_LANG['prosper_custom10_banner_price'] = "499";
$_LANG['prosper_custom10_banner_price_term'] = "/one time";
$_LANG['prosper_custom10_banner_image'] = "web-design.png";
$_LANG['prosper_custom10_banner_image_small'] = "web-design.png";
$_LANG['prosper_custom10_banner_image_alt'] = $_LANG['prosper_custom10_name'];
$_LANG['prosper_custom10_banner_image_url'] = "#features";
$_LANG['prosper_custom10_banner_image_url_newwindow'] = false;
$_LANG['prosper_custom10_banner_image_screenshot'] = false;
$_LANG['prosper_custom10_banner_image_video'] = false;
$_LANG['prosper_custom10_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_custom10_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_custom10_banner_button1_text'] = "Features";
$_LANG['prosper_custom10_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_custom10_banner_button1_url'] = "#features";
$_LANG['prosper_custom10_banner_button1_url_newwindow'] = false;
$_LANG['prosper_custom10_banner_button2_text'] = "View Plans";
$_LANG['prosper_custom10_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_custom10_banner_button2_url'] = "#plans";
$_LANG['prosper_custom10_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_custom10_submenu_display'] = true;

$_LANG['prosper_custom10_submenu_1_display'] = true;
$_LANG['prosper_custom10_submenu_1_text'] = "Overview";
$_LANG['prosper_custom10_submenu_1_url'] = "#overview";
$_LANG['prosper_custom10_submenu_1_url_newwindow'] = false;

$_LANG['prosper_custom10_submenu_2_display'] = true;
$_LANG['prosper_custom10_submenu_2_text'] = "Plans";
$_LANG['prosper_custom10_submenu_2_url'] = "#plans";
$_LANG['prosper_custom10_submenu_2_url_newwindow'] = false;

$_LANG['prosper_custom10_submenu_3_display'] = true;
$_LANG['prosper_custom10_submenu_3_text'] = "Features";
$_LANG['prosper_custom10_submenu_3_url'] = "#features";
$_LANG['prosper_custom10_submenu_3_url_newwindow'] = false;

$_LANG['prosper_custom10_submenu_4_display'] = true;
$_LANG['prosper_custom10_submenu_4_text'] = "Testimonials";
$_LANG['prosper_custom10_submenu_4_url'] = "#testimonials";
$_LANG['prosper_custom10_submenu_4_url_newwindow'] = false;

$_LANG['prosper_custom10_submenu_5_display'] = true;
$_LANG['prosper_custom10_submenu_5_text'] = "Why Choose Us";
$_LANG['prosper_custom10_submenu_5_url'] = "#whychooseus";
$_LANG['prosper_custom10_submenu_5_url_newwindow'] = false;

$_LANG['prosper_custom10_submenu_6_display'] = true;
$_LANG['prosper_custom10_submenu_6_text'] = "FAQS";
$_LANG['prosper_custom10_submenu_6_url'] = "#faqs";
$_LANG['prosper_custom10_submenu_6_url_newwindow'] = false;

// Title

$_LANG['prosper_custom10_plans_heading'] = "Select your perfect " . $_LANG['prosper_custom10_name'] . " package";

// Plans

/* By default your plans are editable via Wizard Panel. If you have Multi-language support set to on in Wizard Panel then most of your plans content comes from this file under the "Multi-language support: on" section */

// Overview

$_LANG['prosper_custom10_overview_display'] = true;

$_LANG['prosper_custom10_overview_text'] = "

<p>Every website we design is completely custom, based on the research we conduct on your business, competition, your goals and requirements. We also put a lot of time into optimising your website to be effective in the search engines and include many web design features. Hire " . $_LANG['prosper_setting_companyname'] . " today and relax while we design and deliver the perfect website for you.</p>

";

// Features

$_LANG['prosper_custom10_features_display'] = true;

$_LANG['prosper_custom10_features_heading'] = $_LANG['prosper_custom10_name'] . " Features";

// Feature 1

$_LANG['prosper_custom10_features_1_display'] = true;
$_LANG['prosper_custom10_features_1_displayorder'] = 0;
$_LANG['prosper_custom10_features_1_heading'] = "Responsive";
$_LANG['prosper_custom10_features_1_content_image'] = "custom10-features-1.png";
$_LANG['prosper_custom10_features_1_content_image_alt'] = "responsive";
$_LANG['prosper_custom10_features_1_content_image_url'] = "";
$_LANG['prosper_custom10_features_1_content_image_url_newwindow'] = false;
$_LANG['prosper_custom10_features_1_content_image_bold'] = false;
$_LANG['prosper_custom10_features_1_content_heading'] = "Responsive Web Design";
$_LANG['prosper_custom10_features_1_content_heading2'] = "Your website will support all devices (desktop, tablet, mobile)";
$_LANG['prosper_custom10_features_1_content_text'] = "

<p>Every website we create is fully responsive meaning it will automatically adapt to fit the device used to access it. For example if you access the website with a desktop you will see a full scale version, then if you access with a mobile device it will automatically adjust to fit.</p>

";

// Feature 2

$_LANG['prosper_custom10_features_2_display'] = true;
$_LANG['prosper_custom10_features_2_displayorder'] = 0;
$_LANG['prosper_custom10_features_2_heading'] = "WordPress";
$_LANG['prosper_custom10_features_2_content_image'] = "custom10-features-2.png";
$_LANG['prosper_custom10_features_2_content_image_alt'] = "wordpress";
$_LANG['prosper_custom10_features_2_content_image_url'] = "";
$_LANG['prosper_custom10_features_2_content_image_url_newwindow'] = false;
$_LANG['prosper_custom10_features_2_content_image_bold'] = true;
$_LANG['prosper_custom10_features_2_content_heading'] = "WordPress";
$_LANG['prosper_custom10_features_2_content_heading2'] = "Easily update and extend your website";
$_LANG['prosper_custom10_features_2_content_text'] = "

<p>WordPress is free and open source CMS (Content Management System) that is used by an astonishing 35% of websites. What makes WordPress so special is that it allows you to manage your website easily thanks to the admin panel. Using the admin panel you can update/add text, edit the menu, create new pages/posts, upload images & more. WordPress also offers thousands of free plugins which add extra features allowing you to create any type of website. WordPress can also be used to manage your Ecommerce website thanks to the free and easy to use eCommerce plugin, Woocommerce.</p>

";

// Feature 3

$_LANG['prosper_custom10_features_3_display'] = true;
$_LANG['prosper_custom10_features_3_displayorder'] = 0;
$_LANG['prosper_custom10_features_3_heading'] = "HTML";
$_LANG['prosper_custom10_features_3_content_image'] = "custom10-features-3.png";
$_LANG['prosper_custom10_features_3_content_image_alt'] = "html";
$_LANG['prosper_custom10_features_3_content_image_url'] = "";
$_LANG['prosper_custom10_features_3_content_image_url_newwindow'] = false;
$_LANG['prosper_custom10_features_3_content_image_bold'] = false;
$_LANG['prosper_custom10_features_3_content_heading'] = "HTML";
$_LANG['prosper_custom10_features_3_content_heading2'] = "Lightning fast & maintenance free";
$_LANG['prosper_custom10_features_3_content_text'] = "

<p>A HTML website, otherwise known as static comes with many benefits over using software such as WordPress. A HTML website is lightning fast and completely maintenance free as it doesn't rely on software which has to be updated. A HTML website is the perfect choice if you require a website that you don't want to update yourself or frequently.</p>

";

// Feature 4

$_LANG['prosper_custom10_features_4_display'] = true;
$_LANG['prosper_custom10_features_4_displayorder'] = 0;
$_LANG['prosper_custom10_features_4_heading'] = "PrestaShop";
$_LANG['prosper_custom10_features_4_content_image'] = "custom10-features-4.png";
$_LANG['prosper_custom10_features_4_content_image_alt'] = "prestashop";
$_LANG['prosper_custom10_features_4_content_image_url'] = "";
$_LANG['prosper_custom10_features_4_content_image_url_newwindow'] = false;
$_LANG['prosper_custom10_features_4_content_image_bold'] = true;
$_LANG['prosper_custom10_features_4_content_heading'] = "PrestaShop";
$_LANG['prosper_custom10_features_4_content_heading2'] = "Easily manage your Ecommerce website";
$_LANG['prosper_custom10_features_4_content_text'] = "

<p>PrestaShop is free and open source software designed specially for Ecommerce websites. 12% of Ecommerce websites use PrestaShop as the platform to manage their store. PrestaShop is very easily to use thanks to the admin panel where you can mange every aspect of your store. Easily create new pages, products, promotions, manage orders, view your statistics & more.</p>

<p>PrestaShop is the perfect choice for your Ecommerce store if your website is primary providing products/services. If you would like to sell products/services on your website as a secondary goal then we also create your website on the WordPress platform.</p>

";

// Testimonials

$_LANG['prosper_custom10_testimonials_display'] = true;

$_LANG['prosper_custom10_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['prosper_custom10_testimonials_1_display'] = true;
$_LANG['prosper_custom10_testimonials_1_displayorder'] = 0;
$_LANG['prosper_custom10_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_custom10_testimonials_1_author'] = "Nathan";
$_LANG['prosper_custom10_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_custom10_testimonials_1_image'] = "custom10-testimonials-1.png";
$_LANG['prosper_custom10_testimonials_1_alt'] = "client 1";
$_LANG['prosper_custom10_testimonials_1_image_url'] = "";
$_LANG['prosper_custom10_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_custom10_testimonials_2_display'] = true;
$_LANG['prosper_custom10_testimonials_2_displayorder'] = 0;
$_LANG['prosper_custom10_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_custom10_testimonials_2_author'] = "Joanna";
$_LANG['prosper_custom10_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_custom10_testimonials_2_image'] = "custom10-testimonials-2.png";
$_LANG['prosper_custom10_testimonials_2_alt'] = "client 2";
$_LANG['prosper_custom10_testimonials_2_image_url'] = "";
$_LANG['prosper_custom10_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_custom10_testimonials_3_display'] = true;
$_LANG['prosper_custom10_testimonials_3_displayorder'] = 0;
$_LANG['prosper_custom10_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_custom10_testimonials_3_author'] = "George";
$_LANG['prosper_custom10_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_custom10_testimonials_3_image'] = "custom10-testimonials-3.png";
$_LANG['prosper_custom10_testimonials_3_alt'] = "client 3";
$_LANG['prosper_custom10_testimonials_3_image_url'] = "";
$_LANG['prosper_custom10_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['prosper_custom10_whychooseus_display'] = true;

$_LANG['prosper_custom10_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_custom10_whychooseus_1_display'] = true;
$_LANG['prosper_custom10_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_custom10_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_custom10_whychooseus_1_image'] = "custom10-whychooseus-1.png";
$_LANG['prosper_custom10_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_custom10_whychooseus_1_image_url'] = "";
$_LANG['prosper_custom10_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_custom10_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_custom10_whychooseus_1_button1_text'] = "";
$_LANG['prosper_custom10_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_custom10_whychooseus_1_button1_url'] = "";
$_LANG['prosper_custom10_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_custom10_whychooseus_1_button2_text'] = "";
$_LANG['prosper_custom10_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_custom10_whychooseus_1_button2_url'] = "";
$_LANG['prosper_custom10_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_custom10_whychooseus_2_display'] = true;
$_LANG['prosper_custom10_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_custom10_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_custom10_whychooseus_2_image'] = "custom10-whychooseus-2.png";
$_LANG['prosper_custom10_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_custom10_whychooseus_2_image_url'] = "";
$_LANG['prosper_custom10_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_custom10_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_custom10_whychooseus_2_button1_text'] = "";
$_LANG['prosper_custom10_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_custom10_whychooseus_2_button1_url'] = "";
$_LANG['prosper_custom10_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_custom10_whychooseus_2_button2_text'] = "";
$_LANG['prosper_custom10_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_custom10_whychooseus_2_button2_url'] = "";
$_LANG['prosper_custom10_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_custom10_whychooseus_3_display'] = true;
$_LANG['prosper_custom10_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_custom10_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_custom10_whychooseus_3_image'] = "custom10-whychooseus-3.png";
$_LANG['prosper_custom10_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_custom10_whychooseus_3_image_url'] = "";
$_LANG['prosper_custom10_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_custom10_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_custom10_whychooseus_3_button1_text'] = "";
$_LANG['prosper_custom10_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_custom10_whychooseus_3_button1_url'] = "";
$_LANG['prosper_custom10_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_custom10_whychooseus_3_button2_text'] = "";
$_LANG['prosper_custom10_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_custom10_whychooseus_3_button2_url'] = "";
$_LANG['prosper_custom10_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_custom10_faqs_display'] = true;

$_LANG['prosper_custom10_faqs_heading'] = "FAQs";

$_LANG['prosper_custom10_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_custom10_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_custom10_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_custom10_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_custom10_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_custom10_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_custom10_faqs_question_button2_text'] = "";
$_LANG['prosper_custom10_faqs_question_button2_icon'] = "";
$_LANG['prosper_custom10_faqs_question_button2_url'] = "";
$_LANG['prosper_custom10_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_custom10_faqs_1_display'] = true;
$_LANG['prosper_custom10_faqs_1_displayorder'] = 0;
$_LANG['prosper_custom10_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_custom10_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_custom10_faqs_2_display'] = true;
$_LANG['prosper_custom10_faqs_2_displayorder'] = 0;
$_LANG['prosper_custom10_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_custom10_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_custom10_faqs_3_display'] = true;
$_LANG['prosper_custom10_faqs_3_displayorder'] = 0;
$_LANG['prosper_custom10_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_custom10_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Affiliate Program page (File: affiliate-program.tpl, affiliate-program.php)   ---------
-----------------------------------------
*/

// Banner

$_LANG['prosper_affiliateprogram_banner_display'] = true;
$_LANG['prosper_affiliateprogram_banner_heading'] = "Make Money As A " . $_LANG['prosper_setting_companyname'] . " Affiliate";
$_LANG['prosper_affiliateprogram_banner_text'] = "Refer your friends, family and website visitors to " . $_LANG['prosper_setting_companyname'] . " and earn high commissions on all of the products & services we provide. Join over 700 affiliates making money with " . $_LANG['prosper_setting_companyname'] . " using our free program that comes with marketing tools to help you get started.";
$_LANG['prosper_affiliateprogram_banner_feat1'] = "";
$_LANG['prosper_affiliateprogram_banner_feat2'] = "";
$_LANG['prosper_affiliateprogram_banner_feat3'] = "";
$_LANG['prosper_affiliateprogram_banner_feat4'] = "";
$_LANG['prosper_affiliateprogram_banner_feat5'] = "";
$_LANG['prosper_affiliateprogram_banner_feat6'] = "";
$_LANG['prosper_affiliateprogram_banner_feat_icon'] = "";
$_LANG['prosper_affiliateprogram_banner_background'] = "background5.jpg";
$_LANG['prosper_affiliateprogram_banner_background_opacity'] = 0.5;
$_LANG['prosper_affiliateprogram_banner_price_before'] = "";
$_LANG['prosper_affiliateprogram_banner_price'] = "free";
$_LANG['prosper_affiliateprogram_banner_price_term'] = "";
$_LANG['prosper_affiliateprogram_banner_image'] = "";
$_LANG['prosper_affiliateprogram_banner_image_small'] = "";
$_LANG['prosper_affiliateprogram_banner_image_alt'] = "";
$_LANG['prosper_affiliateprogram_banner_image_url'] = "";
$_LANG['prosper_affiliateprogram_banner_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_banner_image_screenshot'] = false;
$_LANG['prosper_affiliateprogram_banner_image_video'] = false;
$_LANG['prosper_affiliateprogram_banner_image_video_badge'] = "";
$_LANG['prosper_affiliateprogram_banner_image_video_badge_icon'] = "";
$_LANG['prosper_affiliateprogram_banner_button1_text'] = "View Marketing Tools";
$_LANG['prosper_affiliateprogram_banner_button1_icon'] = "fas fa-search";
$_LANG['prosper_affiliateprogram_banner_button1_url'] = "#marketingtools";
$_LANG['prosper_affiliateprogram_banner_button1_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_banner_button2_text'] = "Become A " . $_LANG['prosper_setting_companyname'] . " Affiliate";
$_LANG['prosper_affiliateprogram_banner_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_affiliateprogram_banner_button2_url'] = "register.php";
$_LANG['prosper_affiliateprogram_banner_button2_url_newwindow'] = false;

// Submenu

$_LANG['prosper_affiliateprogram_submenu_display'] = true;

$_LANG['prosper_affiliateprogram_submenu_1_display'] = true;
$_LANG['prosper_affiliateprogram_submenu_1_text'] = "Overview";
$_LANG['prosper_affiliateprogram_submenu_1_url'] = "#overview";
$_LANG['prosper_affiliateprogram_submenu_1_url_newwindow'] = false;

$_LANG['prosper_affiliateprogram_submenu_2_display'] = true;
$_LANG['prosper_affiliateprogram_submenu_2_text'] = "Commissions";
$_LANG['prosper_affiliateprogram_submenu_2_url'] = "#commissions";
$_LANG['prosper_affiliateprogram_submenu_2_url_newwindow'] = false;

$_LANG['prosper_affiliateprogram_submenu_3_display'] = true;
$_LANG['prosper_affiliateprogram_submenu_3_text'] = "Why Choose Us";
$_LANG['prosper_affiliateprogram_submenu_3_url'] = "#whychooseus";
$_LANG['prosper_affiliateprogram_submenu_3_url_newwindow'] = false;

$_LANG['prosper_affiliateprogram_submenu_4_display'] = true;
$_LANG['prosper_affiliateprogram_submenu_4_text'] = "Marketing Tools";
$_LANG['prosper_affiliateprogram_submenu_4_url'] = "#marketingtools";
$_LANG['prosper_affiliateprogram_submenu_4_url_newwindow'] = false;

$_LANG['prosper_affiliateprogram_submenu_5_display'] = true;
$_LANG['prosper_affiliateprogram_submenu_5_text'] = "How To Join";
$_LANG['prosper_affiliateprogram_submenu_5_url'] = "#howtojoin";
$_LANG['prosper_affiliateprogram_submenu_5_url_newwindow'] = false;

// Overview

$_LANG['prosper_affiliateprogram_overview_display'] = true;

$_LANG['prosper_affiliateprogram_overview_text'] = "

<p>Earn money by promoting our products/services via our free to join affiliate program. Once you've created your free affiliate account you'll receive a unique referral link. Whenever someone clicks this they are redirected to our website and any purchases they make are recorded and the commission from that purchase is added to your account. As your commission builds you'll be able to request a payout via PayPal.</p>

";

// Buttons

$_LANG['prosper_affiliateprogram_overview_button1_text'] = "Access Account";
$_LANG['prosper_affiliateprogram_overview_button1_icon'] = "fas fa-lock";
$_LANG['prosper_affiliateprogram_overview_button1_url'] = "clientarea.php";
$_LANG['prosper_affiliateprogram_overview_button1_newwindow'] = false;

$_LANG['prosper_affiliateprogram_overview_button2_text'] = "Join Free";
$_LANG['prosper_affiliateprogram_overview_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_affiliateprogram_overview_button2_url'] = "register.php";
$_LANG['prosper_affiliateprogram_overview_button2_newwindow'] = false;

// Commissions

$_LANG['prosper_affiliateprogram_commissions_display'] = true;

$_LANG['prosper_affiliateprogram_commissions_heading'] = "Commissions";

$_LANG['prosper_affiliateprogram_commissions_table_heading1'] = "Product/Service";
$_LANG['prosper_affiliateprogram_commissions_table_heading2'] = "Commission";

// Product 1

$_LANG['prosper_affiliateprogram_commissions_table_product_1_display'] = true;
$_LANG['prosper_affiliateprogram_commissions_table_product_1_product'] = "Shared Hosting";
$_LANG['prosper_affiliateprogram_commissions_table_product_1_prefix'] = "As much as ";
$_LANG['prosper_affiliateprogram_commissions_table_product_1_commission'] = "3.99";
$_LANG['prosper_affiliateprogram_commissions_table_product_1_term'] = "/month";

// Product 2

$_LANG['prosper_affiliateprogram_commissions_table_product_2_display'] = true;
$_LANG['prosper_affiliateprogram_commissions_table_product_2_product'] = "Reseller Hosting";
$_LANG['prosper_affiliateprogram_commissions_table_product_2_prefix'] = "As much as ";
$_LANG['prosper_affiliateprogram_commissions_table_product_2_commission'] = "9.99";
$_LANG['prosper_affiliateprogram_commissions_table_product_2_term'] = "/month";

// Product 3

$_LANG['prosper_affiliateprogram_commissions_table_product_3_display'] = true;
$_LANG['prosper_affiliateprogram_commissions_table_product_3_product'] = "VPN";
$_LANG['prosper_affiliateprogram_commissions_table_product_3_prefix'] = "";
$_LANG['prosper_affiliateprogram_commissions_table_product_3_commission'] = "10.00";
$_LANG['prosper_affiliateprogram_commissions_table_product_3_term'] = "/sale";

// Product 4

$_LANG['prosper_affiliateprogram_commissions_table_product_4_display'] = true;
$_LANG['prosper_affiliateprogram_commissions_table_product_4_product'] = "IPTV";
$_LANG['prosper_affiliateprogram_commissions_table_product_4_prefix'] = "Earn ";
$_LANG['prosper_affiliateprogram_commissions_table_product_4_commission'] = "5.00";
$_LANG['prosper_affiliateprogram_commissions_table_product_4_term'] = " per signup";

// Why Choose Us

$_LANG['prosper_affiliateprogram_whychooseus_display'] = true;

$_LANG['prosper_affiliateprogram_whychooseus_heading'] = "Why Become A " . $_LANG['prosper_setting_companyname'] . " Affiliate?";

// Why Choose Us 1

$_LANG['prosper_affiliateprogram_whychooseus_1_display'] = true;
$_LANG['prosper_affiliateprogram_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_whychooseus_1_heading'] = "Control Panel";
$_LANG['prosper_affiliateprogram_whychooseus_1_image'] = "affiliateprogram-whychooseus-1.png";
$_LANG['prosper_affiliateprogram_whychooseus_1_image_alt'] = "control panel";
$_LANG['prosper_affiliateprogram_whychooseus_1_image_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_1_text'] = "<p>Once you have registered as an affiliate you will be able to access our affiliate control panel which includes your referral URL, marketing material and realtime reports & statistics.</p>";
$_LANG['prosper_affiliateprogram_whychooseus_1_button1_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_button1_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_1_button2_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_button2_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_affiliateprogram_whychooseus_2_display'] = true;
$_LANG['prosper_affiliateprogram_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_whychooseus_2_heading'] = "High Commissions";
$_LANG['prosper_affiliateprogram_whychooseus_2_image'] = "affiliateprogram-whychooseus-2.png";
$_LANG['prosper_affiliateprogram_whychooseus_2_image_alt'] = "high commissions";
$_LANG['prosper_affiliateprogram_whychooseus_2_image_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_2_text'] = "<p>Join our affiliate program today to benefit from our industry leading high commissions. We pay a completetive commission on all of the products and services that we provide.</p>";
$_LANG['prosper_affiliateprogram_whychooseus_2_button1_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_button1_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_2_button2_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_button2_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_affiliateprogram_whychooseus_3_display'] = true;
$_LANG['prosper_affiliateprogram_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_whychooseus_3_heading'] = "Realtime Reports";
$_LANG['prosper_affiliateprogram_whychooseus_3_image'] = "affiliateprogram-whychooseus-3.png";
$_LANG['prosper_affiliateprogram_whychooseus_3_image_alt'] = "realtime reports";
$_LANG['prosper_affiliateprogram_whychooseus_3_image_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_3_text'] = "<p>We provide real-time statistics as well as a monthly email report with information on any new clicks, conversions and commissions you have generated as a valued affiliate.</p>";
$_LANG['prosper_affiliateprogram_whychooseus_3_button1_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_button1_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_3_button2_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_button2_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_3_button2_url_newwindow'] = false;

// Why Choose Us 4

$_LANG['prosper_affiliateprogram_whychooseus_4_display'] = true;
$_LANG['prosper_affiliateprogram_whychooseus_4_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_whychooseus_4_heading'] = "Marketing Tools";
$_LANG['prosper_affiliateprogram_whychooseus_4_image'] = "affiliateprogram-whychooseus-4.png";
$_LANG['prosper_affiliateprogram_whychooseus_4_image_alt'] = "marketing tools";
$_LANG['prosper_affiliateprogram_whychooseus_4_image_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_4_text'] = "<p>One of the benefits of our program is the focus we have given to the free marketing tools that we provide. We have banners, badges, links to specific landing pages & more.</p>";
$_LANG['prosper_affiliateprogram_whychooseus_4_button1_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_button1_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_button1_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_button1_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_4_button2_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_button2_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_button2_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_4_button2_url_newwindow'] = false;

// Why Choose Us 5

$_LANG['prosper_affiliateprogram_whychooseus_5_display'] = true;
$_LANG['prosper_affiliateprogram_whychooseus_5_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_whychooseus_5_heading'] = "Free &amp; Instant Access";
$_LANG['prosper_affiliateprogram_whychooseus_5_image'] = "affiliateprogram-whychooseus-5.png";
$_LANG['prosper_affiliateprogram_whychooseus_5_image_alt'] = "free access";
$_LANG['prosper_affiliateprogram_whychooseus_5_image_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_5_text'] = "<p>Join today for free and you will gain instant access to our high commission affiliate program and all of the marketing resources we provide including banners, badges & more.</p>";
$_LANG['prosper_affiliateprogram_whychooseus_5_button1_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_button1_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_button1_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_button1_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_whychooseus_5_button2_text'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_button2_icon'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_button2_url'] = "";
$_LANG['prosper_affiliateprogram_whychooseus_5_button2_url_newwindow'] = false;

// Marketing Tools

$_LANG['prosper_affiliateprogram_tools_display'] = true;

$_LANG['prosper_affiliateprogram_tools_heading'] = "Marketing Tools";

$_LANG['prosper_affiliateprogram_tools_text'] = "We have created a range of banners and media that you can use to promote our products/services.";

// Tool 1

$_LANG['prosper_affiliateprogram_tools_1_display'] = true;
$_LANG['prosper_affiliateprogram_tools_1_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_tools_1_image'] = "affiliateprogram-tools-1.jpg";
$_LANG['prosper_affiliateprogram_tools_1_image_alt'] = "tool 1";
$_LANG['prosper_affiliateprogram_tools_1_image_url'] = "affiliateprogram-tools-1.jpg";
$_LANG['prosper_affiliateprogram_tools_1_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_tools_1_image_url_popup'] = true;

// Tool 2

$_LANG['prosper_affiliateprogram_tools_2_display'] = true;
$_LANG['prosper_affiliateprogram_tools_2_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_tools_2_image'] = "affiliateprogram-tools-2.jpg";
$_LANG['prosper_affiliateprogram_tools_2_image_alt'] = "tool 2";
$_LANG['prosper_affiliateprogram_tools_2_image_url'] = "affiliateprogram-tools-2.jpg";
$_LANG['prosper_affiliateprogram_tools_2_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_tools_2_image_url_popup'] = true;

// Tool 3

$_LANG['prosper_affiliateprogram_tools_3_display'] = true;
$_LANG['prosper_affiliateprogram_tools_3_displayorder'] = 0;
$_LANG['prosper_affiliateprogram_tools_3_image'] = "affiliateprogram-tools-3.jpg";
$_LANG['prosper_affiliateprogram_tools_3_image_alt'] = "tool 3";
$_LANG['prosper_affiliateprogram_tools_3_image_url'] = "affiliateprogram-tools-3.jpg";
$_LANG['prosper_affiliateprogram_tools_3_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_tools_3_image_url_popup'] = true;

// How To Join

$_LANG['prosper_affiliateprogram_howtojoin_display'] = true;

$_LANG['prosper_affiliateprogram_howtojoin_heading'] = "How Do I Join?";

// Step 1

$_LANG['prosper_affiliateprogram_howtojoin_step_1_display'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_1_image'] = "affiliateprogram-step-1.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_1_image_alt'] = "step 1";
$_LANG['prosper_affiliateprogram_howtojoin_step_1_image_url'] = "affiliateprogram-step-1.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_1_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_howtojoin_step_1_image_url_popup'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_1_text'] = "Click on the join free button at the top of this page.";

// Step 2

$_LANG['prosper_affiliateprogram_howtojoin_step_2_display'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_2_image'] = "affiliateprogram-step-2.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_2_image_alt'] = "step 2";
$_LANG['prosper_affiliateprogram_howtojoin_step_2_image_url'] = "affiliateprogram-step-2.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_2_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_howtojoin_step_2_image_url_popup'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_2_text'] = "Once logged-in a new menu will appear. Hover over My Account and click on My Commissions.";

// Step 3

$_LANG['prosper_affiliateprogram_howtojoin_step_3_display'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_3_image'] = "affiliateprogram-step-3.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_3_image_alt'] = "step 3";
$_LANG['prosper_affiliateprogram_howtojoin_step_3_image_url'] = "affiliateprogram-step-3.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_3_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_howtojoin_step_3_image_url_popup'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_3_text'] = "Click the button named Activate Affiliate Account to activate your affiliate account.";

// Step 4

$_LANG['prosper_affiliateprogram_howtojoin_step_4_display'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_4_image'] = "affiliateprogram-step-4.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_4_image_alt'] = "step 4";
$_LANG['prosper_affiliateprogram_howtojoin_step_4_image_url'] = "affiliateprogram-step-4.jpg";
$_LANG['prosper_affiliateprogram_howtojoin_step_4_image_url_newwindow'] = false;
$_LANG['prosper_affiliateprogram_howtojoin_step_4_image_url_popup'] = true;
$_LANG['prosper_affiliateprogram_howtojoin_step_4_text'] = "You'll now see a page showing your unique referral link, commissions & banners.";






/*
-----------------------------------------
---------   Why choose us page (File: why-choose-us.tpl, why-choose-us.php)   ---------
-----------------------------------------
*/

// Why Choose Us

$_LANG['prosper_whychooseus_display'] = true;

// Why Choose Us 1

$_LANG['prosper_whychooseus_1_display'] = true;
$_LANG['prosper_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_whychooseus_1_image'] = "whychooseus-whychooseus-1.png";
$_LANG['prosper_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_whychooseus_1_image_url'] = "";
$_LANG['prosper_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_whychooseus_1_button1_text'] = "";
$_LANG['prosper_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_whychooseus_1_button1_url'] = "";
$_LANG['prosper_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_whychooseus_1_button2_text'] = "";
$_LANG['prosper_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_whychooseus_1_button2_url'] = "";
$_LANG['prosper_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_whychooseus_2_display'] = true;
$_LANG['prosper_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_whychooseus_2_image'] = "whychooseus-whychooseus-2.png";
$_LANG['prosper_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_whychooseus_2_image_url'] = "";
$_LANG['prosper_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_whychooseus_2_button1_text'] = "";
$_LANG['prosper_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_whychooseus_2_button1_url'] = "";
$_LANG['prosper_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_whychooseus_2_button2_text'] = "";
$_LANG['prosper_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_whychooseus_2_button2_url'] = "";
$_LANG['prosper_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_whychooseus_3_display'] = true;
$_LANG['prosper_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_whychooseus_3_image'] = "whychooseus-whychooseus-3.png";
$_LANG['prosper_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_whychooseus_3_image_url'] = "";
$_LANG['prosper_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_whychooseus_3_button1_text'] = "";
$_LANG['prosper_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_whychooseus_3_button1_url'] = "";
$_LANG['prosper_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_whychooseus_3_button2_text'] = "";
$_LANG['prosper_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_whychooseus_3_button2_url'] = "";
$_LANG['prosper_whychooseus_3_button2_url_newwindow'] = false;






/*
-----------------------------------------
---------   Testimonials page (File: testimonials.tpl, testimonials.php)   ---------
-----------------------------------------
*/

// Testimonials

$_LANG['prosper_testimonials_display'] = true;

// Testimonial 1

$_LANG['prosper_testimonials_1_display'] = true;
$_LANG['prosper_testimonials_1_displayorder'] = 0;
$_LANG['prosper_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['prosper_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['prosper_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['prosper_testimonials_1_author'] = "Nathan";
$_LANG['prosper_testimonials_1_url'] = "www.google.com";
$_LANG['prosper_testimonials_1_image'] = "testimonials-testimonials-1.png";
$_LANG['prosper_testimonials_1_alt'] = "client 1";
$_LANG['prosper_testimonials_1_image_url'] = "";
$_LANG['prosper_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['prosper_testimonials_2_display'] = true;
$_LANG['prosper_testimonials_2_displayorder'] = 0;
$_LANG['prosper_testimonials_2_quote'] = "

<p>" . $_LANG['prosper_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['prosper_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['prosper_testimonials_2_author'] = "Joanna";
$_LANG['prosper_testimonials_2_url'] = "www.yahoo.com";
$_LANG['prosper_testimonials_2_image'] = "testimonials-testimonials-2.png";
$_LANG['prosper_testimonials_2_alt'] = "client 2";
$_LANG['prosper_testimonials_2_image_url'] = "";
$_LANG['prosper_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['prosper_testimonials_3_display'] = true;
$_LANG['prosper_testimonials_3_displayorder'] = 0;
$_LANG['prosper_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['prosper_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['prosper_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['prosper_testimonials_3_author'] = "George";
$_LANG['prosper_testimonials_3_url'] = "www.msn.com";
$_LANG['prosper_testimonials_3_image'] = "testimonials-testimonials-3.png";
$_LANG['prosper_testimonials_3_alt'] = "client 3";
$_LANG['prosper_testimonials_3_image_url'] = "";
$_LANG['prosper_testimonials_3_image_url_newwindow'] = false;






/*
-----------------------------------------
---------   Portal page (File: portal.tpl, portal.php)   ---------
-----------------------------------------
*/

$_LANG['prosper_portal_display'] = true;

// Button 1

$_LANG['prosper_portal_1_display'] = true;
$_LANG['prosper_portal_1_displayorder'] = 0;
$_LANG['prosper_portal_1_heading'] = "Client Area";
$_LANG['prosper_portal_1_url'] = "clientarea.php";
$_LANG['prosper_portal_1_url_newwindow'] = false;
$_LANG['prosper_portal_1_image'] = "portal-1.png";
$_LANG['prosper_portal_1_image_alt'] = "client area";
$_LANG['prosper_portal_1_text'] = "View & update your account details";

// Button 2

$_LANG['prosper_portal_2_display'] = true;
$_LANG['prosper_portal_2_displayorder'] = 0;
$_LANG['prosper_portal_2_heading'] = "Pre-Sales Contact Us";
$_LANG['prosper_portal_2_url'] = "contact.php";
$_LANG['prosper_portal_2_url_newwindow'] = false;
$_LANG['prosper_portal_2_image'] = "portal-2.png";
$_LANG['prosper_portal_2_image_alt'] = "contact us";
$_LANG['prosper_portal_2_text'] = "Place any pre-sales enquiries here";

// Button 3

$_LANG['prosper_portal_3_display'] = true;
$_LANG['prosper_portal_3_displayorder'] = 0;
$_LANG['prosper_portal_3_heading'] = "Submit Ticket";
$_LANG['prosper_portal_3_url'] = "submitticket.php";
$_LANG['prosper_portal_3_url_newwindow'] = false;
$_LANG['prosper_portal_3_image'] = "portal-3.png";
$_LANG['prosper_portal_3_image_alt'] = "submit ticket";
$_LANG['prosper_portal_3_text'] = "Submit a support or sales request";

// Button 4

$_LANG['prosper_portal_4_display'] = true;
$_LANG['prosper_portal_4_displayorder'] = 0;
$_LANG['prosper_portal_4_heading'] = "Downloads";
$_LANG['prosper_portal_4_url'] = "default";
$_LANG['prosper_portal_4_url_newwindow'] = false;
$_LANG['prosper_portal_4_image'] = "portal-4.png";
$_LANG['prosper_portal_4_image_alt'] = "downloads";
$_LANG['prosper_portal_4_text'] = "View our library of downloads";

// Button 5

$_LANG['prosper_portal_5_display'] = true;
$_LANG['prosper_portal_5_displayorder'] = 0;
$_LANG['prosper_portal_5_heading'] = "Support Tickets";
$_LANG['prosper_portal_5_url'] = "supporttickets.php";
$_LANG['prosper_portal_5_url_newwindow'] = false;
$_LANG['prosper_portal_5_image'] = "portal-5.png";
$_LANG['prosper_portal_5_image_alt'] = "support tickets";
$_LANG['prosper_portal_5_text'] = "View and respond to existing tickets";

// Button 6

$_LANG['prosper_portal_6_display'] = true;
$_LANG['prosper_portal_6_displayorder'] = 0;
$_LANG['prosper_portal_6_heading'] = "Knowledgebase";
$_LANG['prosper_portal_6_url'] = "default";
$_LANG['prosper_portal_6_url_newwindow'] = false;
$_LANG['prosper_portal_6_image'] = "portal-6.png";
$_LANG['prosper_portal_6_image_alt'] = "knowledgebase";
$_LANG['prosper_portal_6_text'] = "Browse our KB for answers to FAQs";

// Button 7

$_LANG['prosper_portal_7_display'] = true;
$_LANG['prosper_portal_7_displayorder'] = 0;
$_LANG['prosper_portal_7_heading'] = "Server Status";
$_LANG['prosper_portal_7_url'] = "serverstatus.php";
$_LANG['prosper_portal_7_url_newwindow'] = false;
$_LANG['prosper_portal_7_image'] = "portal-7.png";
$_LANG['prosper_portal_7_image_alt'] = "server status";
$_LANG['prosper_portal_7_text'] = "View live status info for our servers";

// Button 8

$_LANG['prosper_portal_8_display'] = true;
$_LANG['prosper_portal_8_displayorder'] = 0;
$_LANG['prosper_portal_8_heading'] = "Order";
$_LANG['prosper_portal_8_url'] = "cart.php";
$_LANG['prosper_portal_8_url_newwindow'] = false;
$_LANG['prosper_portal_8_image'] = "portal-8.png";
$_LANG['prosper_portal_8_image_alt'] = "order";
$_LANG['prosper_portal_8_text'] = "Place a new order with us today";

// Button 9

$_LANG['prosper_portal_9_display'] = true;
$_LANG['prosper_portal_9_displayorder'] = 0;
$_LANG['prosper_portal_9_heading'] = "Domain Checker";
$_LANG['prosper_portal_9_url'] = "default";
$_LANG['prosper_portal_9_url_newwindow'] = false;
$_LANG['prosper_portal_9_image'] = "portal-9.png";
$_LANG['prosper_portal_9_image_alt'] = "domain checker";
$_LANG['prosper_portal_9_text'] = "Register your perfect domain";

// Button 10

$_LANG['prosper_portal_10_display'] = true;
$_LANG['prosper_portal_10_displayorder'] = 0;
$_LANG['prosper_portal_10_heading'] = "Network Issues";
$_LANG['prosper_portal_10_url'] = "networkissues.php";
$_LANG['prosper_portal_10_url_newwindow'] = false;
$_LANG['prosper_portal_10_image'] = "portal-10.png";
$_LANG['prosper_portal_10_image_alt'] = "network issues";
$_LANG['prosper_portal_10_text'] = "Read about current and scheduled outages";

// Button 11

$_LANG['prosper_portal_11_display'] = true;
$_LANG['prosper_portal_11_displayorder'] = 0;
$_LANG['prosper_portal_11_heading'] = "Affiliate Program";
$_LANG['prosper_portal_11_url'] = "affiliate-program.php";
$_LANG['prosper_portal_11_url_newwindow'] = false;
$_LANG['prosper_portal_11_image'] = "portal-11.png";
$_LANG['prosper_portal_11_image_alt'] = "affiliate program";
$_LANG['prosper_portal_11_text'] = "Become a " . $_LANG['prosper_setting_companyname'] . " affiliate";

// Button 12

$_LANG['prosper_portal_12_display'] = true;
$_LANG['prosper_portal_12_displayorder'] = 0;
$_LANG['prosper_portal_12_heading'] = "Announcements";
$_LANG['prosper_portal_12_url'] = "default";
$_LANG['prosper_portal_12_url_newwindow'] = false;
$_LANG['prosper_portal_12_image'] = "portal-12.png";
$_LANG['prosper_portal_12_image_alt'] = "announcements";
$_LANG['prosper_portal_12_text'] = "View our latest news & announcements";






/*
-----------------------------------------
---------   Company page (File: company.tpl, company.php)  ---------
-----------------------------------------
*/

// Submenu

$_LANG['prosper_company_submenu_display'] = true;

$_LANG['prosper_company_submenu_1_display'] = true;
$_LANG['prosper_company_submenu_1_text'] = "Overview";
$_LANG['prosper_company_submenu_1_url'] = "#overview";
$_LANG['prosper_company_submenu_1_url_newwindow'] = false;

$_LANG['prosper_company_submenu_2_display'] = true;
$_LANG['prosper_company_submenu_2_text'] = "Why Choose Us";
$_LANG['prosper_company_submenu_2_url'] = "#whychooseus";
$_LANG['prosper_company_submenu_2_url_newwindow'] = false;

$_LANG['prosper_company_submenu_3_display'] = true;
$_LANG['prosper_company_submenu_3_text'] = "FAQs";
$_LANG['prosper_company_submenu_3_url'] = "#faqs";
$_LANG['prosper_company_submenu_3_url_newwindow'] = false;

// Overview

$_LANG['prosper_company_overview_display'] = true;

$_LANG['prosper_company_overview_heading'] = "Welcome to " . $_LANG['prosper_setting_companyname'];
$_LANG['prosper_company_overview_heading2'] = "We provide premium cPanel hosting!";

$_LANG['prosper_company_overview_text'] = "<p>" . $_LANG['prosper_setting_companyname'] . " is miles above the rest as an exceptional web hosting company. We have many years of leading experience with global businesses of all sizes and have built up an affluence of web hosting expertise that put down us a scratch above other web hosting companies in this time. " . $_LANG['prosper_setting_companyname'] . " is a company that you can rely on for all of your web hosting. With 24 hour support and a money back guarantee there is no reason not to sign up today!</p>";

// Image

$_LANG['prosper_company_overview_image'] = "company.jpg";
$_LANG['prosper_company_overview_image_alt'] = "company premises";
$_LANG['prosper_company_overview_image_url'] = "";
$_LANG['prosper_company_overview_image_url_newwindow'] = false;
$_LANG['prosper_company_overview_image_text'] = "A look at our company premises";
$_LANG['prosper_company_overview_image_bold'] = true;

// Buttons

$_LANG['prosper_company_overview_button1_text'] = "Why Choose Us?";
$_LANG['prosper_company_overview_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_company_overview_button1_url'] = "#whychooseus";
$_LANG['prosper_company_overview_button1_url_newwindow'] = false;

$_LANG['prosper_company_overview_button2_text'] = "Get Started";
$_LANG['prosper_company_overview_button2_icon'] = "fas fa-angle-double-right";
$_LANG['prosper_company_overview_button2_url'] = "index.php#services";
$_LANG['prosper_company_overview_button2_url_newwindow'] = false;

// Company Bio

$_LANG['prosper_company_bio_text'] = "

<div class=\"headingstyle1\"><h2>Free Domain Name</h2></div>	

<p>As we are a pronounced web hosting company we include a free domain name registration/transfer with all of our web hosting plans. The domain name included with your hosting plan is yours to carry on forever.</p>

<div class=\"headingstyle1\"><h2>99.9% Uptime Guarantee</h2></div>	

<p>We offer a 99.9% uptime guarantee with all of our plans which is monitored by reliable third party companies. Whether it&#39;s the day or night, you can be confident that your website is safe in our professional hands.</p>

<div class=\"headingstyle1\"><h2>Disk Space &amp; Bandwidth</h2></div>	

<p>As we are prominent in our web hosting service, so you can get enormous storage for your files. We offer several tactics with diverse storage options.</p>

<div class=\"headingstyle1\"><h2>30 Days Money Back Guarantee</h2></div>	

<p>We also endow with a 30-days money back guarantee whereby you can claim your money back in full within a month of signing up without any questions asked.</p>

<div class=\"headingstyle1\"><h2>24/7 Support</h2></div>	

<p>Our experts are available 24 hours a day, 7 days a week by customer desk, live chat &amp; by phone for those times when you need help. Whether you need help with server assistance, registration of domains, transferring domain and websites, hosting related issues, control panel guidance we are here to assist you!</p>

<div class=\"headingstyle1\"><h2>Multiple Services To Fit Any Budget</h2></div>	

<p>We have the right web hosing plan for you, whether you&#39;re a big business corporate house or looking to setup your first Wordpress blog. We have a web hosting plan that&#39;s right for you!</p>

<div class=\"headingstyle1\"><h2>cPanel - Multi-Language Control Panel</h2></div>	

<p>We offer a multi-language, user-friendly control panel called cPanel. Languages supported are English, Portuguese, French, Dutch, Norwegian, Spanish, German, Russian, Ukrainian &amp; Bulgarian.</p>

<div class=\"headingstyle1\"><h2>Preinstalled Scripts</h2></div>	

<p>Preinstalled scripts make life much easier by allowing you to install any popular application/software without any web hosting knowledge. Whether you want to start a website, blog, forum or online store our 1 click, script installer has the right software for your needs. From Wordpress to Zen Cart, we have it all!</p>

";

// Why Choose Us

$_LANG['prosper_company_whychooseus_display'] = true;

$_LANG['prosper_company_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['prosper_company_whychooseus_1_display'] = true;
$_LANG['prosper_company_whychooseus_1_displayorder'] = 0;
$_LANG['prosper_company_whychooseus_1_heading'] = "Reliable Support";
$_LANG['prosper_company_whychooseus_1_image'] = "company-whychooseus-1.png";
$_LANG['prosper_company_whychooseus_1_image_alt'] = "reliable support";
$_LANG['prosper_company_whychooseus_1_image_url'] = "";
$_LANG['prosper_company_whychooseus_1_image_url_newwindow'] = false;
$_LANG['prosper_company_whychooseus_1_text'] = "

<p>As a " . $_LANG['prosper_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";
$_LANG['prosper_company_whychooseus_1_button1_text'] = "";
$_LANG['prosper_company_whychooseus_1_button1_icon'] = "";
$_LANG['prosper_company_whychooseus_1_button1_url'] = "";
$_LANG['prosper_company_whychooseus_1_button1_url_newwindow'] = false;
$_LANG['prosper_company_whychooseus_1_button2_text'] = "";
$_LANG['prosper_company_whychooseus_1_button2_icon'] = "";
$_LANG['prosper_company_whychooseus_1_button2_url'] = "";
$_LANG['prosper_company_whychooseus_1_button2_url_newwindow'] = false;

// Why Choose Us 2

$_LANG['prosper_company_whychooseus_2_display'] = true;
$_LANG['prosper_company_whychooseus_2_displayorder'] = 0;
$_LANG['prosper_company_whychooseus_2_heading'] = "Passionate";
$_LANG['prosper_company_whychooseus_2_image'] = "company-whychooseus-2.png";
$_LANG['prosper_company_whychooseus_2_image_alt'] = "quality servers";
$_LANG['prosper_company_whychooseus_2_image_url'] = "";
$_LANG['prosper_company_whychooseus_2_image_url_newwindow'] = false;
$_LANG['prosper_company_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";
$_LANG['prosper_company_whychooseus_2_button1_text'] = "";
$_LANG['prosper_company_whychooseus_2_button1_icon'] = "";
$_LANG['prosper_company_whychooseus_2_button1_url'] = "";
$_LANG['prosper_company_whychooseus_2_button1_url_newwindow'] = false;
$_LANG['prosper_company_whychooseus_2_button2_text'] = "";
$_LANG['prosper_company_whychooseus_2_button2_icon'] = "";
$_LANG['prosper_company_whychooseus_2_button2_url'] = "";
$_LANG['prosper_company_whychooseus_2_button2_url_newwindow'] = false;

// Why Choose Us 3

$_LANG['prosper_company_whychooseus_3_display'] = true;
$_LANG['prosper_company_whychooseus_3_displayorder'] = 0;
$_LANG['prosper_company_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['prosper_company_whychooseus_3_image'] = "company-whychooseus-3.png";
$_LANG['prosper_company_whychooseus_3_image_alt'] = "renewable";
$_LANG['prosper_company_whychooseus_3_image_url'] = "";
$_LANG['prosper_company_whychooseus_3_image_url_newwindow'] = false;
$_LANG['prosper_company_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";
$_LANG['prosper_company_whychooseus_3_button1_text'] = "";
$_LANG['prosper_company_whychooseus_3_button1_icon'] = "";
$_LANG['prosper_company_whychooseus_3_button1_url'] = "";
$_LANG['prosper_company_whychooseus_3_button1_url_newwindow'] = false;
$_LANG['prosper_company_whychooseus_3_button2_text'] = "";
$_LANG['prosper_company_whychooseus_3_button2_icon'] = "";
$_LANG['prosper_company_whychooseus_3_button2_url'] = "";
$_LANG['prosper_company_whychooseus_3_button2_url_newwindow'] = false;

// FAQs

$_LANG['prosper_company_faqs_display'] = true;

$_LANG['prosper_company_faqs_heading'] = "FAQs";

$_LANG['prosper_company_faqs_question_heading'] = "Have A Question?";
$_LANG['prosper_company_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['prosper_company_faqs_question_button1_text'] = "Contact Us";
$_LANG['prosper_company_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['prosper_company_faqs_question_button1_url'] = "contact.php";
$_LANG['prosper_company_faqs_question_button1_url_newwindow'] = false;

$_LANG['prosper_company_faqs_question_button2_text'] = "";
$_LANG['prosper_company_faqs_question_button2_icon'] = "";
$_LANG['prosper_company_faqs_question_button2_url'] = "";
$_LANG['prosper_company_faqs_question_button2_url_newwindow'] = false;

$_LANG['prosper_company_faqs_1_display'] = true;
$_LANG['prosper_company_faqs_1_displayorder'] = 0;
$_LANG['prosper_company_faqs_1_question'] = "How long have you been in business?";
$_LANG['prosper_company_faqs_1_answer'] = "<p>" . $_LANG['prosper_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['prosper_company_faqs_2_display'] = true;
$_LANG['prosper_company_faqs_2_displayorder'] = 0;
$_LANG['prosper_company_faqs_2_question'] = "Which payment methods are available?";
$_LANG['prosper_company_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['prosper_company_faqs_3_display'] = true;
$_LANG['prosper_company_faqs_3_displayorder'] = 0;
$_LANG['prosper_company_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['prosper_company_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Terms Of Service page (File: terms-of-service.tpl, terms-of-service.php)   ---------
-----------------------------------------
*/

$_LANG['prosper_page_terms_of_service'] = "

<p>This Web Hosting Agreement is between " . $_LANG['prosper_setting_companyname'] . " and the person/persons who use our website hosting and domain service. Please read carefully to ensure you understand our terms before purchasing any of our products or services.</p>

<h2>Services</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " agrees to provide the services stated for the price agreed at any given time. We do not miss lead customers with hidden costs unlike many other web hosting companies.</p>

<h2>Terms</h2>

<p>All customers are responsible for monitoring their storage space and bandwidth transfer each month. Customers who go over the limit of their account will be sent an email with the option to either upgrade their account or reduce store and or storage. If customers continue to go over we will do everything possible to fix the problem. We do hold to right to ban accounts for continuous problems. If customers sign up for an account and cancel it within the first month they will still be charged for the full first month.</p>

<h2>Payments</h2>

<p>Renewal notices are emailed three days before the actual renew date in your account. If you're using a credit card you will not have to worry about manual payments. All accounts are set up on a pre-pay basis. If payment is not received within 7 days a $5 fee will be added. " . $_LANG['prosper_setting_companyname'] . " reserves the right to change prices at any time, unless other terms have been agreed upon. Any account not brought current within a week (7 days) of e-mail notice or exceeding this time frame in any way is subject to suspension. YOU are responsible for all fees owed on the account from the time it was established to the time that YOU notify " . $_LANG['prosper_setting_companyname'] . " to request for termination of services. Although we are based in the UK our websites currency is USD. YOUR particular billing cycle corresponds to the contract length that was initially chosen at setup. YOUR account will automatically renew at this length unless cancelled before hand. There is no fee for cancelled accounts that have been paid for yearly. If you cancel an account on the monthly billing cycle " . $_LANG['prosper_setting_companyname'] . " can not refund any payments made before.</p>

<p>All annual payments are non refundable once the 30 day money back guarantee has passed. The only time your annual plan will end is if your account does not comply with our terms of service/acceptable usage policy. Both monthly and annual payments are non-refundable if your account does not follow our terms of service/acceptable usage policy.</p>

<h2>Cancellation and Early Termination</h2>

<p>Customers must acknowledge that the amount of the services bought is based on customers agreement to pay the fee for the initial term or renewal term.</p>

<h2>Server Abuse</h2>

<p>Any attempt to undermine or cause harm to a server or customer of " . $_LANG['prosper_setting_companyname'] . " is strictly prohibited.</p>

<p>" . $_LANG['prosper_setting_companyname'] . " will strongly react to any use or attempted use of an Internet account or computer without the owner's authorization. Such attempts include 'Internet scamming' (tricking other people into releasing their passwords), password theft, security hole scanning, etc.</p>

<p>Any unauthorized use of accounts or computers by YOU, whether or not the attacked account or computer belongs to " . $_LANG['prosper_setting_companyname'] . ", will result in action against YOU. Possible actions include warnings, account suspension or cancelation, as well as civil or criminal legal action, depending on the seriousness of the attack.</p>

<p>IMPORTANT NOTE - " . $_LANG['prosper_setting_companyname'] . " has the right to discontinue service, or deny access to anyone who violates our policies or the terms and conditions shown below WITHOUT WARNING or PRIOR NOTICE. No refunds of fees paid will be made if account termination is due to violation of the terms outlined below.</p>

<p>YOU may not run IRC, bots or clients on shared servers. Unacceptable uses also include, but are NOT limited to: Bulk emailing, unsolicited emailing, newsgroup spamming, upload scripts (Rappidleach), pornographic content, illegal content, copyright infringement, trademark infringement, warez sites (including links to/from), cracks, software serial numbers, proxy-relaying, link farming (the act of or by use of scripts), link grinding, link-only sites, spamdexing, FFA (Free-For-All) and/or anything else determined by " . $_LANG['prosper_setting_companyname'] . " to be unacceptable use of our services including abuse of server resources.</p>

<p>WEB APPLICATIONS and WEB ACCESSIBLE SCRIPTS - All web applications that are out-of-date and actively being exploited will be shut down immediately without prior notice. YOU are responsible for and should evaluate YOUR web-based applications and scripts on a regular basis to ensure their security and orderliness.</p>

<p>Shared hosting accounts may also be terminated if it includes the following content or have links to the following content: Providing material that is grossly offensive to the Web community including blatant expressions of bigotry, racism, hatred, or profanity; promoting or providing instructional information about illegal activities; promoting physical harm or injury against any group or individual; displaying material containing obscene nudity or pornographic material (not applicable to managed dedicated servers); displaying material that exploits children under 18-years of age; acts of copyright infringement including offering pirated computer programs or links to such programs; information used to circumvent manufacturer-installed copy-protect devices, including serial or registration numbers for software programs, or any type of cracker utilities.</p>

<h2>Disk Space Abuse</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " will be the sole arbiter as to what constitutes a violation of this provision. You are responsible for monitoring your disk space usage. If you need extra disk space contact one of our staff and they will be happy to help out. You can also upgrade your hosting plan from inside your " . $_LANG['prosper_setting_companyname'] . " client account.</p>

<h2>Bandwidth Abuse</h2>

<p>The intention of " . $_LANG['prosper_setting_companyname'] . " is to provide a large bandwidth to transfer web documents, and not an offsite storage area for electronic files. If YOU violate this condition, YOU will be notified and given 48 hours to remedy the problem. Failure to do so will result in YOU being billed for the overages.</p>

<p>Traffic will go unmonitored until YOU reach the amount of quota allocated to YOUR specific PLAN. " . $_LANG['prosper_setting_companyname'] . " will be the sole arbiter as to what constitutes a violation of this provision.</p>

<h2>AUP</h2>

<p>Customers agree to use our services under the <a href='acceptable-usage-policy.php'>Acceptable Usage Policy</a> which is here by incorporated with this agreement. Customers agree that " . $_LANG['prosper_setting_companyname'] . " hold the right to change their AUP at any time to meet web hosting standards and laws. Amendments to the AUP are effective on the earlier of " . $_LANG['prosper_setting_companyname'] . " notice to Customer that an amendment has been made, or the first day of any Renewal Term that begins subsequent to the amendment. Customer agrees to cooperate with " . $_LANG['prosper_setting_companyname'] . " reasonable investigation of any suspected violation of the AUP. In the event of a dispute between " . $_LANG['prosper_setting_companyname'] . " and Customer regarding the interpretation of the AUP, " . $_LANG['prosper_setting_companyname'] . " commercially reasonable interpretation of the AUP shall govern.</p>

<h2>Customer Information</h2>

<p>Customer represents and warrants to " . $_LANG['prosper_setting_companyname'] . " that the information he, she or it has provided and will provide to " . $_LANG['prosper_setting_companyname'] . " for purposes of establishing and maintaining the service is accurate. If Customer is an individual, Customer represents and warrants to " . $_LANG['prosper_setting_companyname'] . " that he or she is at least 18 years of age. " . $_LANG['prosper_setting_companyname'] . " may rely on the instructions of the person listed as the Primary Customer Contact on the Order with regard to Customer's account until Customer has provided a written notice changing the Primary Customer Contract.</p>

<h2>Unsolicited email &amp; spamming</h2>

<p>Unsolicited commercial advertisements ('SPAM') are not allowed in e-mail, and will likely result in account cancelation. " . $_LANG['prosper_setting_companyname'] . " takes a zero-tolerance approach to SPAM originating from its servers or for spam advertising of domains hosted within our network. If found, YOUR account may be deleted.</p>

<p>The following activities are not allowed: SPAM, which includes, but is not limited to, bulk mailing of commercial advertising, informational announcements, charity requests, petitions for signatures, and political or religious tracts (such messages may only be sent to those who have explicitly requested it from your domain); Forging, altering or removing electronic mail headers - any domain sending stealth spam will be terminated without warning and without refund. Sending numerous copies of the same or substantially similar message with the intent to disrupt a server or account ('mail bombing'); Spamming Newsgroups: Commercial advertisements are unwelcome in most Usenet discussion groups and on most e-mail mailing lists. Inappropriate posting may result in account cancelation. See the newsgroup or mailing list's charter for whether advertising is allowed or not. Sending a message to many different off-topic newsgroups, is particularly unethical and will be treated as such; Mail may not be used to harass or intimidate others. Harassment, whether through language, frequency of messages, or size of messages, is prohibited. Sending a single unwelcome message may be considered harassment. If a recipient asks to stop receiving e-mail, YOU must not send that person any further messages.</p>
<p>NOTE - If YOU use the services of another provider to promote a website hosted by or through " . $_LANG['prosper_setting_companyname'] . " ('spamvertising'), then the provisions of the above policy shall apply as if the SPAM were sent through our servers.</p>

<h2>99.99% Uptime Gurantee</h2>

<p>(1.) COVERAGE - This 99.99% uptime guarantee applies to any Customer in good financial standing with " . $_LANG['prosper_setting_companyname'] . " at the time of a service outage.</p>

<p>(2.) SERVICE LEVEL AGREEMENT ('SLA') &amp; SPECIFICATIONS - " . $_LANG['prosper_setting_companyname'] . " endeavors to have the content of YOUR website available for http access by any party in the world 99.99% of the time. Network downtime ('unavailability') is defined as 100% packet loss from " . $_LANG['prosper_setting_companyname'] . " to its backbone providers. Downtime is measured past 10 minutes after notification of network failure via " . $_LANG['prosper_setting_companyname'] . "'s online ticketing system. If the ticketing system itself is unreachable, the ticket must be started by calling the " . $_LANG['prosper_setting_companyname'] . " NOC.</p>

<p>" . $_LANG['prosper_setting_companyname'] . "'s administrators will determine the end of the downtime by a traceroute to YOUR machine from outside the " . $_LANG['prosper_setting_companyname'] . " network.</p>

<p>(3a.) SHARED HOSTING CREDITS - In the event that YOUR website is unavailable for less than 100%, " . $_LANG['prosper_setting_companyname'] . " will credit the following month's service fee as follows. YOUR credit shall be retroactive and measured in 24 hours a day of a calendar month, with the maximum credit not exceeding 50% of the monthly service charge for the affected month.</p>

<p>- 95% to 99.9% - YOUR account will be credited 10% of your monthly hosting fee<br />
- 90% to 94.9% - YOUR account will be credited 20% of your monthly hosting fee<br />
- 89.9% or below - YOUR account will be credited 50% of your monthly hosting fee (3b.)</p>

<p>Credit shall not be provided to YOU in the event that you have any outage resulting from:</p>

<p>- scheduled maintenance as posted from time to time at " . $_LANG['prosper_setting_companyname'] . ",<br />
- your behavior or the performance or failure of your equipment, facilities or applications,<br />
- circumstances beyond " . $_LANG['prosper_setting_companyname'] . "'s reasonable control, including, without limitation, acts of any governmental body, war, insurrection, sabotage, embargo, fire, flood, strike or other labor disturbance, interruption of or delay in transportation, unavailability of interruption or delay in telecommunications or third party services, including DNS propagation, domain name registration/transfer, failure of third party software or hardware or inability to obtain raw materials, supplies, or power used in or equipment needed for provision of your web site,<br />
- YOU breaking any agreement policy in " . $_LANG['prosper_setting_companyname'] . "'s 'Terms &amp; Conditions and AUP' causing a machine to fail as a result.</p>

<h2>Technical Support Limits</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " provides technical support for YOU that encompasses within our area of expertise only. Such expertise includes assistance, troubleshooting, and debugging of our cPanel control panel interface, servers within our immediate responsibility and any other hosting related issues.</p>

<p>Unlike many hosting companies We do our best to help with scripts, templates and programing languages. However, under no circumstances is " . $_LANG['prosper_setting_companyname'] . " obligated to help YOU in the installations of new application modules, templates and/or programming languages, nor in providing assistance for any errors produced by any applications that have been modified by YOU previously.</p>

<h2>CGI SCRIPTS</h2>

<p>Each shared web hosting account comes with its own CGI-BIN. YOU are free to use any CGI scripts YOU wish, however we reserve the rights to disable any CGI script that effects normal shared server operation without prior notice.</p>

<h2>Indemnification</h2>

<p>Customer agrees to indemnify and hold harmless " . $_LANG['prosper_setting_companyname'] . ", " . $_LANG['prosper_setting_companyname'] . "'s affiliates, and each of their respective officers, directors, agents, and employees from and against any and all claims, demands, liabilities, obligations, losses, damages, penalties, fines, punitive damages, amounts in interest, expenses and disbursements of any kind and nature whatsoever (including reasonable attorneys fees) brought by a third party under any theory of legal liability arising out of or related to the actual or alleged use of Customer's services in violation of applicable law or the AUP by Customer or any person using Customer's log on information, regardless of whether such person has been authorized to use the services by Customer.</p>

<p>YOU AGREE TO DEFEND,INDEMNIFY AND HOLD HARMLESS " . $_LANG['prosper_setting_companyname'] . " AGAINST LIABILITIES ARISING OF:</p>

<p>(1) ANY INJURY TO PERSON OR PROPERTY CAUSED BY ANY PRODUCTS SOLD OR OTHERWISE DISTRIBUTED IN CONNECTION WITH " . $_LANG['prosper_setting_companyname'] . "'S SERVER.<br />
(2) ANY MATERIAL SUPPLIED BY THE CUSTOMER INFRINGING OR ALLEGEDLY INFRINGING ON THE PROPRIETARY RIGHTS OF A THIRD PARTY<br />
(3) COPYRIGHT INFRINGEMENT AND<br />
(4) ANY DEFECTIVE PRODUCTS SOLD TO CUSTOMER FROM " . $_LANG['prosper_setting_companyname'] . "'S SERVER.</p>

<h2>Disclaimer of Warranties</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " does not warrant or represent that the services will be uninterrupted, error free, or completely secure. To the extent permitted by applicable law " . $_LANG['prosper_setting_companyname'] . " disclaims any and all warranties including the implied warranties or merchantability, fitness for a particular purpose and non-infringement. To the extent permitted by applicable law all services are provided on an &quot;As Is&quot; basis.</p>

<h2>Limitation of Damages</h2>

<p>Neither party shall be liable to the other for any lost profits or any indirect, special incidental, consequential or punitive loss or damage of any kind, or for damages that could have been avoided by the use of reasonable diligence, arising in connection with the agreement, even if the party has been advised or should be aware of the possibility of such damages.</p>

<p>Notwithstanding anything else in the agreement to the contrary, the maximum aggregate liability of " . $_LANG['prosper_setting_companyname'] . " and any of its employees, agents or affiliates, under any theory of the law (including breach of contract, tort, strict liability and infringement) shall  be a payment of money not to exceed the amount payable by customer for the three months service.</p>

<h2>Suspension of Services/Termination</h2>

<p>Customer agrees that " . $_LANG['prosper_setting_companyname'] . " may suspend services to Customer without notice and without liability if: (i) " . $_LANG['prosper_setting_companyname'] . " reasonably believes that the services are being used in violation of the AUP; (ii) Customer fails to cooperate with any reasonable investigation of any suspected violation of the AUP; (iii) " . $_LANG['prosper_setting_companyname'] . " reasonably believes that the suspension of service is necessary to protect its network or its other customers, or (iv) as requested by a law enforcement or regulatory agency. Customer shall pay " . $_LANG['prosper_setting_companyname'] . " reasonable reinstatement fee if service is " . $_LANG['prosper_setting_companyname'] . " following a suspension of service under this subsection.</p>

<p>The Agreement may be terminated by Customer prior to the expiration of the Initial Term or any Renewal Term without further notice and without liability if " . $_LANG['prosper_setting_companyname'] . " fails in a material way to provide the service in accordance with the terms of the Agreement and does not cure the failure within ten (10) days of Customer's written notice describing the failure in reasonable detail. The Agreement may be terminated by " . $_LANG['prosper_setting_companyname'] . " prior to the expiration of the Initial Term or any Renewal Term without further notice and without liability as follows: (i) upon five (5) days notice if Customer is overdue on the payment of any amount due under the Agreement; (ii) Customer materially violates any other provision of the Agreement, including the AUP, and fails to cure the violation within thirty (30) days of a written notice from " . $_LANG['prosper_setting_companyname'] . " describing the violation in reasonable detail; (iii) upon one (1) days notice if Customer's Service is used in violation of a material term of the AUP more than once, or (iv) upon one (1) days notice if Customer violates Section 5 (Customer Information) of this Agreement. Either party may terminate this agreement upon five (5) days advance notice if the other party admits insolvency, makes an assignment for the benefit of its creditors, files for bankruptcy or similar protection, is unable to pay debts as they become due, has a trustee or receiver appointed over all or a substantial portion of its assets, or enters into an agreement for the extension or readjustment of all or substantially all of its obligations.</p>

<p>If you break our terms of service/acceptable usage policy we hold the right to cancel any services. We will never cancel any services without trying our best to resolve the problem with you. However in extreme cases such as an account containing child pornography we hold the right to cancel services without any prior warning. We do not refund any accounts breaking our terms of service/acceptable usage policy. For example if we cancel your hosting account during your first month for breaching copyright, we will not refund you for the first month. This is to prevent people signing up for our services with the intention of breaching our terms.</p>

<h2>Request For Customer Information</h2>

<p>Customer agrees that " . $_LANG['prosper_setting_companyname'] . " may, without notice to Customer, (i) report to the appropriate authorities any conduct by Customer or any of Customer's customers or end users that " . $_LANG['prosper_setting_companyname'] . " believes violates applicable law, and (ii) provide any information that it has about Customer or any of its customers or end users in response to a formal or informal request from a law enforcement or regulatory agency or in response to a formal request in a civil action that on its face meets the requirements for such a request.</p>

<h2>Back Up Copy</h2>

<p>Customer agrees to maintain a current copy of all content hosted by " . $_LANG['prosper_setting_companyname'] . " not with standing any agreement by " . $_LANG['prosper_setting_companyname'] . " to provide back up services.</p>

<h2>Request For Restore Of Hosting Package</h2>

<p>During any service term, customer may request up to one free restore for any reason of choice. If a customer should need to request a restore after this a $5 one time fee will be enforced.</p>

<h2>Changes To " . $_LANG['prosper_setting_companyname'] . "'s Network</h2>

<p>Upgrades and other changes in " . $_LANG['prosper_setting_companyname'] . "'s network, including, but not limited to changes in its software, hardware, and service providers, may affect the display or operation of Customer's hosted content and/or applications. " . $_LANG['prosper_setting_companyname'] . " reserves the right to change its network in its commercially reasonable discretion, and " . $_LANG['prosper_setting_companyname'] . " shall not be liable for any resulting harm to Customer.</p>

<h2>Notices</h2>

<p>Notices to " . $_LANG['prosper_setting_companyname'] . " under the Agreement shall be given via electronic mail to the e-mail address posted for customer support. Notices to Customer shall be given via electronic mail to the individual listed as the Primary Customer Contact on the Order. Notices are deemed received on the day transmitted, or if that day is not a business day, on the first business day following the day delivered. Customer may change his, her or its notice address by a notice given in accordance with this Section.</p>

<h2>Force Majored</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " shall not be in default of any obligation under the Agreement if the failure to perform the obligation is due to any event beyond " . $_LANG['prosper_setting_companyname'] . "'s control, including, without limitation, significant failure of a portion of the power grid, significant failure of the Internet, natural disaster, war, riot, insurrection, epidemic, strikes or other organized labour action, terrorist activity, or other events of a magnitude or type for which precautions are not generally taken in the industry.</p>

<h2>Governing/Law Disputes</h2>

<p>The Agreement shall be governed by the laws of the State of Virginia, exclusive of its choice of law principles, and the laws of the United States of America, as applicable. The Agreement shall not be governed by the United Nations Convention on the International Sale of Goods.</p>

<h2>Miscellaneous</h2>

<p>Each party acknowledges and agrees that the other party retains exclusive ownership and rights in its trademarks, service marks, trade secrets, inventions, copyrights, and other intellectual property. Neither party may use the other party's name or trade mark without the other party's prior written consent. The parties intend for their relationship to be that of independent contractors and not a partnership, joint venture, or employer/employee. Neither party will represent itself to be agent of the other. Each party acknowledges that it has no power or authority to bind the other on any agreement and that it will not represent to any person that it has such power or authority. This Agreement may be amended only by a formal written agreement signed by both parties. The terms on Customer's purchase order or other business forms are not binding on " . $_LANG['prosper_setting_companyname'] . " unless they are expressly incorporated into a formal written agreement signed by both parties. A party's failure or delay in enforcing any provision of the Agreement will not be deemed a waiver of that party's rights with respect to that provision or any other provision of the Agreement. A party's waiver of any of its right under the Agreement is not a waiver of any of its other rights with respect to a prior, contemporaneous or future occurrence, whether similar in nature or not. The captions in the Agreement are not part of the Agreement, but are for the convenience of the parties. The following provisions will survive expiration or termination of the Agreement: Fees, indemnity obligations, provisions limiting liability and disclaiming warranties, provisions regarding ownership of intellectual property, these miscellaneous provisions, and other provisions that by their nature are intended to survive termination of the Agreement. There are no third party beneficiaries to the Agreement. Neither insurers nor the customers of resellers are third party beneficiaries to the Agreement. Customer may not transfer the Agreement without " . $_LANG['prosper_setting_companyname'] . "'s prior written consent. " . $_LANG['prosper_setting_companyname'] . "'s approval for assignment is contingent on the assignee meeting " . $_LANG['prosper_setting_companyname'] . "'s credit approval criteria. " . $_LANG['prosper_setting_companyname'] . " may assign the Agreement in whole or in part. This Agreement together with the Order and AUP constitutes the complete and exclusive agreement between the parties regarding its subject matter and supersedes and replace any prior understanding or communication, written or oral.</p>

<h2>Copyright Files</h2>

<p>All files stored on " . $_LANG['prosper_setting_companyname'] . "'s servers must be legally-owned and be accompanied with a valid license and/or copyright. This include and is not limiting to MP3, AVI, MID, MIDI, MPG, MPEG, MOV, EXE, ISO. Should we discover any unlicensed and/or illegal files within YOUR account, the files will be subjected to deletion.</p>

<h2>Cancelation Of Service</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " reserves the right to cancel a service at any time. All fees paid in advance of cancellation will be pro-rated and paid by " . $_LANG['prosper_setting_companyname'] . " if we institutes our right of cancelation. Any violation of policies which results in extra costs billed to YOU.</p>

<h2>Promotional Rates &amp; Special Offers</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " may offer subsequent promotional rates or special offers, the terms of which may or may not be more favorable than the terms and conditions for YOUR Services. Any such promotions or modifications shall not effect YOUR obligations under this Agreement. Promotional fees may be subject to additional terms and conditions which, to the extent they conflict with the terms of this Agreement, shall govern. Different promotional fees and special offers may not be combined together.</p>

<p>We have various special promotions that include a domain name. The cost of this domain name is usually covered by the first month's payment. As a result of this our promotions are not refundable and are not covered by our 30-day money back guarantee.</p>

<h2>Intellectual Property Rights</h2>

<p>Material accessible to you through " . $_LANG['prosper_setting_companyname'] . "'s services may be subject to protection under the United States or other copyright laws, or laws protecting trademarks, trade secrets and proprietary information. Except when expressly permitted by the owner of such rights, YOU must not use " . $_LANG['prosper_setting_companyname'] . " or its servers and network in a manner that would infringe, violate, dilute or misappropriate any such rights, with respect to any material that you access or receive through the " . $_LANG['prosper_setting_companyname'] . " network. If YOU use a domain name in connection with " . $_LANG['prosper_setting_companyname'] . " or similar service, YOU must not use that domain name in violation of any trademark, service mark, or similar rights of any third party.</p>

<h2>Network Security</h2>

<p>Customers may not use the " . $_LANG['prosper_setting_companyname'] . " network with an attempt to circumvent user authentication or security of any host, network, or account. This includes, but is not limited to, accessing data not intended for YOU, logging into a server or account YOU are not expressly authorized to access, password cracking, probing the security of other networks in search of weakness, or violation of any other organization's security policy. YOU may not attempt to interfere or deny service to any user, host, or network. This includes, but is not limited to, flooding, mail bombing, or other deliberate attempts to overload or crash a host or network. " . $_LANG['prosper_setting_companyname'] . " will cooperate fully with investigations for violations of systems or network security at other sites, including cooperating with law enforcement authorities in the investigation of suspected criminal violations. Users who violate system or network security may incur criminal or civil liability.</p>

<h2>Electronic Commerce</h2>

<p>YOU will be solely responsible for the development, operation and maintenance of YOUR online store and products along with all content and materials appearing online or on YOUR products, including without limitation:</p>

<p>(a.) the accuracy and appropriateness of content and materials appearing within the store or related to YOUR products,<br />(b.) ensuring that the content and materials appearing within the store or related to YOUR products do not violate or infringe upon the rights of any third party, and<br />(c.) ensuring that the content and materials appearing within the store or related to YOUR products are not libelous or otherwise illegal. YOU will be solely responsible for the final calculation and application of shipping and sales tax. YOU will also be solely responsible for accepting, processing, and filling any customer orders, and for handling any customer inquiries or complaints arising there from.</p>

<p>YOU are also responsible for the security of any customer credit card numbers and related customer information YOU may access as a result of conducting electronic commerce transactions through YOUR website. YOU will keep all such information confidential and will use the same degree of care and security as YOU use with your confidential information.</p>

<h2>Static &amp; Dynamic Content Caching</h2>

<p>YOU expressly</p>

<p>(i) grant to " . $_LANG['prosper_setting_companyname'] . " a license to cache the entirety of YOUR website, including content supplied by third parties, hosted by " . $_LANG['prosper_setting_companyname'] . " under this Agreement and<br />(ii) agree that such caching is not an infringement of any of YOUR intellectual property rights or any third party's intellectual property rights.</p>

<h2>IP Address Ownership</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " shall maintain and control ownership of all IP numbers and addresses that may be assigned to YOU by " . $_LANG['prosper_setting_companyname'] . ". " . $_LANG['prosper_setting_companyname'] . " reserves, in its sole discretion, the right to change or remove any and all such IP numbers and addresses.</p>

<h2>Domain Name Registration</h2>

<p>YOU agree to pay " . $_LANG['prosper_setting_companyname'] . " prior to the effectiveness of the desired domain name registration, the then-current amount set forth in the " . $_LANG['prosper_setting_companyname'] . " price schedule for the initial registration of the domain name and, should YOU choose to renew the registration, subsequent renewals of the registration. All fees are non-refundable, in whole or in part, even if YOUR domain name registration is suspended, canceled or transferred prior to the end of YOUR then current registration term. " . $_LANG['prosper_setting_companyname'] . " reserves the right to change fees, surcharges, renewal fees or to institute new fees at any time, for any reason, at its sole discretion. YOUR requested domain name will not be registered unless and until we receive actual payment of the registration fee, and have confirmed YOUR registration in an email from " . $_LANG['prosper_setting_companyname'] . " to the email address indicated in YOUR registration application. In the event of a chargeback by a credit card company (or similar action by another payment provider allowed by " . $_LANG['prosper_setting_companyname'] . ") in connection with the payments of the registration fee for YOUR domain name registration, YOU agrees and acknowledges that the domain name registration shall be transferred to " . $_LANG['prosper_setting_companyname'] . " as the paying entity for that registration to the registry and that we reserve all rights regarding such domain name including, without limitation, the right to make the domain name available to other parties for purchase. " . $_LANG['prosper_setting_companyname'] . " will reinstate YOUR domain name registration solely at " . $_LANG['prosper_setting_companyname'] . "'s discretion, and subject to our receipt of the initial registration or renewal fee and our then-current reinstatement fee.</p>

<p>Transfer domain registrar to " . $_LANG['prosper_setting_companyname'] . "</p>

<p>YOU agree to pay " . $_LANG['prosper_setting_companyname'] . " prior to the effectiveness of the desired domain name transfer request, the then-current amount set forth in the " . $_LANG['prosper_setting_companyname'] . " price schedule for the initial transfer request of the domain name. YOU agree and acknowledge that the domain name transfer will fail, and all fees are non-refundable, for the following reasons, but not limited to:</p>

<p>- No response from the Registered Name Holder or Administrative Contact<br />
- Domain name in Registrar Lock Status<br />
- Domain name registration period time expires or other constraints, other than during the first 60 days of initial registration or during the first 60 days after a registrar transfer</p>

<p>" . $_LANG['prosper_setting_companyname'] . " reserves the right to change fees, surcharges, renewal fees or to institute new fees at any time, for any reason, at its sole discretion. YOUR requested domain name will not be registered unless and until we receive actual payment of the registration fee, and have confirmed YOUR registration in an email from " . $_LANG['prosper_setting_companyname'] . " to the email address indicated in YOUR registration application. In the event of a chargeback by a credit card company (or similar action by another payment provider allowed by " . $_LANG['prosper_setting_companyname'] . ") in connection with the payments of the registration fee for YOUR domain name registration, YOU agrees and acknowledges that the domain name registration shall be transferred to " . $_LANG['prosper_setting_companyname'] . " as the paying entity for that registration to the registry and that we reserve all rights regarding such domain name including, without limitation, the right to make the domain name available to other parties for purchase. " . $_LANG['prosper_setting_companyname'] . " will reinstate YOUR domain name registration solely at " . $_LANG['prosper_setting_companyname'] . " discretion, and subject to our receipt of the initial registration or renewal fee and our then-current reinstatement fee.</p>

<p>Transfer domain away from " . $_LANG['prosper_setting_companyname'] . "</p>

<p>" . $_LANG['prosper_setting_companyname'] . " reserves all rights, without limitation, to reject the domain name transfer request for the following reasons, but not limited to:</p>

<p>- No response from the Registered Name Holder or Administrative Contact<br />
- Domain name in Registrar Lock Status and there is no request from Registered Name Holder or Administrative Contact for the status change<br />- Domain name registration period time will be expiring in less than 60 days or other constraints, other than during the first 60 days of initial registration or during the first 60 days after a registrar transfer</p>

<p>YOU agree and acknowledge that the failure or success of a domain name transfer will be his/her sole responsibility, and " . $_LANG['prosper_setting_companyname'] . " will not be held liable for the failure of a domain name transfer for any reason.</p>

<p>Domain registrations are non-refundable. Please do not purchase the domain name until you are certain that it is exactly what you would like to buy.</p>

<h2>Lawful Purpose</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " reserves the right to refuse service to anyone. YOU may only use " . $_LANG['prosper_setting_companyname'] . " server for lawful purposes and our services may not be used for illegal purposes or in support of illegal activities. We reserve the right to cooperate with legal authorities and/or injured third parties in the investigation of any suspected crime or civil wrongdoing. If anything is not legal in the United States of America, it is not permitted to reside on our servers. Transmission, distribution or storage of any material in violation of any applicable law or regulation is prohibited. This includes but not limiting material protected by copyright, trademark, trade secret or other intellectual property right used without proper authorization, and material that is obscene, defamatory, constitutes an illegal threat, or violates export control laws. Examples of non-acceptable content or links: 'Pirated Warez', OGG, AVI, MPEG, ISO, 'Hacker programs or archives', 'Copyrighted Digital Movie Copies (DIVX)' and 'Unlicensed MP3'. The designation of any materials as such described above is left entirely to the discretion of " . $_LANG['prosper_setting_companyname'] . " management.</p>

<p>If illegal content or usage is found, the account will be suspended and/or terminated. YOU agree that " . $_LANG['prosper_setting_companyname'] . " may disclose any and all YOUR information including assigned IP numbers, account history, account use, etc. to any law enforcement agent who makes a written request without further consent or notification.</p>

<p>Regardless of the place of signing this agreement, YOU agree that for purposes of venue this contract is entered in Fremont, California, and any dispute will be litigated or arbitrated in Fremont, California. Defendants further waive all objections to venue and acknowledge that venue in any such litigation will be held in Fremont courts. IN NO EVENT SHALL " . $_LANG['prosper_setting_companyname'] . "'S MAXIMUM LIABILITY EXCEED FIVE HUNDRED ($500.00) DOLLARS.</p>

<h2>Privacy Statement</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " follows the strict guidelines of our customer privacy statement. Please make sure you understand this statement fully.</p>

";






/*
-----------------------------------------
---------   Acceptable Usage Policy page (File: acceptable-usage-policy.tpl, acceptable-usage-policy.php)   ---------
-----------------------------------------
*/

$_LANG['prosper_page_acceptable_usage_policy'] = "

<p>This AUP governs the use of " . $_LANG['prosper_setting_companyname'] . "&#39;s web hosting service. Violation of this AUP may result in suspension or termination of your service. In the event of a dispute between you and " . $_LANG['prosper_setting_companyname'] . " regarding the interpretation of this AUP, " . $_LANG['prosper_setting_companyname'] . "'s interpretation, in its reasonable commercial judgment, shall govern.</p>

<p>The following is the entire Acceptable User Policy ('AUP') agreement between " . $_LANG['prosper_setting_companyname'] . " and the personal or corporate account holder. " . $_LANG['prosper_setting_companyname'] . " provides World Wide Web Hosting, web design and script installation. " . $_LANG['prosper_setting_companyname'] . " has certain legal and ethical responsibilities consisting with the use of its servers and equipment involved in these services. " . $_LANG['prosper_setting_companyname'] . "'s general policy is to act as a provider of Internet presence. " . $_LANG['prosper_setting_companyname'] . " reserves the rights to suspend or cancel a customer's access to any or all services provided by " . $_LANG['prosper_setting_companyname'] . " when we decide that the account has been inappropriately used.</p>

<h2>What is Appropriate Usage?</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " is designed to serve the web hosting needs of small, independently owned and operated businesses in a single country. It is not appropriate to use our services to support large enterprises or internationally based businesses with a sustained demand that places undue burden on our systems or negatively impacts use by small, independently owned and operated businesses.</p>

<p>" . $_LANG['prosper_setting_companyname'] . " is a shared web hosting service, which means that a number of customers' web sites and other email or storage services are hosted from the same server. " . $_LANG['prosper_setting_companyname'] . " uses abuse controls to help ensure that use of our services does not adversely affect the performance of our system or other customers' sites. It is not appropriate to use an account primarily as an online storage space or for archiving electronic files.</p>

<h2>Disk Space</h2>

<p>If you use your services consistently with the <a href=\"terms-of-service.php\">Terms Of Service</a> and these paragraphs, your site can grow as large as necessary to meet your small business needs, but to ensure a great experience for all, we will place some constraints on how fast you can grow. The vast majority of our customers' sites grow at rates well within our rules, but our abuse controls may cause a brief delay while we evaluate if expansion is appropriate for your particular plan.</p>

<p>" . $_LANG['prosper_setting_companyname'] . " Customers may not initiate the following (below), if any customer does " . $_LANG['prosper_setting_companyname'] . " may terminate the account with no refund. Depending on the situation there will/won't be warnings sent.<br />
a) Use 25% or more of system CPU resources for longer then 90 seconds or 1% of the servers CPU resources for longer than 5 minutes. There are numerous activities that could cause such problems; these include: CGI scripts, FTP, PHP, HTTP, etc.<br />
b) Use of any kind of distributed computing software, including but not limited to SETI@home, Node Zero and Folding@home.<br />
c) Run any type of interactive real-time chat applications that require server resources. Remotely-hosted services are fully allowed.<br />
d) Run stand-alone, unattended server-side processes at any point in time on the server. This includes any and all daemons.<br />
e) Run any software that interfaces with an IRC (Internet Relay Chat) network.<br />
f) Run any file sharing, bit torrent or other P2P network services, client or server software.<br />
g) Run any gaming servers such as counter-strike, half-life, battlefield 1492 etc</p>

<h2>Bandwidth</h2>

<p>In most cases, if you use our services consistently with our <a href=\"terms-of-service.php\">Terms Of Service</a>, visitors to your web site will be able to download and view as much content from your site as they like. However, in certain circumstances, our server processing power, server memory, or abuse controls could limit downloads from your site. You will always be able to use as much bandwidth as your account has. For example our Enterprise Plan comes with 40GB bandwidth which is a huge amount, all of this 40GB can be used. Bandwidth is also reset every month.</p>

<p>You are allocated a monthly bandwidth allowance. This allowance varies depending on the hosting package you purchase. Should your account pass the allocated amount we reserve the right to suspend the account until the start of the next allocation, suspend the account until more bandwidth is purchased at an additional fee, suspend the account until you upgrade to a higher level of package, terminate the account and/or charge you an additional fee for the overages. Unused transfer in one month cannot be carried over to the next month.</p>

<h2>Email Storage</h2>

<p>You do not have to worry about hitting a storage limit if you use our services consistently with the <a href=\"terms-of-service.php\">Terms Of Service</a> and our acceptable usage policy. " . $_LANG['prosper_setting_companyname'] . " will increase your space along with your appropriate small business needs, but our abuse controls may impact the rate of growth or your folder size, and there may be a short delay while we assess your usage. In some cases, creating additional folders or subfolders will help ensure that the system works well for everyone. You will always be allowed to use as much disk space is applied to your account.</p>

<h2>Unlimited</h2>

<p>You may have noticed all of our accounts come with unlimited email accounts, sub-domains, FTP accounts and in some cases domains. This is subject to how much disk space your account has. So you can create as many emails, sub-domains etc as you want as long as it's within your disk space limit.</p>

<h2>Offensive Content</h2>

<p>You may not publish or transmit via " . $_LANG['prosper_setting_companyname'] . "'s service any content that " . $_LANG['prosper_setting_companyname'] . " reasonably believes:<br />
a) constitutes child pornography;<br /> 
b) constitutes pornography;<br />
c) is excessively violent, incites violence, threatens violence, or contains harassing content or hate speech;<br /> 
d) is unfair or deceptive under the consumer protection laws of any jurisdiction, including chain letters and pyramid schemes;<br /> 
e) is defamatory or violates a person's privacy;<br /> 
f) creates a risk to a person's safety or health, creates a risk to public safety or health, compromises national security, or interferes with a investigation by law enforcement;<br />
g) improperly exposes trade secrets or other confidential or proprietary information of another person;<br /> 
h) is intended to assist others in defeating technical copyright protections;<br />
i) clearly infringes on another person's trade or service mark, patent, or other property right;<br />
j) promotes illegal drugs, violates export control laws, relates to illegal gambling, or illegal arms trafficking;<br />
k) is otherwise illegal or solicits conduct that is illegal under laws applicable to you or to " . $_LANG['prosper_setting_companyname'] . ";<br />
l) is otherwise malicious, fraudulent, or may result in retaliation against " . $_LANG['prosper_setting_companyname'] . " by offended viewers;</p>

<p>" . $_LANG['prosper_setting_companyname'] . " does not accept material such as:<br />
a) Proxy, Warez, Escrow, High Yield Investment Programs (HYIP), illegal Gambling and Lottery sites.<br />
b )Content 'published or transmitted' via " . $_LANG['prosper_setting_companyname'] . "'s service includes Web content, e-mail, bulletin board postings, chat, and any other type of posting or transmission that relies on any Internet service provided by " . $_LANG['prosper_setting_companyname'] . ".<br /> 
* " . $_LANG['prosper_setting_companyname'] . " can terminate service for any of the above reasons and it's at " . $_LANG['prosper_setting_companyname'] . "'s sole discretion to issue a refund</p>

<h2>Security</h2>

<p>You must take reasonable security precautions. You must protect the confidentiality of your password, and you should change your password periodically.</p>

<h2>Bulk Comercial Email</h2>

<p>Bulk commercial email, mailing lists and email reflectors are allowed on " . $_LANG['prosper_setting_companyname'] . "'s servers, we do however allow a maximum of 500 emails per hour per account. For any emails sent from your " . $_LANG['prosper_setting_companyname'] . " account you must adhere to the following rules:</p>

<p>a) Your intended recipients have given their consent to receive e-mail via some affirmative means, such as an opt-in procedure;<br />b) Your procedures for soliciting consent include reasonable means to ensure that the person giving consent is the owner of the e-mail address for which the consent is given;<br />c) You may not obscure the source of your e-mail in any manner.<br />
d) You otherwise comply with the CAN SPAM Act and other applicable law.</p>

<p>These policies apply to messages sent using your " . $_LANG['prosper_setting_companyname'] . " service, or to messages sent from any network by you or any person on your behalf that directly or indirectly refer the recipient to a site hosted via your " . $_LANG['prosper_setting_companyname'] . " service. In addition, you may not use a third party e-mail service that does not practice similar procedures for all its customers.</p>

<h2>Unsolicited E-Mail</h2>

<p>You may not send any unsolicited e-mail, either in bulk or individually, to any person who has indicated that they do not wish to receive it. You must comply with the rules of any other network you access or participate in using your " . $_LANG['prosper_setting_companyname'] . "'s services.</p>

<h2>Material Protected By Copyright</h2>

<p>You may not publish, distribute, or otherwise copy in any manner any music, software, art, or other work protected by copyright law unless:<br />
a) you have been expressly authorized by the owner of the copyright for the work to copy the work in that manner.<br />
b) you are otherwise permitted by established United States copyright law to copy the work in that manner.</p>

<p>" . $_LANG['prosper_setting_companyname'] . " will terminate the service of repeat copyright infringers.</p>

<h2>Other</h2>

<p>You must have valid and current information on file with your domain name registrar for any domain hosted on the " . $_LANG['prosper_setting_companyname'] . " network.</p>

<h2>Disclaimer</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " is under no duty, and does not by this AUP undertake a duty, to monitor or police our customers' activities and disclaims any responsibility for any misuse of the " . $_LANG['prosper_setting_companyname'] . " network.</p>

<h2>Internet Abuse</h2>

<p>You may not engage in illegal, abusive, or irresponsible behaviour, including:</p>

<p>a) Unauthorized access to or use of data, systems or networks, including any attempt to probe, scan or test the vulnerability of a system or network or to breach security or authentication measures (including those belonging to " . $_LANG['prosper_setting_companyname'] . " and its customers) without express authorization of the owner of the system or network;<br />
b) monitoring data or traffic on any network or system without the authorization of the owner of the system or network;<br />
c) Interference with service to any user, host or network including, without limitation, mail bombing, flooding, deliberate attempts to overload a system and broadcast attacks;<br />
d) Use of an Internet account or computer without the owner's authorization, including, but not limited to Internet scanning (tricking other people into releasing their passwords), password robbery, security hole scanning, and port scanning;<br />
e) Forging of any TCP-IP packet header or any part of the header information in an e-mail or a newsgroup posting; or<br />
f) Any conduct that is likely to result in retaliation against the " . $_LANG['prosper_setting_companyname'] . " network.<br />
g) Use of " . $_LANG['prosper_setting_companyname'] . "'s network in a way that unreasonably interferes with " . $_LANG['prosper_setting_companyname'] . "'s other customers use of the network</p>

<h2>Newsgroup, Chat Forums, Other Networks</h2>

<p>You must comply with the rules and conventions for postings to any bulletin board, chat group or other forum in which you participate, such as IRC and USENET groups including their rules for content and commercial postings. These groups usually prohibit the posting of off-topic commercial messages, or mass postings to multiple forums.</p>

";






/*
-----------------------------------------
---------   Privacy Policy page (File: privacy-policy.tpl, privacy-policy.php)   ---------
-----------------------------------------
*/

$_LANG['prosper_page_privacy_policy'] = "

<p>Your privacy is very important to us, below explains the information we collect from you, what we do with that information and our information security policy.</p>

<h2>Your Information</h2>

<p>When you sign up for any of our services we will ask you to provide contact information for your convenience as well as legal reasons. This will include name, home address, e-mail addresses and payment details (credit or debit card and PayPal). If you need support our staff may need to know information to solve the problem such as operating system, browser software and editing software. When you visit this website we do record certain information using Google Analytics such as your location, browser version, ip address, screen resolution, operating system and flash support. This is so we can continue to provide the most convenient web site for all our visitors. Our website is protected by a Secure Sockets Layer (SSL) and verified by Equifax. This helps prevent eavesdropping on our website, just look for the padlock.</p>

<h2>How Your Information Is Used</h2>

<p>We will use your personal identifiable information in the following ways.</p>

<p>- For payment purposes and to provide convenient and targeted support.<br />
- To contact you and announce special offers, general announcements and news. Please note you can opt out of receiving these emails at anytime by following the instructions at the bottom of the e-mail.<br />
- To improve our service and the marketing of our service. This could include using your demographic location to improve targeting of our website and customise your visit.</p>

<p>We will <strong>NEVER</strong> provide your personally identifiable information to any persons other than A law enforcement or regulatory agency at their request, third parties who provide services on our behalf such as payment processing, only if they agree not to miss use this information.</p>

<p><strong>We do not under any circumstances apart from the above give away or sell your information to any third parties.</strong></p>

<p>Your personal information is <strong>safe with us</strong>, your information is safely encrypted using SSI. Our service is not available to anyone under the age of 13, never will we intentionally maintain information about anyone under the age of 13.</p>

<h2>Cookies</h2>

<p>A cookie is a small text file that is stored on a users computer for record-keeping purposes. We use cookies on this site. We do not link the information we store in cookies to any personally identifiable information you submit while on our site. We use both session ID cookies and persistent cookies. We use session cookies to make it easier for you to navigate our site. A session ID cookie expires when you close you browser. A persistent cookie remains on your hard drive for an extended period of time much like the cookie used for our affiliate program. You can remove persistent cookies by following directions provided in your Internet browsers &#39;help&#39; file. We set a persistent cookie to store your passwords, so you do not have to enter it more than once. Persistent cookies also enable us to track and target the interests of our users to enhance the experience on our site. If you reject cookies, you may still use our site, but you will be asked to enter your username and password again every time you closed your browser or your session has timed out.</p>

<h2>Log Files</h2>

<p>As is true of most Web sites, we gather certain information automatically and store it in log files. This information includes Internet protocol (IP) addresses, browser type, internet service provider (ISP), referring/exit pages, operating system, date/time stamp, and clickstream data. We use this information, which does not identify individual users, to analyze trends, to administer the site, to track users movements around the site and to gather demographic information about our user base as a whole. We do not link this automatically-collected data to personally identifiable information. IP addresses are tied to personally identifiable information to prevent and block abusers to keep using our services such as members who violates our terms of service. We use a third-party tracking service that uses cookies and log files to track non-personally identifiable information about visitors to our site in the aggregate of usage and volume statistics to determine how our users navigate through our website and to know how many users are using our services demographically. We use the information you provide about yourself or others to complete the transaction for which it is intended. This may include administering a service such as registration, email, forum, etc., or contacting you if you have indicated your permission to do so by agreeing to accept further notification and service announcement from us on your member profile page. You can choose to opt-out from receiving any further notification from your member profile page. We do not share this information with outside parties.</p>

<h2>Surveys</h2>

<p>Upon using our free services, you may be requested to participate in our periodic internal surveys that are conducted by " . $_LANG['prosper_setting_companyname'] . " to determine your personal interests. These surveys are strictly voluntary. The data collected through these surveys will only be used to improve our products and services and will never be sold to any third parties.</p>

<h2>Communications From The Site</h2>

<p>When we receive email, we use return email addresses to reply with the information requested. Such addresses are not used for any other purpose and are not shared with outside parties. When supplying contact information to " . $_LANG['prosper_setting_companyname'] . " you can indicate your preference if you would like to be contacted to receive information and updates about our services by logging in to your " . $_LANG['prosper_setting_companyname'] . " account, going to your member profile page and choose not to receive any further notification emails from us or other information pertaining to " . $_LANG['prosper_setting_companyname'] . ". Information you submit to us will not be used for this purpose unless you indicate this as your preference. When supplying contact information to " . $_LANG['prosper_setting_companyname'] . " you can indicate your preference on your members profile page to participate in the " . $_LANG['prosper_setting_companyname'] . " newsletter. You will receive a confirmation email from us when placing an order on our site and paying through PayPal.</p>

<h2>Newsletter</h2>

<p>We provide you the opportunity to &#39;opt-in&#39; and &#39;opt-out&#39; of our newsletter at any time. Our newsletter is sent every month so it will certainly contain allot of useful information and any offers we may have. If you no longer wish to receive our newsletter and promotional communications, you may opt-out of receiving them at any time.</p>

<h2>Information Sharing and Disclosure</h2>

<p>We collect information from our website visitors using <a href=\"https://www.google.com/analytics/\" target=\"_blank\" rel=\"nofollow\">Google Analytics</a>. We use this information to better design our Web site and services. This information is never shared with any third party. We do not link aggregate user data with personally identifiable information.</p>

<h2>Personally Identifiable Information</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " does not share, sell, rent, or trade personally identifiable information with third parties. We never use or share the personally identifiable information provided to us online in ways unrelated to the ones described within this privacy policy without also providing you an opportunity to opt-out or otherwise prohibit such unrelated uses.</p>

<h2>How You Can Access /Correct Your Information</h2>

<p>You can access all your personally identifiable information that we collect by logging into your password-protected " . $_LANG['prosper_setting_companyname'] . " account and selecting to update your &#39;My Details&#39; We use this procedure to better safeguard your information. You can also correct factual errors in your personally identifiable information by sending us a request that credibly shows error. To protect your privacy and security, we will also take reasonable steps to verify your identity before granting access or making corrections.</p>

<h2>Specific Terms and Conditions</h2>

<p>" . $_LANG['prosper_setting_companyname'] . " considers email transmitted via our service to be the private correspondence between the sender and recipient. We will not monitor, edit or disclose the contents of a user`s private communications, except as required by law, to comply with legal process, if necessary to enforce the Service Agreement, to respond to claims that such contents violate the rights of third-parties, or to protect the rights or property of " . $_LANG['prosper_setting_companyname'] . ". By using the service you agree that technical processing of email communications is and may be required to send and receive messages, to conform to the technical requirements of connecting networks, to conform to the limitations of the Service, or to conform to other, similar technical requirements. By using the service you acknowledge and agree that " . $_LANG['prosper_setting_companyname'] . " do not endorse the content of any user communications and are not responsible or liable for any unlawful, harassing, libellous, privacy invading, abusive, threatening, harmful, vulgar, obscene, tortuous, or otherwise objectionable content, or content that infringes or may infringe the intellectual property or other rights of another.</p>

<h2>Legal Disclaimer</h2>

<p>We reserve the right to disclose your personally identifiable information as required by law and when we believe that disclosure is necessary to protect our rights and/or to comply with a judicial proceeding, court order, or legal process served on our Web site.</p>

<h2>Security</h2>

<p>The security of your personal information is important to us. We follow generally accepted industry standards to protect the personal information submitted to us, both during transmission and once we receive it. No method of transmission over the Internet, or method of electronic storage, is 100% secure, however we have taken every step possible to make your information safe. This website is protected by Secure Sockets Layer (SSL) to protect your information. Therefore, while we strive to use commercially acceptable means to protect your personal information, we cannot guarantee its absolute security.</p>

<h2>Links To Other Sites</h2>

<p>This Web site contains links to other sites that are not owned or controlled by " . $_LANG['prosper_setting_companyname'] . ". Please be aware that we, " . $_LANG['prosper_setting_companyname'] . " are not responsible for the privacy practices of such other sites. We encourage you to be aware when you leave our site and to read the privacy statements of each and every Web site that collects personally identifiable information. This privacy statement applies only to information collected by this Web site.</p>

<h2>Changes To This Privacy Statement</h2>

<p>If we decide to change our privacy policy, we will post those changes to this privacy statement, the home page, and other places we deem appropriate so that you are aware of what information we collect, how we use it, and under what circumstances, if any, we disclose it. We reserve the right to modify this privacy statement at any time, so please review it frequently. If we make material changes to this policy, we will notify you here, by email, or by means of a notice on our home page. For more information please do not hesitate to send your questions via our <a href=\"contact.php\">Contact Form</a>.</p>

";






/*
-----------------------------------------
---------   Addons   ---------
-----------------------------------------
*/

// Global

$_LANG['prosper_addons_onetime'] = "one time";

$_LANG['prosper_addons_button1_text'] = "Learn More";
$_LANG['prosper_addons_button1_icon'] = "fas fa-info-circle";

$_LANG['prosper_addons_button2_text'] = "View Demo";
$_LANG['prosper_addons_button2_icon'] = "fas fa-search";

$_LANG['prosper_addons_button3_text'] = "Order Now";
$_LANG['prosper_addons_button3_icon'] = "fas fa-shopping-cart";

// Addons (addons.tpl, addons.php)

// WHMCS Templates

$_LANG['prosper_addons_whmcstemplates_box_image'] = $_LANG['prosper_whmcstemplates_icon'];
$_LANG['prosper_addons_whmcstemplates_box_image_alt'] = "WHMCS Templates";
$_LANG['prosper_addons_whmcstemplates_box_desc'] = "<p>These WHMCS Templates are a complete solution for your web hosting business. They come with all of the functionality and content required for a successful hosting company.</p>";

// WordPress Themes

$_LANG['prosper_addons_wordpressthemes_box_image'] = $_LANG['prosper_wordpressthemes_icon'];
$_LANG['prosper_addons_wordpressthemes_box_image_alt'] = "WordPress Themes";
$_LANG['prosper_addons_wordpressthemes_box_desc'] = "<p>Our Wordpress Themes are feature-rich and perfect for any type of online business. They allow you to customise every aspect of your website without HTML experience.</p>";

// HTML Templates

$_LANG['prosper_addons_htmltemplates_box_image'] = $_LANG['prosper_htmltemplates_icon'];
$_LANG['prosper_addons_htmltemplates_box_image_alt'] = "HTML Templates";
$_LANG['prosper_addons_htmltemplates_box_desc'] = "<p>Our exclusive HTML Templates are lightning-fast, easy to edit and fully responsive. They also support multiple software integrations including WHMCS, Blesta & WISECP.</p>";

// Blesta Templates

$_LANG['prosper_addons_blestatemplates_box_image'] = $_LANG['prosper_blestatemplates_icon'];
$_LANG['prosper_addons_blestatemplates_box_image_alt'] = "Blesta Templates";
$_LANG['prosper_addons_blestatemplates_box_desc'] = "<p>Our Blesta Templates consist of a fully customisable HTML/PHP template for the main website and a pixel perfect Blesta integration.</p>";

// Clientexec Templates

$_LANG['prosper_addons_clientexectemplates_box_image'] = $_LANG['prosper_clientexectemplates_icon'];
$_LANG['prosper_addons_clientexectemplates_box_image_alt'] = "Clientexec Templates";
$_LANG['prosper_addons_clientexectemplates_box_desc'] = "<p>Our Clientexec Templates consist of a fully customisable HTML/PHP template for the main website and a pixel perfect Clientexec integration.</p>";

// WISECP Templates

$_LANG['prosper_addons_wisecptemplates_box_image'] = $_LANG['prosper_wisecptemplates_icon'];
$_LANG['prosper_addons_wisecptemplates_box_image_alt'] = "WISECP Templates";
$_LANG['prosper_addons_wisecptemplates_box_desc'] = "<p>Our WISECP Templates consist of a fully customisable HTML/PHP template for the main website and a pixel perfect WISECP integration.</p>";

// HostBill Templates

$_LANG['prosper_addons_hostbilltemplates_box_image'] = $_LANG['prosper_hostbilltemplates_icon'];
$_LANG['prosper_addons_hostbilltemplates_box_image_alt'] = "HostBill Templates";
$_LANG['prosper_addons_hostbilltemplates_box_desc'] = "<p>Our HostBill Templates consist of a fully customisable HTML/PHP template for the main website and a pixel perfect HostBill integration.</p>";

// WHMCS Modules

$_LANG['prosper_addons_whmcsmodules_box_image'] = $_LANG['prosper_whmcsmodules_icon'];
$_LANG['prosper_addons_whmcsmodules_box_image_alt'] = "WHMCS Modules";
$_LANG['prosper_addons_whmcsmodules_box_desc'] = "<p>A collection of exclusive & easy to customize WHMCS Modules. These modules provide instant functionality to your WHMCS based website.</p>";

// Scripts

$_LANG['prosper_addons_scripts_box_image'] = $_LANG['prosper_scripts_icon'];
$_LANG['prosper_addons_scripts_box_image_alt'] = "Scripts";
$_LANG['prosper_addons_scripts_box_desc'] = "<p>Originally created for our own website we've made all of our custom Scripts available to purchase. You'll find menus, feature boxes & other useful scripts.</p>";

// Logo Design

$_LANG['prosper_addons_logodesign_box_image'] = $_LANG['prosper_logodesign_icon'];
$_LANG['prosper_addons_logodesign_box_image_alt'] = "Logo Design";
$_LANG['prosper_addons_logodesign_box_desc'] = "<p>Get your business up and running with a custom Logo Design. All of our vector logos are designed from scratch based on your requirements.</p>";

// Banner Design

$_LANG['prosper_addons_bannerdesign_box_image'] = $_LANG['prosper_bannerdesign_icon'];
$_LANG['prosper_addons_bannerdesign_box_image_alt'] = "Banner Design";
$_LANG['prosper_addons_bannerdesign_box_desc'] = "<p>We develop banners from scratch based on your requirements. Our banners are suitable for advertising campaigns and useful for your affiliate program.</p>";

// WHMCS Services

$_LANG['prosper_addons_whmcsservices_box_image'] = $_LANG['prosper_whmcsservices_icon'];
$_LANG['prosper_addons_whmcsservices_box_image_alt'] = "WHMCS Services";
$_LANG['prosper_addons_whmcsservices_box_desc'] = "<p>We have a lot of experience working with WHMCS. Our WHMCS Services consist of installation, configuration, integration, security & automation.</p>";

// WordPress Services

$_LANG['prosper_addons_wordpressservices_box_image'] = $_LANG['prosper_wordpressservices_icon'];
$_LANG['prosper_addons_wordpressservices_box_image_alt'] = "WordPress Services";
$_LANG['prosper_addons_wordpressservices_box_desc'] = "<p>We provide a selection of WordPress Services to help get your website up and running. Services include installation, configuration & integration.</p>";

// Blesta Services

$_LANG['prosper_addons_blestaservices_box_image'] = $_LANG['prosper_blestaservices_icon'];
$_LANG['prosper_addons_blestaservices_box_image_alt'] = "Blesta Services";
$_LANG['prosper_addons_blestaservices_box_desc'] = "<p>Premium Blesta Services including installation, configuration, security & integration. Browse our services today or request a custom service.</p>";

// Clientexec Services

$_LANG['prosper_addons_clientexecservices_box_image'] = $_LANG['prosper_clientexecservices_icon'];
$_LANG['prosper_addons_clientexecservices_box_image_alt'] = "Clientexec Services";
$_LANG['prosper_addons_clientexecservices_box_desc'] = "<p>We have vast experience of providing Clientexec Services including installation, configuration & integration. Browse our services today to get started.</p>";

// WHMCS Templates (whmcs-templates.tpl, whmcs-templates.php)

// Submenu

$_LANG['prosper_whmcstemplates_submenu_display'] = true;

$_LANG['prosper_whmcstemplates_submenu_1_display'] = true;
$_LANG['prosper_whmcstemplates_submenu_1_text'] = "Overview";
$_LANG['prosper_whmcstemplates_submenu_1_url'] = "#overview";
$_LANG['prosper_whmcstemplates_submenu_1_url_newwindow'] = false;

$_LANG['prosper_whmcstemplates_submenu_2_display'] = true;
$_LANG['prosper_whmcstemplates_submenu_2_text'] = "Templates";
$_LANG['prosper_whmcstemplates_submenu_2_url'] = "#templates";
$_LANG['prosper_whmcstemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_whmcstemplates_overview_display'] = true;

$_LANG['prosper_addons_whmcstemplates_overview'] = "<p>These WHMCS Templates are a complete solution for your web hosting reseller business. They come with a large selection of features that allow you to get your online business up and running quickly with a highly professional look and functioning website. You do not need any HTML experience to launch your business using these templates thanks to the built-in admin based settings area (Wizard Panel) and our support documentation.</p>";

// Templates

$_LANG['prosper_addons_whmcstemplates_heading'] = "Templates";

// WordPress Themes (wordpress-themes.tpl, wordpress-themes.php)

// Submenu

$_LANG['prosper_wordpressthemes_submenu_display'] = true;

$_LANG['prosper_wordpressthemes_submenu_1_display'] = true;
$_LANG['prosper_wordpressthemes_submenu_1_text'] = "Overview";
$_LANG['prosper_wordpressthemes_submenu_1_url'] = "#overview";
$_LANG['prosper_wordpressthemes_submenu_1_url_newwindow'] = false;

$_LANG['prosper_wordpressthemes_submenu_2_display'] = true;
$_LANG['prosper_wordpressthemes_submenu_2_text'] = "Themes";
$_LANG['prosper_wordpressthemes_submenu_2_url'] = "#themes";
$_LANG['prosper_wordpressthemes_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_wordpressthemes_overview_display'] = true;

$_LANG['prosper_addons_wordpressthemes_overview'] = "<p>These WordPress Themes allow you to launch your very own web hosting reseller business using the power of WordPress (no experience required). They feature a built-in options panel, admin-based menus, widgets, blog support & an optional automatic WHMCS synchronisation template ($50).</p>";

// Themes

$_LANG['prosper_addons_wordpressthemes_heading'] = "Themes";

// HTML Templates (html-templates.tpl, html-templates.php)

// Submenu

$_LANG['prosper_htmltemplates_submenu_display'] = true;

$_LANG['prosper_htmltemplates_submenu_1_display'] = true;
$_LANG['prosper_htmltemplates_submenu_1_text'] = "Overview";
$_LANG['prosper_htmltemplates_submenu_1_url'] = "#overview";
$_LANG['prosper_htmltemplates_submenu_1_url_newwindow'] = false;

$_LANG['prosper_htmltemplates_submenu_2_display'] = true;
$_LANG['prosper_htmltemplates_submenu_2_text'] = "Templates";
$_LANG['prosper_htmltemplates_submenu_2_url'] = "#templates";
$_LANG['prosper_htmltemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_htmltemplates_overview_display'] = true;

$_LANG['prosper_addons_htmltemplates_overview'] = "<p>These HTML Templates come packed with many features, are highly optimized and lightning fast. They use a PHP format to allow easy editing and the ability to support unlimited customizations. Our HTML Templates also support optional software consisting of an integration template that will match the design/content of your HTML Template. The supported software includes WHMCS, Blesta, Clientexec, WISECP & HostBill ($30/year).</p>";

// Templates

$_LANG['prosper_addons_htmltemplates_heading'] = "Templates";

// Blesta Templates (blesta-templates.tpl, blesta-templates.php)

// Submenu

$_LANG['prosper_blestatemplates_submenu_display'] = true;

$_LANG['prosper_blestatemplates_submenu_1_display'] = true;
$_LANG['prosper_blestatemplates_submenu_1_text'] = "Overview";
$_LANG['prosper_blestatemplates_submenu_1_url'] = "#overview";
$_LANG['prosper_blestatemplates_submenu_1_url_newwindow'] = false;

$_LANG['prosper_blestatemplates_submenu_2_display'] = true;
$_LANG['prosper_blestatemplates_submenu_2_text'] = "Templates";
$_LANG['prosper_blestatemplates_submenu_2_url'] = "#templates";
$_LANG['prosper_blestatemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_blestatemplates_overview_display'] = true;

$_LANG['prosper_addons_blestatemplates_overview'] = "<p>These Blesta Templates are designed to launch your very own web hosting reseller business. The templates are lighting fast, easy to edit with HTML experience and come with reliable support. Each template comes with a optional Blesta integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['prosper_addons_blestatemplates_heading'] = "Templates";

// Clientexec Templates (clientexec-templates.tpl, clientexec-templates.php)

// Submenu

$_LANG['prosper_clientexectemplates_submenu_display'] = true;

$_LANG['prosper_clientexectemplates_submenu_1_display'] = true;
$_LANG['prosper_clientexectemplates_submenu_1_text'] = "Overview";
$_LANG['prosper_clientexectemplates_submenu_1_url'] = "#overview";
$_LANG['prosper_clientexectemplates_submenu_1_url_newwindow'] = false;

$_LANG['prosper_clientexectemplates_submenu_2_display'] = true;
$_LANG['prosper_clientexectemplates_submenu_2_text'] = "Templates";
$_LANG['prosper_clientexectemplates_submenu_2_url'] = "#templates";
$_LANG['prosper_clientexectemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_clientexectemplates_overview_display'] = true;

$_LANG['prosper_addons_clientexectemplates_overview'] = "<p>These Clientexec Templates are designed to launch your very own web hosting reseller business. The templates are lighting fast, easy to edit with HTML experience and come with reliable support. Each template comes with a optional Clientexec integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['prosper_addons_clientexectemplates_heading'] = "Templates";

// WISECP Templates (wisecp-templates.tpl, wisecp-templates.php)

// Submenu

$_LANG['prosper_wisecptemplates_submenu_display'] = true;

$_LANG['prosper_wisecptemplates_submenu_1_display'] = true;
$_LANG['prosper_wisecptemplates_submenu_1_text'] = "Overview";
$_LANG['prosper_wisecptemplates_submenu_1_url'] = "#overview";
$_LANG['prosper_wisecptemplates_submenu_1_url_newwindow'] = false;

$_LANG['prosper_wisecptemplates_submenu_2_display'] = true;
$_LANG['prosper_wisecptemplates_submenu_2_text'] = "Templates";
$_LANG['prosper_wisecptemplates_submenu_2_url'] = "#templates";
$_LANG['prosper_wisecptemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_wisecptemplates_overview_display'] = true;

$_LANG['prosper_addons_wisecptemplates_overview'] = "<p>These WISECP Templates are designed to launch your very own web hosting reseller business. The templates are lighting fast, easy to edit with HTML experience and come with reliable support. Each template comes with a optional WISECP integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['prosper_addons_wisecptemplates_heading'] = "Templates";

// hostbill Templates (hostbill-templates.tpl, hostbill-templates.php)

// Submenu

$_LANG['prosper_hostbilltemplates_submenu_display'] = true;

$_LANG['prosper_hostbilltemplates_submenu_1_display'] = true;
$_LANG['prosper_hostbilltemplates_submenu_1_text'] = "Overview";
$_LANG['prosper_hostbilltemplates_submenu_1_url'] = "#overview";
$_LANG['prosper_hostbilltemplates_submenu_1_url_newwindow'] = false;

$_LANG['prosper_hostbilltemplates_submenu_2_display'] = true;
$_LANG['prosper_hostbilltemplates_submenu_2_text'] = "Templates";
$_LANG['prosper_hostbilltemplates_submenu_2_url'] = "#templates";
$_LANG['prosper_hostbilltemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_hostbilltemplates_overview_display'] = true;

$_LANG['prosper_addons_hostbilltemplates_overview'] = "<p>These HostBill Templates are designed to launch your very own web hosting reseller business. The templates are lighting fast, easy to edit with HTML experience and come with reliable support. Each template comes with a optional HostBill integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['prosper_addons_hostbilltemplates_heading'] = "Templates";

// WHMCS Modules (whmcs-modules.tpl, whmcs-modules.php)

// Submenu

$_LANG['prosper_whmcsmodules_submenu_display'] = true;

$_LANG['prosper_whmcsmodules_submenu_1_display'] = true;
$_LANG['prosper_whmcsmodules_submenu_1_text'] = "Overview";
$_LANG['prosper_whmcsmodules_submenu_1_url'] = "#overview";
$_LANG['prosper_whmcsmodules_submenu_1_url_newwindow'] = false;

$_LANG['prosper_whmcsmodules_submenu_2_display'] = true;
$_LANG['prosper_whmcsmodules_submenu_2_text'] = "Modules";
$_LANG['prosper_whmcsmodules_submenu_2_url'] = "#modules";
$_LANG['prosper_whmcsmodules_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_whmcsmodules_overview_display'] = true;

$_LANG['prosper_addons_whmcsmodules_overview'] = "<p>These WHMCS Modules are easy to install and add instant functionality to your WHMCS based website.</p>";

// Modules

$_LANG['prosper_addons_whmcsmodules_heading'] = "Modules";

// Scripts (scripts.tpl, scripts.php)

// Submenu

$_LANG['prosper_scripts_submenu_display'] = true;

$_LANG['prosper_scripts_submenu_1_display'] = true;
$_LANG['prosper_scripts_submenu_1_text'] = "Overview";
$_LANG['prosper_scripts_submenu_1_url'] = "#overview";
$_LANG['prosper_scripts_submenu_1_url_newwindow'] = false;

$_LANG['prosper_scripts_submenu_2_display'] = true;
$_LANG['prosper_scripts_submenu_2_text'] = "Scripts";
$_LANG['prosper_scripts_submenu_2_url'] = "#scripts";
$_LANG['prosper_scripts_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_scripts_overview_display'] = true;

$_LANG['prosper_addons_scripts_overview'] = "<p>These Scripts were originally developed for our own website but have now decided to make them publicly available. They will enhance your website functionality and design.</p>";

// Scripts

$_LANG['prosper_addons_scripts_heading'] = "Scripts";

// Logo Design (logo-design.tpl, logo-design.php)

// Submenu

$_LANG['prosper_logodesign_submenu_display'] = true;

$_LANG['prosper_logodesign_submenu_1_display'] = true;
$_LANG['prosper_logodesign_submenu_1_text'] = "Overview";
$_LANG['prosper_logodesign_submenu_1_url'] = "#overview";
$_LANG['prosper_logodesign_submenu_1_url_newwindow'] = false;

$_LANG['prosper_logodesign_submenu_2_display'] = true;
$_LANG['prosper_logodesign_submenu_2_text'] = "Features";
$_LANG['prosper_logodesign_submenu_2_url'] = "#features";
$_LANG['prosper_logodesign_submenu_2_url_newwindow'] = false;

$_LANG['prosper_logodesign_submenu_3_display'] = true;
$_LANG['prosper_logodesign_submenu_3_text'] = "Past Work";
$_LANG['prosper_logodesign_submenu_3_url'] = "#pastwork";
$_LANG['prosper_logodesign_submenu_3_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_logodesign_overview_display'] = true;

$_LANG['prosper_logodesign_overview_display'] = true;

$_LANG['prosper_logodesign_overview'] = "

<p>Get your business up and running with a custom Logo Design. All of our logos are designed from scratch based on your requirements.</p>

<p>Our logo design service is completed within 5 days, from concept to the finished logo.</p>

";

// Banner

$_LANG['prosper_logodesign_banner_display'] = true;
$_LANG['prosper_logodesign_banner_heading'] = $_LANG['prosper_logodesign_name'];
$_LANG['prosper_logodesign_banner_text'] = "We design stunning custom vector logos that are unique to you and your business. All logos we design come in vector and raster format meaning you will be able to use your finished logo in any type of advertising.";
$_LANG['prosper_logodesign_banner_feat1'] = "Unique Design";
$_LANG['prosper_logodesign_banner_feat2'] = "Vector Files";
$_LANG['prosper_logodesign_banner_feat3'] = "";
$_LANG['prosper_logodesign_banner_feat4'] = "";
$_LANG['prosper_logodesign_banner_feat5'] = "";
$_LANG['prosper_logodesign_banner_feat6'] = "";
$_LANG['prosper_logodesign_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_logodesign_banner_background'] = "background4.jpg";
$_LANG['prosper_logodesign_banner_background_opacity'] = 0.6;
$_LANG['prosper_logodesign_banner_price_before'] = "Just";
$_LANG['prosper_logodesign_banner_price'] = "150";
$_LANG['prosper_logodesign_banner_price_term'] = "/logo";
$_LANG['prosper_logodesign_banner_image'] = "logodesign1.png";
$_LANG['prosper_logodesign_banner_image_small'] = "logodesign1-small.png";
$_LANG['prosper_logodesign_banner_image_alt'] = "Logo Design";
$_LANG['prosper_logodesign_banner_image_url'] = "#pastwork";
$_LANG['prosper_logodesign_banner_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_banner_image_screenshot'] = false;
$_LANG['prosper_logodesign_banner_image_video'] = false;
$_LANG['prosper_logodesign_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_logodesign_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_logodesign_banner_button1_text'] = "Learn More";
$_LANG['prosper_logodesign_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_logodesign_banner_button1_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['prosper_logodesign_banner_button1_url_newwindow'] = false;
$_LANG['prosper_logodesign_banner_button2_text'] = "Order Now";
$_LANG['prosper_logodesign_banner_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_logodesign_banner_button2_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['prosper_logodesign_banner_button2_url_newwindow'] = false;

// Features

$_LANG['prosper_logodesign_features_display'] = true;

$_LANG['prosper_logodesign_features_heading'] = "Features";

// Feature 1

$_LANG['prosper_logodesign_features_1_display'] = true;
$_LANG['prosper_logodesign_features_1_displayorder'] = 0;
$_LANG['prosper_logodesign_features_1_heading'] = "Custom Design";
$_LANG['prosper_logodesign_features_1_image'] = "logodesign-features-1.png";
$_LANG['prosper_logodesign_features_1_image_alt'] = "custom design";
$_LANG['prosper_logodesign_features_1_image_url'] = "";
$_LANG['prosper_logodesign_features_1_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_1_text'] = "<p>Every logo we design is completely custom to you and your business. The design is based on your requirements, our research of your business and competition & the goals of your business.</p>";
$_LANG['prosper_logodesign_features_1_button1_text'] = "";
$_LANG['prosper_logodesign_features_1_button1_icon'] = "";
$_LANG['prosper_logodesign_features_1_button1_url'] = "";
$_LANG['prosper_logodesign_features_1_button1_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_1_button2_text'] = "";
$_LANG['prosper_logodesign_features_1_button2_icon'] = "";
$_LANG['prosper_logodesign_features_1_button2_url'] = "";
$_LANG['prosper_logodesign_features_1_button2_url_newwindow'] = false;

// Feature 2

$_LANG['prosper_logodesign_features_2_display'] = true;
$_LANG['prosper_logodesign_features_2_displayorder'] = 0;
$_LANG['prosper_logodesign_features_2_heading'] = "Unlimited Revisions";
$_LANG['prosper_logodesign_features_2_image'] = "logodesign-features-2.png";
$_LANG['prosper_logodesign_features_2_image_alt'] = "unlimited revisions";
$_LANG['prosper_logodesign_features_2_image_url'] = "";
$_LANG['prosper_logodesign_features_2_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_2_text'] = "<p>You can request unlimited revisions once the initial logo design is provided ensuring that the end result is a perfect logo for your business that meets your requirements.</p>";
$_LANG['prosper_logodesign_features_2_button1_text'] = "";
$_LANG['prosper_logodesign_features_2_button1_icon'] = "";
$_LANG['prosper_logodesign_features_2_button1_url'] = "";
$_LANG['prosper_logodesign_features_2_button1_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_2_button2_text'] = "";
$_LANG['prosper_logodesign_features_2_button2_icon'] = "";
$_LANG['prosper_logodesign_features_2_button2_url'] = "";
$_LANG['prosper_logodesign_features_2_button2_url_newwindow'] = false;

// Feature 3

$_LANG['prosper_logodesign_features_3_display'] = true;
$_LANG['prosper_logodesign_features_3_displayorder'] = 0;
$_LANG['prosper_logodesign_features_3_heading'] = "Full Copyright Owned By You";
$_LANG['prosper_logodesign_features_3_image'] = "logodesign-features-3.png";
$_LANG['prosper_logodesign_features_3_image_alt'] = "full copyright";
$_LANG['prosper_logodesign_features_3_image_url'] = "";
$_LANG['prosper_logodesign_features_3_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_3_text'] = "<p>The logo we design will be completely custom to you and your business. We also include exclusive and full copyright rights to you as part of our logo design service.</p>";
$_LANG['prosper_logodesign_features_3_button1_text'] = "";
$_LANG['prosper_logodesign_features_3_button1_icon'] = "";
$_LANG['prosper_logodesign_features_3_button1_url'] = "";
$_LANG['prosper_logodesign_features_3_button1_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_3_button2_text'] = "";
$_LANG['prosper_logodesign_features_3_button2_icon'] = "";
$_LANG['prosper_logodesign_features_3_button2_url'] = "";
$_LANG['prosper_logodesign_features_3_button2_url_newwindow'] = false;

// Feature 4

$_LANG['prosper_logodesign_features_4_display'] = true;
$_LANG['prosper_logodesign_features_4_displayorder'] = 0;
$_LANG['prosper_logodesign_features_4_heading'] = "All File Formats Provided";
$_LANG['prosper_logodesign_features_4_image'] = "logodesign-features-4.png";
$_LANG['prosper_logodesign_features_4_image_alt'] = "file formats";
$_LANG['prosper_logodesign_features_4_image_url'] = "";
$_LANG['prosper_logodesign_features_4_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_4_text'] = "<p>We can provide your finished logo design in any file format you need. By default we will provide the .ai, .eps (vector - perfect for print), .jpg, .png (perfect for the web) file formats.</p>";
$_LANG['prosper_logodesign_features_4_button1_text'] = "";
$_LANG['prosper_logodesign_features_4_button1_icon'] = "";
$_LANG['prosper_logodesign_features_4_button1_url'] = "";
$_LANG['prosper_logodesign_features_4_button1_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_4_button2_text'] = "";
$_LANG['prosper_logodesign_features_4_button2_icon'] = "";
$_LANG['prosper_logodesign_features_4_button2_url'] = "";
$_LANG['prosper_logodesign_features_4_button2_url_newwindow'] = false;

// Feature 5

$_LANG['prosper_logodesign_features_5_display'] = true;
$_LANG['prosper_logodesign_features_5_displayorder'] = 0;
$_LANG['prosper_logodesign_features_5_heading'] = "Out Of The Box Service";
$_LANG['prosper_logodesign_features_5_image'] = "logodesign-features-5.png";
$_LANG['prosper_logodesign_features_5_image_alt'] = "out of the box service";
$_LANG['prosper_logodesign_features_5_image_url'] = "";
$_LANG['prosper_logodesign_features_5_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_5_text'] = "<p>Our Logo Design service is the perfect solution for new businesses looking for a high quality logo that is professional, effective and custom at an affordable price.</p>";
$_LANG['prosper_logodesign_features_5_button1_text'] = "";
$_LANG['prosper_logodesign_features_5_button1_icon'] = "";
$_LANG['prosper_logodesign_features_5_button1_url'] = "";
$_LANG['prosper_logodesign_features_5_button1_url_newwindow'] = false;
$_LANG['prosper_logodesign_features_5_button2_text'] = "";
$_LANG['prosper_logodesign_features_5_button2_icon'] = "";
$_LANG['prosper_logodesign_features_5_button2_url'] = "";
$_LANG['prosper_logodesign_features_5_button2_url_newwindow'] = false;

// Past Work

$_LANG['prosper_logodesign_pastwork_display'] = true;

$_LANG['prosper_logodesign_pastwork_heading'] = "Past Work";

// Past Work 1

$_LANG['prosper_logodesign_pastwork_1_display'] = true;
$_LANG['prosper_logodesign_pastwork_1_displayorder'] = 0;
$_LANG['prosper_logodesign_pastwork_1_image'] = "logodesign-pastwork-1.png";
$_LANG['prosper_logodesign_pastwork_1_image_alt'] = "logo design 1";
$_LANG['prosper_logodesign_pastwork_1_image_url'] = "logodesign-pastwork-1.png";
$_LANG['prosper_logodesign_pastwork_1_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_pastwork_1_image_url_popup'] = true;

// Past Work 2

$_LANG['prosper_logodesign_pastwork_2_display'] = true;
$_LANG['prosper_logodesign_pastwork_2_displayorder'] = 0;
$_LANG['prosper_logodesign_pastwork_2_image'] = "logodesign-pastwork-2.png";
$_LANG['prosper_logodesign_pastwork_2_image_alt'] = "logo design 2";
$_LANG['prosper_logodesign_pastwork_2_image_url'] = "logodesign-pastwork-2.png";
$_LANG['prosper_logodesign_pastwork_2_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_pastwork_2_image_url_popup'] = true;

// Past Work 3

$_LANG['prosper_logodesign_pastwork_3_display'] = true;
$_LANG['prosper_logodesign_pastwork_3_displayorder'] = 0;
$_LANG['prosper_logodesign_pastwork_3_image'] = "logodesign-pastwork-3.png";
$_LANG['prosper_logodesign_pastwork_3_image_alt'] = "logo design 3";
$_LANG['prosper_logodesign_pastwork_3_image_url'] = "logodesign-pastwork-3.png";
$_LANG['prosper_logodesign_pastwork_3_image_url_newwindow'] = false;
$_LANG['prosper_logodesign_pastwork_3_image_url_popup'] = true;

// CTA

$_LANG['prosper_logodesign_cta_display'] = true;
$_LANG['prosper_logodesign_cta_text'] = "Ready To Get Started?";
$_LANG['prosper_logodesign_cta_button_text'] = "Order Now";
$_LANG['prosper_logodesign_cta_button_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_logodesign_cta_button_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['prosper_logodesign_cta_button_url_newwindow'] = false;

// Banner Design (banner-design.tpl, banner-design.php)

$_LANG['prosper_addons_bannerdesign_text'] = "<p>We design banners of all sizes for any type of business! We take great care when creating your custom banners to ensure they are help achieve your goal whether that's increased sales or any other goal using enhanced call-to-actions.</p>";

// Submenu

$_LANG['prosper_bannerdesign_submenu_display'] = true;

$_LANG['prosper_bannerdesign_submenu_1_display'] = true;
$_LANG['prosper_bannerdesign_submenu_1_text'] = "Overview";
$_LANG['prosper_bannerdesign_submenu_1_url'] = "#overview";
$_LANG['prosper_bannerdesign_submenu_1_url_newwindow'] = false;

$_LANG['prosper_bannerdesign_submenu_2_display'] = true;
$_LANG['prosper_bannerdesign_submenu_2_text'] = "Features";
$_LANG['prosper_bannerdesign_submenu_2_url'] = "#features";
$_LANG['prosper_bannerdesign_submenu_2_url_newwindow'] = false;

$_LANG['prosper_bannerdesign_submenu_3_display'] = true;
$_LANG['prosper_bannerdesign_submenu_3_text'] = "Past Work";
$_LANG['prosper_bannerdesign_submenu_3_url'] = "#pastwork";
$_LANG['prosper_bannerdesign_submenu_3_url_newwindow'] = false;

// Overview

$_LANG['prosper_bannerdesign_overview_display'] = true;

$_LANG['prosper_bannerdesign_overview'] = "

<p>We develop banners from scratch based on your requirements. Our banners are suitable for advertising campaigns and useful for your affiliate program.</p>
	
<p>Our banner design service is completed within 5 days, from concept to the finished banner.</p>

";

// Banner

$_LANG['prosper_bannerdesign_banner_display'] = true;
$_LANG['prosper_bannerdesign_banner_heading'] = $_LANG['prosper_bannerdesign_name'];
$_LANG['prosper_bannerdesign_banner_text'] = "We design banners of all sizes! We take great care when creating your custom banners to ensure they are help achieve your goal whether that's increased sales or any other goal using enhanced call-to-actions.";
$_LANG['prosper_bannerdesign_banner_feat1'] = "Unique Design";
$_LANG['prosper_bannerdesign_banner_feat2'] = "Any Size";
$_LANG['prosper_bannerdesign_banner_feat3'] = "";
$_LANG['prosper_bannerdesign_banner_feat4'] = "";
$_LANG['prosper_bannerdesign_banner_feat5'] = "";
$_LANG['prosper_bannerdesign_banner_feat6'] = "";
$_LANG['prosper_bannerdesign_banner_feat_icon'] = "fas fa-check-square";
$_LANG['prosper_bannerdesign_banner_background'] = "background4.jpg";
$_LANG['prosper_bannerdesign_banner_background_opacity'] = 0.6;
$_LANG['prosper_bannerdesign_banner_price_before'] = "Just";
$_LANG['prosper_bannerdesign_banner_price'] = "30";
$_LANG['prosper_bannerdesign_banner_price_term'] = "/banner";
$_LANG['prosper_bannerdesign_banner_image'] = "bannerdesign1.png";
$_LANG['prosper_bannerdesign_banner_image_small'] = "bannerdesign1-small.png";
$_LANG['prosper_bannerdesign_banner_image_alt'] = "Banner Design";
$_LANG['prosper_bannerdesign_banner_image_url'] = "#pastwork";
$_LANG['prosper_bannerdesign_banner_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_banner_image_screenshot'] = false;
$_LANG['prosper_bannerdesign_banner_image_video'] = false;
$_LANG['prosper_bannerdesign_banner_image_video_badge'] = "Watch Video";
$_LANG['prosper_bannerdesign_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['prosper_bannerdesign_banner_button1_text'] = "Learn More";
$_LANG['prosper_bannerdesign_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['prosper_bannerdesign_banner_button1_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['prosper_bannerdesign_banner_button1_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_banner_button2_text'] = "Order Now";
$_LANG['prosper_bannerdesign_banner_button2_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_bannerdesign_banner_button2_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['prosper_bannerdesign_banner_button2_url_newwindow'] = false;

// Features

$_LANG['prosper_bannerdesign_features_display'] = true;

$_LANG['prosper_bannerdesign_features_heading'] = "Features";

// Feature 1

$_LANG['prosper_bannerdesign_features_1_display'] = true;
$_LANG['prosper_bannerdesign_features_1_displayorder'] = 0;
$_LANG['prosper_bannerdesign_features_1_heading'] = "Custom Design";
$_LANG['prosper_bannerdesign_features_1_image'] = "bannerdesign-features-1.png";
$_LANG['prosper_bannerdesign_features_1_image_alt'] = "custom design";
$_LANG['prosper_bannerdesign_features_1_image_url'] = "";
$_LANG['prosper_bannerdesign_features_1_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_1_text'] = "<p>Every banner we design is completely custom to you and your business. The design is based on your requirements, our research of your business and competition & the goals of your business.</p>";
$_LANG['prosper_bannerdesign_features_1_button1_text'] = "";
$_LANG['prosper_bannerdesign_features_1_button1_icon'] = "";
$_LANG['prosper_bannerdesign_features_1_button1_url'] = "";
$_LANG['prosper_bannerdesign_features_1_button1_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_1_button2_text'] = "";
$_LANG['prosper_bannerdesign_features_1_button2_icon'] = "";
$_LANG['prosper_bannerdesign_features_1_button2_url'] = "";
$_LANG['prosper_bannerdesign_features_1_button2_url_newwindow'] = false;

// Feature 2

$_LANG['prosper_bannerdesign_features_2_display'] = true;
$_LANG['prosper_bannerdesign_features_2_displayorder'] = 0;
$_LANG['prosper_bannerdesign_features_2_heading'] = "Unlimited Revisions";
$_LANG['prosper_bannerdesign_features_2_image'] = "bannerdesign-features-2.png";
$_LANG['prosper_bannerdesign_features_2_image_alt'] = "unlimited revisions";
$_LANG['prosper_bannerdesign_features_2_image_url'] = "";
$_LANG['prosper_bannerdesign_features_2_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_2_text'] = "<p>You can request unlimited revisions once the initial banner design is provided ensuring that the end result is a perfect banner for your business that meets your requirements.</p>";
$_LANG['prosper_bannerdesign_features_2_button1_text'] = "";
$_LANG['prosper_bannerdesign_features_2_button1_icon'] = "";
$_LANG['prosper_bannerdesign_features_2_button1_url'] = "";
$_LANG['prosper_bannerdesign_features_2_button1_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_2_button2_text'] = "";
$_LANG['prosper_bannerdesign_features_2_button2_icon'] = "";
$_LANG['prosper_bannerdesign_features_2_button2_url'] = "";
$_LANG['prosper_bannerdesign_features_2_button2_url_newwindow'] = false;

// Feature 3

$_LANG['prosper_bannerdesign_features_3_display'] = true;
$_LANG['prosper_bannerdesign_features_3_displayorder'] = 0;
$_LANG['prosper_bannerdesign_features_3_heading'] = "All File Formats Provided";
$_LANG['prosper_bannerdesign_features_3_image'] = "bannerdesign-features-3.png";
$_LANG['prosper_bannerdesign_features_3_image_alt'] = "all file formats";
$_LANG['prosper_bannerdesign_features_3_image_url'] = "";
$_LANG['prosper_bannerdesign_features_3_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_3_text'] = "<p>We can provide your finished banner design in any file format you need. By default we will provide the .jpg and .png file formats.</p>";
$_LANG['prosper_bannerdesign_features_3_button1_text'] = "";
$_LANG['prosper_bannerdesign_features_3_button1_icon'] = "";
$_LANG['prosper_bannerdesign_features_3_button1_url'] = "";
$_LANG['prosper_bannerdesign_features_3_button1_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_3_button2_text'] = "";
$_LANG['prosper_bannerdesign_features_3_button2_icon'] = "";
$_LANG['prosper_bannerdesign_features_3_button2_url'] = "";
$_LANG['prosper_bannerdesign_features_3_button2_url_newwindow'] = false;

// Feature 4

$_LANG['prosper_bannerdesign_features_4_display'] = true;
$_LANG['prosper_bannerdesign_features_4_displayorder'] = 0;
$_LANG['prosper_bannerdesign_features_4_heading'] = "Out Of The Box Service";
$_LANG['prosper_bannerdesign_features_4_image'] = "bannerdesign-features-4.png";
$_LANG['prosper_bannerdesign_features_4_image_alt'] = "out of the box service";
$_LANG['prosper_bannerdesign_features_4_image_url'] = "";
$_LANG['prosper_bannerdesign_features_4_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_4_text'] = "<p>Our banner design service is the perfect solution for new businesses looking for a high quality banner that is professional, effective and custom at an affordable price.</p>";
$_LANG['prosper_bannerdesign_features_4_button1_text'] = "";
$_LANG['prosper_bannerdesign_features_4_button1_icon'] = "";
$_LANG['prosper_bannerdesign_features_4_button1_url'] = "";
$_LANG['prosper_bannerdesign_features_4_button1_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_features_4_button2_text'] = "";
$_LANG['prosper_bannerdesign_features_4_button2_icon'] = "";
$_LANG['prosper_bannerdesign_features_4_button2_url'] = "";
$_LANG['prosper_bannerdesign_features_4_button2_url_newwindow'] = false;

// Past Work

$_LANG['prosper_bannerdesign_pastwork_display'] = true;

$_LANG['prosper_bannerdesign_pastwork_heading'] = "Past Work";

// Past Work 1

$_LANG['prosper_bannerdesign_pastwork_1_display'] = true;
$_LANG['prosper_bannerdesign_pastwork_1_displayorder'] = 0;
$_LANG['prosper_bannerdesign_pastwork_1_image'] = "bannerdesign-pastwork-1.gif";
$_LANG['prosper_bannerdesign_pastwork_1_image_alt'] = "banner design 1";
$_LANG['prosper_bannerdesign_pastwork_1_image_url'] = "bannerdesign-pastwork-1.gif";
$_LANG['prosper_bannerdesign_pastwork_1_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_pastwork_1_image_url_popup'] = true;

// Past Work 2

$_LANG['prosper_bannerdesign_pastwork_2_display'] = true;
$_LANG['prosper_bannerdesign_pastwork_2_displayorder'] = 0;
$_LANG['prosper_bannerdesign_pastwork_2_image'] = "bannerdesign-pastwork-2.gif";
$_LANG['prosper_bannerdesign_pastwork_2_image_alt'] = "banner design 2";
$_LANG['prosper_bannerdesign_pastwork_2_image_url'] = "bannerdesign-pastwork-2.gif";
$_LANG['prosper_bannerdesign_pastwork_2_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_pastwork_2_image_url_popup'] = true;

// Past Work 3

$_LANG['prosper_bannerdesign_pastwork_3_display'] = true;
$_LANG['prosper_bannerdesign_pastwork_3_displayorder'] = 0;
$_LANG['prosper_bannerdesign_pastwork_3_image'] = "bannerdesign-pastwork-3.gif";
$_LANG['prosper_bannerdesign_pastwork_3_image_alt'] = "banner design 3";
$_LANG['prosper_bannerdesign_pastwork_3_image_url'] = "bannerdesign-pastwork-3.gif";
$_LANG['prosper_bannerdesign_pastwork_3_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_pastwork_3_image_url_popup'] = true;

// Past Work 4

$_LANG['prosper_bannerdesign_pastwork_4_display'] = true;
$_LANG['prosper_bannerdesign_pastwork_4_displayorder'] = 0;
$_LANG['prosper_bannerdesign_pastwork_4_image'] = "bannerdesign-pastwork-4.gif";
$_LANG['prosper_bannerdesign_pastwork_4_image_alt'] = "banner design 4";
$_LANG['prosper_bannerdesign_pastwork_4_image_url'] = "bannerdesign-pastwork-4.gif";
$_LANG['prosper_bannerdesign_pastwork_4_image_url_newwindow'] = false;
$_LANG['prosper_bannerdesign_pastwork_4_image_url_popup'] = true;

// CTA

$_LANG['prosper_bannerdesign_cta_display'] = true;
$_LANG['prosper_bannerdesign_cta_text'] = "Ready To Get Started?";
$_LANG['prosper_bannerdesign_cta_button_text'] = "Order Now";
$_LANG['prosper_bannerdesign_cta_button_icon'] = "fas fa-shopping-cart";
$_LANG['prosper_bannerdesign_cta_button_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['prosper_bannerdesign_cta_button_url_newwindow'] = false;

// WHMCS Services (whmcs-services.tpl, whmcs-services.php)

// Submenu

$_LANG['prosper_whmcsservices_submenu_display'] = true;

$_LANG['prosper_whmcsservices_submenu_1_display'] = true;
$_LANG['prosper_whmcsservices_submenu_1_text'] = "Overview";
$_LANG['prosper_whmcsservices_submenu_1_url'] = "#overview";
$_LANG['prosper_whmcsservices_submenu_1_url_newwindow'] = false;

$_LANG['prosper_whmcsservices_submenu_2_display'] = true;
$_LANG['prosper_whmcsservices_submenu_2_text'] = "Services";
$_LANG['prosper_whmcsservices_submenu_2_url'] = "#services";
$_LANG['prosper_whmcsservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_whmcsservices_overview_display'] = true;

$_LANG['prosper_addons_whmcsservices_overview'] = "<p>We have been providing WHMCS Services for many years. Using our vast experience we provide installation, configuration, integration, security, automation & more.</p>";

// Services

$_LANG['prosper_addons_whmcsservices_heading'] = "Services";

$_LANG['prosper_addons_whmcsservices_1_display'] = true;
$_LANG['prosper_addons_whmcsservices_1_heading'] = "WHMCS Configuration";
$_LANG['prosper_addons_whmcsservices_1_desc'] = "This service includes the general configuration of WHMCS, 3 support departments, 1 payment gateway and the setup of 3 shared hosting plans that are fully automated.";

$_LANG['prosper_addons_whmcsservices_2_display'] = true;
$_LANG['prosper_addons_whmcsservices_2_heading'] = "WHMCS Upgrade";
$_LANG['prosper_addons_whmcsservices_2_desc'] = "We will manually update your WHMCS installation to the latest version. During which we will ensure that any customisations you've made to the language or template files remain safe without any data loss.";

$_LANG['prosper_addons_whmcsservices_3_display'] = true;
$_LANG['prosper_addons_whmcsservices_3_heading'] = "WHMCS Integration";
$_LANG['prosper_addons_whmcsservices_3_desc'] = "We will take the design of your existing website and use it to create a matching WHMCS Template, this ensures that both your website and WHMCS match in design creating a consistent user experience.";

$_LANG['prosper_addons_whmcsservices_4_display'] = true;
$_LANG['prosper_addons_whmcsservices_4_heading'] = "WHMCS Installation";
$_LANG['prosper_addons_whmcsservices_4_desc'] = "Hire Zomex to complete your WHMCS Installation. We have vast experience working with WHMCS and first installed WHMCS back in 2009 for this very website you are using, Zomex.com.";

$_LANG['prosper_addons_whmcsservices_5_display'] = true;
$_LANG['prosper_addons_whmcsservices_5_heading'] = "Basic Security";
$_LANG['prosper_addons_whmcsservices_5_desc'] = "Our basic security service includes the completion of the further security steps. This includes securing writable directories, changing your admin directory & securing your configuration.php file.";

$_LANG['prosper_addons_whmcsservices_6_display'] = true;
$_LANG['prosper_addons_whmcsservices_6_heading'] = "Advanced Security";
$_LANG['prosper_addons_whmcsservices_6_desc'] = "One big security risk we see is WHMCS installations that contain old files (modules, WHMCS copies, databases etc). Hire Zomex to tidy your WHMCS directory by clearing out these old files.";

$_LANG['prosper_addons_whmcsservices_7_display'] = true;
$_LANG['prosper_addons_whmcsservices_7_heading'] = "Move Directory";
$_LANG['prosper_addons_whmcsservices_7_desc'] = "We will move the directory of your WHMCS installation. For example from domain.com/whmcs to domain.com/clients. Once this process is finished all you'll need to do is re-issue your license.";

$_LANG['prosper_addons_whmcsservices_8_display'] = true;
$_LANG['prosper_addons_whmcsservices_8_heading'] = "Move Server";
$_LANG['prosper_addons_whmcsservices_8_desc'] = "We will move the server of your WHMCS installation. For example from domain.com/whmcs to domain2.com/clients. Once this process is finished all you'll need to do is re-issue your license.";

$_LANG['prosper_addons_whmcsservices_9_display'] = true;
$_LANG['prosper_addons_whmcsservices_9_heading'] = "Shared Hosting Setup";
$_LANG['prosper_addons_whmcsservices_9_desc'] = "This service includes the setup of 3 shared hosting plans in WHMCS using any supported server (cPanel, Plesk etc). The plans we setup in WHMCS will be fully automated.";

$_LANG['prosper_addons_whmcsservices_10_display'] = true;
$_LANG['prosper_addons_whmcsservices_10_heading'] = "Reseller Hosting Setup";
$_LANG['prosper_addons_whmcsservices_10_desc'] = "This service includes the setup of 3 reseller hosting plans in WHMCS using any supported server (cPanel, Plesk etc). The plans we setup in WHMCS will be fully automated.";

$_LANG['prosper_addons_whmcsservices_11_display'] = true;
$_LANG['prosper_addons_whmcsservices_11_heading'] = "Domain Registrar Setup";
$_LANG['prosper_addons_whmcsservices_11_desc'] = "This service includes the setup of any WHMCS supported domain registrar (Enom, ResellerClub etc). We will setup 6 domains of your choice (e.g .com at $14.99/year) with full automation within WHMCS.";

$_LANG['prosper_addons_whmcsservices_12_display'] = true;
$_LANG['prosper_addons_whmcsservices_12_heading'] = "Payment Gateway Setup";
$_LANG['prosper_addons_whmcsservices_12_desc'] = "This service includes the setup of any WHMCS supported payment gateway (PayPal, 2CheckOut, Stripe etc). Once finished you will be able to accept payments via WHMCS using this payment gateway.";

// WordPress Services (wordpress-services.tpl, wordpress-services.php)

// Submenu

$_LANG['prosper_wordpressservices_submenu_display'] = true;

$_LANG['prosper_wordpressservices_submenu_1_display'] = true;
$_LANG['prosper_wordpressservices_submenu_1_text'] = "Overview";
$_LANG['prosper_wordpressservices_submenu_1_url'] = "#overview";
$_LANG['prosper_wordpressservices_submenu_1_url_newwindow'] = false;

$_LANG['prosper_wordpressservices_submenu_2_display'] = true;
$_LANG['prosper_wordpressservices_submenu_2_text'] = "Services";
$_LANG['prosper_wordpressservices_submenu_2_url'] = "#services";
$_LANG['prosper_wordpressservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_wordpressservices_overview_display'] = true;

$_LANG['prosper_addons_wordpressservices_overview'] = "<p>We have been providing WordPress Services for many years. Using our vast experience we provide installation, integration & more.</p>";

// Services

$_LANG['prosper_addons_wordpressservices_heading'] = "Services";

$_LANG['prosper_addons_wordpressservices_1_display'] = true;
$_LANG['prosper_addons_wordpressservices_1_heading'] = "WordPress Installation";
$_LANG['prosper_addons_wordpressservices_1_desc'] = "We will install the latest version of WordPress, completing the installation manually. This service is a quick and easy way to avoid having to install the software yourself and at just $10 is fantastic value.";

$_LANG['prosper_addons_wordpressservices_2_display'] = true;
$_LANG['prosper_addons_wordpressservices_2_heading'] = "WordPress Configuration";
$_LANG['prosper_addons_wordpressservices_2_desc'] = "Hire Zomex to configure your WordPress installation with our recommended settings and plugins for a website that is well optimized for the search engines. We setup your website as we would do for our own.";

$_LANG['prosper_addons_wordpressservices_3_display'] = true;
$_LANG['prosper_addons_wordpressservices_3_heading'] = "WordPress Integration";
$_LANG['prosper_addons_wordpressservices_3_desc'] = "This service involves taking your existing website design to create a matching WordPress theme. This service is popular with companies looking to have a matching WordPress Theme to create a company blog.";

// Blesta Services (blesta-services.tpl, blesta-services.php)

// Submenu

$_LANG['prosper_blestaservices_submenu_display'] = true;

$_LANG['prosper_blestaservices_submenu_1_display'] = true;
$_LANG['prosper_blestaservices_submenu_1_text'] = "Overview";
$_LANG['prosper_blestaservices_submenu_1_url'] = "#overview";
$_LANG['prosper_blestaservices_submenu_1_url_newwindow'] = false;

$_LANG['prosper_blestaservices_submenu_2_display'] = true;
$_LANG['prosper_blestaservices_submenu_2_text'] = "Services";
$_LANG['prosper_blestaservices_submenu_2_url'] = "#services";
$_LANG['prosper_blestaservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_blestaservices_overview_display'] = true;

$_LANG['prosper_addons_blestaservices_overview'] = "<p>We have been providing Blesta Services for many years. Using our vast experience we provide installation, integration & more.</p>";

// Services

$_LANG['prosper_addons_blestaservices_heading'] = "Services";

$_LANG['prosper_addons_blestaservices_1_display'] = true;
$_LANG['prosper_addons_blestaservices_1_heading'] = "Blesta Installation";
$_LANG['prosper_addons_blestaservices_1_desc'] = "We will install the latest version of Blesta, completing the installation manually. This service is a quick and easy way to avoid having to install the software yourself and at just $12 represents fantastic value.";

$_LANG['prosper_addons_blestaservices_2_display'] = true;
$_LANG['prosper_addons_blestaservices_2_heading'] = "Blesta Integration";
$_LANG['prosper_addons_blestaservices_2_desc'] = "We will take the design of your existing website and use it to create a Blesta theme including support for the WordPress based functionality such as admin based pages, menu & widget editing.";

// Clientexec Services (clientexec-services.tpl, clientexec-services.php)

// Submenu

$_LANG['prosper_clientexecservices_submenu_display'] = true;

$_LANG['prosper_clientexecservices_submenu_1_display'] = true;
$_LANG['prosper_clientexecservices_submenu_1_text'] = "Overview";
$_LANG['prosper_clientexecservices_submenu_1_url'] = "#overview";
$_LANG['prosper_clientexecservices_submenu_1_url_newwindow'] = false;

$_LANG['prosper_clientexecservices_submenu_2_display'] = true;
$_LANG['prosper_clientexecservices_submenu_2_text'] = "Services";
$_LANG['prosper_clientexecservices_submenu_2_url'] = "#services";
$_LANG['prosper_clientexecservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['prosper_addons_clientexecservices_overview_display'] = true;

$_LANG['prosper_addons_clientexecservices_overview'] = "<p>We have been providing Clientexec Services for many years. Using our vast experience we provide installation, integration & more.</p>";

// Services

$_LANG['prosper_addons_clientexecservices_heading'] = "Services";

$_LANG['prosper_addons_clientexecservices_1_display'] = true;
$_LANG['prosper_addons_clientexecservices_1_heading'] = "Clientexec Installation";
$_LANG['prosper_addons_clientexecservices_1_desc'] = "We will install the latest version of Clientexec, completing the installation manually. This service is a quick and easy way to avoid having to install the software yourself and at just $12 represents fantastic value.";

$_LANG['prosper_addons_clientexecservices_2_display'] = true;
$_LANG['prosper_addons_clientexecservices_2_heading'] = "Clientexec Integration";
$_LANG['prosper_addons_clientexecservices_2_desc'] = " We will take the design of your existing website and use it to create a Clientexec theme including support for the Clientexec based functionality such as admin based pages, menu & widget editing.";






	
/*
-----------------------------------------
---------   Multi-language support: on   -------
-----------------------------------------

When Multi-language support is set to On from inside Wizard Panel the below text will be used (in order to support multiple languages). If your Multi-language support setting is set to Google Translate or Off then this text is editable in Wizard Panel directly and everything below can be ignored.

-----------------------------------------	
*/






/*
-----------------------------------------
---------   Begin hosting plans   ---------
-----------------------------------------
*/

/*
	
	With multi-language support turned on the below text is used for your plans, your plan price and order URL remain editable in Wizard Panel.
	
	You can re-name any of the 10 hosting pages following this guide: https://www.zomex.com/docs/whmcs-templates/how-to-change-hosting-page-type.php
	
*/






/*
-----------------------------------------
---------   Home page (File: homepage.tpl, index.php)   ---------
-----------------------------------------
*/

// Domain Checker

$_LANG['prosper_domainchecker_tld_1_term'] = "/yr";
$_LANG['prosper_domainchecker_tld_2_term'] = "/yr";
$_LANG['prosper_domainchecker_tld_3_term'] = "/yr";
$_LANG['prosper_domainchecker_tld_4_term'] = "/yr";
$_LANG['prosper_domainchecker_tld_5_term'] = "/yr";

// Feature boxes (File: includes/feature-boxes.tpl)

// Plan 1

$_LANG['prosper_homepage_featureboxes_plan1_name'] = "Shared Hosting";
$_LANG['prosper_homepage_featureboxes_plan1_desc'] = "Premium cPanel based web hosting";
$_LANG['prosper_homepage_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan1_feat1'] = "10GB Disk Space";
$_LANG['prosper_homepage_featureboxes_plan1_feat2'] = "100GB Bandwidth";
$_LANG['prosper_homepage_featureboxes_plan1_feat3'] = "5 Addon Domains";
$_LANG['prosper_homepage_featureboxes_plan1_feat4'] = "cPanel Control Panel";
$_LANG['prosper_homepage_featureboxes_plan1_feat5'] = "Softaculous Installer";
$_LANG['prosper_homepage_featureboxes_plan1_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan1_term'] = "/monthly";
$_LANG['prosper_homepage_featureboxes_plan1_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_homepage_featureboxes_plan2_name'] = "Reseller Hosting";
$_LANG['prosper_homepage_featureboxes_plan2_desc'] = "Start your own reseller business";
$_LANG['prosper_homepage_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan2_feat1'] = "50GB Disk Space";
$_LANG['prosper_homepage_featureboxes_plan2_feat2'] = "500GB Bandwidth";
$_LANG['prosper_homepage_featureboxes_plan2_feat3'] = "cPanel/WHM";
$_LANG['prosper_homepage_featureboxes_plan2_feat4'] = "Overselling Enabled";
$_LANG['prosper_homepage_featureboxes_plan2_feat5'] = "Free WHMCS License";
$_LANG['prosper_homepage_featureboxes_plan2_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan2_term'] = "/monthly";
$_LANG['prosper_homepage_featureboxes_plan2_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_homepage_featureboxes_plan3_name'] = "VPS Hosting";
$_LANG['prosper_homepage_featureboxes_plan3_desc'] = "Take full control of your website";
$_LANG['prosper_homepage_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan3_feat1'] = "50GB Disk Space";
$_LANG['prosper_homepage_featureboxes_plan3_feat2'] = "1TB Bandwidth";
$_LANG['prosper_homepage_featureboxes_plan3_feat3'] = "Free cPanel License";
$_LANG['prosper_homepage_featureboxes_plan3_feat4'] = "SolusVM Included";
$_LANG['prosper_homepage_featureboxes_plan3_feat5'] = "VPS Templates";
$_LANG['prosper_homepage_featureboxes_plan3_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan3_term'] = "/monthly";
$_LANG['prosper_homepage_featureboxes_plan3_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_homepage_featureboxes_plan4_name'] = "Dedicated Servers";
$_LANG['prosper_homepage_featureboxes_plan4_desc'] = "Give your website the hosting it deserves";
$_LANG['prosper_homepage_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan4_feat1'] = "2.8GHz";
$_LANG['prosper_homepage_featureboxes_plan4_feat2'] = "3 CPU Cores";
$_LANG['prosper_homepage_featureboxes_plan4_feat3'] = "4GB RAM";
$_LANG['prosper_homepage_featureboxes_plan4_feat4'] = "250GB Storage";
$_LANG['prosper_homepage_featureboxes_plan4_feat5'] = "2TB Bandwidth";
$_LANG['prosper_homepage_featureboxes_plan4_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan4_term'] = "/monthly";
$_LANG['prosper_homepage_featureboxes_plan4_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_homepage_featureboxes_plan5_name'] = "Cloud Hosting";
$_LANG['prosper_homepage_featureboxes_plan5_desc'] = "Next generation in website hosting";
$_LANG['prosper_homepage_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan5_feat1'] = "10GB Disk Space";
$_LANG['prosper_homepage_featureboxes_plan5_feat2'] = "100GB Bandwidth";
$_LANG['prosper_homepage_featureboxes_plan5_feat3'] = "5 Addon Domains";
$_LANG['prosper_homepage_featureboxes_plan5_feat4'] = "cPanel Control Panel";
$_LANG['prosper_homepage_featureboxes_plan5_feat5'] = "Softaculous Installer";
$_LANG['prosper_homepage_featureboxes_plan5_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan5_term'] = "/monthly";
$_LANG['prosper_homepage_featureboxes_plan5_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_homepage_featureboxes_plan6_name'] = "Game Servers";
$_LANG['prosper_homepage_featureboxes_plan6_desc'] = "Call Of Duty, Medal Of Honour, Halo";
$_LANG['prosper_homepage_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan6_feat1'] = "Control Panel";
$_LANG['prosper_homepage_featureboxes_plan6_feat2'] = "Price Match";
$_LANG['prosper_homepage_featureboxes_plan6_feat3'] = "Fast & Reliable";
$_LANG['prosper_homepage_featureboxes_plan6_feat4'] = "Instant Setup";
$_LANG['prosper_homepage_featureboxes_plan6_feat5'] = "High Quality Network";
$_LANG['prosper_homepage_featureboxes_plan6_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan6_term'] = "/slot";
$_LANG['prosper_homepage_featureboxes_plan6_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_homepage_featureboxes_plan7_name'] = "VPN";
$_LANG['prosper_homepage_featureboxes_plan7_desc'] = "We offer low cost VPN servers";
$_LANG['prosper_homepage_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan7_feat1'] = "Easy To Setup";
$_LANG['prosper_homepage_featureboxes_plan7_feat2'] = "Anonymous Browsing";
$_LANG['prosper_homepage_featureboxes_plan7_feat3'] = "Unlimited Access";
$_LANG['prosper_homepage_featureboxes_plan7_feat4'] = "Low Fees";
$_LANG['prosper_homepage_featureboxes_plan7_feat5'] = "Reliable Support";
$_LANG['prosper_homepage_featureboxes_plan7_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan7_term'] = "/user";
$_LANG['prosper_homepage_featureboxes_plan7_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_homepage_featureboxes_plan8_name'] = "IPTV";
$_LANG['prosper_homepage_featureboxes_plan8_desc'] = "Stream hundreds of popular shows & movies ";
$_LANG['prosper_homepage_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan8_feat1'] = "TV Shows & Movies";
$_LANG['prosper_homepage_featureboxes_plan8_feat2'] = "Unlimited Bandwidth";
$_LANG['prosper_homepage_featureboxes_plan8_feat3'] = "Secure Access";
$_LANG['prosper_homepage_featureboxes_plan8_feat4'] = "Desktop & Mobile Apps";
$_LANG['prosper_homepage_featureboxes_plan8_feat5'] = "Reliable Support";
$_LANG['prosper_homepage_featureboxes_plan8_pricepre'] = "From";
$_LANG['prosper_homepage_featureboxes_plan8_term'] = "/user";
$_LANG['prosper_homepage_featureboxes_plan8_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_homepage_featureboxes_plan9_name'] = "Web Design Quote";
$_LANG['prosper_homepage_featureboxes_plan9_desc'] = "Hire us to create your website";
$_LANG['prosper_homepage_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_homepage_featureboxes_plan9_feat1'] = "WordPress & HTML";
$_LANG['prosper_homepage_featureboxes_plan9_feat2'] = "10 Years Experience";
$_LANG['prosper_homepage_featureboxes_plan9_feat3'] = "SEO Included";
$_LANG['prosper_homepage_featureboxes_plan9_feat4'] = "FREE Domain";
$_LANG['prosper_homepage_featureboxes_plan9_feat5'] = "FREE Email";
$_LANG['prosper_homepage_featureboxes_plan9_pricepre'] = "";
$_LANG['prosper_homepage_featureboxes_plan9_term'] = "";
$_LANG['prosper_homepage_featureboxes_plan9_button1'] = "Learn More";
$_LANG['prosper_homepage_featureboxes_plan9_button2'] = "Quote";






/*
-----------------------------------------
---------   Shared Hosting page by default (File: web-hosting.tpl, web-hosting.php, includes/custom1.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom1_table_heading1'] = "Main Information";
$_LANG['prosper_custom1_table_feat1'] = "Web Space";
$_LANG['prosper_custom1_table_feat2'] = "Bandwidth";
$_LANG['prosper_custom1_table_feat3'] = "Control Panel";

$_LANG['prosper_custom1_table_heading2'] = "Plan Comparison";
$_LANG['prosper_custom1_table_feat4'] = "Web Space";
$_LANG['prosper_custom1_table_feat5'] = "Bandwidth";
$_LANG['prosper_custom1_table_feat6'] = "Addon Domains";
$_LANG['prosper_custom1_table_feat7'] = "Control Panel";
$_LANG['prosper_custom1_table_feat8'] = "Script Installer";
$_LANG['prosper_custom1_table_feat9'] = "Daily Backups";
$_LANG['prosper_custom1_table_feat10'] = "Server";
$_LANG['prosper_custom1_table_feat11'] = "Free Domain";
$_LANG['prosper_custom1_table_feat12'] = "Ticket Support";

$_LANG['prosper_custom1_table_heading3'] = "Key Features";
$_LANG['prosper_custom1_table_feat13'] = "Addon Domains";
$_LANG['prosper_custom1_table_feat14'] = "Databases";
$_LANG['prosper_custom1_table_feat15'] = "FTP Accounts";
$_LANG['prosper_custom1_table_feat16'] = "Email Accounts";
$_LANG['prosper_custom1_table_feat17'] = "Mailing lists";
$_LANG['prosper_custom1_table_feat18'] = "Subdomains";
$_LANG['prosper_custom1_table_feat19'] = "Email Limit";
$_LANG['prosper_custom1_table_feat20'] = "Auto Responders";
$_LANG['prosper_custom1_table_feat21'] = "File Manager";

$_LANG['prosper_custom1_table_heading4'] = "Free Software";
$_LANG['prosper_custom1_table_feat22'] = "Wordpress";
$_LANG['prosper_custom1_table_feat23'] = "Joomla";
$_LANG['prosper_custom1_table_feat24'] = "Drupal";
$_LANG['prosper_custom1_table_feat25'] = "Magento";
$_LANG['prosper_custom1_table_feat26'] = "Zen Cart";
$_LANG['prosper_custom1_table_feat27'] = "phpBB";
$_LANG['prosper_custom1_table_feat28'] = "myBB";
$_LANG['prosper_custom1_table_feat29'] = "SMF";
$_LANG['prosper_custom1_table_feat30'] = "PHPCoin";

// Plan 1

$_LANG['prosper_custom1_table_plan1_name'] = "Shared 1";
$_LANG['prosper_custom1_table_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['prosper_custom1_table_plan1_pricepre'] = "Only";
$_LANG['prosper_custom1_table_plan1_term'] = "/month";
$_LANG['prosper_custom1_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom1_table_plan2_name'] = "Shared 2";
$_LANG['prosper_custom1_table_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['prosper_custom1_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom1_table_plan2_term'] = "/month";
$_LANG['prosper_custom1_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom1_table_plan3_name'] = "Shared 3";
$_LANG['prosper_custom1_table_plan3_desc'] = "Advanced shared hosting package";
$_LANG['prosper_custom1_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom1_table_plan3_term'] = "/month";
$_LANG['prosper_custom1_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom1_table_plan4_name'] = "Shared 4";
$_LANG['prosper_custom1_table_plan4_desc'] = "Professional shared hosting plan";
$_LANG['prosper_custom1_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom1_table_plan4_term'] = "/month";
$_LANG['prosper_custom1_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom1_table_plan5_name'] = "Shared 5";
$_LANG['prosper_custom1_table_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['prosper_custom1_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom1_table_plan5_term'] = "/month";
$_LANG['prosper_custom1_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom1_table_plan6_name'] = "Shared 6";
$_LANG['prosper_custom1_table_plan6_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom1_table_plan6_term'] = "/month";
$_LANG['prosper_custom1_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom1_table2_heading0'] = "Package";
$_LANG['prosper_custom1_table2_heading1'] = "Disk Space";
$_LANG['prosper_custom1_table2_heading2'] = "Bandwidth";
$_LANG['prosper_custom1_table2_heading3'] = "Control Panel";
$_LANG['prosper_custom1_table2_heading4'] = "Script Installer";
$_LANG['prosper_custom1_table2_heading5'] = "Online Editor";
$_LANG['prosper_custom1_table2_heading6'] = "Reliable Support";

// Plan 1

$_LANG['prosper_custom1_table2_plan1_name'] = "Shared 1";
$_LANG['prosper_custom1_table2_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['prosper_custom1_table2_plan1_feat1'] = "10GB";
$_LANG['prosper_custom1_table2_plan1_feat2'] = "100GB";
$_LANG['prosper_custom1_table2_plan1_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan1_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan1_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan1_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan1_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan1_term'] = "/month";
$_LANG['prosper_custom1_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom1_table2_plan2_name'] = "Shared 2";
$_LANG['prosper_custom1_table2_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['prosper_custom1_table2_plan2_feat1'] = "20GB";
$_LANG['prosper_custom1_table2_plan2_feat2'] = "200GB";
$_LANG['prosper_custom1_table2_plan2_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan2_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan2_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan2_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan2_term'] = "/month";
$_LANG['prosper_custom1_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom1_table2_plan3_name'] = "Shared 3";
$_LANG['prosper_custom1_table2_plan3_desc'] = "Advanced shared hosting package";
$_LANG['prosper_custom1_table2_plan3_feat1'] = "30GB";
$_LANG['prosper_custom1_table2_plan3_feat2'] = "300GB";
$_LANG['prosper_custom1_table2_plan3_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan3_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan3_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan3_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan3_term'] = "/month";
$_LANG['prosper_custom1_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom1_table2_plan4_name'] = "Shared 4";
$_LANG['prosper_custom1_table2_plan4_desc'] = "Professional shared hosting plan";
$_LANG['prosper_custom1_table2_plan4_feat1'] = "40GB";
$_LANG['prosper_custom1_table2_plan4_feat2'] = "400GB";
$_LANG['prosper_custom1_table2_plan4_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan4_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan4_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan4_term'] = "/month";
$_LANG['prosper_custom1_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom1_table2_plan5_name'] = "Shared 5";
$_LANG['prosper_custom1_table2_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['prosper_custom1_table2_plan5_feat1'] = "50GB";
$_LANG['prosper_custom1_table2_plan5_feat2'] = "500GB";
$_LANG['prosper_custom1_table2_plan5_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan5_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan5_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan5_term'] = "/month";
$_LANG['prosper_custom1_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom1_table2_plan6_name'] = "Shared 6";
$_LANG['prosper_custom1_table2_plan6_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_table2_plan6_feat1'] = "60GB";
$_LANG['prosper_custom1_table2_plan6_feat2'] = "600GB";
$_LANG['prosper_custom1_table2_plan6_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan6_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan6_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan6_term'] = "/month";
$_LANG['prosper_custom1_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom1_table2_plan7_name'] = "Shared 7";
$_LANG['prosper_custom1_table2_plan7_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_table2_plan7_feat1'] = "70GB";
$_LANG['prosper_custom1_table2_plan7_feat2'] = "700GB";
$_LANG['prosper_custom1_table2_plan7_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan7_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan7_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan7_term'] = "/month";
$_LANG['prosper_custom1_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom1_table2_plan8_name'] = "Shared 8";
$_LANG['prosper_custom1_table2_plan8_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_table2_plan8_feat1'] = "80GB";
$_LANG['prosper_custom1_table2_plan8_feat2'] = "800GB";
$_LANG['prosper_custom1_table2_plan8_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan8_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan8_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan8_term'] = "/month";
$_LANG['prosper_custom1_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom1_table2_plan9_name'] = "Shared 9";
$_LANG['prosper_custom1_table2_plan9_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_table2_plan9_feat1'] = "90GB";
$_LANG['prosper_custom1_table2_plan9_feat2'] = "900GB";
$_LANG['prosper_custom1_table2_plan9_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan9_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan9_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan9_term'] = "/month";
$_LANG['prosper_custom1_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom1_table2_plan10_name'] = "Shared 10";
$_LANG['prosper_custom1_table2_plan10_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_table2_plan10_feat1'] = "100GB";
$_LANG['prosper_custom1_table2_plan10_feat2'] = "1TB";
$_LANG['prosper_custom1_table2_plan10_feat3'] = "cPanel";
$_LANG['prosper_custom1_table2_plan10_feat4'] = "Softaculous";
$_LANG['prosper_custom1_table2_plan10_feat5'] = "check";
$_LANG['prosper_custom1_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom1_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom1_table2_plan10_term'] = "/month";
$_LANG['prosper_custom1_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom1_featureboxes_plan1_name'] = "Shared 1";
$_LANG['prosper_custom1_featureboxes_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['prosper_custom1_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan1_feat1'] = "10GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan1_feat2'] = "100GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan1_feat3'] = "5 Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan1_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan1_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan1_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan1_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom1_featureboxes_plan2_name'] = "Shared 2";
$_LANG['prosper_custom1_featureboxes_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['prosper_custom1_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan2_feat1'] = "20GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan2_feat2'] = "200GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan2_feat3'] = "10 Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan2_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan2_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan2_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom1_featureboxes_plan3_name'] = "Shared 3";
$_LANG['prosper_custom1_featureboxes_plan3_desc'] = "Advanced shared hosting package";
$_LANG['prosper_custom1_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan3_feat1'] = "30GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan3_feat2'] = "300GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan3_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan3_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan3_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom1_featureboxes_plan4_name'] = "Shared 4";
$_LANG['prosper_custom1_featureboxes_plan4_desc'] = "Professional shared hosting plan";
$_LANG['prosper_custom1_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan4_feat1'] = "40GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan4_feat2'] = "400GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan4_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan4_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan4_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan4_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom1_featureboxes_plan5_name'] = "Shared 5";
$_LANG['prosper_custom1_featureboxes_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['prosper_custom1_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan5_feat1'] = "50GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan5_feat2'] = "500GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan5_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan5_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan5_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom1_featureboxes_plan6_name'] = "Shared 6";
$_LANG['prosper_custom1_featureboxes_plan6_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan6_feat1'] = "60GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan6_feat2'] = "600GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan6_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan6_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan6_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan6_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom1_featureboxes_plan7_name'] = "Shared 7";
$_LANG['prosper_custom1_featureboxes_plan7_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan7_feat1'] = "70GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan7_feat2'] = "700GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan7_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan7_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan7_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan7_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom1_featureboxes_plan8_name'] = "Shared 8";
$_LANG['prosper_custom1_featureboxes_plan8_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan8_feat1'] = "80GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan8_feat2'] = "800GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan8_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan8_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan8_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan8_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom1_featureboxes_plan9_name'] = "Shared 9";
$_LANG['prosper_custom1_featureboxes_plan9_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan9_feat1'] = "90GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan9_feat2'] = "900GB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan9_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan9_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan9_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom1_featureboxes_plan10_name'] = "Shared 10";
$_LANG['prosper_custom1_featureboxes_plan10_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan10_feat1'] = "100GB Disk Space";
$_LANG['prosper_custom1_featureboxes_plan10_feat2'] = "1TB Bandwidth";
$_LANG['prosper_custom1_featureboxes_plan10_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom1_featureboxes_plan10_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom1_featureboxes_plan10_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom1_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom1_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom1_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom1_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom1_slider_heading1'] = "Disk Space";
$_LANG['prosper_custom1_slider_heading2'] = "Bandwidth";
$_LANG['prosper_custom1_slider_heading3'] = "Control Panel";
$_LANG['prosper_custom1_slider_heading4'] = "Script Installer";
$_LANG['prosper_custom1_slider_heading5'] = "Support";

// Plan 1

$_LANG['prosper_custom1_slider_plan1_name'] = "Shared 1";
$_LANG['prosper_custom1_slider_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['prosper_custom1_slider_plan1_feat1'] = "10GB";
$_LANG['prosper_custom1_slider_plan1_feat2'] = "100GB";
$_LANG['prosper_custom1_slider_plan1_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan1_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan1_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan1_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan1_term'] = "/month";
$_LANG['prosper_custom1_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom1_slider_plan2_name'] = "Shared 2";
$_LANG['prosper_custom1_slider_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['prosper_custom1_slider_plan2_feat1'] = "20GB";
$_LANG['prosper_custom1_slider_plan2_feat2'] = "200GB";
$_LANG['prosper_custom1_slider_plan2_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan2_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan2_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan2_term'] = "/month";
$_LANG['prosper_custom1_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom1_slider_plan3_name'] = "Shared 3";
$_LANG['prosper_custom1_slider_plan3_desc'] = "Advanced shared hosting package";
$_LANG['prosper_custom1_slider_plan3_feat1'] = "30GB";
$_LANG['prosper_custom1_slider_plan3_feat2'] = "300GB";
$_LANG['prosper_custom1_slider_plan3_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan3_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan3_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan3_term'] = "/month";
$_LANG['prosper_custom1_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom1_slider_plan4_name'] = "Shared 4";
$_LANG['prosper_custom1_slider_plan4_desc'] = "Professional shared hosting plan";
$_LANG['prosper_custom1_slider_plan4_feat1'] = "40GB";
$_LANG['prosper_custom1_slider_plan4_feat2'] = "400GB";
$_LANG['prosper_custom1_slider_plan4_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan4_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan4_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan4_term'] = "/month";
$_LANG['prosper_custom1_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom1_slider_plan5_name'] = "Shared 5";
$_LANG['prosper_custom1_slider_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['prosper_custom1_slider_plan5_feat1'] = "50GB";
$_LANG['prosper_custom1_slider_plan5_feat2'] = "500GB";
$_LANG['prosper_custom1_slider_plan5_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan5_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan5_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan5_term'] = "/month";
$_LANG['prosper_custom1_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom1_slider_plan6_name'] = "Shared 6";
$_LANG['prosper_custom1_slider_plan6_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_slider_plan6_feat1'] = "60GB";
$_LANG['prosper_custom1_slider_plan6_feat2'] = "600GB";
$_LANG['prosper_custom1_slider_plan6_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan6_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan6_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan6_term'] = "/month";
$_LANG['prosper_custom1_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom1_slider_plan7_name'] = "Shared 7";
$_LANG['prosper_custom1_slider_plan7_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_slider_plan7_feat1'] = "70GB";
$_LANG['prosper_custom1_slider_plan7_feat2'] = "700GB";
$_LANG['prosper_custom1_slider_plan7_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan7_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan7_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan7_term'] = "/month";
$_LANG['prosper_custom1_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom1_slider_plan8_name'] = "Shared 8";
$_LANG['prosper_custom1_slider_plan8_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_slider_plan8_feat1'] = "80GB";
$_LANG['prosper_custom1_slider_plan8_feat2'] = "800GB";
$_LANG['prosper_custom1_slider_plan8_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan8_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan8_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan8_term'] = "/month";
$_LANG['prosper_custom1_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom1_slider_plan9_name'] = "Shared 9";
$_LANG['prosper_custom1_slider_plan9_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_slider_plan9_feat1'] = "90GB";
$_LANG['prosper_custom1_slider_plan9_feat2'] = "900GB";
$_LANG['prosper_custom1_slider_plan9_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan9_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan9_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan9_term'] = "/month";
$_LANG['prosper_custom1_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom1_slider_plan10_name'] = "Shared 10";
$_LANG['prosper_custom1_slider_plan10_desc'] = "The best shared plan for experts";
$_LANG['prosper_custom1_slider_plan10_feat1'] = "100GB";
$_LANG['prosper_custom1_slider_plan10_feat2'] = "1TB";
$_LANG['prosper_custom1_slider_plan10_feat3'] = "cPanel";
$_LANG['prosper_custom1_slider_plan10_feat4'] = "Softaculous";
$_LANG['prosper_custom1_slider_plan10_feat5'] = "Tickets";
$_LANG['prosper_custom1_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom1_slider_plan10_term'] = "/month";
$_LANG['prosper_custom1_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Reseller Hosting page by default (File: reseller-hosting.tpl, reseller-hosting.php, includes/custom2.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom2_table_heading1'] = "Main Information";
$_LANG['prosper_custom2_table_feat1'] = "Web Space";
$_LANG['prosper_custom2_table_feat2'] = "Bandwidth";
$_LANG['prosper_custom2_table_feat3'] = "cPanel Accounts";

$_LANG['prosper_custom2_table_heading2'] = "Plan Comparison";
$_LANG['prosper_custom2_table_feat4'] = "Web Space";
$_LANG['prosper_custom2_table_feat5'] = "Bandwidth";
$_LANG['prosper_custom2_table_feat6'] = "Control Panel";
$_LANG['prosper_custom2_table_feat7'] = "cPanel Accounts";
$_LANG['prosper_custom2_table_feat8'] = "Overselling";
$_LANG['prosper_custom2_table_feat9'] = "Daily Backups";
$_LANG['prosper_custom2_table_feat10'] = "Server";
$_LANG['prosper_custom2_table_feat11'] = "End User Support";
$_LANG['prosper_custom2_table_feat12'] = "WHMCS License";

$_LANG['prosper_custom2_table_heading3'] = "";
$_LANG['prosper_custom2_table_feat13'] = "";
$_LANG['prosper_custom2_table_feat14'] = "";
$_LANG['prosper_custom2_table_feat15'] = "";
$_LANG['prosper_custom2_table_feat16'] = "";
$_LANG['prosper_custom2_table_feat17'] = "";
$_LANG['prosper_custom2_table_feat18'] = "";
$_LANG['prosper_custom2_table_feat19'] = "";
$_LANG['prosper_custom2_table_feat20'] = "";
$_LANG['prosper_custom2_table_feat21'] = "";

$_LANG['prosper_custom2_table_heading4'] = "";
$_LANG['prosper_custom2_table_feat22'] = "";
$_LANG['prosper_custom2_table_feat23'] = "";
$_LANG['prosper_custom2_table_feat24'] = "";
$_LANG['prosper_custom2_table_feat25'] = "";
$_LANG['prosper_custom2_table_feat26'] = "";
$_LANG['prosper_custom2_table_feat27'] = "";
$_LANG['prosper_custom2_table_feat28'] = "";
$_LANG['prosper_custom2_table_feat29'] = "";
$_LANG['prosper_custom2_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom2_table_plan1_name'] = "Reseller 1";
$_LANG['prosper_custom2_table_plan1_desc'] = "Perfect reseller hosting plan for beginners";
$_LANG['prosper_custom2_table_plan1_pricepre'] = "Only";
$_LANG['prosper_custom2_table_plan1_term'] = "/month";
$_LANG['prosper_custom2_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom2_table_plan2_name'] = "Reseller 2";
$_LANG['prosper_custom2_table_plan2_desc'] = "Reliable low-cost reseller hosting plan";
$_LANG['prosper_custom2_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom2_table_plan2_term'] = "/month";
$_LANG['prosper_custom2_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom2_table_plan3_name'] = "Reseller 3";
$_LANG['prosper_custom2_table_plan3_desc'] = "Advanced reseller hosting package";
$_LANG['prosper_custom2_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom2_table_plan3_term'] = "/month";
$_LANG['prosper_custom2_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom2_table_plan4_name'] = "Reseller 4";
$_LANG['prosper_custom2_table_plan4_desc'] = "Professional reseller hosting plan";
$_LANG['prosper_custom2_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom2_table_plan4_term'] = "/month";
$_LANG['prosper_custom2_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom2_table_plan5_name'] = "Reseller 5";
$_LANG['prosper_custom2_table_plan5_desc'] = "Suitable reseller plan for web designers";
$_LANG['prosper_custom2_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom2_table_plan5_term'] = "/month";
$_LANG['prosper_custom2_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom2_table_plan6_name'] = "Reseller 6";
$_LANG['prosper_custom2_table_plan6_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom2_table_plan6_term'] = "/month";
$_LANG['prosper_custom2_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom2_table2_heading0'] = "Package";
$_LANG['prosper_custom2_table2_heading1'] = "Disk Space";
$_LANG['prosper_custom2_table2_heading2'] = "Bandwidth";
$_LANG['prosper_custom2_table2_heading3'] = "Control Panel";
$_LANG['prosper_custom2_table2_heading4'] = "cPanel Accounts";
$_LANG['prosper_custom2_table2_heading5'] = "Overselling";
$_LANG['prosper_custom2_table2_heading6'] = "End User Support";

// Plan 1

$_LANG['prosper_custom2_table2_plan1_name'] = "Reseller 1";
$_LANG['prosper_custom2_table2_plan1_desc'] = "Perfect reseller hosting plan for beginners";
$_LANG['prosper_custom2_table2_plan1_feat1'] = "50GB";
$_LANG['prosper_custom2_table2_plan1_feat2'] = "500GB";
$_LANG['prosper_custom2_table2_plan1_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan1_feat4'] = "25";
$_LANG['prosper_custom2_table2_plan1_feat5'] = "cross";
$_LANG['prosper_custom2_table2_plan1_feat6'] = "cross";
$_LANG['prosper_custom2_table2_plan1_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan1_term'] = "/month";
$_LANG['prosper_custom2_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom2_table2_plan2_name'] = "Reseller 2";
$_LANG['prosper_custom2_table2_plan2_desc'] = "Reliable low-cost reseller hosting plan";
$_LANG['prosper_custom2_table2_plan2_feat1'] = "60GB";
$_LANG['prosper_custom2_table2_plan2_feat2'] = "600GB";
$_LANG['prosper_custom2_table2_plan2_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan2_feat4'] = "50";
$_LANG['prosper_custom2_table2_plan2_feat5'] = "cross";
$_LANG['prosper_custom2_table2_plan2_feat6'] = "cross";
$_LANG['prosper_custom2_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan2_term'] = "/month";
$_LANG['prosper_custom2_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom2_table2_plan3_name'] = "Reseller 3";
$_LANG['prosper_custom2_table2_plan3_desc'] = "Advanced reseller hosting package";
$_LANG['prosper_custom2_table2_plan3_feat1'] = "70GB";
$_LANG['prosper_custom2_table2_plan3_feat2'] = "700GB";
$_LANG['prosper_custom2_table2_plan3_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan3_feat4'] = "75";
$_LANG['prosper_custom2_table2_plan3_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan3_feat6'] = "cross";
$_LANG['prosper_custom2_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan3_term'] = "/month";
$_LANG['prosper_custom2_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom2_table2_plan4_name'] = "Reseller 4";
$_LANG['prosper_custom2_table2_plan4_desc'] = "Professional reseller hosting plan";
$_LANG['prosper_custom2_table2_plan4_feat1'] = "80GB";
$_LANG['prosper_custom2_table2_plan4_feat2'] = "800GB";
$_LANG['prosper_custom2_table2_plan4_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan4_feat4'] = "100";
$_LANG['prosper_custom2_table2_plan4_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan4_term'] = "/month";
$_LANG['prosper_custom2_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom2_table2_plan5_name'] = "Reseller 5";
$_LANG['prosper_custom2_table2_plan5_desc'] = "Suitable reseller plan for web designers";
$_LANG['prosper_custom2_table2_plan5_feat1'] = "90GB";
$_LANG['prosper_custom2_table2_plan5_feat2'] = "900GB";
$_LANG['prosper_custom2_table2_plan5_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan5_feat4'] = "125";
$_LANG['prosper_custom2_table2_plan5_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan5_term'] = "/month";
$_LANG['prosper_custom2_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom2_table2_plan6_name'] = "Reseller 6";
$_LANG['prosper_custom2_table2_plan6_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_table2_plan6_feat1'] = "10GB";
$_LANG['prosper_custom2_table2_plan6_feat2'] = "1TB";
$_LANG['prosper_custom2_table2_plan6_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan6_feat4'] = "Unlimited";
$_LANG['prosper_custom2_table2_plan6_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan6_term'] = "/month";
$_LANG['prosper_custom2_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom2_table2_plan7_name'] = "Reseller 7";
$_LANG['prosper_custom2_table2_plan7_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_table2_plan7_feat1'] = "110GB";
$_LANG['prosper_custom2_table2_plan7_feat2'] = "1.1TB";
$_LANG['prosper_custom2_table2_plan7_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan7_feat4'] = "Unlimited";
$_LANG['prosper_custom2_table2_plan7_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan7_term'] = "/month";
$_LANG['prosper_custom2_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom2_table2_plan8_name'] = "Reseller 8";
$_LANG['prosper_custom2_table2_plan8_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_table2_plan8_feat1'] = "120GB";
$_LANG['prosper_custom2_table2_plan8_feat2'] = "1.2TB";
$_LANG['prosper_custom2_table2_plan8_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan8_feat4'] = "Unlimited";
$_LANG['prosper_custom2_table2_plan8_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan8_term'] = "/month";
$_LANG['prosper_custom2_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom2_table2_plan9_name'] = "Reseller 9";
$_LANG['prosper_custom2_table2_plan9_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_table2_plan9_feat1'] = "130GB";
$_LANG['prosper_custom2_table2_plan9_feat2'] = "1.3TB";
$_LANG['prosper_custom2_table2_plan9_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan9_feat4'] = "Unlimited";
$_LANG['prosper_custom2_table2_plan9_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan9_term'] = "/month";
$_LANG['prosper_custom2_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom2_table2_plan10_name'] = "Reseller 10";
$_LANG['prosper_custom2_table2_plan10_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_table2_plan10_feat1'] = "140GB";
$_LANG['prosper_custom2_table2_plan10_feat2'] = "1.4TB";
$_LANG['prosper_custom2_table2_plan10_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_table2_plan10_feat4'] = "Unlimited";
$_LANG['prosper_custom2_table2_plan10_feat5'] = "check";
$_LANG['prosper_custom2_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom2_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom2_table2_plan10_term'] = "/month";
$_LANG['prosper_custom2_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom2_featureboxes_plan1_name'] = "Reseller 1";
$_LANG['prosper_custom2_featureboxes_plan1_desc'] = "Perfect reseller hosting plan for beginners";
$_LANG['prosper_custom2_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan1_feat1'] = "50GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan1_feat2'] = "500GB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan1_feat3'] = "25 cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan1_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan1_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan1_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan1_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom2_featureboxes_plan2_name'] = "Reseller 2";
$_LANG['prosper_custom2_featureboxes_plan2_desc'] = "Reliable low-cost reseller hosting plan";
$_LANG['prosper_custom2_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan2_feat1'] = "60GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan2_feat2'] = "600GB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan2_feat3'] = "50 cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan2_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan2_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan2_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom2_featureboxes_plan3_name'] = "Reseller 3";
$_LANG['prosper_custom2_featureboxes_plan3_desc'] = "Advanced reseller hosting package";
$_LANG['prosper_custom2_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan3_feat1'] = "70GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan3_feat2'] = "700GB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan3_feat3'] = "75 cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan3_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan3_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom2_featureboxes_plan4_name'] = "Reseller 4";
$_LANG['prosper_custom2_featureboxes_plan4_desc'] = "Professional reseller hosting plan";
$_LANG['prosper_custom2_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan4_feat1'] = "80GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan4_feat2'] = "800GB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan4_feat3'] = "100 cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan4_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan4_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan4_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom2_featureboxes_plan5_name'] = "Reseller 5";
$_LANG['prosper_custom2_featureboxes_plan5_desc'] = "Suitable reseller plan for web designers";
$_LANG['prosper_custom2_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan5_feat1'] = "90GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan5_feat2'] = "900GB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan5_feat3'] = "125 cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan5_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan5_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom2_featureboxes_plan6_name'] = "Reseller 6";
$_LANG['prosper_custom2_featureboxes_plan6_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan6_feat1'] = "100GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan6_feat2'] = "1TB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan6_feat3'] = "Unlimited cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan6_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan6_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan6_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom2_featureboxes_plan7_name'] = "Reseller 7";
$_LANG['prosper_custom2_featureboxes_plan7_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan7_feat1'] = "110GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan7_feat2'] = "1.1TB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan7_feat3'] = "Unlimited cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan7_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan7_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan7_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom2_featureboxes_plan8_name'] = "Reseller 8";
$_LANG['prosper_custom2_featureboxes_plan8_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan8_feat1'] = "120GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan8_feat2'] = "1.2TB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan8_feat3'] = "Unlimited cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan8_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan8_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan8_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom2_featureboxes_plan9_name'] = "Reseller 9";
$_LANG['prosper_custom2_featureboxes_plan9_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan9_feat1'] = "130GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan9_feat2'] = "1.3TB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan9_feat3'] = "Unlimited cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan9_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan9_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom2_featureboxes_plan10_name'] = "Reseller 10";
$_LANG['prosper_custom2_featureboxes_plan10_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan10_feat1'] = "140GB Disk Space";
$_LANG['prosper_custom2_featureboxes_plan10_feat2'] = "1.4TB Bandwidth";
$_LANG['prosper_custom2_featureboxes_plan10_feat3'] = "Unlimited cPanel Accounts";
$_LANG['prosper_custom2_featureboxes_plan10_feat4'] = "cPanel/WHM";
$_LANG['prosper_custom2_featureboxes_plan10_feat5'] = "LiteSpeed Web Server";
$_LANG['prosper_custom2_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom2_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom2_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom2_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom2_slider_heading1'] = "Disk Space";
$_LANG['prosper_custom2_slider_heading2'] = "Bandwidth";
$_LANG['prosper_custom2_slider_heading3'] = "Control Panel";
$_LANG['prosper_custom2_slider_heading4'] = "cPanel Accounts";
$_LANG['prosper_custom2_slider_heading5'] = "Overselling";

// Plan 1

$_LANG['prosper_custom2_slider_plan1_name'] = "Reseller 1";
$_LANG['prosper_custom2_slider_plan1_desc'] = "Perfect reseller hosting plan for beginners";
$_LANG['prosper_custom2_slider_plan1_feat1'] = "50GB";
$_LANG['prosper_custom2_slider_plan1_feat2'] = "500GB";
$_LANG['prosper_custom2_slider_plan1_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan1_feat4'] = "25";
$_LANG['prosper_custom2_slider_plan1_feat5'] = "cross";
$_LANG['prosper_custom2_slider_plan1_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan1_term'] = "/month";
$_LANG['prosper_custom2_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom2_slider_plan2_name'] = "Reseller 2";
$_LANG['prosper_custom2_slider_plan2_desc'] = "Reliable low-cost reseller hosting plan";
$_LANG['prosper_custom2_slider_plan2_feat1'] = "60GB";
$_LANG['prosper_custom2_slider_plan2_feat2'] = "600GB";
$_LANG['prosper_custom2_slider_plan2_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan2_feat4'] = "50";
$_LANG['prosper_custom2_slider_plan2_feat5'] = "cross";
$_LANG['prosper_custom2_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan2_term'] = "/month";
$_LANG['prosper_custom2_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom2_slider_plan3_name'] = "Reseller 3";
$_LANG['prosper_custom2_slider_plan3_desc'] = "Advanced reseller hosting package";
$_LANG['prosper_custom2_slider_plan3_feat1'] = "70GB";
$_LANG['prosper_custom2_slider_plan3_feat2'] = "700GB";
$_LANG['prosper_custom2_slider_plan3_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan3_feat4'] = "75";
$_LANG['prosper_custom2_slider_plan3_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan3_term'] = "/month";
$_LANG['prosper_custom2_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom2_slider_plan4_name'] = "Reseller 4";
$_LANG['prosper_custom2_slider_plan4_desc'] = "Professional reseller hosting plan";
$_LANG['prosper_custom2_slider_plan4_feat1'] = "80GB";
$_LANG['prosper_custom2_slider_plan4_feat2'] = "800GB";
$_LANG['prosper_custom2_slider_plan4_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan4_feat4'] = "100";
$_LANG['prosper_custom2_slider_plan4_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan4_term'] = "/month";
$_LANG['prosper_custom2_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom2_slider_plan5_name'] = "Reseller 5";
$_LANG['prosper_custom2_slider_plan5_desc'] = "Suitable reseller plan for web designers";
$_LANG['prosper_custom2_slider_plan5_feat1'] = "90GB";
$_LANG['prosper_custom2_slider_plan5_feat2'] = "900GB";
$_LANG['prosper_custom2_slider_plan5_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan5_feat4'] = "125";
$_LANG['prosper_custom2_slider_plan5_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan5_term'] = "/month";
$_LANG['prosper_custom2_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom2_slider_plan6_name'] = "Reseller 6";
$_LANG['prosper_custom2_slider_plan6_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_slider_plan6_feat1'] = "100GB";
$_LANG['prosper_custom2_slider_plan6_feat2'] = "1TB";
$_LANG['prosper_custom2_slider_plan6_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan6_feat4'] = "Unlimited";
$_LANG['prosper_custom2_slider_plan6_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan6_term'] = "/month";
$_LANG['prosper_custom2_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom2_slider_plan7_name'] = "Reseller 7";
$_LANG['prosper_custom2_slider_plan7_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_slider_plan7_feat1'] = "110GB";
$_LANG['prosper_custom2_slider_plan7_feat2'] = "1.1TB";
$_LANG['prosper_custom2_slider_plan7_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan7_feat4'] = "Unlimited";
$_LANG['prosper_custom2_slider_plan7_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan7_term'] = "/month";
$_LANG['prosper_custom2_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom2_slider_plan8_name'] = "Reseller 8";
$_LANG['prosper_custom2_slider_plan8_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_slider_plan8_feat1'] = "120GB";
$_LANG['prosper_custom2_slider_plan8_feat2'] = "1.2TB";
$_LANG['prosper_custom2_slider_plan8_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan8_feat4'] = "Unlimited";
$_LANG['prosper_custom2_slider_plan8_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan8_term'] = "/month";
$_LANG['prosper_custom2_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom2_slider_plan9_name'] = "Reseller 9";
$_LANG['prosper_custom2_slider_plan9_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_slider_plan9_feat1'] = "130GB";
$_LANG['prosper_custom2_slider_plan9_feat2'] = "1.3TB";
$_LANG['prosper_custom2_slider_plan9_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan9_feat4'] = "Unlimited";
$_LANG['prosper_custom2_slider_plan9_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan9_term'] = "/month";
$_LANG['prosper_custom2_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom2_slider_plan10_name'] = "Reseller 10";
$_LANG['prosper_custom2_slider_plan10_desc'] = "The best reseller plan for experts";
$_LANG['prosper_custom2_slider_plan10_feat1'] = "140GB";
$_LANG['prosper_custom2_slider_plan10_feat2'] = "1.4TB";
$_LANG['prosper_custom2_slider_plan10_feat3'] = "cPanel/WHM";
$_LANG['prosper_custom2_slider_plan10_feat4'] = "Unlimited";
$_LANG['prosper_custom2_slider_plan10_feat5'] = "check";
$_LANG['prosper_custom2_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom2_slider_plan10_term'] = "/month";
$_LANG['prosper_custom2_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   VPS Hosting page by default (File: vps-hosting.tpl, vps-hosting.php, includes/custom3.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom3_table_heading1'] = "Main Information";
$_LANG['prosper_custom3_table_feat1'] = "Web Space";
$_LANG['prosper_custom3_table_feat2'] = "Bandwidth";
$_LANG['prosper_custom3_table_feat3'] = "cPanel License";

$_LANG['prosper_custom3_table_heading2'] = "Plan Comparison";
$_LANG['prosper_custom3_table_feat4'] = "Web Space";
$_LANG['prosper_custom3_table_feat5'] = "Bandwidth";
$_LANG['prosper_custom3_table_feat6'] = "cPanel License";
$_LANG['prosper_custom3_table_feat7'] = "SolusVM License";
$_LANG['prosper_custom3_table_feat8'] = "LiteSpeed License";
$_LANG['prosper_custom3_table_feat9'] = "VPS Templates";
$_LANG['prosper_custom3_table_feat10'] = "Money Back Guarantee";
$_LANG['prosper_custom3_table_feat11'] = "End User Support";
$_LANG['prosper_custom3_table_feat12'] = "Tutorials";

$_LANG['prosper_custom3_table_heading3'] = "";
$_LANG['prosper_custom3_table_feat13'] = "";
$_LANG['prosper_custom3_table_feat14'] = "";
$_LANG['prosper_custom3_table_feat15'] = "";
$_LANG['prosper_custom3_table_feat16'] = "";
$_LANG['prosper_custom3_table_feat17'] = "";
$_LANG['prosper_custom3_table_feat18'] = "";
$_LANG['prosper_custom3_table_feat19'] = "";
$_LANG['prosper_custom3_table_feat20'] = "";
$_LANG['prosper_custom3_table_feat21'] = "";

$_LANG['prosper_custom3_table_heading4'] = "";
$_LANG['prosper_custom3_table_feat22'] = "";
$_LANG['prosper_custom3_table_feat23'] = "";
$_LANG['prosper_custom3_table_feat24'] = "";
$_LANG['prosper_custom3_table_feat25'] = "";
$_LANG['prosper_custom3_table_feat26'] = "";
$_LANG['prosper_custom3_table_feat27'] = "";
$_LANG['prosper_custom3_table_feat28'] = "";
$_LANG['prosper_custom3_table_feat29'] = "";
$_LANG['prosper_custom3_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom3_table_plan1_name'] = "VPS 1";
$_LANG['prosper_custom3_table_plan1_desc'] = "Perfect VPS for beginners";
$_LANG['prosper_custom3_table_plan1_pricepre'] = "Only";
$_LANG['prosper_custom3_table_plan1_term'] = "/month";
$_LANG['prosper_custom3_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom3_table_plan2_name'] = "VPS 2";
$_LANG['prosper_custom3_table_plan2_desc'] = "Reliable low-cost VPS";
$_LANG['prosper_custom3_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom3_table_plan2_term'] = "/month";
$_LANG['prosper_custom3_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom3_table_plan3_name'] = "VPS 3";
$_LANG['prosper_custom3_table_plan3_desc'] = "Advanced VPS package";
$_LANG['prosper_custom3_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom3_table_plan3_term'] = "/month";
$_LANG['prosper_custom3_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom3_table_plan4_name'] = "VPS 4";
$_LANG['prosper_custom3_table_plan4_desc'] = "Professional VPS";
$_LANG['prosper_custom3_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom3_table_plan4_term'] = "/month";
$_LANG['prosper_custom3_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom3_table_plan5_name'] = "VPS 5";
$_LANG['prosper_custom3_table_plan5_desc'] = "Suitable VPS for web designers";
$_LANG['prosper_custom3_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom3_table_plan5_term'] = "/month";
$_LANG['prosper_custom3_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom3_table_plan6_name'] = "VPS 6";
$_LANG['prosper_custom3_table_plan6_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom3_table_plan6_term'] = "/month";
$_LANG['prosper_custom3_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom3_table2_heading0'] = "Package";
$_LANG['prosper_custom3_table2_heading1'] = "Disk Space";
$_LANG['prosper_custom3_table2_heading2'] = "Bandwidth";
$_LANG['prosper_custom3_table2_heading3'] = "cPanel License";
$_LANG['prosper_custom3_table2_heading4'] = "SolusVM License";
$_LANG['prosper_custom3_table2_heading5'] = "LiteSpeed License";
$_LANG['prosper_custom3_table2_heading6'] = "Tutorials";

// Plan 1

$_LANG['prosper_custom3_table2_plan1_name'] = "VPS 1";
$_LANG['prosper_custom3_table2_plan1_desc'] = "Perfect VPS for beginners";
$_LANG['prosper_custom3_table2_plan1_feat1'] = "50GB";
$_LANG['prosper_custom3_table2_plan1_feat2'] = "1TB";
$_LANG['prosper_custom3_table2_plan1_feat3'] = "cross";
$_LANG['prosper_custom3_table2_plan1_feat4'] = "cross";
$_LANG['prosper_custom3_table2_plan1_feat5'] = "cross";
$_LANG['prosper_custom3_table2_plan1_feat6'] = "cross";
$_LANG['prosper_custom3_table2_plan1_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan1_term'] = "/month";
$_LANG['prosper_custom3_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom3_table2_plan2_name'] = "VPS 2";
$_LANG['prosper_custom3_table2_plan2_desc'] = "Reliable low-cost VPS";
$_LANG['prosper_custom3_table2_plan2_feat1'] = "60GB";
$_LANG['prosper_custom3_table2_plan2_feat2'] = "1.1TB";
$_LANG['prosper_custom3_table2_plan2_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan2_feat4'] = "cross";
$_LANG['prosper_custom3_table2_plan2_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan2_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan2_term'] = "/month";
$_LANG['prosper_custom3_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom3_table2_plan3_name'] = "VPS 3";
$_LANG['prosper_custom3_table2_plan3_desc'] = "Advanced VPS package";
$_LANG['prosper_custom3_table2_plan3_feat1'] = "70GB";
$_LANG['prosper_custom3_table2_plan3_feat2'] = "1.2TB";
$_LANG['prosper_custom3_table2_plan3_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan3_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan3_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan3_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan3_term'] = "/month";
$_LANG['prosper_custom3_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom3_table2_plan4_name'] = "VPS 4";
$_LANG['prosper_custom3_table2_plan4_desc'] = "Professional VPS";
$_LANG['prosper_custom3_table2_plan4_feat1'] = "80GB";
$_LANG['prosper_custom3_table2_plan4_feat2'] = "800GB";
$_LANG['prosper_custom3_table2_plan4_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan4_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan4_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan4_term'] = "/month";
$_LANG['prosper_custom3_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom3_table2_plan5_name'] = "VPS 5";
$_LANG['prosper_custom3_table2_plan5_desc'] = "Suitable VPS for web designers";
$_LANG['prosper_custom3_table2_plan5_feat1'] = "90GB";
$_LANG['prosper_custom3_table2_plan5_feat2'] = "1.4TB";
$_LANG['prosper_custom3_table2_plan5_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan5_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan5_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan5_term'] = "/month";
$_LANG['prosper_custom3_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom3_table2_plan6_name'] = "VPS 6";
$_LANG['prosper_custom3_table2_plan6_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_table2_plan6_feat1'] = "10GB";
$_LANG['prosper_custom3_table2_plan6_feat2'] = "1.5TB";
$_LANG['prosper_custom3_table2_plan6_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan6_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan6_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan6_term'] = "/month";
$_LANG['prosper_custom3_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom3_table2_plan7_name'] = "VPS 7";
$_LANG['prosper_custom3_table2_plan7_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_table2_plan7_feat1'] = "110GB";
$_LANG['prosper_custom3_table2_plan7_feat2'] = "1.6TB";
$_LANG['prosper_custom3_table2_plan7_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan7_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan7_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan7_term'] = "/month";
$_LANG['prosper_custom3_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom3_table2_plan8_name'] = "VPS 8";
$_LANG['prosper_custom3_table2_plan8_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_table2_plan8_feat1'] = "120GB";
$_LANG['prosper_custom3_table2_plan8_feat2'] = "1.7TB";
$_LANG['prosper_custom3_table2_plan8_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan8_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan8_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan8_term'] = "/month";
$_LANG['prosper_custom3_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom3_table2_plan9_name'] = "VPS 9";
$_LANG['prosper_custom3_table2_plan9_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_table2_plan9_feat1'] = "130GB";
$_LANG['prosper_custom3_table2_plan9_feat2'] = "1.8TB";
$_LANG['prosper_custom3_table2_plan9_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan9_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan9_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan9_term'] = "/month";
$_LANG['prosper_custom3_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom3_table2_plan10_name'] = "VPS 10";
$_LANG['prosper_custom3_table2_plan10_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_table2_plan10_feat1'] = "140GB";
$_LANG['prosper_custom3_table2_plan10_feat2'] = "1.9TB";
$_LANG['prosper_custom3_table2_plan10_feat3'] = "check";
$_LANG['prosper_custom3_table2_plan10_feat4'] = "check";
$_LANG['prosper_custom3_table2_plan10_feat5'] = "check";
$_LANG['prosper_custom3_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom3_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom3_table2_plan10_term'] = "/month";
$_LANG['prosper_custom3_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom3_featureboxes_plan1_name'] = "VPS 1";
$_LANG['prosper_custom3_featureboxes_plan1_desc'] = "Perfect VPS for beginners";
$_LANG['prosper_custom3_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan1_feat1'] = "50GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan1_feat2'] = "1TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan1_feat3'] = "-";
$_LANG['prosper_custom3_featureboxes_plan1_feat4'] = "-";
$_LANG['prosper_custom3_featureboxes_plan1_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan1_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan1_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom3_featureboxes_plan2_name'] = "VPS 2";
$_LANG['prosper_custom3_featureboxes_plan2_desc'] = "Reliable low-cost VPS";
$_LANG['prosper_custom3_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan2_feat1'] = "60GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan2_feat2'] = "1.1TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan2_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan2_feat4'] = "-";
$_LANG['prosper_custom3_featureboxes_plan2_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan2_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom3_featureboxes_plan3_name'] = "VPS 3";
$_LANG['prosper_custom3_featureboxes_plan3_desc'] = "Advanced VPS package";
$_LANG['prosper_custom3_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan3_feat1'] = "70GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan3_feat2'] = "1.2TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan3_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan3_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan3_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom3_featureboxes_plan4_name'] = "VPS 4";
$_LANG['prosper_custom3_featureboxes_plan4_desc'] = "Professional VPS";
$_LANG['prosper_custom3_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan4_feat1'] = "80GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan4_feat2'] = "1.3TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan4_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan4_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan4_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan4_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom3_featureboxes_plan5_name'] = "VPS 5";
$_LANG['prosper_custom3_featureboxes_plan5_desc'] = "Suitable VPS for web designers";
$_LANG['prosper_custom3_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan5_feat1'] = "90GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan5_feat2'] = "1.4TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan5_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan5_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan5_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom3_featureboxes_plan6_name'] = "VPS 6";
$_LANG['prosper_custom3_featureboxes_plan6_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan6_feat1'] = "100GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan6_feat2'] = "1.5TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan6_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan6_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan6_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan6_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom3_featureboxes_plan7_name'] = "VPS 7";
$_LANG['prosper_custom3_featureboxes_plan7_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan7_feat1'] = "110GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan7_feat2'] = "1.6TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan7_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan7_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan7_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan7_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom3_featureboxes_plan8_name'] = "VPS 8";
$_LANG['prosper_custom3_featureboxes_plan8_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan8_feat1'] = "120GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan8_feat2'] = "1.7TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan8_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan8_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan8_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan8_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom3_featureboxes_plan9_name'] = "VPS 9";
$_LANG['prosper_custom3_featureboxes_plan9_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan9_feat1'] = "130GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan9_feat2'] = "1.8TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan9_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan9_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan9_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom3_featureboxes_plan10_name'] = "VPS 10";
$_LANG['prosper_custom3_featureboxes_plan10_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan10_feat1'] = "140GB Disk Space";
$_LANG['prosper_custom3_featureboxes_plan10_feat2'] = "1.9TB Bandwidth";
$_LANG['prosper_custom3_featureboxes_plan10_feat3'] = "FREE cPanel License";
$_LANG['prosper_custom3_featureboxes_plan10_feat4'] = "FREE SolusVM License";
$_LANG['prosper_custom3_featureboxes_plan10_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom3_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom3_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom3_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom3_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom3_slider_heading1'] = "Disk Space";
$_LANG['prosper_custom3_slider_heading2'] = "Bandwidth";
$_LANG['prosper_custom3_slider_heading3'] = "cPanel License";
$_LANG['prosper_custom3_slider_heading4'] = "SolusVM License";
$_LANG['prosper_custom3_slider_heading5'] = "VPS Templates";

// Plan 1

$_LANG['prosper_custom3_slider_plan1_name'] = "VPS 1";
$_LANG['prosper_custom3_slider_plan1_desc'] = "Perfect VPS for beginners";
$_LANG['prosper_custom3_slider_plan1_feat1'] = "50GB";
$_LANG['prosper_custom3_slider_plan1_feat2'] = "1TB";
$_LANG['prosper_custom3_slider_plan1_feat3'] = "cross";
$_LANG['prosper_custom3_slider_plan1_feat4'] = "cross";
$_LANG['prosper_custom3_slider_plan1_feat5'] = "cross";
$_LANG['prosper_custom3_slider_plan1_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan1_term'] = "/month";
$_LANG['prosper_custom3_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom3_slider_plan2_name'] = "VPS 2";
$_LANG['prosper_custom3_slider_plan2_desc'] = "Reliable low-cost VPS";
$_LANG['prosper_custom3_slider_plan2_feat1'] = "60GB";
$_LANG['prosper_custom3_slider_plan2_feat2'] = "1.1TB";
$_LANG['prosper_custom3_slider_plan2_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan2_feat4'] = "cross";
$_LANG['prosper_custom3_slider_plan2_feat5'] = "cross";
$_LANG['prosper_custom3_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan2_term'] = "/month";
$_LANG['prosper_custom3_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom3_slider_plan3_name'] = "VPS 3";
$_LANG['prosper_custom3_slider_plan3_desc'] = "Advanced VPS package";
$_LANG['prosper_custom3_slider_plan3_feat1'] = "70GB";
$_LANG['prosper_custom3_slider_plan3_feat2'] = "1.2TB";
$_LANG['prosper_custom3_slider_plan3_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan3_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan3_feat5'] = "cross";
$_LANG['prosper_custom3_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan3_term'] = "/month";
$_LANG['prosper_custom3_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom3_slider_plan4_name'] = "VPS 4";
$_LANG['prosper_custom3_slider_plan4_desc'] = "Professional VPS";
$_LANG['prosper_custom3_slider_plan4_feat1'] = "80GB";
$_LANG['prosper_custom3_slider_plan4_feat2'] = "1.3TB";
$_LANG['prosper_custom3_slider_plan4_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan4_feat4'] = "100check";
$_LANG['prosper_custom3_slider_plan4_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan4_term'] = "/month";
$_LANG['prosper_custom3_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom3_slider_plan5_name'] = "VPS 5";
$_LANG['prosper_custom3_slider_plan5_desc'] = "Suitable VPS for web designers";
$_LANG['prosper_custom3_slider_plan5_feat1'] = "90GB";
$_LANG['prosper_custom3_slider_plan5_feat2'] = "1.4TB";
$_LANG['prosper_custom3_slider_plan5_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan5_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan5_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan5_term'] = "/month";
$_LANG['prosper_custom3_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom3_slider_plan6_name'] = "VPS 6";
$_LANG['prosper_custom3_slider_plan6_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_slider_plan6_feat1'] = "100GB";
$_LANG['prosper_custom3_slider_plan6_feat2'] = "1.5TB";
$_LANG['prosper_custom3_slider_plan6_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan6_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan6_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan6_term'] = "/month";
$_LANG['prosper_custom3_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom3_slider_plan7_name'] = "VPS 7";
$_LANG['prosper_custom3_slider_plan7_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_slider_plan7_feat1'] = "110GB";
$_LANG['prosper_custom3_slider_plan7_feat2'] = "1.6TB";
$_LANG['prosper_custom3_slider_plan7_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan7_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan7_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan7_term'] = "/month";
$_LANG['prosper_custom3_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom3_slider_plan8_name'] = "VPS 8";
$_LANG['prosper_custom3_slider_plan8_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_slider_plan8_feat1'] = "120GB";
$_LANG['prosper_custom3_slider_plan8_feat2'] = "1.7TB";
$_LANG['prosper_custom3_slider_plan8_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan8_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan8_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan8_term'] = "/month";
$_LANG['prosper_custom3_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom3_slider_plan9_name'] = "VPS 9";
$_LANG['prosper_custom3_slider_plan9_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_slider_plan9_feat1'] = "130GB";
$_LANG['prosper_custom3_slider_plan9_feat2'] = "1.8TB";
$_LANG['prosper_custom3_slider_plan9_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan9_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan9_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan9_term'] = "/month";
$_LANG['prosper_custom3_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom3_slider_plan10_name'] = "VPS 10";
$_LANG['prosper_custom3_slider_plan10_desc'] = "The best VPS for experts";
$_LANG['prosper_custom3_slider_plan10_feat1'] = "140GB";
$_LANG['prosper_custom3_slider_plan10_feat2'] = "1.9TB";
$_LANG['prosper_custom3_slider_plan10_feat3'] = "check";
$_LANG['prosper_custom3_slider_plan10_feat4'] = "check";
$_LANG['prosper_custom3_slider_plan10_feat5'] = "check";
$_LANG['prosper_custom3_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom3_slider_plan10_term'] = "/month";
$_LANG['prosper_custom3_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Dedicated Servers page by default (File: dedicated-servers.tpl, dedicated-servers.php, includes/custom4.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom4_table_heading1'] = "Main Information";
$_LANG['prosper_custom4_table_feat1'] = "Hard Drive";
$_LANG['prosper_custom4_table_feat2'] = "Bandwidth";
$_LANG['prosper_custom4_table_feat3'] = "RAM";

$_LANG['prosper_custom4_table_heading2'] = "Server Comparison";
$_LANG['prosper_custom4_table_feat4'] = "Hard Drive";
$_LANG['prosper_custom4_table_feat5'] = "Bandwidth";
$_LANG['prosper_custom4_table_feat6'] = "RAM";
$_LANG['prosper_custom4_table_feat7'] = "CPU Cores";
$_LANG['prosper_custom4_table_feat8'] = "Transfer";
$_LANG['prosper_custom4_table_feat9'] = "New Hardware";
$_LANG['prosper_custom4_table_feat10'] = "OS";
$_LANG['prosper_custom4_table_feat11'] = "Location Choice";
$_LANG['prosper_custom4_table_feat12'] = "FREE SSL";

$_LANG['prosper_custom4_table_heading3'] = "Key Features";
$_LANG['prosper_custom4_table_feat13'] = "Root Access";
$_LANG['prosper_custom4_table_feat14'] = "Cloud Panel";
$_LANG['prosper_custom4_table_feat15'] = "Control Panel";
$_LANG['prosper_custom4_table_feat16'] = "Monitoring";
$_LANG['prosper_custom4_table_feat17'] = "Remote Access";
$_LANG['prosper_custom4_table_feat18'] = "Backup";
$_LANG['prosper_custom4_table_feat19'] = "SIEM";
$_LANG['prosper_custom4_table_feat20'] = "IPS/IDS";
$_LANG['prosper_custom4_table_feat21'] = "Firewall";

$_LANG['prosper_custom4_table_heading4'] = "Support";
$_LANG['prosper_custom4_table_feat22'] = "Live Chat";
$_LANG['prosper_custom4_table_feat23'] = "Tickets";
$_LANG['prosper_custom4_table_feat24'] = "Phone";
$_LANG['prosper_custom4_table_feat25'] = "";
$_LANG['prosper_custom4_table_feat26'] = "";
$_LANG['prosper_custom4_table_feat27'] = "";
$_LANG['prosper_custom4_table_feat28'] = "";
$_LANG['prosper_custom4_table_feat29'] = "";
$_LANG['prosper_custom4_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom4_table_plan1_name'] = "Dedicated 1";
$_LANG['prosper_custom4_table_plan1_desc'] = "Perfect Dedicated for beginners";
$_LANG['prosper_custom4_table_plan1_pricepre'] = "Only";
$_LANG['prosper_custom4_table_plan1_term'] = "/month";
$_LANG['prosper_custom4_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom4_table_plan2_name'] = "Dedicated 2";
$_LANG['prosper_custom4_table_plan2_desc'] = "Reliable low-cost Dedicated";
$_LANG['prosper_custom4_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom4_table_plan2_term'] = "/month";
$_LANG['prosper_custom4_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom4_table_plan3_name'] = "Dedicated 3";
$_LANG['prosper_custom4_table_plan3_desc'] = "Advanced Dedicated package";
$_LANG['prosper_custom4_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom4_table_plan3_term'] = "/month";
$_LANG['prosper_custom4_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom4_table_plan4_name'] = "Dedicated 4";
$_LANG['prosper_custom4_table_plan4_desc'] = "Professional Dedicated";
$_LANG['prosper_custom4_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom4_table_plan4_term'] = "/month";
$_LANG['prosper_custom4_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom4_table_plan5_name'] = "Dedicated 5";
$_LANG['prosper_custom4_table_plan5_desc'] = "Suitable Dedicated for web designers";
$_LANG['prosper_custom4_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom4_table_plan5_term'] = "/month";
$_LANG['prosper_custom4_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom4_table_plan6_name'] = "Dedicated 6";
$_LANG['prosper_custom4_table_plan6_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom4_table_plan6_term'] = "/month";
$_LANG['prosper_custom4_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom4_table2_heading0'] = "Server";
$_LANG['prosper_custom4_table2_heading1'] = "Hard Drive";
$_LANG['prosper_custom4_table2_heading2'] = "Bandwidth";
$_LANG['prosper_custom4_table2_heading3'] = "RAM";
$_LANG['prosper_custom4_table2_heading4'] = "CPU Cores";
$_LANG['prosper_custom4_table2_heading5'] = "OS";
$_LANG['prosper_custom4_table2_heading6'] = "Remote Backup";

// Plan 1

$_LANG['prosper_custom4_table2_plan1_name'] = "Dedicated 1";
$_LANG['prosper_custom4_table2_plan1_desc'] = "Perfect Dedicated for beginners";
$_LANG['prosper_custom4_table2_plan1_feat1'] = "250GB";
$_LANG['prosper_custom4_table2_plan1_feat2'] = "2TB";
$_LANG['prosper_custom4_table2_plan1_feat3'] = "4GB";
$_LANG['prosper_custom4_table2_plan1_feat4'] = "3";
$_LANG['prosper_custom4_table2_plan1_feat5'] = "Linux";
$_LANG['prosper_custom4_table2_plan1_feat6'] = "cross";
$_LANG['prosper_custom4_table2_plan1_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan1_term'] = "/month";
$_LANG['prosper_custom4_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom4_table2_plan2_name'] = "Dedicated 2";
$_LANG['prosper_custom4_table2_plan2_desc'] = "Reliable low-cost Dedicated";
$_LANG['prosper_custom4_table2_plan2_feat1'] = "300GB";
$_LANG['prosper_custom4_table2_plan2_feat2'] = "4TB";
$_LANG['prosper_custom4_table2_plan2_feat3'] = "6GB";
$_LANG['prosper_custom4_table2_plan2_feat4'] = "3";
$_LANG['prosper_custom4_table2_plan2_feat5'] = "Linux";
$_LANG['prosper_custom4_table2_plan2_feat6'] = "cross";
$_LANG['prosper_custom4_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan2_term'] = "/month";
$_LANG['prosper_custom4_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom4_table2_plan3_name'] = "Dedicated 3";
$_LANG['prosper_custom4_table2_plan3_desc'] = "Advanced Dedicated package";
$_LANG['prosper_custom4_table2_plan3_feat1'] = "350GB";
$_LANG['prosper_custom4_table2_plan3_feat2'] = "6TB";
$_LANG['prosper_custom4_table2_plan3_feat3'] = "8GB";
$_LANG['prosper_custom4_table2_plan3_feat4'] = "4";
$_LANG['prosper_custom4_table2_plan3_feat5'] = "Linux";
$_LANG['prosper_custom4_table2_plan3_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan3_term'] = "/month";
$_LANG['prosper_custom4_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom4_table2_plan4_name'] = "Dedicated 4";
$_LANG['prosper_custom4_table2_plan4_desc'] = "Professional Dedicated";
$_LANG['prosper_custom4_table2_plan4_feat1'] = "400GB";
$_LANG['prosper_custom4_table2_plan4_feat2'] = "8TB";
$_LANG['prosper_custom4_table2_plan4_feat3'] = "10GB";
$_LANG['prosper_custom4_table2_plan4_feat4'] = "4";
$_LANG['prosper_custom4_table2_plan4_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan4_term'] = "/month";
$_LANG['prosper_custom4_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom4_table2_plan5_name'] = "Dedicated 5";
$_LANG['prosper_custom4_table2_plan5_desc'] = "Suitable Dedicated for web designers";
$_LANG['prosper_custom4_table2_plan5_feat1'] = "450GB";
$_LANG['prosper_custom4_table2_plan5_feat2'] = "10TB";
$_LANG['prosper_custom4_table2_plan5_feat3'] = "12GB";
$_LANG['prosper_custom4_table2_plan5_feat4'] = "5";
$_LANG['prosper_custom4_table2_plan5_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan5_term'] = "/month";
$_LANG['prosper_custom4_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom4_table2_plan6_name'] = "Dedicated 6";
$_LANG['prosper_custom4_table2_plan6_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_table2_plan6_feat1'] = "500GB";
$_LANG['prosper_custom4_table2_plan6_feat2'] = "12TB";
$_LANG['prosper_custom4_table2_plan6_feat3'] = "14GB";
$_LANG['prosper_custom4_table2_plan6_feat4'] = "5";
$_LANG['prosper_custom4_table2_plan6_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan6_term'] = "/month";
$_LANG['prosper_custom4_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom4_table2_plan7_name'] = "Dedicated 7";
$_LANG['prosper_custom4_table2_plan7_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_table2_plan7_feat1'] = "550GB";
$_LANG['prosper_custom4_table2_plan7_feat2'] = "14TB";
$_LANG['prosper_custom4_table2_plan7_feat3'] = "16GB";
$_LANG['prosper_custom4_table2_plan7_feat4'] = "6";
$_LANG['prosper_custom4_table2_plan7_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan7_term'] = "/month";
$_LANG['prosper_custom4_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom4_table2_plan8_name'] = "Dedicated 8";
$_LANG['prosper_custom4_table2_plan8_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_table2_plan8_feat1'] = "600GB";
$_LANG['prosper_custom4_table2_plan8_feat2'] = "16TB";
$_LANG['prosper_custom4_table2_plan8_feat3'] = "18GB";
$_LANG['prosper_custom4_table2_plan8_feat4'] = "6";
$_LANG['prosper_custom4_table2_plan8_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan8_term'] = "/month";
$_LANG['prosper_custom4_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom4_table2_plan9_name'] = "Dedicated 9";
$_LANG['prosper_custom4_table2_plan9_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_table2_plan9_feat1'] = "650GB";
$_LANG['prosper_custom4_table2_plan9_feat2'] = "18TB";
$_LANG['prosper_custom4_table2_plan9_feat3'] = "20GB";
$_LANG['prosper_custom4_table2_plan9_feat4'] = "7";
$_LANG['prosper_custom4_table2_plan9_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan9_term'] = "/month";
$_LANG['prosper_custom4_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom4_table2_plan10_name'] = "Dedicated 10";
$_LANG['prosper_custom4_table2_plan10_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_table2_plan10_feat1'] = "700GB";
$_LANG['prosper_custom4_table2_plan10_feat2'] = "20TB";
$_LANG['prosper_custom4_table2_plan10_feat3'] = "22GB";
$_LANG['prosper_custom4_table2_plan10_feat4'] = "7";
$_LANG['prosper_custom4_table2_plan10_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom4_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom4_table2_plan10_term'] = "/month";
$_LANG['prosper_custom4_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom4_featureboxes_plan1_name'] = "Dedicated 1";
$_LANG['prosper_custom4_featureboxes_plan1_desc'] = "Perfect Dedicated for beginners";
$_LANG['prosper_custom4_featureboxes_plan1_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan1_feat1'] = "250GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan1_feat2'] = "2TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan1_feat3'] = "4GB RAM";
$_LANG['prosper_custom4_featureboxes_plan1_feat4'] = "3 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan1_feat5'] = "Linux OS";
$_LANG['prosper_custom4_featureboxes_plan1_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan1_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom4_featureboxes_plan2_name'] = "Dedicated 2";
$_LANG['prosper_custom4_featureboxes_plan2_desc'] = "Reliable low-cost Dedicated";
$_LANG['prosper_custom4_featureboxes_plan2_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan2_feat1'] = "300GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan2_feat2'] = "4TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan2_feat3'] = "6GB RAM";
$_LANG['prosper_custom4_featureboxes_plan2_feat4'] = "3 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan2_feat5'] = "Linux OS";
$_LANG['prosper_custom4_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan2_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom4_featureboxes_plan3_name'] = "Dedicated 3";
$_LANG['prosper_custom4_featureboxes_plan3_desc'] = "Advanced Dedicated package";
$_LANG['prosper_custom4_featureboxes_plan3_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan3_feat1'] = "350GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan3_feat2'] = "6TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan3_feat3'] = "8GB RAM";
$_LANG['prosper_custom4_featureboxes_plan3_feat4'] = "4 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan3_feat5'] = "Linux OS";
$_LANG['prosper_custom4_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom4_featureboxes_plan4_name'] = "Dedicated 4";
$_LANG['prosper_custom4_featureboxes_plan4_desc'] = "Professional Dedicated";
$_LANG['prosper_custom4_featureboxes_plan4_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan4_feat1'] = "400GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan4_feat2'] = "8TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan4_feat3'] = "10GB RAM";
$_LANG['prosper_custom4_featureboxes_plan4_feat4'] = "4 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan4_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan4_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom4_featureboxes_plan5_name'] = "Dedicated 5";
$_LANG['prosper_custom4_featureboxes_plan5_desc'] = "Suitable Dedicated for web designers";
$_LANG['prosper_custom4_featureboxes_plan5_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan5_feat1'] = "450GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan5_feat2'] = "10TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan5_feat3'] = "12GB RAM";
$_LANG['prosper_custom4_featureboxes_plan5_feat4'] = "5 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan5_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom4_featureboxes_plan6_name'] = "Dedicated 6";
$_LANG['prosper_custom4_featureboxes_plan6_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_featureboxes_plan6_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan6_feat1'] = "500GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan6_feat2'] = "12TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan6_feat3'] = "14GB RAM";
$_LANG['prosper_custom4_featureboxes_plan6_feat4'] = "5 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan6_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan6_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom4_featureboxes_plan7_name'] = "Dedicated 7";
$_LANG['prosper_custom4_featureboxes_plan7_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_featureboxes_plan7_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan7_feat1'] = "550GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan7_feat2'] = "14TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan7_feat3'] = "16GB RAM";
$_LANG['prosper_custom4_featureboxes_plan7_feat4'] = "6 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan7_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan7_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom4_featureboxes_plan8_name'] = "Dedicated 8";
$_LANG['prosper_custom4_featureboxes_plan8_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_featureboxes_plan8_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan8_feat1'] = "600GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan8_feat2'] = "16TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan8_feat3'] = "18GB RAM";
$_LANG['prosper_custom4_featureboxes_plan8_feat4'] = "6 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan8_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan8_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom4_featureboxes_plan9_name'] = "Dedicated 9";
$_LANG['prosper_custom4_featureboxes_plan9_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_featureboxes_plan9_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan9_feat1'] = "650GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan9_feat2'] = "18TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan9_feat3'] = "20GB RAM";
$_LANG['prosper_custom4_featureboxes_plan9_feat4'] = "7 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan9_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom4_featureboxes_plan10_name'] = "Dedicated 10";
$_LANG['prosper_custom4_featureboxes_plan10_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_featureboxes_plan10_features'] = "Specs";
$_LANG['prosper_custom4_featureboxes_plan10_feat1'] = "700GB Hard Drive";
$_LANG['prosper_custom4_featureboxes_plan10_feat2'] = "20TB Bandwidth";
$_LANG['prosper_custom4_featureboxes_plan10_feat3'] = "22GB RAM";
$_LANG['prosper_custom4_featureboxes_plan10_feat4'] = "7 CPU Cores";
$_LANG['prosper_custom4_featureboxes_plan10_feat5'] = "LiteSpeed OS";
$_LANG['prosper_custom4_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom4_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom4_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom4_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom4_slider_heading1'] = "Hard Drive";
$_LANG['prosper_custom4_slider_heading2'] = "Bandwidth";
$_LANG['prosper_custom4_slider_heading3'] = "RAM";
$_LANG['prosper_custom4_slider_heading4'] = "CPU Cores";
$_LANG['prosper_custom4_slider_heading5'] = "OS";

// Plan 1

$_LANG['prosper_custom4_slider_plan1_name'] = "Dedicated 1";
$_LANG['prosper_custom4_slider_plan1_desc'] = "Perfect Dedicated for beginners";
$_LANG['prosper_custom4_slider_plan1_feat1'] = "250GB";
$_LANG['prosper_custom4_slider_plan1_feat2'] = "2TB";
$_LANG['prosper_custom4_slider_plan1_feat3'] = "4GB";
$_LANG['prosper_custom4_slider_plan1_feat4'] = "3";
$_LANG['prosper_custom4_slider_plan1_feat5'] = "Linux";
$_LANG['prosper_custom4_slider_plan1_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan1_term'] = "/month";
$_LANG['prosper_custom4_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom4_slider_plan2_name'] = "Dedicated 2";
$_LANG['prosper_custom4_slider_plan2_desc'] = "Reliable low-cost Dedicated";
$_LANG['prosper_custom4_slider_plan2_feat1'] = "300GB";
$_LANG['prosper_custom4_slider_plan2_feat2'] = "4TB";
$_LANG['prosper_custom4_slider_plan2_feat3'] = "6GB";
$_LANG['prosper_custom4_slider_plan2_feat4'] = "3";
$_LANG['prosper_custom4_slider_plan2_feat5'] = "Linux";
$_LANG['prosper_custom4_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan2_term'] = "/month";
$_LANG['prosper_custom4_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom4_slider_plan3_name'] = "Dedicated 3";
$_LANG['prosper_custom4_slider_plan3_desc'] = "Advanced Dedicated package";
$_LANG['prosper_custom4_slider_plan3_feat1'] = "350GB";
$_LANG['prosper_custom4_slider_plan3_feat2'] = "6TB";
$_LANG['prosper_custom4_slider_plan3_feat3'] = "8GB";
$_LANG['prosper_custom4_slider_plan3_feat4'] = "4";
$_LANG['prosper_custom4_slider_plan3_feat5'] = "Linux";
$_LANG['prosper_custom4_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan3_term'] = "/month";
$_LANG['prosper_custom4_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom4_slider_plan4_name'] = "Dedicated 4";
$_LANG['prosper_custom4_slider_plan4_desc'] = "Professional Dedicated";
$_LANG['prosper_custom4_slider_plan4_feat1'] = "400GB";
$_LANG['prosper_custom4_slider_plan4_feat2'] = "8TB";
$_LANG['prosper_custom4_slider_plan4_feat3'] = "10GB";
$_LANG['prosper_custom4_slider_plan4_feat4'] = "4";
$_LANG['prosper_custom4_slider_plan4_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan4_term'] = "/month";
$_LANG['prosper_custom4_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom4_slider_plan5_name'] = "Dedicated 5";
$_LANG['prosper_custom4_slider_plan5_desc'] = "Suitable Dedicated for web designers";
$_LANG['prosper_custom4_slider_plan5_feat1'] = "450GB";
$_LANG['prosper_custom4_slider_plan5_feat2'] = "10TB";
$_LANG['prosper_custom4_slider_plan5_feat3'] = "12GB";
$_LANG['prosper_custom4_slider_plan5_feat4'] = "5";
$_LANG['prosper_custom4_slider_plan5_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan5_term'] = "/month";
$_LANG['prosper_custom4_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom4_slider_plan6_name'] = "Dedicated 6";
$_LANG['prosper_custom4_slider_plan6_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_slider_plan6_feat1'] = "500GB";
$_LANG['prosper_custom4_slider_plan6_feat2'] = "12TB";
$_LANG['prosper_custom4_slider_plan6_feat3'] = "14GB";
$_LANG['prosper_custom4_slider_plan6_feat4'] = "5";
$_LANG['prosper_custom4_slider_plan6_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan6_term'] = "/month";
$_LANG['prosper_custom4_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom4_slider_plan7_name'] = "Dedicated 7";
$_LANG['prosper_custom4_slider_plan7_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_slider_plan7_feat1'] = "550GB";
$_LANG['prosper_custom4_slider_plan7_feat2'] = "14TB";
$_LANG['prosper_custom4_slider_plan7_feat3'] = "16GB";
$_LANG['prosper_custom4_slider_plan7_feat4'] = "6";
$_LANG['prosper_custom4_slider_plan7_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan7_term'] = "/month";
$_LANG['prosper_custom4_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom4_slider_plan8_name'] = "Dedicated 8";
$_LANG['prosper_custom4_slider_plan8_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_slider_plan8_feat1'] = "600GB";
$_LANG['prosper_custom4_slider_plan8_feat2'] = "16TB";
$_LANG['prosper_custom4_slider_plan8_feat3'] = "18GB";
$_LANG['prosper_custom4_slider_plan8_feat4'] = "6";
$_LANG['prosper_custom4_slider_plan8_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan8_term'] = "/month";
$_LANG['prosper_custom4_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom4_slider_plan9_name'] = "Dedicated 9";
$_LANG['prosper_custom4_slider_plan9_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_slider_plan9_feat1'] = "650GB";
$_LANG['prosper_custom4_slider_plan9_feat2'] = "18TB";
$_LANG['prosper_custom4_slider_plan9_feat3'] = "20GB";
$_LANG['prosper_custom4_slider_plan9_feat4'] = "7";
$_LANG['prosper_custom4_slider_plan9_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan9_term'] = "/month";
$_LANG['prosper_custom4_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom4_slider_plan10_name'] = "Dedicated 10";
$_LANG['prosper_custom4_slider_plan10_desc'] = "The best Dedicated for experts";
$_LANG['prosper_custom4_slider_plan10_feat1'] = "700GB";
$_LANG['prosper_custom4_slider_plan10_feat2'] = "20TB";
$_LANG['prosper_custom4_slider_plan10_feat3'] = "22GB";
$_LANG['prosper_custom4_slider_plan10_feat4'] = "7";
$_LANG['prosper_custom4_slider_plan10_feat5'] = "LiteSpeed";
$_LANG['prosper_custom4_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom4_slider_plan10_term'] = "/month";
$_LANG['prosper_custom4_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Cloud Hosting page by default (File: cloud-hosting.tpl, cloud-hosting.php, includes/custom5.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom5_table_heading1'] = "Main Information";
$_LANG['prosper_custom5_table_feat1'] = "SSD Web Space";
$_LANG['prosper_custom5_table_feat2'] = "Data Transfer";
$_LANG['prosper_custom5_table_feat3'] = "Control Panel";

$_LANG['prosper_custom5_table_heading2'] = "Plan Comparison";
$_LANG['prosper_custom5_table_feat4'] = "SSD Web Space";
$_LANG['prosper_custom5_table_feat5'] = "Data Transfer";
$_LANG['prosper_custom5_table_feat6'] = "CPU Cores";
$_LANG['prosper_custom5_table_feat7'] = "Memory";
$_LANG['prosper_custom5_table_feat8'] = "Addon Domains";
$_LANG['prosper_custom5_table_feat9'] = "Control Panel";
$_LANG['prosper_custom5_table_feat10'] = "Script Installer";
$_LANG['prosper_custom5_table_feat11'] = "Daily Backups";
$_LANG['prosper_custom5_table_feat12'] = "Server";

$_LANG['prosper_custom5_table_heading3'] = "";
$_LANG['prosper_custom5_table_feat13'] = "";
$_LANG['prosper_custom5_table_feat14'] = "";
$_LANG['prosper_custom5_table_feat15'] = "";
$_LANG['prosper_custom5_table_feat16'] = "";
$_LANG['prosper_custom5_table_feat17'] = "";
$_LANG['prosper_custom5_table_feat18'] = "";
$_LANG['prosper_custom5_table_feat19'] = "";
$_LANG['prosper_custom5_table_feat20'] = "";
$_LANG['prosper_custom5_table_feat21'] = "";

$_LANG['prosper_custom5_table_heading4'] = "";
$_LANG['prosper_custom5_table_feat22'] = "";
$_LANG['prosper_custom5_table_feat23'] = "";
$_LANG['prosper_custom5_table_feat24'] = "";
$_LANG['prosper_custom5_table_feat25'] = "";
$_LANG['prosper_custom5_table_feat26'] = "";
$_LANG['prosper_custom5_table_feat27'] = "";
$_LANG['prosper_custom5_table_feat28'] = "";
$_LANG['prosper_custom5_table_feat29'] = "";
$_LANG['prosper_custom5_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom5_table_plan1_name'] = "Trial";
$_LANG['prosper_custom5_table_plan1_desc'] = "Perfect Cloud hosting plan for beginners";
$_LANG['prosper_custom5_table_plan1_pricepre'] = "";
$_LANG['prosper_custom5_table_plan1_term'] = "";
$_LANG['prosper_custom5_table_plan1_button'] = "Get Started";

// Plan 2

$_LANG['prosper_custom5_table_plan2_name'] = "Cloud 1";
$_LANG['prosper_custom5_table_plan2_desc'] = "Reliable low-cost Cloud hosting plan";
$_LANG['prosper_custom5_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom5_table_plan2_term'] = "/month";
$_LANG['prosper_custom5_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom5_table_plan3_name'] = "Cloud 2";
$_LANG['prosper_custom5_table_plan3_desc'] = "Advanced Cloud hosting package";
$_LANG['prosper_custom5_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom5_table_plan3_term'] = "/month";
$_LANG['prosper_custom5_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom5_table_plan4_name'] = "Cloud 3";
$_LANG['prosper_custom5_table_plan4_desc'] = "Professional Cloud hosting plan";
$_LANG['prosper_custom5_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom5_table_plan4_term'] = "/month";
$_LANG['prosper_custom5_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom5_table_plan5_name'] = "Cloud 4";
$_LANG['prosper_custom5_table_plan5_desc'] = "Suitable Cloud plan for web designers";
$_LANG['prosper_custom5_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom5_table_plan5_term'] = "/month";
$_LANG['prosper_custom5_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom5_table_plan6_name'] = "Cloud 5";
$_LANG['prosper_custom5_table_plan6_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom5_table_plan6_term'] = "/month";
$_LANG['prosper_custom5_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom5_table2_heading0'] = "Package";
$_LANG['prosper_custom5_table2_heading1'] = "SSD Web Space";
$_LANG['prosper_custom5_table2_heading2'] = "Data Transfer";
$_LANG['prosper_custom5_table2_heading3'] = "CPU Cores";
$_LANG['prosper_custom5_table2_heading4'] = "Memory";
$_LANG['prosper_custom5_table2_heading5'] = "Control Panel";
$_LANG['prosper_custom5_table2_heading6'] = "Script Installer";

// Plan 1

$_LANG['prosper_custom5_table2_plan1_name'] = "Trial";
$_LANG['prosper_custom5_table2_plan1_desc'] = "Perfect Cloud hosting plan for beginners";
$_LANG['prosper_custom5_table2_plan1_feat1'] = "100MB";
$_LANG['prosper_custom5_table2_plan1_feat2'] = "1GB";
$_LANG['prosper_custom5_table2_plan1_feat3'] = "4";
$_LANG['prosper_custom5_table2_plan1_feat4'] = "8GB";
$_LANG['prosper_custom5_table2_plan1_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan1_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan1_pricepre'] = "";
$_LANG['prosper_custom5_table2_plan1_term'] = "";
$_LANG['prosper_custom5_table2_plan1_button'] = "Get Started";

// Plan 2

$_LANG['prosper_custom5_table2_plan2_name'] = "Cloud 1";
$_LANG['prosper_custom5_table2_plan2_desc'] = "Reliable low-cost Cloud hosting plan";
$_LANG['prosper_custom5_table2_plan2_feat1'] = "10GB";
$_LANG['prosper_custom5_table2_plan2_feat2'] = "100GB";
$_LANG['prosper_custom5_table2_plan2_feat3'] = "4";
$_LANG['prosper_custom5_table2_plan2_feat4'] = "10GB";
$_LANG['prosper_custom5_table2_plan2_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan2_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan2_term'] = "/month";
$_LANG['prosper_custom5_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom5_table2_plan3_name'] = "Cloud 2";
$_LANG['prosper_custom5_table2_plan3_desc'] = "Advanced Cloud hosting package";
$_LANG['prosper_custom5_table2_plan3_feat1'] = "20GB";
$_LANG['prosper_custom5_table2_plan3_feat2'] = "200GB";
$_LANG['prosper_custom5_table2_plan3_feat3'] = "4";
$_LANG['prosper_custom5_table2_plan3_feat4'] = "12GB";
$_LANG['prosper_custom5_table2_plan3_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan3_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan3_term'] = "/month";
$_LANG['prosper_custom5_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom5_table2_plan4_name'] = "Cloud 3";
$_LANG['prosper_custom5_table2_plan4_desc'] = "Professional Cloud hosting plan";
$_LANG['prosper_custom5_table2_plan4_feat1'] = "30GB";
$_LANG['prosper_custom5_table2_plan4_feat2'] = "300GB";
$_LANG['prosper_custom5_table2_plan4_feat3'] = "4";
$_LANG['prosper_custom5_table2_plan4_feat4'] = "14GB";
$_LANG['prosper_custom5_table2_plan4_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan4_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan4_term'] = "/month";
$_LANG['prosper_custom5_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom5_table2_plan5_name'] = "Cloud 4";
$_LANG['prosper_custom5_table2_plan5_desc'] = "Suitable Cloud plan for web designers";
$_LANG['prosper_custom5_table2_plan5_feat1'] = "40GB";
$_LANG['prosper_custom5_table2_plan5_feat2'] = "400GB";
$_LANG['prosper_custom5_table2_plan5_feat3'] = "8";
$_LANG['prosper_custom5_table2_plan5_feat4'] = "16GB";
$_LANG['prosper_custom5_table2_plan5_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan5_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan5_term'] = "/month";
$_LANG['prosper_custom5_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom5_table2_plan6_name'] = "Cloud 5";
$_LANG['prosper_custom5_table2_plan6_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_table2_plan6_feat1'] = "50GB";
$_LANG['prosper_custom5_table2_plan6_feat2'] = "500GB";
$_LANG['prosper_custom5_table2_plan6_feat3'] = "8";
$_LANG['prosper_custom5_table2_plan6_feat4'] = "18GB";
$_LANG['prosper_custom5_table2_plan6_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan6_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan6_term'] = "/month";
$_LANG['prosper_custom5_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom5_table2_plan7_name'] = "Cloud 6";
$_LANG['prosper_custom5_table2_plan7_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_table2_plan7_feat1'] = "60GB";
$_LANG['prosper_custom5_table2_plan7_feat2'] = "600GB";
$_LANG['prosper_custom5_table2_plan7_feat3'] = "8";
$_LANG['prosper_custom5_table2_plan7_feat4'] = "20GB";
$_LANG['prosper_custom5_table2_plan7_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan7_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan7_term'] = "/month";
$_LANG['prosper_custom5_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom5_table2_plan8_name'] = "Cloud 7";
$_LANG['prosper_custom5_table2_plan8_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_table2_plan8_feat1'] = "70GB";
$_LANG['prosper_custom5_table2_plan8_feat2'] = "700GB";
$_LANG['prosper_custom5_table2_plan8_feat3'] = "8";
$_LANG['prosper_custom5_table2_plan8_feat4'] = "22GB";
$_LANG['prosper_custom5_table2_plan8_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan8_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan8_term'] = "/month";
$_LANG['prosper_custom5_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom5_table2_plan9_name'] = "Cloud 8";
$_LANG['prosper_custom5_table2_plan9_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_table2_plan9_feat1'] = "80GB";
$_LANG['prosper_custom5_table2_plan9_feat2'] = "800GB";
$_LANG['prosper_custom5_table2_plan9_feat3'] = "12";
$_LANG['prosper_custom5_table2_plan9_feat4'] = "24GB";
$_LANG['prosper_custom5_table2_plan9_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan9_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan9_term'] = "/month";
$_LANG['prosper_custom5_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom5_table2_plan10_name'] = "Cloud 9";
$_LANG['prosper_custom5_table2_plan10_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_table2_plan10_feat1'] = "90GB";
$_LANG['prosper_custom5_table2_plan10_feat2'] = "900GB";
$_LANG['prosper_custom5_table2_plan10_feat3'] = "12";
$_LANG['prosper_custom5_table2_plan10_feat4'] = "26GB";
$_LANG['prosper_custom5_table2_plan10_feat5'] = "cPanel";
$_LANG['prosper_custom5_table2_plan10_feat6'] = "Softaculous";
$_LANG['prosper_custom5_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom5_table2_plan10_term'] = "/month";
$_LANG['prosper_custom5_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom5_featureboxes_plan1_name'] = "Trial";
$_LANG['prosper_custom5_featureboxes_plan1_desc'] = "Perfect Cloud hosting plan for beginners";
$_LANG['prosper_custom5_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan1_feat1'] = "100MB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan1_feat2'] = "1GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan1_feat3'] = "5 Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan1_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan1_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan1_pricepre'] = "";
$_LANG['prosper_custom5_featureboxes_plan1_term'] = "";
$_LANG['prosper_custom5_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan1_button2'] = "Get Started";

// Plan 2

$_LANG['prosper_custom5_featureboxes_plan2_name'] = "Cloud 1";
$_LANG['prosper_custom5_featureboxes_plan2_desc'] = "Reliable low-cost Cloud hosting plan";
$_LANG['prosper_custom5_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan2_feat1'] = "10GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan2_feat2'] = "100GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan2_feat3'] = "10 Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan2_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan2_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan2_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom5_featureboxes_plan3_name'] = "Cloud 2";
$_LANG['prosper_custom5_featureboxes_plan3_desc'] = "Advanced Cloud hosting package";
$_LANG['prosper_custom5_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan3_feat1'] = "20GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan3_feat2'] = "200GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan3_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan3_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan3_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom5_featureboxes_plan4_name'] = "Cloud 3";
$_LANG['prosper_custom5_featureboxes_plan4_desc'] = "Professional Cloud hosting plan";
$_LANG['prosper_custom5_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan4_feat1'] = "30GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan4_feat2'] = "300GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan4_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan4_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan4_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan4_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom5_featureboxes_plan5_name'] = "Cloud 4";
$_LANG['prosper_custom5_featureboxes_plan5_desc'] = "Suitable Cloud plan for web designers";
$_LANG['prosper_custom5_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan5_feat1'] = "40GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan5_feat2'] = "400GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan5_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan5_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan5_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom5_featureboxes_plan6_name'] = "Cloud 5";
$_LANG['prosper_custom5_featureboxes_plan6_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan6_feat1'] = "50GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan6_feat2'] = "500GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan6_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan6_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan6_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan6_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom5_featureboxes_plan7_name'] = "Cloud 6";
$_LANG['prosper_custom5_featureboxes_plan7_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan7_feat1'] = "60GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan7_feat2'] = "600GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan7_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan7_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan7_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan7_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom5_featureboxes_plan8_name'] = "Cloud 7";
$_LANG['prosper_custom5_featureboxes_plan8_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan8_feat1'] = "70GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan8_feat2'] = "700GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan8_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan8_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan8_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan8_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom5_featureboxes_plan9_name'] = "Cloud 8";
$_LANG['prosper_custom5_featureboxes_plan9_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan9_feat1'] = "80GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan9_feat2'] = "800GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan9_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan9_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan9_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom5_featureboxes_plan10_name'] = "Cloud 9";
$_LANG['prosper_custom5_featureboxes_plan10_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan10_feat1'] = "90GB SSD Web Space";
$_LANG['prosper_custom5_featureboxes_plan10_feat2'] = "900GB Data Transfer";
$_LANG['prosper_custom5_featureboxes_plan10_feat3'] = "Unlimited Addon Domains";
$_LANG['prosper_custom5_featureboxes_plan10_feat4'] = "cPanel Control Panel";
$_LANG['prosper_custom5_featureboxes_plan10_feat5'] = "Softaculous Installer";
$_LANG['prosper_custom5_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom5_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom5_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom5_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom5_slider_heading1'] = "SSD Web Space";
$_LANG['prosper_custom5_slider_heading2'] = "Data Transfer";
$_LANG['prosper_custom5_slider_heading3'] = "CPU Cores";
$_LANG['prosper_custom5_slider_heading4'] = "Control Panel";
$_LANG['prosper_custom5_slider_heading5'] = "Script Installer";

// Plan 1

$_LANG['prosper_custom5_slider_plan1_name'] = "Trial";
$_LANG['prosper_custom5_slider_plan1_desc'] = "Perfect Cloud hosting plan for beginners";
$_LANG['prosper_custom5_slider_plan1_feat1'] = "100MB";
$_LANG['prosper_custom5_slider_plan1_feat2'] = "1GB";
$_LANG['prosper_custom5_slider_plan1_feat3'] = "4";
$_LANG['prosper_custom5_slider_plan1_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan1_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan1_pricepre'] = "";
$_LANG['prosper_custom5_slider_plan1_term'] = "";
$_LANG['prosper_custom5_slider_plan1_button'] = "Get Started";

// Plan 2

$_LANG['prosper_custom5_slider_plan2_name'] = "Cloud 1";
$_LANG['prosper_custom5_slider_plan2_desc'] = "Reliable low-cost Cloud hosting plan";
$_LANG['prosper_custom5_slider_plan2_feat1'] = "10GB";
$_LANG['prosper_custom5_slider_plan2_feat2'] = "100GB";
$_LANG['prosper_custom5_slider_plan2_feat3'] = "4";
$_LANG['prosper_custom5_slider_plan2_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan2_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan2_term'] = "/month";
$_LANG['prosper_custom5_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom5_slider_plan3_name'] = "Cloud 2";
$_LANG['prosper_custom5_slider_plan3_desc'] = "Advanced Cloud hosting package";
$_LANG['prosper_custom5_slider_plan3_feat1'] = "20GB";
$_LANG['prosper_custom5_slider_plan3_feat2'] = "200GB";
$_LANG['prosper_custom5_slider_plan3_feat3'] = "4";
$_LANG['prosper_custom5_slider_plan3_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan3_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan3_term'] = "/month";
$_LANG['prosper_custom5_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom5_slider_plan4_name'] = "Cloud 3";
$_LANG['prosper_custom5_slider_plan4_desc'] = "Professional Cloud hosting plan";
$_LANG['prosper_custom5_slider_plan4_feat1'] = "30GB";
$_LANG['prosper_custom5_slider_plan4_feat2'] = "300GB";
$_LANG['prosper_custom5_slider_plan4_feat3'] = "4";
$_LANG['prosper_custom5_slider_plan4_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan4_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan4_term'] = "/month";
$_LANG['prosper_custom5_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom5_slider_plan5_name'] = "Cloud 4";
$_LANG['prosper_custom5_slider_plan5_desc'] = "Suitable Cloud plan for web designers";
$_LANG['prosper_custom5_slider_plan5_feat1'] = "40GB";
$_LANG['prosper_custom5_slider_plan5_feat2'] = "400GB";
$_LANG['prosper_custom5_slider_plan5_feat3'] = "8";
$_LANG['prosper_custom5_slider_plan5_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan5_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan5_term'] = "/month";
$_LANG['prosper_custom5_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom5_slider_plan6_name'] = "Cloud 5";
$_LANG['prosper_custom5_slider_plan6_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_slider_plan6_feat1'] = "50GB";
$_LANG['prosper_custom5_slider_plan6_feat2'] = "500GB";
$_LANG['prosper_custom5_slider_plan6_feat3'] = "8";
$_LANG['prosper_custom5_slider_plan6_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan6_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan6_term'] = "/month";
$_LANG['prosper_custom5_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom5_slider_plan7_name'] = "Cloud 6";
$_LANG['prosper_custom5_slider_plan7_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_slider_plan7_feat1'] = "60GB";
$_LANG['prosper_custom5_slider_plan7_feat2'] = "600GB";
$_LANG['prosper_custom5_slider_plan7_feat3'] = "8";
$_LANG['prosper_custom5_slider_plan7_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan7_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan7_term'] = "/month";
$_LANG['prosper_custom5_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom5_slider_plan8_name'] = "Cloud 7";
$_LANG['prosper_custom5_slider_plan8_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_slider_plan8_feat1'] = "70GB";
$_LANG['prosper_custom5_slider_plan8_feat2'] = "700GB";
$_LANG['prosper_custom5_slider_plan8_feat3'] = "8";
$_LANG['prosper_custom5_slider_plan8_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan8_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan8_term'] = "/month";
$_LANG['prosper_custom5_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom5_slider_plan9_name'] = "Cloud 8";
$_LANG['prosper_custom5_slider_plan9_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_slider_plan9_feat1'] = "80GB";
$_LANG['prosper_custom5_slider_plan9_feat2'] = "800GB";
$_LANG['prosper_custom5_slider_plan9_feat3'] = "12";
$_LANG['prosper_custom5_slider_plan9_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan9_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan9_term'] = "/month";
$_LANG['prosper_custom5_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom5_slider_plan10_name'] = "Cloud 9";
$_LANG['prosper_custom5_slider_plan10_desc'] = "The best Cloud plan for experts";
$_LANG['prosper_custom5_slider_plan10_feat1'] = "90GB";
$_LANG['prosper_custom5_slider_plan10_feat2'] = "900GB";
$_LANG['prosper_custom5_slider_plan10_feat3'] = "12";
$_LANG['prosper_custom5_slider_plan10_feat4'] = "cPanel";
$_LANG['prosper_custom5_slider_plan10_feat5'] = "Softaculous";
$_LANG['prosper_custom5_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom5_slider_plan10_term'] = "/month";
$_LANG['prosper_custom5_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Game Servers page by default (File: game-servers.tpl, game-servers.php, includes/custom6.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom6_table_heading1'] = "Main Information";
$_LANG['prosper_custom6_table_feat1'] = "Control Panel";
$_LANG['prosper_custom6_table_feat2'] = "Low Ping";
$_LANG['prosper_custom6_table_feat3'] = "No Lagg";

$_LANG['prosper_custom6_table_heading2'] = "Server Comparison";
$_LANG['prosper_custom6_table_feat4'] = "Setup In Minutes";
$_LANG['prosper_custom6_table_feat5'] = "24x7 Support";
$_LANG['prosper_custom6_table_feat6'] = "Location Choice";
$_LANG['prosper_custom6_table_feat7'] = "Money Back Guarantee";
$_LANG['prosper_custom6_table_feat8'] = "Anti-DDoS";
$_LANG['prosper_custom6_table_feat9'] = "IPv4 & IPv6";
$_LANG['prosper_custom6_table_feat10'] = "Backup Storage";
$_LANG['prosper_custom6_table_feat11'] = "Failover IPs";
$_LANG['prosper_custom6_table_feat12'] = "Enviroments";

$_LANG['prosper_custom6_table_heading3'] = "";
$_LANG['prosper_custom6_table_feat13'] = "";
$_LANG['prosper_custom6_table_feat14'] = "";
$_LANG['prosper_custom6_table_feat15'] = "";
$_LANG['prosper_custom6_table_feat16'] = "";
$_LANG['prosper_custom6_table_feat17'] = "";
$_LANG['prosper_custom6_table_feat18'] = "";
$_LANG['prosper_custom6_table_feat19'] = "";
$_LANG['prosper_custom6_table_feat20'] = "";
$_LANG['prosper_custom6_table_feat21'] = "";

$_LANG['prosper_custom6_table_heading4'] = "";
$_LANG['prosper_custom6_table_feat22'] = "";
$_LANG['prosper_custom6_table_feat23'] = "";
$_LANG['prosper_custom6_table_feat24'] = "";
$_LANG['prosper_custom6_table_feat25'] = "";
$_LANG['prosper_custom6_table_feat26'] = "";
$_LANG['prosper_custom6_table_feat27'] = "";
$_LANG['prosper_custom6_table_feat28'] = "";
$_LANG['prosper_custom6_table_feat29'] = "";
$_LANG['prosper_custom6_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom6_table_plan1_name'] = "Minecraft";
$_LANG['prosper_custom6_table_plan1_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table_plan1_pricepre'] = "Only";
$_LANG['prosper_custom6_table_plan1_term'] = "/slot";
$_LANG['prosper_custom6_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom6_table_plan2_name'] = "Battlefield";
$_LANG['prosper_custom6_table_plan2_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom6_table_plan2_term'] = "/slot";
$_LANG['prosper_custom6_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom6_table_plan3_name'] = "Call Of Duty";
$_LANG['prosper_custom6_table_plan3_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom6_table_plan3_term'] = "/slot";
$_LANG['prosper_custom6_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom6_table_plan4_name'] = "Counter Strike";
$_LANG['prosper_custom6_table_plan4_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom6_table_plan4_term'] = "/slot";
$_LANG['prosper_custom6_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom6_table_plan5_name'] = "ARK";
$_LANG['prosper_custom6_table_plan5_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom6_table_plan5_term'] = "/slot";
$_LANG['prosper_custom6_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom6_table_plan6_name'] = "Crysis 2";
$_LANG['prosper_custom6_table_plan6_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom6_table_plan6_term'] = "/slot";
$_LANG['prosper_custom6_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom6_table2_heading0'] = "Game";
$_LANG['prosper_custom6_table2_heading1'] = "Control Panel";
$_LANG['prosper_custom6_table2_heading2'] = "Backup Storage";
$_LANG['prosper_custom6_table2_heading3'] = "Anti-DDoS";
$_LANG['prosper_custom6_table2_heading4'] = "Environments";
$_LANG['prosper_custom6_table2_heading5'] = "Support";
$_LANG['prosper_custom6_table2_heading6'] = "Location Choice";

// Plan 1

$_LANG['prosper_custom6_table2_plan1_name'] = "Minecraft";
$_LANG['prosper_custom6_table2_plan1_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan1_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan1_feat2'] = "100GB";
$_LANG['prosper_custom6_table2_plan1_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan1_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan1_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan1_feat6'] = "cross";
$_LANG['prosper_custom6_table2_plan1_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan1_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom6_table2_plan2_name'] = "Battlefield";
$_LANG['prosper_custom6_table2_plan2_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan2_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan2_feat2'] = "100GB";
$_LANG['prosper_custom6_table2_plan2_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan2_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan2_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan2_feat6'] = "cross";
$_LANG['prosper_custom6_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan2_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom6_table2_plan3_name'] = "Call Of Duty";
$_LANG['prosper_custom6_table2_plan3_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan3_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan3_feat2'] = "200GB";
$_LANG['prosper_custom6_table2_plan3_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan3_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan3_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan3_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan3_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom6_table2_plan4_name'] = "Counter Strike";
$_LANG['prosper_custom6_table2_plan4_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan4_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan4_feat2'] = "200GB";
$_LANG['prosper_custom6_table2_plan4_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan4_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan4_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan4_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom6_table2_plan5_name'] = "ARK";
$_LANG['prosper_custom6_table2_plan5_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan5_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan5_feat2'] = "300GB";
$_LANG['prosper_custom6_table2_plan5_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan5_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan5_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan5_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom6_table2_plan6_name'] = "Crysis 2";
$_LANG['prosper_custom6_table2_plan6_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan6_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan6_feat2'] = "300GB";
$_LANG['prosper_custom6_table2_plan6_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan6_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan6_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan6_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom6_table2_plan7_name'] = "Halo";
$_LANG['prosper_custom6_table2_plan7_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan7_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan7_feat2'] = "400GB";
$_LANG['prosper_custom6_table2_plan7_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan7_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan7_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan7_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom6_table2_plan8_name'] = "Quake 3";
$_LANG['prosper_custom6_table2_plan8_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan8_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan8_feat2'] = "400GB";
$_LANG['prosper_custom6_table2_plan8_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan8_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan8_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan8_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom6_table2_plan9_name'] = "Team Fortress 2";
$_LANG['prosper_custom6_table2_plan9_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan9_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan9_feat2'] = "500GB";
$_LANG['prosper_custom6_table2_plan9_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan9_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan9_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan9_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom6_table2_plan10_name'] = "Unreal Tournament";
$_LANG['prosper_custom6_table2_plan10_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_table2_plan10_feat1'] = "check";
$_LANG['prosper_custom6_table2_plan10_feat2'] = "500GB";
$_LANG['prosper_custom6_table2_plan10_feat3'] = "check";
$_LANG['prosper_custom6_table2_plan10_feat4'] = "90";
$_LANG['prosper_custom6_table2_plan10_feat5'] = "24/7";
$_LANG['prosper_custom6_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom6_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom6_table2_plan10_term'] = "/slot";
$_LANG['prosper_custom6_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom6_featureboxes_plan1_name'] = "Minecraft";
$_LANG['prosper_custom6_featureboxes_plan1_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan1_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan1_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan1_feat3'] = "100GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan1_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan1_feat5'] = "-";
$_LANG['prosper_custom6_featureboxes_plan1_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan1_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom6_featureboxes_plan2_name'] = "Battlefield";
$_LANG['prosper_custom6_featureboxes_plan2_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan2_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan2_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan2_feat3'] = "100GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan2_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan2_feat5'] = "-";
$_LANG['prosper_custom6_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan2_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom6_featureboxes_plan3_name'] = "Call Of Duty";
$_LANG['prosper_custom6_featureboxes_plan3_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan3_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan3_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan3_feat3'] = "200GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan3_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan3_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan3_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom6_featureboxes_plan4_name'] = "Counter Strike";
$_LANG['prosper_custom6_featureboxes_plan4_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan4_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan4_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan4_feat3'] = "200GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan4_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan4_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan4_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom6_featureboxes_plan5_name'] = "ARK";
$_LANG['prosper_custom6_featureboxes_plan5_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan5_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan5_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan5_feat3'] = "300GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan5_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan5_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan5_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom6_featureboxes_plan6_name'] = "Crysis 2";
$_LANG['prosper_custom6_featureboxes_plan6_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan6_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan6_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan6_feat3'] = "300GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan6_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan6_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan6_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom6_featureboxes_plan7_name'] = "Halo";
$_LANG['prosper_custom6_featureboxes_plan7_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan7_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan7_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan7_feat3'] = "400GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan7_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan7_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan7_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom6_featureboxes_plan8_name'] = "Quake 3";
$_LANG['prosper_custom6_featureboxes_plan8_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan8_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan8_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan8_feat3'] = "400GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan8_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan8_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan8_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom6_featureboxes_plan9_name'] = "Team Fortress 2";
$_LANG['prosper_custom6_featureboxes_plan9_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan9_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan9_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan9_feat3'] = "500GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan9_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan9_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan9_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom6_featureboxes_plan10_name'] = "Unreal Tournament";
$_LANG['prosper_custom6_featureboxes_plan10_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan10_feat1'] = "Control Panel";
$_LANG['prosper_custom6_featureboxes_plan10_feat2'] = "Anti-DDoS";
$_LANG['prosper_custom6_featureboxes_plan10_feat3'] = "500GB Backup Storage";
$_LANG['prosper_custom6_featureboxes_plan10_feat4'] = "24/7 Support";
$_LANG['prosper_custom6_featureboxes_plan10_feat5'] = "Location Choice";
$_LANG['prosper_custom6_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom6_featureboxes_plan10_term'] = "/slot";
$_LANG['prosper_custom6_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom6_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom6_slider_heading1'] = "Control Panel";
$_LANG['prosper_custom6_slider_heading2'] = "Backup Storage";
$_LANG['prosper_custom6_slider_heading3'] = "Anti-DDoS";
$_LANG['prosper_custom6_slider_heading4'] = "Environments";
$_LANG['prosper_custom6_slider_heading5'] = "Location Choice";

// Plan 1

$_LANG['prosper_custom6_slider_plan1_name'] = "Minecraft";
$_LANG['prosper_custom6_slider_plan1_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan1_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan1_feat2'] = "100GB";
$_LANG['prosper_custom6_slider_plan1_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan1_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan1_feat5'] = "cross";
$_LANG['prosper_custom6_slider_plan1_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan1_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom6_slider_plan2_name'] = "Battlefield";
$_LANG['prosper_custom6_slider_plan2_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan2_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan2_feat2'] = "100GB";
$_LANG['prosper_custom6_slider_plan2_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan2_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan2_feat5'] = "cross";
$_LANG['prosper_custom6_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan2_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom6_slider_plan3_name'] = "Call Of Duty";
$_LANG['prosper_custom6_slider_plan3_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan3_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan3_feat2'] = "200GB";
$_LANG['prosper_custom6_slider_plan3_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan3_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan3_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan3_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom6_slider_plan4_name'] = "Counter Strike";
$_LANG['prosper_custom6_slider_plan4_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan4_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan4_feat2'] = "200GB";
$_LANG['prosper_custom6_slider_plan4_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan4_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan4_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan4_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom6_slider_plan5_name'] = "ARK";
$_LANG['prosper_custom6_slider_plan5_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan5_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan5_feat2'] = "300GB";
$_LANG['prosper_custom6_slider_plan5_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan5_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan5_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan5_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom6_slider_plan6_name'] = "Crysis 2";
$_LANG['prosper_custom6_slider_plan6_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan6_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan6_feat2'] = "300GB";
$_LANG['prosper_custom6_slider_plan6_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan6_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan6_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan6_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom6_slider_plan7_name'] = "Halo";
$_LANG['prosper_custom6_slider_plan7_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan7_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan7_feat2'] = "400GB";
$_LANG['prosper_custom6_slider_plan7_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan7_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan7_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan7_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom6_slider_plan8_name'] = "Quake 3";
$_LANG['prosper_custom6_slider_plan8_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan8_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan8_feat2'] = "400GB";
$_LANG['prosper_custom6_slider_plan8_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan8_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan8_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan8_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom6_slider_plan9_name'] = "Team Fortress 2";
$_LANG['prosper_custom6_slider_plan9_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan9_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan9_feat2'] = "500GB";
$_LANG['prosper_custom6_slider_plan9_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan9_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan9_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan9_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom6_slider_plan10_name'] = "Unreal Tournament";
$_LANG['prosper_custom6_slider_plan10_desc'] = "Reliable & fast Game Server";
$_LANG['prosper_custom6_slider_plan10_feat1'] = "check";
$_LANG['prosper_custom6_slider_plan10_feat2'] = "500GB";
$_LANG['prosper_custom6_slider_plan10_feat3'] = "check";
$_LANG['prosper_custom6_slider_plan10_feat4'] = "90";
$_LANG['prosper_custom6_slider_plan10_feat5'] = "check";
$_LANG['prosper_custom6_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom6_slider_plan10_term'] = "/slot";
$_LANG['prosper_custom6_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Virtual Private Network page by default (File: virtual-private-network.tpl, virtual-private-network.php, includes/custom7.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom7_table_heading1'] = "Main Information";
$_LANG['prosper_custom7_table_feat1'] = "Users";
$_LANG['prosper_custom7_table_feat2'] = "Concurrent Devices";
$_LANG['prosper_custom7_table_feat3'] = "Bandwidth";

$_LANG['prosper_custom7_table_heading2'] = "VPN Comparison";
$_LANG['prosper_custom7_table_feat4'] = "Servers";
$_LANG['prosper_custom7_table_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_table_feat6'] = "Windows &amp; Mac";
$_LANG['prosper_custom7_table_feat7'] = "Desktop &amp; Mobile App";
$_LANG['prosper_custom7_table_feat8'] = "Setup In Minutes";
$_LANG['prosper_custom7_table_feat9'] = "24x7 Support";
$_LANG['prosper_custom7_table_feat10'] = "Money Back Guarantee";
$_LANG['prosper_custom7_table_feat11'] = "No Logs";
$_LANG['prosper_custom7_table_feat12'] = "Cancel Anytime";

$_LANG['prosper_custom7_table_heading3'] = "";
$_LANG['prosper_custom7_table_feat13'] = "";
$_LANG['prosper_custom7_table_feat14'] = "";
$_LANG['prosper_custom7_table_feat15'] = "";
$_LANG['prosper_custom7_table_feat16'] = "";
$_LANG['prosper_custom7_table_feat17'] = "";
$_LANG['prosper_custom7_table_feat18'] = "";
$_LANG['prosper_custom7_table_feat19'] = "";
$_LANG['prosper_custom7_table_feat20'] = "";
$_LANG['prosper_custom7_table_feat21'] = "";

$_LANG['prosper_custom7_table_heading4'] = "";
$_LANG['prosper_custom7_table_feat22'] = "";
$_LANG['prosper_custom7_table_feat23'] = "";
$_LANG['prosper_custom7_table_feat24'] = "";
$_LANG['prosper_custom7_table_feat25'] = "";
$_LANG['prosper_custom7_table_feat26'] = "";
$_LANG['prosper_custom7_table_feat27'] = "";
$_LANG['prosper_custom7_table_feat28'] = "";
$_LANG['prosper_custom7_table_feat29'] = "";
$_LANG['prosper_custom7_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom7_table_plan1_name'] = "VPN 1";
$_LANG['prosper_custom7_table_plan1_desc'] = "Perfect VPN plan for beginners";
$_LANG['prosper_custom7_table_plan1_pricepre'] = "";
$_LANG['prosper_custom7_table_plan1_term'] = "/user";
$_LANG['prosper_custom7_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom7_table_plan2_name'] = "VPN 2";
$_LANG['prosper_custom7_table_plan2_desc'] = "Reliable low-cost VPN plan";
$_LANG['prosper_custom7_table_plan2_pricepre'] = "";
$_LANG['prosper_custom7_table_plan2_term'] = "/user";
$_LANG['prosper_custom7_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom7_table_plan3_name'] = "VPN 3";
$_LANG['prosper_custom7_table_plan3_desc'] = "Advanced VPN package";
$_LANG['prosper_custom7_table_plan3_pricepre'] = "";
$_LANG['prosper_custom7_table_plan3_term'] = "/user";
$_LANG['prosper_custom7_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom7_table_plan4_name'] = "VPN 4";
$_LANG['prosper_custom7_table_plan4_desc'] = "Professional VPN plan";
$_LANG['prosper_custom7_table_plan4_pricepre'] = "";
$_LANG['prosper_custom7_table_plan4_term'] = "/user";
$_LANG['prosper_custom7_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom7_table_plan5_name'] = "VPN 5";
$_LANG['prosper_custom7_table_plan5_desc'] = "Suitable VPN plan for web designers";
$_LANG['prosper_custom7_table_plan5_pricepre'] = "";
$_LANG['prosper_custom7_table_plan5_term'] = "/user";
$_LANG['prosper_custom7_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom7_table_plan6_name'] = "VPN 6";
$_LANG['prosper_custom7_table_plan6_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_table_plan6_pricepre'] = "";
$_LANG['prosper_custom7_table_plan6_term'] = "/user";
$_LANG['prosper_custom7_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom7_table2_heading0'] = "VPN";
$_LANG['prosper_custom7_table2_heading1'] = "Users";
$_LANG['prosper_custom7_table2_heading2'] = "Concurrent Devices";
$_LANG['prosper_custom7_table2_heading3'] = "Bandwidth";
$_LANG['prosper_custom7_table2_heading4'] = "Servers";
$_LANG['prosper_custom7_table2_heading5'] = "Support";
$_LANG['prosper_custom7_table2_heading6'] = "Setup";

// Plan 1

$_LANG['prosper_custom7_table2_plan1_name'] = "VPN 1";
$_LANG['prosper_custom7_table2_plan1_desc'] = "Perfect VPN plan for beginners";
$_LANG['prosper_custom7_table2_plan1_feat1'] = "1";
$_LANG['prosper_custom7_table2_plan1_feat2'] = "2";
$_LANG['prosper_custom7_table2_plan1_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan1_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan1_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan1_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan1_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan1_term'] = "/user";
$_LANG['prosper_custom7_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom7_table2_plan2_name'] = "VPN 2";
$_LANG['prosper_custom7_table2_plan2_desc'] = "Reliable low-cost VPN plan";
$_LANG['prosper_custom7_table2_plan2_feat1'] = "2";
$_LANG['prosper_custom7_table2_plan2_feat2'] = "4";
$_LANG['prosper_custom7_table2_plan2_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan2_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan2_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan2_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan2_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan2_term'] = "/user";
$_LANG['prosper_custom7_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom7_table2_plan3_name'] = "VPN 3";
$_LANG['prosper_custom7_table2_plan3_desc'] = "Advanced VPN package";
$_LANG['prosper_custom7_table2_plan3_feat1'] = "3";
$_LANG['prosper_custom7_table2_plan3_feat2'] = "6";
$_LANG['prosper_custom7_table2_plan3_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan3_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan3_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan3_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan3_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan3_term'] = "/user";
$_LANG['prosper_custom7_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom7_table2_plan4_name'] = "VPN 4";
$_LANG['prosper_custom7_table2_plan4_desc'] = "Professional VPN plan";
$_LANG['prosper_custom7_table2_plan4_feat1'] = "4";
$_LANG['prosper_custom7_table2_plan4_feat2'] = "8";
$_LANG['prosper_custom7_table2_plan4_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan4_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan4_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan4_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan4_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan4_term'] = "/user";
$_LANG['prosper_custom7_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom7_table2_plan5_name'] = "VPN 5";
$_LANG['prosper_custom7_table2_plan5_desc'] = "Suitable VPN plan for web designers";
$_LANG['prosper_custom7_table2_plan5_feat1'] = "5";
$_LANG['prosper_custom7_table2_plan5_feat2'] = "10";
$_LANG['prosper_custom7_table2_plan5_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan5_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan5_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan5_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan5_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan5_term'] = "/user";
$_LANG['prosper_custom7_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom7_table2_plan6_name'] = "VPN 6";
$_LANG['prosper_custom7_table2_plan6_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_table2_plan6_feat1'] = "6";
$_LANG['prosper_custom7_table2_plan6_feat2'] = "12";
$_LANG['prosper_custom7_table2_plan6_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan6_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan6_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan6_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan6_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan6_term'] = "/user";
$_LANG['prosper_custom7_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom7_table2_plan7_name'] = "VPN 7";
$_LANG['prosper_custom7_table2_plan7_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_table2_plan7_feat1'] = "7";
$_LANG['prosper_custom7_table2_plan7_feat2'] = "14";
$_LANG['prosper_custom7_table2_plan7_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan7_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan7_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan7_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan7_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan7_term'] = "/user";
$_LANG['prosper_custom7_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom7_table2_plan8_name'] = "VPN 8";
$_LANG['prosper_custom7_table2_plan8_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_table2_plan8_feat1'] = "8";
$_LANG['prosper_custom7_table2_plan8_feat2'] = "16";
$_LANG['prosper_custom7_table2_plan8_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan8_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan8_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan8_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan8_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan8_term'] = "/user";
$_LANG['prosper_custom7_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom7_table2_plan9_name'] = "VPN 9";
$_LANG['prosper_custom7_table2_plan9_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_table2_plan9_feat1'] = "9";
$_LANG['prosper_custom7_table2_plan9_feat2'] = "18";
$_LANG['prosper_custom7_table2_plan9_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan9_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan9_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan9_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan9_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan9_term'] = "/user";
$_LANG['prosper_custom7_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom7_table2_plan10_name'] = "VPN 10";
$_LANG['prosper_custom7_table2_plan10_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_table2_plan10_feat1'] = "10";
$_LANG['prosper_custom7_table2_plan10_feat2'] = "20";
$_LANG['prosper_custom7_table2_plan10_feat3'] = "Unlimited";
$_LANG['prosper_custom7_table2_plan10_feat4'] = "5000+";
$_LANG['prosper_custom7_table2_plan10_feat5'] = "24/7";
$_LANG['prosper_custom7_table2_plan10_feat6'] = "Minutes";
$_LANG['prosper_custom7_table2_plan10_pricepre'] = "";
$_LANG['prosper_custom7_table2_plan10_term'] = "/user";
$_LANG['prosper_custom7_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom7_featureboxes_plan1_name'] = "VPN 1";
$_LANG['prosper_custom7_featureboxes_plan1_desc'] = "Perfect VPN plan for beginners";
$_LANG['prosper_custom7_featureboxes_plan1_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan1_feat1'] = "1 User";
$_LANG['prosper_custom7_featureboxes_plan1_feat2'] = "2 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan1_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan1_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan1_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan1_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan1_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom7_featureboxes_plan2_name'] = "VPN 2";
$_LANG['prosper_custom7_featureboxes_plan2_desc'] = "Reliable low-cost VPN plan";
$_LANG['prosper_custom7_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan2_feat1'] = "2 Users";
$_LANG['prosper_custom7_featureboxes_plan2_feat2'] = "4 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan2_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan2_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan2_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan2_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan2_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom7_featureboxes_plan3_name'] = "VPN 3";
$_LANG['prosper_custom7_featureboxes_plan3_desc'] = "Advanced VPN package";
$_LANG['prosper_custom7_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan3_feat1'] = "3 Users";
$_LANG['prosper_custom7_featureboxes_plan3_feat2'] = "6 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan3_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan3_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan3_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan3_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan3_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom7_featureboxes_plan4_name'] = "VPN 4";
$_LANG['prosper_custom7_featureboxes_plan4_desc'] = "Professional VPN plan";
$_LANG['prosper_custom7_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan4_feat1'] = "4 Users";
$_LANG['prosper_custom7_featureboxes_plan4_feat2'] = "8 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan4_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan4_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan4_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan4_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan4_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom7_featureboxes_plan5_name'] = "VPN 5";
$_LANG['prosper_custom7_featureboxes_plan5_desc'] = "Suitable VPN plan for web designers";
$_LANG['prosper_custom7_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan5_feat1'] = "5 Users";
$_LANG['prosper_custom7_featureboxes_plan5_feat2'] = "10 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan5_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan5_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan5_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan5_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan5_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom7_featureboxes_plan6_name'] = "VPN 6";
$_LANG['prosper_custom7_featureboxes_plan6_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan6_feat1'] = "6 Users";
$_LANG['prosper_custom7_featureboxes_plan6_feat2'] = "12 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan6_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan6_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan6_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan6_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan6_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom7_featureboxes_plan7_name'] = "VPN 7";
$_LANG['prosper_custom7_featureboxes_plan7_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan7_feat1'] = "7 Users";
$_LANG['prosper_custom7_featureboxes_plan7_feat2'] = "14 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan7_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan7_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan7_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan7_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan7_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom7_featureboxes_plan8_name'] = "VPN 8";
$_LANG['prosper_custom7_featureboxes_plan8_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan8_feat1'] = "8 Users";
$_LANG['prosper_custom7_featureboxes_plan8_feat2'] = "16 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan8_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan8_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan8_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan8_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan8_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom7_featureboxes_plan9_name'] = "VPN 9";
$_LANG['prosper_custom7_featureboxes_plan9_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan9_feat1'] = "9 Users";
$_LANG['prosper_custom7_featureboxes_plan9_feat2'] = "18 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan9_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan9_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan9_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan9_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan9_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom7_featureboxes_plan10_name'] = "VPN 10";
$_LANG['prosper_custom7_featureboxes_plan10_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan10_feat1'] = "10 Users";
$_LANG['prosper_custom7_featureboxes_plan10_feat2'] = "20 Concurrent Devices";
$_LANG['prosper_custom7_featureboxes_plan10_feat3'] = "Unlimited Bandwidth";
$_LANG['prosper_custom7_featureboxes_plan10_feat4'] = "5000+ Servers";
$_LANG['prosper_custom7_featureboxes_plan10_feat5'] = "Military Grade Encryption";
$_LANG['prosper_custom7_featureboxes_plan10_pricepre'] = "";
$_LANG['prosper_custom7_featureboxes_plan10_term'] = "/user";
$_LANG['prosper_custom7_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom7_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom7_slider_heading1'] = "Users";
$_LANG['prosper_custom7_slider_heading2'] = "Concurrent Devices";
$_LANG['prosper_custom7_slider_heading3'] = "Bandwidth";
$_LANG['prosper_custom7_slider_heading4'] = "Servers";
$_LANG['prosper_custom7_slider_heading5'] = "Setup";

// Plan 1

$_LANG['prosper_custom7_slider_plan1_name'] = "VPN 1";
$_LANG['prosper_custom7_slider_plan1_desc'] = "Perfect VPN plan for beginners";
$_LANG['prosper_custom7_slider_plan1_feat1'] = "1";
$_LANG['prosper_custom7_slider_plan1_feat2'] = "2";
$_LANG['prosper_custom7_slider_plan1_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan1_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan1_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan1_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan1_term'] = "/user";
$_LANG['prosper_custom7_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom7_slider_plan2_name'] = "VPN 2";
$_LANG['prosper_custom7_slider_plan2_desc'] = "Reliable low-cost VPN plan";
$_LANG['prosper_custom7_slider_plan2_feat1'] = "2";
$_LANG['prosper_custom7_slider_plan2_feat2'] = "4";
$_LANG['prosper_custom7_slider_plan2_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan2_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan2_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan2_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan2_term'] = "/user";
$_LANG['prosper_custom7_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom7_slider_plan3_name'] = "VPN 3";
$_LANG['prosper_custom7_slider_plan3_desc'] = "Advanced VPN package";
$_LANG['prosper_custom7_slider_plan3_feat1'] = "3";
$_LANG['prosper_custom7_slider_plan3_feat2'] = "6";
$_LANG['prosper_custom7_slider_plan3_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan3_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan3_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan3_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan3_term'] = "/user";
$_LANG['prosper_custom7_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom7_slider_plan4_name'] = "VPN 4";
$_LANG['prosper_custom7_slider_plan4_desc'] = "Professional VPN plan";
$_LANG['prosper_custom7_slider_plan4_feat1'] = "4";
$_LANG['prosper_custom7_slider_plan4_feat2'] = "8";
$_LANG['prosper_custom7_slider_plan4_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan4_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan4_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan4_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan4_term'] = "/user";
$_LANG['prosper_custom7_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom7_slider_plan5_name'] = "VPN 5";
$_LANG['prosper_custom7_slider_plan5_desc'] = "Suitable VPN plan for web designers";
$_LANG['prosper_custom7_slider_plan5_feat1'] = "5";
$_LANG['prosper_custom7_slider_plan5_feat2'] = "10";
$_LANG['prosper_custom7_slider_plan5_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan5_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan5_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan5_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan5_term'] = "/user";
$_LANG['prosper_custom7_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom7_slider_plan6_name'] = "VPN 6";
$_LANG['prosper_custom7_slider_plan6_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_slider_plan6_feat1'] = "6";
$_LANG['prosper_custom7_slider_plan6_feat2'] = "12";
$_LANG['prosper_custom7_slider_plan6_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan6_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan6_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan6_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan6_term'] = "/user";
$_LANG['prosper_custom7_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom7_slider_plan7_name'] = "VPN 7";
$_LANG['prosper_custom7_slider_plan7_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_slider_plan7_feat1'] = "7";
$_LANG['prosper_custom7_slider_plan7_feat2'] = "14";
$_LANG['prosper_custom7_slider_plan7_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan7_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan7_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan7_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan7_term'] = "/user";
$_LANG['prosper_custom7_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom7_slider_plan8_name'] = "VPN 8";
$_LANG['prosper_custom7_slider_plan8_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_slider_plan8_feat1'] = "8";
$_LANG['prosper_custom7_slider_plan8_feat2'] = "16";
$_LANG['prosper_custom7_slider_plan8_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan8_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan8_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan8_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan8_term'] = "/user";
$_LANG['prosper_custom7_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom7_slider_plan9_name'] = "VPN 9";
$_LANG['prosper_custom7_slider_plan9_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_slider_plan9_feat1'] = "9";
$_LANG['prosper_custom7_slider_plan9_feat2'] = "18";
$_LANG['prosper_custom7_slider_plan9_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan9_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan9_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan9_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan9_term'] = "/user";
$_LANG['prosper_custom7_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom7_slider_plan10_name'] = "VPN 10";
$_LANG['prosper_custom7_slider_plan10_desc'] = "The best VPN plan for experts";
$_LANG['prosper_custom7_slider_plan10_feat1'] = "10";
$_LANG['prosper_custom7_slider_plan10_feat2'] = "20";
$_LANG['prosper_custom7_slider_plan10_feat3'] = "Unlimited";
$_LANG['prosper_custom7_slider_plan10_feat4'] = "6000+";
$_LANG['prosper_custom7_slider_plan10_feat5'] = "Minutes";
$_LANG['prosper_custom7_slider_plan10_pricepre'] = "";
$_LANG['prosper_custom7_slider_plan10_term'] = "/user";
$_LANG['prosper_custom7_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   IPTV page by default (File: iptv.tpl, iptv.php, includes/custom8.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom8_table_heading1'] = "Main Information";
$_LANG['prosper_custom8_table_feat1'] = "Users";
$_LANG['prosper_custom8_table_feat2'] = "Movies";
$_LANG['prosper_custom8_table_feat3'] = "TV Shows";

$_LANG['prosper_custom8_table_heading2'] = "Package Comparison";
$_LANG['prosper_custom8_table_feat4'] = "Concurrent Devices";
$_LANG['prosper_custom8_table_feat5'] = "Users";
$_LANG['prosper_custom8_table_feat6'] = "Live TV";
$_LANG['prosper_custom8_table_feat7'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_table_feat8'] = "TV Guide";
$_LANG['prosper_custom8_table_feat9'] = "Windows &amp; Mac";
$_LANG['prosper_custom8_table_feat10'] = "Desktop &amp; Mobile App";
$_LANG['prosper_custom8_table_feat11'] = "24/7 Support";
$_LANG['prosper_custom8_table_feat12'] = "Cancel Anytime";

$_LANG['prosper_custom8_table_heading3'] = "";
$_LANG['prosper_custom8_table_feat13'] = "";
$_LANG['prosper_custom8_table_feat14'] = "";
$_LANG['prosper_custom8_table_feat15'] = "";
$_LANG['prosper_custom8_table_feat16'] = "";
$_LANG['prosper_custom8_table_feat17'] = "";
$_LANG['prosper_custom8_table_feat18'] = "";
$_LANG['prosper_custom8_table_feat19'] = "";
$_LANG['prosper_custom8_table_feat20'] = "";
$_LANG['prosper_custom8_table_feat21'] = "";

$_LANG['prosper_custom8_table_heading4'] = "";
$_LANG['prosper_custom8_table_feat22'] = "";
$_LANG['prosper_custom8_table_feat23'] = "";
$_LANG['prosper_custom8_table_feat24'] = "";
$_LANG['prosper_custom8_table_feat25'] = "";
$_LANG['prosper_custom8_table_feat26'] = "";
$_LANG['prosper_custom8_table_feat27'] = "";
$_LANG['prosper_custom8_table_feat28'] = "";
$_LANG['prosper_custom8_table_feat29'] = "";
$_LANG['prosper_custom8_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom8_table_plan1_name'] = "IPTV 1";
$_LANG['prosper_custom8_table_plan1_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table_plan1_pricepre'] = "Only";
$_LANG['prosper_custom8_table_plan1_term'] = "/month";
$_LANG['prosper_custom8_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom8_table_plan2_name'] = "IPTV 2";
$_LANG['prosper_custom8_table_plan2_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table_plan2_pricepre'] = "Only";
$_LANG['prosper_custom8_table_plan2_term'] = "/month";
$_LANG['prosper_custom8_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom8_table_plan3_name'] = "IPTV 3";
$_LANG['prosper_custom8_table_plan3_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table_plan3_pricepre'] = "Only";
$_LANG['prosper_custom8_table_plan3_term'] = "/month";
$_LANG['prosper_custom8_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom8_table_plan4_name'] = "IPTV 4";
$_LANG['prosper_custom8_table_plan4_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table_plan4_pricepre'] = "Only";
$_LANG['prosper_custom8_table_plan4_term'] = "/month";
$_LANG['prosper_custom8_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom8_table_plan5_name'] = "IPTV 5";
$_LANG['prosper_custom8_table_plan5_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table_plan5_pricepre'] = "Only";
$_LANG['prosper_custom8_table_plan5_term'] = "/month";
$_LANG['prosper_custom8_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom8_table_plan6_name'] = "IPTV 6";
$_LANG['prosper_custom8_table_plan6_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table_plan6_pricepre'] = "Only";
$_LANG['prosper_custom8_table_plan6_term'] = "/month";
$_LANG['prosper_custom8_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom8_table2_heading0'] = "IPTV";
$_LANG['prosper_custom8_table2_heading1'] = "Users";
$_LANG['prosper_custom8_table2_heading2'] = "Movies";
$_LANG['prosper_custom8_table2_heading3'] = "TV Shows";
$_LANG['prosper_custom8_table2_heading4'] = "Devices";
$_LANG['prosper_custom8_table2_heading5'] = "Live TV";
$_LANG['prosper_custom8_table2_heading6'] = "24/7 Support";

// Plan 1

$_LANG['prosper_custom8_table2_plan1_name'] = "IPTV 1";
$_LANG['prosper_custom8_table2_plan1_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan1_feat1'] = "1";
$_LANG['prosper_custom8_table2_plan1_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan1_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan1_feat4'] = "2";
$_LANG['prosper_custom8_table2_plan1_feat5'] = "cross";
$_LANG['prosper_custom8_table2_plan1_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan1_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan1_term'] = "/month";
$_LANG['prosper_custom8_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom8_table2_plan2_name'] = "IPTV 2";
$_LANG['prosper_custom8_table2_plan2_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan2_feat1'] = "2";
$_LANG['prosper_custom8_table2_plan2_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan2_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan2_feat4'] = "4";
$_LANG['prosper_custom8_table2_plan2_feat5'] = "cross";
$_LANG['prosper_custom8_table2_plan2_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan2_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan2_term'] = "/month";
$_LANG['prosper_custom8_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom8_table2_plan3_name'] = "IPTV 3";
$_LANG['prosper_custom8_table2_plan3_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan3_feat1'] = "3";
$_LANG['prosper_custom8_table2_plan3_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan3_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan3_feat4'] = "6";
$_LANG['prosper_custom8_table2_plan3_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan3_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan3_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan3_term'] = "/month";
$_LANG['prosper_custom8_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom8_table2_plan4_name'] = "IPTV 4";
$_LANG['prosper_custom8_table2_plan4_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan4_feat1'] = "4";
$_LANG['prosper_custom8_table2_plan4_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan4_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan4_feat4'] = "8";
$_LANG['prosper_custom8_table2_plan4_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan4_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan4_term'] = "/month";
$_LANG['prosper_custom8_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom8_table2_plan5_name'] = "IPTV 5";
$_LANG['prosper_custom8_table2_plan5_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan5_feat1'] = "5";
$_LANG['prosper_custom8_table2_plan5_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan5_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan5_feat4'] = "10";
$_LANG['prosper_custom8_table2_plan5_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan5_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan5_term'] = "/month";
$_LANG['prosper_custom8_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom8_table2_plan6_name'] = "IPTV 6";
$_LANG['prosper_custom8_table2_plan6_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan6_feat1'] = "6";
$_LANG['prosper_custom8_table2_plan6_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan6_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan6_feat4'] = "12";
$_LANG['prosper_custom8_table2_plan6_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan6_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan6_term'] = "/month";
$_LANG['prosper_custom8_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom8_table2_plan7_name'] = "IPTV 7";
$_LANG['prosper_custom8_table2_plan7_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan7_feat1'] = "7";
$_LANG['prosper_custom8_table2_plan7_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan7_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan7_feat4'] = "14";
$_LANG['prosper_custom8_table2_plan7_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan7_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan7_term'] = "/month";
$_LANG['prosper_custom8_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom8_table2_plan8_name'] = "IPTV 8";
$_LANG['prosper_custom8_table2_plan8_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan8_feat1'] = "8";
$_LANG['prosper_custom8_table2_plan8_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan8_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan8_feat4'] = "16";
$_LANG['prosper_custom8_table2_plan8_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan8_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan8_term'] = "/month";
$_LANG['prosper_custom8_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom8_table2_plan9_name'] = "IPTV 9";
$_LANG['prosper_custom8_table2_plan9_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan9_feat1'] = "9";
$_LANG['prosper_custom8_table2_plan9_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan9_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan9_feat4'] = "18";
$_LANG['prosper_custom8_table2_plan9_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan9_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan9_term'] = "/month";
$_LANG['prosper_custom8_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom8_table2_plan10_name'] = "IPTV 10";
$_LANG['prosper_custom8_table2_plan10_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_table2_plan10_feat1'] = "10";
$_LANG['prosper_custom8_table2_plan10_feat2'] = "40,000+";
$_LANG['prosper_custom8_table2_plan10_feat3'] = "30,000+";
$_LANG['prosper_custom8_table2_plan10_feat4'] = "20";
$_LANG['prosper_custom8_table2_plan10_feat5'] = "check";
$_LANG['prosper_custom8_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom8_table2_plan10_pricepre'] = "Only";
$_LANG['prosper_custom8_table2_plan10_term'] = "/month";
$_LANG['prosper_custom8_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom8_featureboxes_plan1_name'] = "IPTV 1";
$_LANG['prosper_custom8_featureboxes_plan1_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan1_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan1_feat1'] = "1 User";
$_LANG['prosper_custom8_featureboxes_plan1_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan1_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan1_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan1_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan1_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan1_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan1_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom8_featureboxes_plan2_name'] = "IPTV 2";
$_LANG['prosper_custom8_featureboxes_plan2_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan2_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan2_feat1'] = "2 Users";
$_LANG['prosper_custom8_featureboxes_plan2_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan2_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan2_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan2_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan2_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan2_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom8_featureboxes_plan3_name'] = "IPTV 3";
$_LANG['prosper_custom8_featureboxes_plan3_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan3_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan3_feat1'] = "3 Users";
$_LANG['prosper_custom8_featureboxes_plan3_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan3_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan3_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan3_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan3_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom8_featureboxes_plan4_name'] = "IPTV 4";
$_LANG['prosper_custom8_featureboxes_plan4_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan4_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan4_feat1'] = "4 Users";
$_LANG['prosper_custom8_featureboxes_plan4_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan4_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan4_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan4_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan4_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan4_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom8_featureboxes_plan5_name'] = "IPTV 5";
$_LANG['prosper_custom8_featureboxes_plan5_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan5_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan5_feat1'] = "5 Users";
$_LANG['prosper_custom8_featureboxes_plan5_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan5_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan5_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan5_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan5_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom8_featureboxes_plan6_name'] = "IPTV 6";
$_LANG['prosper_custom8_featureboxes_plan6_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan6_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan6_feat1'] = "6 Users";
$_LANG['prosper_custom8_featureboxes_plan6_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan6_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan6_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan6_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan6_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan6_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom8_featureboxes_plan7_name'] = "IPTV 7";
$_LANG['prosper_custom8_featureboxes_plan7_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan7_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan7_feat1'] = "7 Users";
$_LANG['prosper_custom8_featureboxes_plan7_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan7_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan7_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan7_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan7_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan7_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom8_featureboxes_plan8_name'] = "IPTV 8";
$_LANG['prosper_custom8_featureboxes_plan8_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan8_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan8_feat1'] = "8 Users";
$_LANG['prosper_custom8_featureboxes_plan8_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan8_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan8_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan8_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan8_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan8_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom8_featureboxes_plan9_name'] = "IPTV 9";
$_LANG['prosper_custom8_featureboxes_plan9_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan9_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan9_feat1'] = "9 Users";
$_LANG['prosper_custom8_featureboxes_plan9_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan9_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan9_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan9_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan9_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom8_featureboxes_plan10_name'] = "IPTV 10";
$_LANG['prosper_custom8_featureboxes_plan10_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_featureboxes_plan10_features'] = "What's Included?";
$_LANG['prosper_custom8_featureboxes_plan10_feat1'] = "10 Users";
$_LANG['prosper_custom8_featureboxes_plan10_feat2'] = "40,000+ Movies";
$_LANG['prosper_custom8_featureboxes_plan10_feat3'] = "30,000+ TV Shows";
$_LANG['prosper_custom8_featureboxes_plan10_feat4'] = "4k ,Full HD ,HD & SD";
$_LANG['prosper_custom8_featureboxes_plan10_feat5'] = "24/7 Support";
$_LANG['prosper_custom8_featureboxes_plan10_pricepre'] = "Only";
$_LANG['prosper_custom8_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom8_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom8_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom8_slider_heading1'] = "Users";
$_LANG['prosper_custom8_slider_heading2'] = "Movies";
$_LANG['prosper_custom8_slider_heading3'] = "TV Shows";
$_LANG['prosper_custom8_slider_heading4'] = "Live TV";
$_LANG['prosper_custom8_slider_heading5'] = "24/7 Support";

// Plan 1

$_LANG['prosper_custom8_slider_plan1_name'] = "IPTV 1";
$_LANG['prosper_custom8_slider_plan1_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan1_feat1'] = "1";
$_LANG['prosper_custom8_slider_plan1_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan1_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan1_feat4'] = "cross";
$_LANG['prosper_custom8_slider_plan1_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan1_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan1_term'] = "/month";
$_LANG['prosper_custom8_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom8_slider_plan2_name'] = "IPTV 2";
$_LANG['prosper_custom8_slider_plan2_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan2_feat1'] = "2";
$_LANG['prosper_custom8_slider_plan2_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan2_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan2_feat4'] = "cross";
$_LANG['prosper_custom8_slider_plan2_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan2_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan2_term'] = "/month";
$_LANG['prosper_custom8_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom8_slider_plan3_name'] = "IPTV 3";
$_LANG['prosper_custom8_slider_plan3_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan3_feat1'] = "3";
$_LANG['prosper_custom8_slider_plan3_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan3_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan3_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan3_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan3_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan3_term'] = "/month";
$_LANG['prosper_custom8_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom8_slider_plan4_name'] = "IPTV 4";
$_LANG['prosper_custom8_slider_plan4_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan4_feat1'] = "4";
$_LANG['prosper_custom8_slider_plan4_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan4_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan4_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan4_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan4_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan4_term'] = "/month";
$_LANG['prosper_custom8_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom8_slider_plan5_name'] = "IPTV 5";
$_LANG['prosper_custom8_slider_plan5_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan5_feat1'] = "5";
$_LANG['prosper_custom8_slider_plan5_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan5_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan5_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan5_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan5_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan5_term'] = "/month";
$_LANG['prosper_custom8_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom8_slider_plan6_name'] = "IPTV 6";
$_LANG['prosper_custom8_slider_plan6_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan6_feat1'] = "6";
$_LANG['prosper_custom8_slider_plan6_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan6_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan6_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan6_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan6_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan6_term'] = "/month";
$_LANG['prosper_custom8_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom8_slider_plan7_name'] = "IPTV 7";
$_LANG['prosper_custom8_slider_plan7_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan7_feat1'] = "7";
$_LANG['prosper_custom8_slider_plan7_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan7_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan7_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan7_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan7_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan7_term'] = "/month";
$_LANG['prosper_custom8_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom8_slider_plan8_name'] = "IPTV 8";
$_LANG['prosper_custom8_slider_plan8_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan8_feat1'] = "8";
$_LANG['prosper_custom8_slider_plan8_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan8_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan8_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan8_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan8_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan8_term'] = "/month";
$_LANG['prosper_custom8_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom8_slider_plan9_name'] = "IPTV 9";
$_LANG['prosper_custom8_slider_plan9_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan9_feat1'] = "9";
$_LANG['prosper_custom8_slider_plan9_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan9_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan9_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan9_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan9_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan9_term'] = "/month";
$_LANG['prosper_custom8_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom8_slider_plan10_name'] = "IPTV 10";
$_LANG['prosper_custom8_slider_plan10_desc'] = "Lightning Fast IPTV Service";
$_LANG['prosper_custom8_slider_plan10_feat1'] = "10";
$_LANG['prosper_custom8_slider_plan10_feat2'] = "40,000+";
$_LANG['prosper_custom8_slider_plan10_feat3'] = "30,000+";
$_LANG['prosper_custom8_slider_plan10_feat4'] = "check";
$_LANG['prosper_custom8_slider_plan10_feat5'] = "check";
$_LANG['prosper_custom8_slider_plan10_pricepre'] = "Only";
$_LANG['prosper_custom8_slider_plan10_term'] = "/month";
$_LANG['prosper_custom8_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Hosting Addons page by default (File: hosting-addons.tpl, hosting-addons.php, includes/custom9.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom9_table_heading1'] = "Comparison";
$_LANG['prosper_custom9_table_feat1'] = "Setup";
$_LANG['prosper_custom9_table_feat2'] = "Money Back Guarantee";
$_LANG['prosper_custom9_table_feat3'] = "Support";

$_LANG['prosper_custom9_table_heading2'] = "";
$_LANG['prosper_custom9_table_feat4'] = "";
$_LANG['prosper_custom9_table_feat5'] = "";
$_LANG['prosper_custom9_table_feat6'] = "";
$_LANG['prosper_custom9_table_feat7'] = "";
$_LANG['prosper_custom9_table_feat8'] = "";
$_LANG['prosper_custom9_table_feat9'] = "";
$_LANG['prosper_custom9_table_feat10'] = "";
$_LANG['prosper_custom9_table_feat11'] = "";
$_LANG['prosper_custom9_table_feat12'] = "";

$_LANG['prosper_custom9_table_heading3'] = "";
$_LANG['prosper_custom9_table_feat13'] = "";
$_LANG['prosper_custom9_table_feat14'] = "";
$_LANG['prosper_custom9_table_feat15'] = "";
$_LANG['prosper_custom9_table_feat16'] = "";
$_LANG['prosper_custom9_table_feat17'] = "";
$_LANG['prosper_custom9_table_feat18'] = "";
$_LANG['prosper_custom9_table_feat19'] = "";
$_LANG['prosper_custom9_table_feat20'] = "";
$_LANG['prosper_custom9_table_feat21'] = "";

$_LANG['prosper_custom9_table_heading4'] = "";
$_LANG['prosper_custom9_table_feat22'] = "";
$_LANG['prosper_custom9_table_feat23'] = "";
$_LANG['prosper_custom9_table_feat24'] = "";
$_LANG['prosper_custom9_table_feat25'] = "";
$_LANG['prosper_custom9_table_feat26'] = "";
$_LANG['prosper_custom9_table_feat27'] = "";
$_LANG['prosper_custom9_table_feat28'] = "";
$_LANG['prosper_custom9_table_feat29'] = "";
$_LANG['prosper_custom9_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom9_table_plan1_name'] = "Dedicated IP";
$_LANG['prosper_custom9_table_plan1_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_table_plan1_pricepre'] = "";
$_LANG['prosper_custom9_table_plan1_term'] = "/one time";
$_LANG['prosper_custom9_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom9_table_plan2_name'] = "Backup Service";
$_LANG['prosper_custom9_table_plan2_desc'] = "Instant Setup";
$_LANG['prosper_custom9_table_plan2_pricepre'] = "";
$_LANG['prosper_custom9_table_plan2_term'] = "/annually";
$_LANG['prosper_custom9_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom9_table_plan3_name'] = "Spam Filter";
$_LANG['prosper_custom9_table_plan3_desc'] = "Quick Start";
$_LANG['prosper_custom9_table_plan3_pricepre'] = "";
$_LANG['prosper_custom9_table_plan3_term'] = "/month";
$_LANG['prosper_custom9_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom9_table_plan4_name'] = "WordPress Installation";
$_LANG['prosper_custom9_table_plan4_desc'] = "Completely Free";
$_LANG['prosper_custom9_table_plan4_pricepre'] = "";
$_LANG['prosper_custom9_table_plan4_term'] = "";
$_LANG['prosper_custom9_table_plan4_button'] = "Select";

// Plan 5

$_LANG['prosper_custom9_table_plan5_name'] = "Advanced Analytics";
$_LANG['prosper_custom9_table_plan5_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_table_plan5_pricepre'] = "";
$_LANG['prosper_custom9_table_plan5_term'] = "/month";
$_LANG['prosper_custom9_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom9_table_plan6_name'] = "Domain Change";
$_LANG['prosper_custom9_table_plan6_desc'] = "Support Included";
$_LANG['prosper_custom9_table_plan6_pricepre'] = "";
$_LANG['prosper_custom9_table_plan6_term'] = "/one time";
$_LANG['prosper_custom9_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom9_table2_heading0'] = "Addon";
$_LANG['prosper_custom9_table2_heading1'] = "Setup";
$_LANG['prosper_custom9_table2_heading2'] = "Support";
$_LANG['prosper_custom9_table2_heading3'] = "";
$_LANG['prosper_custom9_table2_heading4'] = "";
$_LANG['prosper_custom9_table2_heading5'] = "";
$_LANG['prosper_custom9_table2_heading6'] = "";

// Plan 1

$_LANG['prosper_custom9_table2_plan1_name'] = "Dedicated IP";
$_LANG['prosper_custom9_table2_plan1_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_table2_plan1_feat1'] = "5 Days";
$_LANG['prosper_custom9_table2_plan1_feat2'] = "Instant";
$_LANG['prosper_custom9_table2_plan1_feat3'] = "";
$_LANG['prosper_custom9_table2_plan1_feat4'] = "";
$_LANG['prosper_custom9_table2_plan1_feat5'] = "";
$_LANG['prosper_custom9_table2_plan1_feat6'] = "";
$_LANG['prosper_custom9_table2_plan1_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan1_term'] = "/one time";
$_LANG['prosper_custom9_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom9_table2_plan2_name'] = "Backup Service";
$_LANG['prosper_custom9_table2_plan2_desc'] = "Instant Setup";
$_LANG['prosper_custom9_table2_plan2_feat1'] = "Instant";
$_LANG['prosper_custom9_table2_plan2_feat2'] = "cross";
$_LANG['prosper_custom9_table2_plan2_feat3'] = "";
$_LANG['prosper_custom9_table2_plan2_feat4'] = "";
$_LANG['prosper_custom9_table2_plan2_feat5'] = "";
$_LANG['prosper_custom9_table2_plan2_feat6'] = "";
$_LANG['prosper_custom9_table2_plan2_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan2_term'] = "/annually";
$_LANG['prosper_custom9_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom9_table2_plan3_name'] = "Spam Filter";
$_LANG['prosper_custom9_table2_plan3_desc'] = "Quick Start";
$_LANG['prosper_custom9_table2_plan3_feat1'] = "Instant";
$_LANG['prosper_custom9_table2_plan3_feat2'] = "check";
$_LANG['prosper_custom9_table2_plan3_feat3'] = "";
$_LANG['prosper_custom9_table2_plan3_feat4'] = "";
$_LANG['prosper_custom9_table2_plan3_feat5'] = "";
$_LANG['prosper_custom9_table2_plan3_feat6'] = "";
$_LANG['prosper_custom9_table2_plan3_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan3_term'] = "/month";
$_LANG['prosper_custom9_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom9_table2_plan4_name'] = "WordPress Installation";
$_LANG['prosper_custom9_table2_plan4_desc'] = "Completely Free";
$_LANG['prosper_custom9_table2_plan4_feat1'] = "24 Hours";
$_LANG['prosper_custom9_table2_plan4_feat2'] = "cross";
$_LANG['prosper_custom9_table2_plan4_feat3'] = "";
$_LANG['prosper_custom9_table2_plan4_feat4'] = "";
$_LANG['prosper_custom9_table2_plan4_feat5'] = "";
$_LANG['prosper_custom9_table2_plan4_feat6'] = "";
$_LANG['prosper_custom9_table2_plan4_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan4_term'] = "";
$_LANG['prosper_custom9_table2_plan4_button'] = "Select";

// Plan 5

$_LANG['prosper_custom9_table2_plan5_name'] = "Advanced Analytics";
$_LANG['prosper_custom9_table2_plan5_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_table2_plan5_feat1'] = "Instant";
$_LANG['prosper_custom9_table2_plan5_feat2'] = "cross";
$_LANG['prosper_custom9_table2_plan5_feat3'] = "";
$_LANG['prosper_custom9_table2_plan5_feat4'] = "";
$_LANG['prosper_custom9_table2_plan5_feat5'] = "";
$_LANG['prosper_custom9_table2_plan5_feat6'] = "";
$_LANG['prosper_custom9_table2_plan5_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan5_term'] = "/month";
$_LANG['prosper_custom9_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom9_table2_plan6_name'] = "Domain Change";
$_LANG['prosper_custom9_table2_plan6_desc'] = "Support Included";
$_LANG['prosper_custom9_table2_plan6_feat1'] = "Minutes";
$_LANG['prosper_custom9_table2_plan6_feat2'] = "check";
$_LANG['prosper_custom9_table2_plan6_feat3'] = "";
$_LANG['prosper_custom9_table2_plan6_feat4'] = "";
$_LANG['prosper_custom9_table2_plan6_feat5'] = "";
$_LANG['prosper_custom9_table2_plan6_feat6'] = "";
$_LANG['prosper_custom9_table2_plan6_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan6_term'] = "/one time";
$_LANG['prosper_custom9_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom9_table2_plan7_name'] = "Premium Support";
$_LANG['prosper_custom9_table2_plan7_desc'] = "Instant Setup";
$_LANG['prosper_custom9_table2_plan7_feat1'] = "5 Days";
$_LANG['prosper_custom9_table2_plan7_feat2'] = "check";
$_LANG['prosper_custom9_table2_plan7_feat3'] = "";
$_LANG['prosper_custom9_table2_plan7_feat4'] = "";
$_LANG['prosper_custom9_table2_plan7_feat5'] = "";
$_LANG['prosper_custom9_table2_plan7_feat6'] = "";
$_LANG['prosper_custom9_table2_plan7_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan7_term'] = "/year";
$_LANG['prosper_custom9_table2_plan7_button'] = "Get Started";

// Plan 8

$_LANG['prosper_custom9_table2_plan8_name'] = "SiteBuilder";
$_LANG['prosper_custom9_table2_plan8_desc'] = "Free Installation";
$_LANG['prosper_custom9_table2_plan8_feat1'] = "3 Days";
$_LANG['prosper_custom9_table2_plan8_feat2'] = "cross";
$_LANG['prosper_custom9_table2_plan8_feat3'] = "";
$_LANG['prosper_custom9_table2_plan8_feat4'] = "";
$_LANG['prosper_custom9_table2_plan8_feat5'] = "";
$_LANG['prosper_custom9_table2_plan8_feat6'] = "";
$_LANG['prosper_custom9_table2_plan8_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan8_term'] = "/annually";
$_LANG['prosper_custom9_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom9_table2_plan9_name'] = "Account Reset";
$_LANG['prosper_custom9_table2_plan9_desc'] = "Money Back Guarantee";
$_LANG['prosper_custom9_table2_plan9_feat1'] = "5 Hours";
$_LANG['prosper_custom9_table2_plan9_feat2'] = "check";
$_LANG['prosper_custom9_table2_plan9_feat3'] = "";
$_LANG['prosper_custom9_table2_plan9_feat4'] = "";
$_LANG['prosper_custom9_table2_plan9_feat5'] = "";
$_LANG['prosper_custom9_table2_plan9_feat6'] = "";
$_LANG['prosper_custom9_table2_plan9_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan9_term'] = "/month";
$_LANG['prosper_custom9_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom9_table2_plan10_name'] = "SEO Report";
$_LANG['prosper_custom9_table2_plan10_desc'] = "Support Included";
$_LANG['prosper_custom9_table2_plan10_feat1'] = "Minutes";
$_LANG['prosper_custom9_table2_plan10_feat2'] = "cross";
$_LANG['prosper_custom9_table2_plan10_feat3'] = "";
$_LANG['prosper_custom9_table2_plan10_feat4'] = "";
$_LANG['prosper_custom9_table2_plan10_feat5'] = "";
$_LANG['prosper_custom9_table2_plan10_feat6'] = "";
$_LANG['prosper_custom9_table2_plan10_pricepre'] = "";
$_LANG['prosper_custom9_table2_plan10_term'] = "/month";
$_LANG['prosper_custom9_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom9_featureboxes_plan1_name'] = "Dedicated IP";
$_LANG['prosper_custom9_featureboxes_plan1_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_featureboxes_plan1_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_term'] = "/one time";
$_LANG['prosper_custom9_featureboxes_plan1_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['prosper_custom9_featureboxes_plan2_name'] = "Backup Service";
$_LANG['prosper_custom9_featureboxes_plan2_desc'] = "Instant Setup";
$_LANG['prosper_custom9_featureboxes_plan2_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_term'] = "/annually";
$_LANG['prosper_custom9_featureboxes_plan2_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom9_featureboxes_plan3_name'] = "Spam Filter";
$_LANG['prosper_custom9_featureboxes_plan3_desc'] = "Quick Start";
$_LANG['prosper_custom9_featureboxes_plan3_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_term'] = "/month";
$_LANG['prosper_custom9_featureboxes_plan3_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom9_featureboxes_plan4_name'] = "WordPress Installation";
$_LANG['prosper_custom9_featureboxes_plan4_desc'] = "Completely Free";
$_LANG['prosper_custom9_featureboxes_plan4_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_term'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan4_button2'] = "Select";

// Plan 5

$_LANG['prosper_custom9_featureboxes_plan5_name'] = "Advanced Analytics";
$_LANG['prosper_custom9_featureboxes_plan5_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_featureboxes_plan5_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_term'] = "/month";
$_LANG['prosper_custom9_featureboxes_plan5_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom9_featureboxes_plan6_name'] = "Domain Change";
$_LANG['prosper_custom9_featureboxes_plan6_desc'] = "Support Included";
$_LANG['prosper_custom9_featureboxes_plan6_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_term'] = "/one time";
$_LANG['prosper_custom9_featureboxes_plan6_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom9_featureboxes_plan7_name'] = "Premium Support";
$_LANG['prosper_custom9_featureboxes_plan7_desc'] = "Instant Setup";
$_LANG['prosper_custom9_featureboxes_plan7_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_term'] = "/year";
$_LANG['prosper_custom9_featureboxes_plan7_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan7_button2'] = "Get Started";

// Plan 8

$_LANG['prosper_custom9_featureboxes_plan8_name'] = "SiteBuilder";
$_LANG['prosper_custom9_featureboxes_plan8_desc'] = "Free Installation";
$_LANG['prosper_custom9_featureboxes_plan8_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_term'] = "/annually";
$_LANG['prosper_custom9_featureboxes_plan8_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom9_featureboxes_plan9_name'] = "Account Reset";
$_LANG['prosper_custom9_featureboxes_plan9_desc'] = "Money Back Guarantee";
$_LANG['prosper_custom9_featureboxes_plan9_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_term'] = "/month";
$_LANG['prosper_custom9_featureboxes_plan9_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom9_featureboxes_plan10_name'] = "SEO Report";
$_LANG['prosper_custom9_featureboxes_plan10_desc'] = "Support Included";
$_LANG['prosper_custom9_featureboxes_plan10_features'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_feat1'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_feat2'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_feat3'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_feat4'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_feat5'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_pricepre'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_term'] = "/month";
$_LANG['prosper_custom9_featureboxes_plan10_button1'] = "";
$_LANG['prosper_custom9_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom9_slider_heading1'] = "Setup";
$_LANG['prosper_custom9_slider_heading2'] = "Support";
$_LANG['prosper_custom9_slider_heading3'] = "";
$_LANG['prosper_custom9_slider_heading4'] = "";
$_LANG['prosper_custom9_slider_heading5'] = "";

// Plan 1

$_LANG['prosper_custom9_slider_plan1_name'] = "Dedicated IP";
$_LANG['prosper_custom9_slider_plan1_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_slider_plan1_feat1'] = "5 Days";
$_LANG['prosper_custom9_slider_plan1_feat2'] = "cross";
$_LANG['prosper_custom9_slider_plan1_feat3'] = "";
$_LANG['prosper_custom9_slider_plan1_feat4'] = "";
$_LANG['prosper_custom9_slider_plan1_feat5'] = "";
$_LANG['prosper_custom9_slider_plan1_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan1_term'] = "/one time";
$_LANG['prosper_custom9_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['prosper_custom9_slider_plan2_name'] = "Backup Service";
$_LANG['prosper_custom9_slider_plan2_desc'] = "Instant Setup";
$_LANG['prosper_custom9_slider_plan2_feat1'] = "Instant";
$_LANG['prosper_custom9_slider_plan2_feat2'] = "cross";
$_LANG['prosper_custom9_slider_plan2_feat3'] = "";
$_LANG['prosper_custom9_slider_plan2_feat4'] = "";
$_LANG['prosper_custom9_slider_plan2_feat5'] = "";
$_LANG['prosper_custom9_slider_plan2_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan2_term'] = "/annually";
$_LANG['prosper_custom9_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom9_slider_plan3_name'] = "Spam Filter";
$_LANG['prosper_custom9_slider_plan3_desc'] = "Quick Start";
$_LANG['prosper_custom9_slider_plan3_feat1'] = "Instant";
$_LANG['prosper_custom9_slider_plan3_feat2'] = "check";
$_LANG['prosper_custom9_slider_plan3_feat3'] = "";
$_LANG['prosper_custom9_slider_plan3_feat4'] = "";
$_LANG['prosper_custom9_slider_plan3_feat5'] = "";
$_LANG['prosper_custom9_slider_plan3_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan3_term'] = "/month";
$_LANG['prosper_custom9_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom9_slider_plan4_name'] = "WordPress Installation";
$_LANG['prosper_custom9_slider_plan4_desc'] = "Completely Free";
$_LANG['prosper_custom9_slider_plan4_feat1'] = "24 Hours";
$_LANG['prosper_custom9_slider_plan4_feat2'] = "cross";
$_LANG['prosper_custom9_slider_plan4_feat3'] = "";
$_LANG['prosper_custom9_slider_plan4_feat4'] = "";
$_LANG['prosper_custom9_slider_plan4_feat5'] = "";
$_LANG['prosper_custom9_slider_plan4_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan4_term'] = "";
$_LANG['prosper_custom9_slider_plan4_button'] = "Select";

// Plan 5

$_LANG['prosper_custom9_slider_plan5_name'] = "Advanced Analytics";
$_LANG['prosper_custom9_slider_plan5_desc'] = "Quick & Easy";
$_LANG['prosper_custom9_slider_plan5_feat1'] = "Instant";
$_LANG['prosper_custom9_slider_plan5_feat2'] = "cross";
$_LANG['prosper_custom9_slider_plan5_feat3'] = "";
$_LANG['prosper_custom9_slider_plan5_feat4'] = "";
$_LANG['prosper_custom9_slider_plan5_feat5'] = "";
$_LANG['prosper_custom9_slider_plan5_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan5_term'] = "/month";
$_LANG['prosper_custom9_slider_plan5_button'] = "Select";

// Plan 6

$_LANG['prosper_custom9_slider_plan6_name'] = "Domain Change";
$_LANG['prosper_custom9_slider_plan6_desc'] = "Support Included";
$_LANG['prosper_custom9_slider_plan6_feat1'] = "Minutes";
$_LANG['prosper_custom9_slider_plan6_feat2'] = "check";
$_LANG['prosper_custom9_slider_plan6_feat3'] = "";
$_LANG['prosper_custom9_slider_plan6_feat4'] = "";
$_LANG['prosper_custom9_slider_plan6_feat5'] = "";
$_LANG['prosper_custom9_slider_plan6_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan6_term'] = "/one time";
$_LANG['prosper_custom9_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom9_slider_plan7_name'] = "Premium Support";
$_LANG['prosper_custom9_slider_plan7_desc'] = "Instant Setup";
$_LANG['prosper_custom9_slider_plan7_feat1'] = "5 Days";
$_LANG['prosper_custom9_slider_plan7_feat2'] = "check";
$_LANG['prosper_custom9_slider_plan7_feat3'] = "";
$_LANG['prosper_custom9_slider_plan7_feat4'] = "";
$_LANG['prosper_custom9_slider_plan7_feat5'] = "";
$_LANG['prosper_custom9_slider_plan7_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan7_term'] = "/year";
$_LANG['prosper_custom9_slider_plan7_button'] = "Get Started";

// Plan 8

$_LANG['prosper_custom9_slider_plan8_name'] = "SiteBuilder";
$_LANG['prosper_custom9_slider_plan8_desc'] = "Free Installation";
$_LANG['prosper_custom9_slider_plan8_feat1'] = "3 Days";
$_LANG['prosper_custom9_slider_plan8_feat2'] = "cross";
$_LANG['prosper_custom9_slider_plan8_feat3'] = "";
$_LANG['prosper_custom9_slider_plan8_feat4'] = "";
$_LANG['prosper_custom9_slider_plan8_feat5'] = "";
$_LANG['prosper_custom9_slider_plan8_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan8_term'] = "/annually";
$_LANG['prosper_custom9_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom9_slider_plan9_name'] = "Account Reset";
$_LANG['prosper_custom9_slider_plan9_desc'] = "Money Back Guarantee";
$_LANG['prosper_custom9_slider_plan9_feat1'] = "5 Hours";
$_LANG['prosper_custom9_slider_plan9_feat2'] = "check";
$_LANG['prosper_custom9_slider_plan9_feat3'] = "";
$_LANG['prosper_custom9_slider_plan9_feat4'] = "";
$_LANG['prosper_custom9_slider_plan9_feat5'] = "";
$_LANG['prosper_custom9_slider_plan9_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan9_term'] = "/month";
$_LANG['prosper_custom9_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom9_slider_plan10_name'] = "SEO Report";
$_LANG['prosper_custom9_slider_plan10_desc'] = "Support Included";
$_LANG['prosper_custom9_slider_plan10_feat1'] = "Minutes";
$_LANG['prosper_custom9_slider_plan10_feat2'] = "cross";
$_LANG['prosper_custom9_slider_plan10_feat3'] = "";
$_LANG['prosper_custom9_slider_plan10_feat4'] = "";
$_LANG['prosper_custom9_slider_plan10_feat5'] = "";
$_LANG['prosper_custom9_slider_plan10_pricepre'] = "";
$_LANG['prosper_custom9_slider_plan10_term'] = "/month";
$_LANG['prosper_custom9_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   Web Design page by default (File: web-design.tpl, web-design.php, includes/custom10.tpl)   ---------
-----------------------------------------
*/

// Table Layout

$_LANG['prosper_custom10_table_heading1'] = "Compare";
$_LANG['prosper_custom10_table_feat1'] = "Pages";
$_LANG['prosper_custom10_table_feat2'] = "WordPress Or HTML";
$_LANG['prosper_custom10_table_feat3'] = "Bespoke Design";

$_LANG['prosper_custom10_table_heading2'] = "What's Included?";
$_LANG['prosper_custom10_table_feat4'] = "Custom Logo Design";
$_LANG['prosper_custom10_table_feat5'] = "Web Hosting";
$_LANG['prosper_custom10_table_feat6'] = "Domain Registration";
$_LANG['prosper_custom10_table_feat7'] = "Email";
$_LANG['prosper_custom10_table_feat8'] = "SEO";
$_LANG['prosper_custom10_table_feat9'] = "Website Backup";
$_LANG['prosper_custom10_table_feat10'] = "Directory Submission";
$_LANG['prosper_custom10_table_feat11'] = "24/7 Support";
$_LANG['prosper_custom10_table_feat12'] = "Revisions";

$_LANG['prosper_custom10_table_heading3'] = "";
$_LANG['prosper_custom10_table_feat13'] = "";
$_LANG['prosper_custom10_table_feat14'] = "";
$_LANG['prosper_custom10_table_feat15'] = "";
$_LANG['prosper_custom10_table_feat16'] = "";
$_LANG['prosper_custom10_table_feat17'] = "";
$_LANG['prosper_custom10_table_feat18'] = "";
$_LANG['prosper_custom10_table_feat19'] = "";
$_LANG['prosper_custom10_table_feat20'] = "";
$_LANG['prosper_custom10_table_feat21'] = "";

$_LANG['prosper_custom10_table_heading4'] = "";
$_LANG['prosper_custom10_table_feat22'] = "";
$_LANG['prosper_custom10_table_feat23'] = "";
$_LANG['prosper_custom10_table_feat24'] = "";
$_LANG['prosper_custom10_table_feat25'] = "";
$_LANG['prosper_custom10_table_feat26'] = "";
$_LANG['prosper_custom10_table_feat27'] = "";
$_LANG['prosper_custom10_table_feat28'] = "";
$_LANG['prosper_custom10_table_feat29'] = "";
$_LANG['prosper_custom10_table_feat30'] = "";

// Plan 1

$_LANG['prosper_custom10_table_plan1_name'] = "Quote";
$_LANG['prosper_custom10_table_plan1_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table_plan1_pricepre'] = "";
$_LANG['prosper_custom10_table_plan1_term'] = "";
$_LANG['prosper_custom10_table_plan1_button'] = "Request";

// Plan 2

$_LANG['prosper_custom10_table_plan2_name'] = "Web Design 1";
$_LANG['prosper_custom10_table_plan2_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table_plan2_pricepre'] = "Just";
$_LANG['prosper_custom10_table_plan2_term'] = "/one time";
$_LANG['prosper_custom10_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom10_table_plan3_name'] = "Web Design 2";
$_LANG['prosper_custom10_table_plan3_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table_plan3_pricepre'] = "Just";
$_LANG['prosper_custom10_table_plan3_term'] = "/one time";
$_LANG['prosper_custom10_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom10_table_plan4_name'] = "Web Design 3";
$_LANG['prosper_custom10_table_plan4_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table_plan4_pricepre'] = "Just";
$_LANG['prosper_custom10_table_plan4_term'] = "/one time";
$_LANG['prosper_custom10_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom10_table_plan5_name'] = "Web Design 4";
$_LANG['prosper_custom10_table_plan5_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table_plan5_pricepre'] = "Just";
$_LANG['prosper_custom10_table_plan5_term'] = "/one time";
$_LANG['prosper_custom10_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom10_table_plan6_name'] = "Web Design 5";
$_LANG['prosper_custom10_table_plan6_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table_plan6_pricepre'] = "Just";
$_LANG['prosper_custom10_table_plan6_term'] = "/one time";
$_LANG['prosper_custom10_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['prosper_custom10_table2_heading0'] = "Package";
$_LANG['prosper_custom10_table2_heading1'] = "Pages";
$_LANG['prosper_custom10_table2_heading2'] = "WordPress Or HTML";
$_LANG['prosper_custom10_table2_heading3'] = "Bespoke Design";
$_LANG['prosper_custom10_table2_heading4'] = "Revisions";
$_LANG['prosper_custom10_table2_heading5'] = "Web Hosting";
$_LANG['prosper_custom10_table2_heading6'] = "Domain Registration";

// Plan 1

$_LANG['prosper_custom10_table2_plan1_name'] = "Quote";
$_LANG['prosper_custom10_table2_plan1_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan1_feat1'] = "-";
$_LANG['prosper_custom10_table2_plan1_feat2'] = "HTML";
$_LANG['prosper_custom10_table2_plan1_feat3'] = "cross";
$_LANG['prosper_custom10_table2_plan1_feat4'] = "10";
$_LANG['prosper_custom10_table2_plan1_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan1_feat6'] = "cross";
$_LANG['prosper_custom10_table2_plan1_pricepre'] = "";
$_LANG['prosper_custom10_table2_plan1_term'] = "";
$_LANG['prosper_custom10_table2_plan1_button'] = "Request";

// Plan 2

$_LANG['prosper_custom10_table2_plan2_name'] = "Web Design 1";
$_LANG['prosper_custom10_table2_plan2_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan2_feat1'] = "1-5";
$_LANG['prosper_custom10_table2_plan2_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan2_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan2_feat4'] = "50";
$_LANG['prosper_custom10_table2_plan2_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan2_feat6'] = "cross";
$_LANG['prosper_custom10_table2_plan2_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan2_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom10_table2_plan3_name'] = "Web Design 2";
$_LANG['prosper_custom10_table2_plan3_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan3_feat1'] = "6-10";
$_LANG['prosper_custom10_table2_plan3_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan3_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan3_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan3_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan3_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan3_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan3_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom10_table2_plan4_name'] = "Web Design 3";
$_LANG['prosper_custom10_table2_plan4_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan4_feat1'] = "11-20";
$_LANG['prosper_custom10_table2_plan4_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan4_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan4_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan4_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan4_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan4_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan4_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom10_table2_plan5_name'] = "Web Design 4";
$_LANG['prosper_custom10_table2_plan5_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan5_feat1'] = "21-30";
$_LANG['prosper_custom10_table2_plan5_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan5_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan5_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan5_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan5_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan5_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan5_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom10_table2_plan6_name'] = "Web Design 5";
$_LANG['prosper_custom10_table2_plan6_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan6_feat1'] = "31-40";
$_LANG['prosper_custom10_table2_plan6_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan6_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan6_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan6_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan6_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan6_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan6_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom10_table2_plan7_name'] = "Web Design 6";
$_LANG['prosper_custom10_table2_plan7_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan7_feat1'] = "41-50";
$_LANG['prosper_custom10_table2_plan7_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan7_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan7_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan7_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan7_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan7_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan7_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom10_table2_plan8_name'] = "Web Design 7";
$_LANG['prosper_custom10_table2_plan8_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan8_feat1'] = "51+";
$_LANG['prosper_custom10_table2_plan8_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan8_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan8_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan8_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan8_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan8_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan8_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom10_table2_plan9_name'] = "Web Design 8";
$_LANG['prosper_custom10_table2_plan9_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan9_feat1'] = "51+";
$_LANG['prosper_custom10_table2_plan9_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan9_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan9_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan9_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan9_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan9_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan9_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom10_table2_plan10_name'] = "Web Design 9";
$_LANG['prosper_custom10_table2_plan10_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_table2_plan10_feat1'] = "51+";
$_LANG['prosper_custom10_table2_plan10_feat2'] = "check";
$_LANG['prosper_custom10_table2_plan10_feat3'] = "check";
$_LANG['prosper_custom10_table2_plan10_feat4'] = "Unlimited";
$_LANG['prosper_custom10_table2_plan10_feat5'] = "check";
$_LANG['prosper_custom10_table2_plan10_feat6'] = "check";
$_LANG['prosper_custom10_table2_plan10_pricepre'] = "Just";
$_LANG['prosper_custom10_table2_plan10_term'] = "/one time";
$_LANG['prosper_custom10_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['prosper_custom10_featureboxes_plan1_name'] = "Quote";
$_LANG['prosper_custom10_featureboxes_plan1_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan1_features'] = "Why Request?";
$_LANG['prosper_custom10_featureboxes_plan1_feat1'] = "Bespoke Web Design";
$_LANG['prosper_custom10_featureboxes_plan1_feat2'] = "No Obligation";
$_LANG['prosper_custom10_featureboxes_plan1_feat3'] = "Choice Of Technology";
$_LANG['prosper_custom10_featureboxes_plan1_feat4'] = "24/7 Support";
$_LANG['prosper_custom10_featureboxes_plan1_feat5'] = "Money Back Guarantee";
$_LANG['prosper_custom10_featureboxes_plan1_pricepre'] = "";
$_LANG['prosper_custom10_featureboxes_plan1_term'] = "";
$_LANG['prosper_custom10_featureboxes_plan1_button1'] = "";
$_LANG['prosper_custom10_featureboxes_plan1_button2'] = "Request";

// Plan 2

$_LANG['prosper_custom10_featureboxes_plan2_name'] = "Web Design 1";
$_LANG['prosper_custom10_featureboxes_plan2_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan2_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan2_feat1'] = "Built With HTML";
$_LANG['prosper_custom10_featureboxes_plan2_feat2'] = "1-5 Pages";
$_LANG['prosper_custom10_featureboxes_plan2_feat3'] = "-";
$_LANG['prosper_custom10_featureboxes_plan2_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan2_feat5'] = "-";
$_LANG['prosper_custom10_featureboxes_plan2_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan2_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan2_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['prosper_custom10_featureboxes_plan3_name'] = "Web Design 2";
$_LANG['prosper_custom10_featureboxes_plan3_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan3_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan3_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan3_feat2'] = "6-10 Pages";
$_LANG['prosper_custom10_featureboxes_plan3_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan3_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan3_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan3_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan3_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan3_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['prosper_custom10_featureboxes_plan4_name'] = "Web Design 3";
$_LANG['prosper_custom10_featureboxes_plan4_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan4_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan4_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan4_feat2'] = "11-20 Pages";
$_LANG['prosper_custom10_featureboxes_plan4_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan4_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan4_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan4_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan4_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan4_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['prosper_custom10_featureboxes_plan5_name'] = "Web Design 4";
$_LANG['prosper_custom10_featureboxes_plan5_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan5_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan5_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan5_feat2'] = "21-30 Pages";
$_LANG['prosper_custom10_featureboxes_plan5_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan5_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan5_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan5_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan5_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan5_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['prosper_custom10_featureboxes_plan6_name'] = "Web Design 5";
$_LANG['prosper_custom10_featureboxes_plan6_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan6_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan6_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan6_feat2'] = "31-40 Pages";
$_LANG['prosper_custom10_featureboxes_plan6_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan6_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan6_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan6_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan6_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan6_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['prosper_custom10_featureboxes_plan7_name'] = "Web Design 6";
$_LANG['prosper_custom10_featureboxes_plan7_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan7_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan7_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan7_feat2'] = "41-50 Pages";
$_LANG['prosper_custom10_featureboxes_plan7_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan7_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan7_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan7_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan7_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan7_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['prosper_custom10_featureboxes_plan8_name'] = "Web Design 7";
$_LANG['prosper_custom10_featureboxes_plan8_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan8_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan8_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan8_feat2'] = "51+ Pages";
$_LANG['prosper_custom10_featureboxes_plan8_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan8_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan8_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan8_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan8_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan8_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['prosper_custom10_featureboxes_plan9_name'] = "Web Design 8";
$_LANG['prosper_custom10_featureboxes_plan9_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan9_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan9_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan9_feat2'] = "51+ Pages";
$_LANG['prosper_custom10_featureboxes_plan9_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan9_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan9_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan9_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan9_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan9_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['prosper_custom10_featureboxes_plan10_name'] = "Web Design 9";
$_LANG['prosper_custom10_featureboxes_plan10_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_featureboxes_plan10_features'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan10_feat1'] = "Built With WordPress Or HTML";
$_LANG['prosper_custom10_featureboxes_plan10_feat2'] = "51+ Pages";
$_LANG['prosper_custom10_featureboxes_plan10_feat3'] = "Custom Logo Design";
$_LANG['prosper_custom10_featureboxes_plan10_feat4'] = "Free Web Hosting";
$_LANG['prosper_custom10_featureboxes_plan10_feat5'] = "Free Domain Name";
$_LANG['prosper_custom10_featureboxes_plan10_pricepre'] = "Just";
$_LANG['prosper_custom10_featureboxes_plan10_term'] = "/one time";
$_LANG['prosper_custom10_featureboxes_plan10_button1'] = "Features";
$_LANG['prosper_custom10_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['prosper_custom10_slider_heading1'] = "Pages";
$_LANG['prosper_custom10_slider_heading2'] = "WordPress Or HTML";
$_LANG['prosper_custom10_slider_heading3'] = "Bespoke Design";
$_LANG['prosper_custom10_slider_heading4'] = "Revisions";
$_LANG['prosper_custom10_slider_heading5'] = "Web Hosting";

// Plan 1

$_LANG['prosper_custom10_slider_plan1_name'] = "Quote";
$_LANG['prosper_custom10_slider_plan1_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan1_feat1'] = "-";
$_LANG['prosper_custom10_slider_plan1_feat2'] = "HTML";
$_LANG['prosper_custom10_slider_plan1_feat3'] = "cross";
$_LANG['prosper_custom10_slider_plan1_feat4'] = "10";
$_LANG['prosper_custom10_slider_plan1_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan1_pricepre'] = "";
$_LANG['prosper_custom10_slider_plan1_term'] = "";
$_LANG['prosper_custom10_slider_plan1_button'] = "Request";

// Plan 2

$_LANG['prosper_custom10_slider_plan2_name'] = "Web Design 1";
$_LANG['prosper_custom10_slider_plan2_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan2_feat1'] = "1-5";
$_LANG['prosper_custom10_slider_plan2_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan2_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan2_feat4'] = "50";
$_LANG['prosper_custom10_slider_plan2_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan2_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan2_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['prosper_custom10_slider_plan3_name'] = "Web Design 2";
$_LANG['prosper_custom10_slider_plan3_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan3_feat1'] = "6-10";
$_LANG['prosper_custom10_slider_plan3_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan3_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan3_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan3_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan3_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan3_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['prosper_custom10_slider_plan4_name'] = "Web Design 3";
$_LANG['prosper_custom10_slider_plan4_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan4_feat1'] = "11-20";
$_LANG['prosper_custom10_slider_plan4_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan4_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan4_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan4_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan4_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan4_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['prosper_custom10_slider_plan5_name'] = "Web Design 4";
$_LANG['prosper_custom10_slider_plan5_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan5_feat1'] = "21-30";
$_LANG['prosper_custom10_slider_plan5_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan5_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan5_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan5_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan5_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan5_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['prosper_custom10_slider_plan6_name'] = "Web Design 5";
$_LANG['prosper_custom10_slider_plan6_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan6_feat1'] = "31-40";
$_LANG['prosper_custom10_slider_plan6_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan6_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan6_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan6_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan6_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan6_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['prosper_custom10_slider_plan7_name'] = "Web Design 6";
$_LANG['prosper_custom10_slider_plan7_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan7_feat1'] = "41-50";
$_LANG['prosper_custom10_slider_plan7_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan7_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan7_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan7_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan7_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan7_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['prosper_custom10_slider_plan8_name'] = "Web Design 7";
$_LANG['prosper_custom10_slider_plan8_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan8_feat1'] = "51+";
$_LANG['prosper_custom10_slider_plan8_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan8_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan8_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan8_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan8_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan8_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['prosper_custom10_slider_plan9_name'] = "Web Design 8";
$_LANG['prosper_custom10_slider_plan9_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan9_feat1'] = "51+";
$_LANG['prosper_custom10_slider_plan9_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan9_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan9_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan9_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan9_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan9_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['prosper_custom10_slider_plan10_name'] = "Web Design 9";
$_LANG['prosper_custom10_slider_plan10_desc'] = "High Quality Web Design";
$_LANG['prosper_custom10_slider_plan10_feat1'] = "51+";
$_LANG['prosper_custom10_slider_plan10_feat2'] = "check";
$_LANG['prosper_custom10_slider_plan10_feat3'] = "check";
$_LANG['prosper_custom10_slider_plan10_feat4'] = "Unlimited";
$_LANG['prosper_custom10_slider_plan10_feat5'] = "check";
$_LANG['prosper_custom10_slider_plan10_pricepre'] = "Just";
$_LANG['prosper_custom10_slider_plan10_term'] = "/one time";
$_LANG['prosper_custom10_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   End hosting plans   ---------
-----------------------------------------
*/






/*
-----------------------------------------
---------   SEO (File: includes/seo.tpl)   ---------
-----------------------------------------
*/

// Homepage

$_LANG['prosper_meta_title_index'] = "Professional Web Hosting - We provide solid web hosting &amp; domain registration services!";
$_LANG['prosper_meta_description_index'] = "Professional web services for businesses and individuals.";
$_LANG['prosper_meta_tags_index'] = "shared hosting, reseller hosting, vps hosting, dedicated hosting, domain registration";

// Register Domain

$_LANG['prosper_meta_title_registerdomain'] = "Domain Registration - Search &amp; register your domains here";
$_LANG['prosper_meta_description_registerdomain'] = "Affordable domain registration service with multiple extension options.";
$_LANG['prosper_meta_tags_registerdomain'] = "domain registration, domains, domain checker, WHOIS";

// Transfer Domain

$_LANG['prosper_meta_title_transferdomain'] = "Transfer multiple domains to our company";
$_LANG['prosper_meta_description_transferdomain'] = "Now you can transfer multiple domains to our company";
$_LANG['prosper_meta_tags_transferdomain'] = "domain registration, domains, domain checker, whois";

// Custom1

$_LANG['prosper_meta_title_custom1'] = "Shared Hosting ~ We provide professional &amp; affordable cPanel hosting";
$_LANG['prosper_meta_description_custom1'] = "We provide top quality cPanel hosting which is perfect for any type of website.";
$_LANG['prosper_meta_tags_custom1'] = "shared hosting, cpanel hosting, website hosting, web hosting";

// Custom2

$_LANG['prosper_meta_title_custom2'] = "Reseller Hosting ~ Become your own boss by starting a web hosting company";
$_LANG['prosper_meta_description_custom2'] = "We provide reseller web hosting which allows you to easily create your own web hosting business.";
$_LANG['prosper_meta_tags_custom2'] = "reseller hosting, reseller web hosting, whm hosting";

// Custom3

$_LANG['prosper_meta_title_custom3'] = "VPS Hosting ~ High resource VPS hosting for individuals &amp; businesses alike";
$_LANG['prosper_meta_description_custom3'] = "The best VPS hosting at an affordable price.";
$_LANG['prosper_meta_tags_custom3'] = "vps hosting, vps, vps server";

// Custom4

$_LANG['prosper_meta_title_custom4'] = "Dedicated Servers ~ We manage your server so you can focus on your business!";
$_LANG['prosper_meta_description_custom4'] = "Our dedicated servers are a great choice for any enterprise as they come fully managed by us.";
$_LANG['prosper_meta_tags_custom4'] = "dedicated hosting, dedicated servers";

// Custom5

$_LANG['prosper_meta_title_custom5'] = "Cloud Hosting - Host your website on our next generation servers!";
$_LANG['prosper_meta_description_custom5'] = "Our cloud hosting is a scalable &amp; quality hosting service.";
$_LANG['prosper_meta_tags_custom5'] = "cloud hosting, cloud servers, cloud";

// Custom6

$_LANG['prosper_meta_title_custom6'] = "Game Servers - Setup your own game server today!";
$_LANG['prosper_meta_description_custom6'] = "Our game servers are fast, reliable &amp; more importantly affordable.";
$_LANG['prosper_meta_tags_custom6'] = "game servers, game hosting, gaming";

// Custom7

$_LANG['prosper_meta_title_custom7'] = "Premium quality Virtual Private Network servers (VPN)";
$_LANG['prosper_meta_description_custom7'] = "We provide the most reliable Virtual Private Networks in the industry.";
$_LANG['prosper_meta_tags_custom7'] = "vpns, vpn, virtual private network";

// Custom8

$_LANG['prosper_meta_title_custom8'] = "Stream hundreds of high quality tv shows & movies";
$_LANG['prosper_meta_description_custom8'] = "We provide a very reliable and fast speed streaming service";
$_LANG['prosper_meta_tags_custom8'] = "streaming, speed, high quality";

// Custom9

$_LANG['prosper_meta_title_custom9'] = "Web Hosting Addons - dedicated IPs, disk space/bandwidth upgrades and more!";
$_LANG['prosper_meta_description_custom9'] = "Enhance your web hosting account with our hosting addons";
$_LANG['prosper_meta_tags_custom9'] = "web hosting, web hosting addons, hosting addons";

// Custom10

$_LANG['prosper_meta_title_custom10'] = "Hire us to create the perfect website for you";
$_LANG['prosper_meta_description_custom10'] = "All of our websites are built using the power of WordPress";
$_LANG['prosper_meta_tags_custom10'] = "web design, wordpress";

// SSL Certificates (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_sslcertificates'] = "SSL Certificates | Secure your website and give your visitors/clients confidence with validation";
$_LANG['prosper_meta_description_sslcertificates'] = "We provide a range of SSL Certificates to help secure your website and project your clients data.";
$_LANG['prosper_meta_tags_sslcertificates'] = "ssl";

// VPN (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_vpn'] = "VPN - Protect your identity & secure your web browsing using our full-featured and IP masking VPN service";
$_LANG['prosper_meta_description_vpn'] = "We provide a high quality VPN service that comes packed with many features and our industry leading support.";
$_LANG['prosper_meta_tags_vpn'] = "vpn";

// Website Builder (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_websitebuilder'] = "Create a website using our easy builder - no experience required";
$_LANG['prosper_meta_description_websitebuilder'] = "We provide a complete website builder that is easy to use and affordable";
$_LANG['prosper_meta_tags_websitebuilder'] = "website builder";

// Website Backup (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_websitebackup'] = "Website Backup - Protect your website from viruses and hacking with automated backup & restore";
$_LANG['prosper_meta_description_websitebackup'] = "Our website backup service is the perfect solution to protect your website against viruses, malware and other threats.";
$_LANG['prosper_meta_tags_websitebackup'] = "backup, website backup";

// Website Security (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_websitesecurity'] = "Website Security - Secure your website today";
$_LANG['prosper_meta_description_websitesecurity'] = "We provide a selection of website security services including malware detection & removal.";
$_LANG['prosper_meta_tags_websitesecurity'] = "website security, wordpress";

// Email Security (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_emailsecurity'] = "Email Security - Protect your inbox from Spam & Malware!";
$_LANG['prosper_meta_description_emailsecurity'] = "Check out our Email Security services that protect both your outgoing and incoming mail from Spam and other security threats.";
$_LANG['prosper_meta_tags_emailsecurity'] = "email security";

// SEO Tools (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_seotools'] = "SEO Report - Get useful insight into your website's SEO with this service from Marketgoo";
$_LANG['prosper_meta_description_seotools'] = "Our SEO Report service is a great way to learn about your website's search engine performance and know how to increase SEO performance.";
$_LANG['prosper_meta_tags_seotools'] = "seo tools";

// Professional Email (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_professionalemail'] = "Professional email services";
$_LANG['prosper_meta_description_professionalemail'] = "Take email to the next level";
$_LANG['prosper_meta_tags_professionalemail'] = "professional email";

// Site Builder (WHMCS Marketconnect page)

$_LANG['prosper_meta_title_sitebuilder'] = "Simply and quick website builder";
$_LANG['prosper_meta_description_sitebuilder'] = "Make use of our affordable and simple to use website builder";
$_LANG['prosper_meta_tags_sitebuilder'] = "site builder";

// cPanel SEO (WHMCS Marketconnect page)

$_LANG['glaze_meta_title_cpanelseo'] = "cPanel SEO - Be found online with cPanel SEO";
$_LANG['glaze_meta_description_cpanelseo'] = "Be found online with cPanel SEO.";
$_LANG['glaze_meta_tags_cpanelseo'] = "cpanel seo";

// Company

$_LANG['prosper_meta_title_company'] = "All you need to know about our web hosting &amp; domain registration company";
$_LANG['prosper_meta_description_company'] = "Where we come from, when we started &amp; why we started.";
$_LANG['prosper_meta_tags_company'] = "company, about us";

// Terms Of Service

$_LANG['prosper_meta_title_terms'] = "Terms Of Service - A document listing all of our terms";
$_LANG['prosper_meta_description_terms'] = "Please read our terms of service to see what our policies are.";
$_LANG['prosper_meta_tags_terms'] = "terms of service, terms, legal";

// Acceptable Usage Policy

$_LANG['prosper_meta_title_aup'] = "Acceptable Usage Policy - The usage policy you must accept before signing up";
$_LANG['prosper_meta_description_aup'] = "Please read our acceptable usage policy to see what our policies are.";
$_LANG['prosper_meta_tags_aup'] = "acceptable usage policy, usage, restrictions";

// Privacy Policy

$_LANG['prosper_meta_title_privacy'] = "Privacy Policy - Our policy regarding your privacy";
$_LANG['prosper_meta_description_privacy'] = "Please read our privacy policy to see what our policies are.";
$_LANG['prosper_meta_tags_privacy'] = "privacy policy";

// Addons

$_LANG['prosper_meta_title_addons'] = "WHMCS Templates | WordPress Themes | HTML Templates | Logo Design | Banner Design | Scripts";
$_LANG['prosper_meta_description_addons'] = "Premium website addons including web hosting templates for WHMCS, WordPress, Clientexec, WISECP &amp; HostBill.";
$_LANG['prosper_meta_tags_addons'] = "whmcs templates, WordPress themes, html templates, logo design, banner design";

// WHMCS Templates

$_LANG['prosper_meta_title_whmcstemplates'] = "WHMCS Templates - Professional WHMCS Themes for web hosting reseller businesses | Complete Solution";
$_LANG['prosper_meta_description_whmcstemplates'] = "Our WHMCS Templates allow you to launch your very own web hosting reseller business using the power of WHMCS.";
$_LANG['prosper_meta_tags_whmcstemplates'] = "whmcs templates, whmcs themes, responsive whmcs templates";

// WordPress Themes

$_LANG['prosper_meta_title_wordpressthemes'] = "WordPress Themes - Premium themes for the web hosting reseller business | Complete with WHMCS integration";
$_LANG['prosper_meta_description_wordpressthemes'] = "We provide the best WordPress web hosting themes with features including our options panel, shortcodes &amp; WHMCS integration.";
$_LANG['prosper_meta_tags_wordpressthemes'] = "wordpress themes, web hosting wordpress themes, wordpress templates";

// HTML Templates

$_LANG['prosper_meta_title_htmltemplates'] = "HTML Templates - We provide high quality web hosting reseller HTML Templates with integrations for WHMCS, Blesta, Clientexec, WISECP &amp; HostBill.";
$_LANG['prosper_meta_description_htmltemplates'] = "Our responsive web hosting reseller HTML Templates come with many features, free support and pixel perfect integrations for WHMCS, Blesta, Clientexec, WISECP &amp; HostBill.";
$_LANG['prosper_meta_tags_htmltemplates'] = "html templates, html web hosting templates, responsive html templates";

// Blesta Templates

$_LANG['prosper_meta_title_blestatemplates'] = "Blesta Templates - We provide high quality HTML web hosting templates with pixel perfect Blesta integration";
$_LANG['prosper_meta_description_blestatemplates'] = "Launch your web hosting reseller business today using our Blesta HTML Templates. They come with a large array of features and unlimited support.";
$_LANG['prosper_meta_tags_blestatemplates'] = "bleata, blesta templates, blesta web hosting templates";

// Clientexec Templates

$_LANG['prosper_meta_title_clientexectemplates'] = "Clientexec Templates - We provide high quality HTML web hosting templates with pixel perfect Clientexec integration";
$_LANG['prosper_meta_description_clientexectemplates'] = "Launch your web hosting reseller business today using our Clientexec HTML Templates. They come with a large array of features and unlimited support.";
$_LANG['prosper_meta_tags_clientexectemplates'] = "clientexec, clientexec templates, clientexec web hosting templates";

// WISECP Templates

$_LANG['prosper_meta_title_wisecptemplates'] = "WISECP Templates - We provide high quality HTML web hosting templates with pixel perfect WISECP integration";
$_LANG['prosper_meta_description_wisecptemplates'] = "Launch your web hosting reseller business today using our WISECP HTML Templates. They come with a large array of features and unlimited support.";
$_LANG['prosper_meta_tags_wisecptemplates'] = "wisecp, wisecp templates, wisecp web hosting templates";

// HostBill Templates

$_LANG['prosper_meta_title_hostbilltemplates'] = "HostBill Templates - We provide high quality HTML web hosting templates with pixel perfect HostBill integration";
$_LANG['prosper_meta_description_hostbilltemplates'] = "Launch your web hosting reseller business today using our HostBill HTML Templates. They come with a large array of features and unlimited support.";
$_LANG['prosper_meta_tags_hostbilltemplates'] = "hostbill, hostbill templates, hostbill web hosting templates";

// WHMCS Modules

$_LANG['prosper_meta_title_whmcsmodules'] = "WHMCS Modules - Exclusive WHMCS Modules to add functionality to your WHMCS based website";
$_LANG['prosper_meta_description_whmcsmodules'] = "We have developed a range of premium WHMCS Modules including Flex Mail, Affiliates Land Anywhere &amp; SEO Enhancer";
$_LANG['prosper_meta_tags_whmcsmodules'] = "whmcs modules, whmcs addons";

// Scripts

$_LANG['prosper_meta_title_scripts'] = "Scripts | Ready-made scripts to enhance your website including Cookie Law Script, Mega Menus &amp; More";
$_LANG['prosper_meta_description_scripts'] = "Our collection of ready to use HTML/CSS mega menus, features boxes and many scripts including our exclusive EU cookie law script.";
$_LANG['prosper_meta_tags_scripts'] = "html code, css menus, css tables, css feature boxes, eu cookie law";

// Logo Design

$_LANG['prosper_meta_title_logodesign'] = "Logo design service - Custom vector logos designed from scratch for businesses of all types | Premium logo design service";
$_LANG['prosper_meta_description_logodesign'] = "We design custom logos from scratch in vector and raster format for businesses of all types.";
$_LANG['prosper_meta_tags_logodesign'] = "logo design, vector logos, logo designer, custom logo design";

// Banner Design

$_LANG['prosper_meta_title_bannerdesign'] = "Custom Banner Design - High quality banner designs, animated .GIF &amp; static, bast portfolio!";
$_LANG['prosper_meta_description_bannerdesign'] = "We offer a very high quality and affordable banner design service.";
$_LANG['prosper_meta_tags_bannerdesign'] = "banner design, banner designer, animated banners";

// WHMCS Serivces

$_LANG['prosper_meta_title_whmcsservices'] = "WHMCS Services - WHMCS Setup, Configuration And Integration Services Starting From $12! Web hosting business setup/startup services";
$_LANG['prosper_meta_description_whmcsservices'] = "Be sure to check out our popular whmcs services including whmcs setup, whmcs configuration & whmcs integration.";
$_LANG['prosper_meta_tags_whmcsservices'] = "whmcs services, whmcs, whmcs integration, whmcs configuration, whmcs security";

// WordPress Services

$_LANG['prosper_meta_title_wordpressservices'] = "WordPress Services - We provide reliable WordPress services including WordPress Installation &amp; WordPress Integration";
$_LANG['prosper_meta_description_wordpressservices'] = "We provide reliable and manual WordPress services including installation and integration.";
$_LANG['prosper_meta_tags_wordpressservices'] = "wordpress services, wordpress installation, wordpress integration";

// Blesta Services

$_LANG['prosper_meta_title_blestaservices'] = "Blesta Services - We provide reliable Blesta services including Blesta Installation &amp; Blesta Integration";
$_LANG['prosper_meta_description_blestaservices'] = "We provide reliable and manual Bleata services including installation and integration.";
$_LANG['prosper_meta_tags_blestaservices'] = "blesta services, blesta, blesta installation, blesta configuration";

// Clientexec Services

$_LANG['prosper_meta_title_clientexecservices'] = "Clientexec Services - We provide reliable Clientexec services including Clientexec Installation &amp; Clientexec Integration";
$_LANG['prosper_meta_description_clientexecservices'] = "We provide reliable and manual Clientexec services including installation and integration.";
$_LANG['prosper_meta_tags_clientexecservices'] = "clientexec services, clientexec, clientexec installation, clientexec configuration";

// Support

$_LANG['prosper_meta_title_portal'] = "Support Portal ~ Everything you need to manage your service &amp; request support";
$_LANG['prosper_meta_description_portal'] = "Links to support &amp; announcements.";
$_LANG['prosper_meta_tags_portal'] = "support, portal";

// Affiliate Program

$_LANG['prosper_meta_title_affiliateprogram'] = "Join our affiliate program and earn commissions on your sales!";
$_LANG['prosper_meta_description_affiliateprogram'] = "We offer a very professional web hosting affiliate program.";
$_LANG['prosper_meta_tags_affiliateprogram'] = "affiliate program, affiliates, web hosting affiliate program";

// Why Choose Us

$_LANG['prosper_meta_title_whychooseus'] = "The reasons why you should choose our company";
$_LANG['prosper_meta_description_whychooseus'] = "Here is 4 reasons why we are are the best hosting provider.";
$_LANG['prosper_meta_tags_whychooseus'] = "why choose us, why us, why choose our company";

// Testimonials

$_LANG['prosper_meta_title_testimonials'] = "We've compiled a list of testimonials from our customer's";
$_LANG['prosper_meta_description_testimonials'] = "Check out our collection of testimonials sent by our customer's.";
$_LANG['prosper_meta_tags_testimonials'] = "testimonials, customer reviews";

// Contact

$_LANG['prosper_meta_title_contact'] = "Contact us for help with your web hosting or with any pre-sale questions.";
$_LANG['prosper_meta_description_contact'] = "Use our contact form as a reliable way to contact us for support.";
$_LANG['prosper_meta_tags_contact'] = "contact us, contact, contact form";

// Register

$_LANG['prosper_meta_title_register'] = "Register your free account with us";
$_LANG['prosper_meta_description_register'] = "Using your account you can easily create a new order and request support.";
$_LANG['prosper_meta_tags_register'] = "register, register account, free account";

// Submit Ticket

$_LANG['prosper_meta_title_submitticket'] = "Submit a new ticket with us";
$_LANG['prosper_meta_description_submitticket'] = "Submit a new ticket with us.";
$_LANG['prosper_meta_tags_submitticket'] = "ticket, ticket system, submit ticket";

// Support Tickets

$_LANG['prosper_meta_title_supporttickets'] = "View your existing tickets in our system";
$_LANG['prosper_meta_description_supporttickets'] = "Here you can view all of your existing tickets in our system and make a reply.";
$_LANG['prosper_meta_tags_supporttickets'] = "tickets, support tickets";

// Cart

$_LANG['prosper_meta_title_cart'] = "Create your new order with us";
$_LANG['prosper_meta_description_cart'] = "Use our order form to create your new hosting/domain order with us";
$_LANG['prosper_meta_tags_cart'] = "cart, checkout";

// Login

$_LANG['prosper_meta_title_login'] = "Login to manage your account";
$_LANG['prosper_meta_description_login'] = "Once logged-in you can view downloads, request support or easily create a new order.";
$_LANG['prosper_meta_tags_login'] = "manage account, account login";

// Knowledgebase

$_LANG['prosper_meta_title_knowledgebase'] = "View our complete list of tutorials & guides!";
$_LANG['prosper_meta_description_knowledgebase'] = "Our knowledgebase is a great resource for easy to access tutorials.";
$_LANG['prosper_meta_tags_knowledgebase'] = "knowledgebase, tutorials, guides";

// Downloads

$_LANG['prosper_meta_title_downloads'] = "We have a great selection of downloads";
$_LANG['prosper_meta_description_downloads'] = "Download a mix of software and ebooks to help you start your website.";
$_LANG['prosper_meta_tags_downloads'] = "downloads, download library";

// Announcements

$_LANG['prosper_meta_title_announcements'] = "View our announcements and latest news";
$_LANG['prosper_meta_description_announcements'] = "Here is where you'll find all of our announcements and news posts.";
$_LANG['prosper_meta_tags_announcements'] = "announcements, news";

// Server Staus

$_LANG['prosper_meta_title_serverstatus'] = "Check out the status of our servers";
$_LANG['prosper_meta_description_serverstatus'] = "View the status of our servers, allows you to easily check if our servers are online.";
$_LANG['prosper_meta_tags_serverstatus'] = "server status, servers";

// Network Issues

$_LANG['prosper_meta_title_networkissues'] = "Here is where we will post any issues with our network";
$_LANG['prosper_meta_description_networkissues'] = "View this page to instantly check any of our listed network issues.";
$_LANG['prosper_meta_tags_networkissues'] = "network issues, network";

/*
-----------------------------------------
---------   Language Functions   ---------
-----------------------------------------
*/

$_LANG['textdirection'] = "rtl"; # Set the text direction of the template (i.e ltr for English, rtl for Arabic)

?>